/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.dimmapping.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.MatchPropType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.DimensionMemberMappingParam;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.match.DimMatchEvent;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.AbstractDimensionMemberMappingManager;
import kd.tmc.fpm.business.provider.FpmBaseDataProvider;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.helper.StringHelper;

public class DetailDimensionMappingManager
extends AbstractDimensionMemberMappingManager<Object> {
    @Override
    protected void doProcess(List<DimensionMemberMappingParam<Object>> dimensionMemberMappingParamList) {
        List<MatchMap> matchMapList = this.getMatchMapList(dimensionMemberMappingParamList);
        List<MatchValue> matchValueList = matchMapList.stream().map(MatchMap::getMatchValueList).flatMap(Collection::stream).filter(MatchValue::isBaseData).collect(Collectors.toList());
        MatchValueProvider matchValueProvider = new MatchValueProvider(matchValueList);
        for (MatchMap matchMap : matchMapList) {
            List<MatchValue> allMatchValueList = matchMap.getMatchValueList();
            BiConsumer<Dimension, Object> callBack = matchMap.getMemberMappingParam().getCallBack();
            for (MatchValue matchValue : allMatchValueList) {
                String value = matchValue.getMatchValue();
                if (!matchValue.isBaseData()) {
                    callBack.accept(matchValue.getDimension(), value);
                    this.notifySuccess(matchMap.getMemberMappingParam().getDimMatchListener(), () -> DimMatchEvent.builder().billMatchRule(matchMap.getMemberMappingParam().getBillMatchRule()).fundPlanSystem(matchMap.getMemberMappingParam().getFundPlanSystem()).matchMapping(matchValue.getMatchMapping()).dimension(matchValue.dimension).matchedValue(value).originalStringValue(value).build());
                    continue;
                }
                List<DynamicObject> baseDataList = matchValueProvider.getBaseDataListByName(matchValue.getEntityName(), value);
                if (EmptyUtil.isEmpty(baseDataList)) {
                    callBack.accept(matchValue.getDimension(), value);
                    this.notifyFailed(matchMap.getMemberMappingParam().getDimMatchListener(), () -> DimMatchEvent.builder().billMatchRule(matchMap.getMemberMappingParam().getBillMatchRule()).fundPlanSystem(matchMap.getMemberMappingParam().getFundPlanSystem()).matchMapping(matchValue.getMatchMapping()).dimension(matchValue.dimension).originalStringValue(value).build());
                    continue;
                }
                List dataId = baseDataList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                callBack.accept(matchValue.getDimension(), dataId);
                this.notifySuccess(matchMap.getMemberMappingParam().getDimMatchListener(), () -> DimMatchEvent.builder().billMatchRule(matchMap.getMemberMappingParam().getBillMatchRule()).fundPlanSystem(matchMap.getMemberMappingParam().getFundPlanSystem()).matchMapping(matchValue.getMatchMapping()).dimension(matchValue.dimension).matchedValue(dataId).originalStringValue(value).build());
            }
        }
    }

    private List<MatchMap> getMatchMapList(List<DimensionMemberMappingParam<Object>> dimensionMemberMappingParamList) {
        ArrayList<MatchMap> matchMapList = new ArrayList<MatchMap>(dimensionMemberMappingParamList.size());
        for (DimensionMemberMappingParam<Object> dimensionMemberMappingParam : dimensionMemberMappingParamList) {
            BillMatchRule billMatchRule = dimensionMemberMappingParam.getBillMatchRule();
            FundPlanSystem fundPlanSystem = dimensionMemberMappingParam.getFundPlanSystem();
            Map detailDimMap = fundPlanSystem.getDetailDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
            List detailMatchMappings = billMatchRule.getMappings().stream().filter(matchMapping -> detailDimMap.containsKey(matchMapping.getDimId())).filter(matchMapping -> this.matchAll || this.dimensionIds.contains(matchMapping.getDimId())).sorted(Comparator.comparing(matchMapping -> DimensionInfoHelper.getScoreByDimensionType((Dimension)detailDimMap.get(matchMapping.getDimId())))).collect(Collectors.toList());
            if (EmptyUtil.isEmpty(detailMatchMappings)) continue;
            Map<String, Object> bizPropMap = dimensionMemberMappingParam.getBillBizInfo().getBizProps().stream().collect(Collectors.toMap(BizProps::getBizProp, BizProps::getValue, (a, b) -> a));
            MatchMap matchMap = new MatchMap(dimensionMemberMappingParam);
            matchMapList.add(matchMap);
            MatchValue counterPartyTypeMatchVal = null;
            for (MatchMapping matchMapping2 : detailMatchMappings) {
                List listMap;
                String counterPartyTypeExtVal;
                DetailDimType detailDimType;
                String bizProp = matchMapping2.getBizProp();
                if (EmptyUtil.isEmpty((String)bizProp)) continue;
                String stringValue = StringHelper.getStringValue((Object)bizPropMap.get(bizProp));
                Dimension dimension = (Dimension)detailDimMap.get(matchMapping2.getDimId());
                if (Objects.isNull(dimension) || Objects.isNull((Object)(detailDimType = dimension.getDetailDimType()))) continue;
                if (EmptyUtil.isEmpty((String)stringValue)) {
                    matchMap.addMatchValue(new MatchValue(dimension, matchMapping2));
                    continue;
                }
                if (dimension.getMemberType() != MemberType.BASE_DATA) {
                    MatchValue matchValue = new MatchValue(dimension, matchMapping2, stringValue);
                    if (detailDimType == DetailDimType.CONNTERPARTY_TYPE) {
                        counterPartyTypeExtVal = (String)DetailDimType.CONNTERPARTY_TYPE.getExtVal();
                        listMap = (List)SerializationUtils.fromJsonString((String)counterPartyTypeExtVal, List.class);
                        Optional<Map> key = listMap.stream().filter(map -> Objects.equals(map.get("key"), stringValue) || Objects.equals(map.get("value"), stringValue)).findFirst();
                        if (key.isPresent()) {
                            matchValue = new MatchValue(dimension, matchMapping2, (String)key.get().get("key"));
                        }
                        counterPartyTypeMatchVal = matchValue;
                    }
                    matchMap.addMatchValue(matchValue);
                    continue;
                }
                Object extVal = detailDimType.getExtVal();
                if (detailDimType == DetailDimType.COUNTERPARTY_NAME) {
                    counterPartyTypeExtVal = (String)DetailDimType.CONNTERPARTY_TYPE.getExtVal();
                    listMap = (List)SerializationUtils.fromJsonString((String)counterPartyTypeExtVal, List.class);
                    if (counterPartyTypeMatchVal != null) {
                        MatchValue counterPartyType = counterPartyTypeMatchVal;
                        Optional<Map> key = listMap.stream().filter(map -> Objects.equals(map.get("key"), counterPartyType.getMatchValue()) || Objects.equals(map.get("value"), counterPartyType.getMatchValue())).findFirst();
                        if (key.isPresent()) {
                            extVal = key.get().get("key");
                        }
                    }
                }
                String entity = StringHelper.getStringValue((Object)(Objects.isNull(extVal) ? dimension.getBaseDataType() : extVal.toString()));
                matchMap.addMatchValue(new MatchValue(dimension, matchMapping2, stringValue, entity));
            }
        }
        return matchMapList;
    }

    static class MatchValueProvider
    extends FpmBaseDataProvider {
        private Map<String, Set<Long>> namePkListMap;

        public MatchValueProvider(List<MatchValue> matchValueList) {
            this.namePkListMap = new HashMap<String, Set<Long>>(matchValueList.size());
            this.initDataMap(matchValueList);
        }

        private void initDataMap(List<MatchValue> matchValueList) {
            HashMap<String, Map> entityNameOrNumberMap = new HashMap<String, Map>(16);
            for (MatchValue matchValue : matchValueList) {
                if (!matchValue.isBaseData()) continue;
                Map nameOrNumberMap = entityNameOrNumberMap.computeIfAbsent(matchValue.getEntityName(), k -> new HashMap(4));
                MatchMapping matchMapping = matchValue.getMatchMapping();
                MatchPropType matchPropType = matchMapping.getMatchPropType();
                Set values = nameOrNumberMap.computeIfAbsent(matchPropType.getProp(), k -> new HashSet(16));
                values.add(matchValue.getMatchValue());
            }
            for (Map.Entry entry : entityNameOrNumberMap.entrySet()) {
                String entityName = (String)entry.getKey();
                Map nameNumberMap = (Map)entry.getValue();
                for (Map.Entry nameNumberEntry : nameNumberMap.entrySet()) {
                    String nameNumberEntryKey = (String)nameNumberEntry.getKey();
                    String selectFields = String.join((CharSequence)",", "id", nameNumberEntryKey);
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter(nameNumberEntryKey, "in", nameNumberEntry.getValue())});
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        Map objectDynamicObjectMap = this.baseDataMap.computeIfAbsent(entityName, k -> new HashMap(16));
                        objectDynamicObjectMap.put(dynamicObject.getLong("id"), dynamicObject);
                        Set set = this.namePkListMap.computeIfAbsent(dynamicObject.getString(nameNumberEntryKey), k -> new HashSet(8));
                        set.add(dynamicObject.getLong("id"));
                    }
                }
            }
        }

        public List<DynamicObject> getBaseDataListByName(String entityType, Object key) {
            Set<Long> set = this.namePkListMap.get(key);
            if (EmptyUtil.isEmpty(set)) {
                return Collections.emptyList();
            }
            Map objectDynamicObjectMap = (Map)this.baseDataMap.get(entityType);
            if (EmptyUtil.isEmpty((Object)objectDynamicObjectMap)) {
                return Collections.emptyList();
            }
            return set.stream().map(objectDynamicObjectMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        }
    }

    private static class MatchValue {
        private Dimension dimension;
        private boolean baseData;
        private String entityName;
        private String matchValue;
        MatchMapping matchMapping;

        public MatchValue(Dimension dimension, MatchMapping matchMapping) {
            this(dimension, matchMapping, "");
        }

        public MatchValue(Dimension dimension, MatchMapping matchMapping, String matchValue) {
            this(dimension, matchMapping, matchValue, "");
        }

        public MatchValue(Dimension dimension, MatchMapping matchMapping, String matchValue, String entityName) {
            this(dimension, matchMapping, matchValue, entityName, EmptyUtil.isNoEmpty((String)entityName));
        }

        public MatchValue(Dimension dimension, MatchMapping matchMapping, String matchValue, String entityName, boolean baseData) {
            this.dimension = dimension;
            this.matchMapping = matchMapping;
            this.baseData = baseData;
            this.entityName = entityName;
            this.matchValue = matchValue;
        }

        public Dimension getDimension() {
            return this.dimension;
        }

        public void setDimension(Dimension dimension) {
            this.dimension = dimension;
        }

        public boolean isBaseData() {
            return this.baseData;
        }

        public void setBaseData(boolean baseData) {
            this.baseData = baseData;
        }

        public String getMatchValue() {
            return this.matchValue;
        }

        public void setMatchValue(String matchValue) {
            this.matchValue = matchValue;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public MatchMapping getMatchMapping() {
            return this.matchMapping;
        }

        public void setMatchMapping(MatchMapping matchMapping) {
            this.matchMapping = matchMapping;
        }
    }

    private static class MatchMap {
        private DimensionMemberMappingParam<Object> memberMappingParam;
        private List<MatchValue> matchValueList;

        public MatchMap(DimensionMemberMappingParam<Object> memberMappingParam) {
            this.memberMappingParam = memberMappingParam;
            this.matchValueList = new ArrayList<MatchValue>(16);
        }

        public void addMatchValue(MatchValue matchValue) {
            this.matchValueList.add(matchValue);
        }

        public DimensionMemberMappingParam<Object> getMemberMappingParam() {
            return this.memberMappingParam;
        }

        public void setMemberMappingParam(DimensionMemberMappingParam<Object> memberMappingParam) {
            this.memberMappingParam = memberMappingParam;
        }

        public List<MatchValue> getMatchValueList() {
            return this.matchValueList;
        }

        public void setMatchValueList(List<MatchValue> matchValueList) {
            this.matchValueList = matchValueList;
        }
    }
}

