/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.DetailControlInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.mvc.service.impl.ControlStrategyDelegate;
import org.apache.commons.collections.CollectionUtils;

public class ControlParamDTO {
    private ControlStrategy controlStrategy;
    private BigDecimal realAmount;
    private BigDecimal waitReleaseAmount;
    private BigDecimal holdAmount;
    private DimMember currPeriodMember;
    private ReportData reportData;
    private ReportTemplate template;
    private List<ReportData> relReportDataList;
    private BillBizInfo billBizInfo;
    private boolean accurateMatch;
    private Collection<Dimension> matchedDimensions;
    private FundPlanSystem fundPlanSystem;
    private ControlAmountCache controlAmountCache;
    private QueryIndexInfo<Long, ReportData> relateReportDataQueryIndexInfo;
    private DetailControlInfo detailControlInfo;
    private ControlStrategyDelegate controlStrategyDelegate;

    public ControlParamDTO() {
    }

    public ControlParamDTO(ControlStrategy controlStrategy, BigDecimal realAmount, DimMember currPeriodMember, ReportData reportData, List<ReportData> relReportDataList, BillBizInfo billBizInfo, boolean accurateMatch, Collection<Dimension> matchedDimensions, FundPlanSystem fundPlanSystem, ReportTemplate template, ControlAmountCache controlAmountCache, BigDecimal waitReleaseAmount, BigDecimal holdAmount, QueryIndexInfo<Long, ReportData> relateReportDataQueryIndexInfo, DetailControlInfo detailControlInfo, ControlStrategyDelegate controlStrategyDelegate) {
        this.controlStrategy = controlStrategy;
        this.realAmount = realAmount;
        this.currPeriodMember = currPeriodMember;
        this.reportData = reportData;
        this.relReportDataList = relReportDataList;
        this.billBizInfo = billBizInfo;
        this.accurateMatch = accurateMatch;
        this.matchedDimensions = matchedDimensions;
        this.fundPlanSystem = fundPlanSystem;
        this.template = template;
        this.controlAmountCache = controlAmountCache;
        this.waitReleaseAmount = waitReleaseAmount;
        this.holdAmount = holdAmount;
        this.relateReportDataQueryIndexInfo = relateReportDataQueryIndexInfo;
        this.detailControlInfo = detailControlInfo;
        this.controlStrategyDelegate = controlStrategyDelegate;
    }

    public String toString() {
        return "ControlParamDTO{controlStrategy: " + this.controlStrategy + ", realAmount: " + this.realAmount + ", currPeriodMember: " + this.currPeriodMember.getName() + ", reportData.id: " + this.reportData.getId() + ", relReportDataList.ids: " + (Objects.isNull(this.relReportDataList) ? "[]" : this.relReportDataList.stream().map(ReportData::getId).map(Object::toString).collect(Collectors.toList())) + ", billBizInfo=[billNo:" + this.billBizInfo.getBillNo() + ",entityType:" + this.billBizInfo.getEntityType() + ", accurateMatch" + this.accurateMatch + ", matchedDimensions" + this.matchedDimensions + ",fundPlanSystem" + this.fundPlanSystem.getName() + '}';
    }

    public BigDecimal getWaitReleaseAmount() {
        return this.waitReleaseAmount;
    }

    public void setWaitReleaseAmount(BigDecimal waitReleaseAmount) {
        this.waitReleaseAmount = waitReleaseAmount;
    }

    public BigDecimal getHoldAmount() {
        return this.holdAmount;
    }

    public void setHoldAmount(BigDecimal holdAmount) {
        this.holdAmount = holdAmount;
    }

    public ControlStrategy getControlStrategy() {
        return this.controlStrategy;
    }

    public void setControlStrategy(ControlStrategy controlStrategy) {
        this.controlStrategy = controlStrategy;
    }

    public BigDecimal getRealAmount() {
        return this.realAmount;
    }

    public void setRealAmount(BigDecimal realAmount) {
        this.realAmount = realAmount;
    }

    public DimMember getCurrPeriodMember() {
        return this.currPeriodMember;
    }

    public void setCurrPeriodMember(DimMember currPeriodMember) {
        this.currPeriodMember = currPeriodMember;
    }

    public ReportData getReportData() {
        return this.reportData;
    }

    public void setReportData(ReportData reportData) {
        this.reportData = reportData;
    }

    public List<ReportData> getRelReportDataList() {
        return this.relReportDataList;
    }

    public void setRelReportDataList(List<ReportData> relReportDataList) {
        this.relReportDataList = relReportDataList;
    }

    public BillBizInfo getBillBizInfo() {
        return this.billBizInfo;
    }

    public void setBillBizInfo(BillBizInfo billBizInfo) {
        this.billBizInfo = billBizInfo;
    }

    public boolean isAccurateMatch() {
        return this.accurateMatch;
    }

    public void setAccurateMatch(boolean accurateMatch) {
        this.accurateMatch = accurateMatch;
    }

    public Collection<Dimension> getMatchedDimensions() {
        return this.matchedDimensions;
    }

    public void setMatchedDimensions(Collection<Dimension> matchedDimensions) {
        this.matchedDimensions = matchedDimensions;
    }

    public FundPlanSystem getFundPlanSystem() {
        return this.fundPlanSystem;
    }

    public void setFundPlanSystem(FundPlanSystem fundPlanSystem) {
        this.fundPlanSystem = fundPlanSystem;
    }

    public ControlAmountCache getControlAmountCache() {
        return this.controlAmountCache;
    }

    public void setControlAmountCache(ControlAmountCache controlAmountCache) {
        this.controlAmountCache = controlAmountCache;
    }

    public QueryIndexInfo<Long, ReportData> getRelateReportDataQueryIndexInfo() {
        if (Objects.isNull(this.relateReportDataQueryIndexInfo)) {
            this.relateReportDataQueryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(this.relReportDataList, this.fundPlanSystem, rd -> true);
        }
        return this.relateReportDataQueryIndexInfo;
    }

    public void setRelateReportDataQueryIndexInfo(QueryIndexInfo<Long, ReportData> relateReportDataQueryIndexInfo) {
        this.relateReportDataQueryIndexInfo = relateReportDataQueryIndexInfo;
    }

    public DetailControlInfo getDetailControlInfo() {
        return this.detailControlInfo;
    }

    public void setDetailControlInfo(DetailControlInfo detailControlInfo) {
        this.detailControlInfo = detailControlInfo;
    }

    public ControlStrategyDelegate getControlStrategyDelegate() {
        return this.controlStrategyDelegate;
    }

    public void setControlStrategyDelegate(ControlStrategyDelegate controlStrategyDelegate) {
        this.controlStrategyDelegate = controlStrategyDelegate;
    }

    public static ControlParamDTOBuilder builder() {
        return new ControlParamDTOBuilder();
    }

    public ReportTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ReportTemplate template) {
        this.template = template;
    }

    public static class ControlParamDTOBuilder {
        private ControlStrategy controlStrategy;
        private BigDecimal realAmount;
        private DimMember currPeriodMember;
        private ReportData reportData;
        private BigDecimal waitReleaseAmount;
        private BigDecimal holdAmount;
        private List<ReportData> relReportDataList;
        private BillBizInfo billBizInfo;
        private FundPlanSystem fundPlanSystem;
        private boolean accurateMatch;
        private ReportTemplate template;
        private Collection<Dimension> matchedDimensions = new ArrayList<Dimension>(2);
        private ControlAmountCache controlAmountCache;
        private QueryIndexInfo<Long, ReportData> relateReportDataQueryIndexInfo;
        private DetailControlInfo detailControlInfo;
        private ControlStrategyDelegate controlStrategyDelegate;

        public ControlParamDTOBuilder template(ReportTemplate template) {
            this.template = template;
            return this;
        }

        public ControlParamDTOBuilder controlStrategy(ControlStrategy controlStrategy) {
            this.controlStrategy = controlStrategy;
            return this;
        }

        public ControlParamDTOBuilder realAmount(BigDecimal realAmount) {
            this.realAmount = realAmount;
            return this;
        }

        public ControlParamDTOBuilder waitReleaseAmount(BigDecimal waitReleaseAmount) {
            this.waitReleaseAmount = waitReleaseAmount;
            return this;
        }

        public ControlParamDTOBuilder holdAmount(BigDecimal holdAmount) {
            this.holdAmount = holdAmount;
            return this;
        }

        public ControlParamDTOBuilder currPeriodMember(DimMember currPeriodMember) {
            this.currPeriodMember = currPeriodMember;
            return this;
        }

        public ControlParamDTOBuilder reportData(ReportData reportData) {
            this.reportData = reportData;
            return this;
        }

        public ControlParamDTOBuilder relReportDataList(List<ReportData> relReportDataList) {
            this.relReportDataList = relReportDataList;
            return this;
        }

        public ControlParamDTOBuilder billBizInfo(BillBizInfo billBizInfo) {
            this.billBizInfo = billBizInfo;
            return this;
        }

        public ControlParamDTOBuilder fundPlanSystem(FundPlanSystem fundPlanSystem) {
            this.fundPlanSystem = fundPlanSystem;
            return this;
        }

        public ControlParamDTOBuilder accurateMatch(boolean accurateMatch) {
            this.accurateMatch = accurateMatch;
            return this;
        }

        public ControlParamDTOBuilder matchedDimensions(Collection<Dimension> matchedDimensions) {
            if (CollectionUtils.isNotEmpty(matchedDimensions)) {
                this.matchedDimensions = matchedDimensions;
            }
            return this;
        }

        public ControlParamDTOBuilder controlAmountCache(ControlAmountCache controlAmountCache) {
            this.controlAmountCache = controlAmountCache;
            return this;
        }

        public ControlParamDTOBuilder relateReportDataQueryIndexInfo(QueryIndexInfo<Long, ReportData> relateReportDataQueryIndexInfo) {
            this.relateReportDataQueryIndexInfo = relateReportDataQueryIndexInfo;
            return this;
        }

        public ControlParamDTOBuilder detailControlInfo(DetailControlInfo detailControlInfo) {
            this.detailControlInfo = detailControlInfo;
            return this;
        }

        public ControlParamDTOBuilder controlStrategyDelegate(ControlStrategyDelegate controlStrategyDelegate) {
            this.controlStrategyDelegate = controlStrategyDelegate;
            return this;
        }

        public ControlParamDTO build() {
            if (Objects.nonNull(this.fundPlanSystem) && Objects.nonNull(this.controlStrategy)) {
                this.controlStrategy.setFundPlanSystem(this.fundPlanSystem);
            }
            return new ControlParamDTO(this.controlStrategy, this.realAmount, this.currPeriodMember, this.reportData, this.relReportDataList, this.billBizInfo, this.accurateMatch, this.matchedDimensions, this.fundPlanSystem, this.template, this.controlAmountCache, this.waitReleaseAmount, this.holdAmount, this.relateReportDataQueryIndexInfo, this.detailControlInfo, this.controlStrategyDelegate);
        }
    }
}

