/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;
import kd.tmc.fpm.common.utils.NumberUtils;

public class ControlParamResultDTO {
    private boolean success = true;
    private boolean warn = false;
    private List<ErrorMessage> errorMessageList = new ArrayList<ErrorMessage>(16);
    private List<WarnMessage> warnMessageList = new ArrayList<WarnMessage>(16);

    public ControlParamResultDTO() {
    }

    public ControlParamResultDTO(boolean success) {
        this.success = success;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isWarn() {
        return this.warn;
    }

    public List<String> getErrorMessageList() {
        return this.errorMessageList.stream().map(ErrorMessage::getMessage).collect(Collectors.toList());
    }

    public List<String> getErrorMessageList(Function<ErrorMessage, String> function) {
        return this.errorMessageList.stream().map(errorMessage -> (String)function.apply((ErrorMessage)errorMessage)).collect(Collectors.toList());
    }

    public List<String> getWarnMessageList() {
        return this.warnMessageList.stream().map(WarnMessage::getMessage).collect(Collectors.toList());
    }

    public List<String> getWarnMessageList(Function<WarnMessage, String> function) {
        return this.warnMessageList.stream().map(warnMessage -> (String)function.apply((WarnMessage)warnMessage)).collect(Collectors.toList());
    }

    public void addErrorMessage(ErrorMessage errorMessage) {
        this.errorMessageList.add(errorMessage);
        this.success = false;
    }

    public void addWarnMessage(WarnMessage warnMessage) {
        this.warn = true;
        this.warnMessageList.add(warnMessage);
    }

    public static class WarnMessage
    extends Message {
        private BigDecimal warnAmount;
        private BigDecimal remainAmount;

        public WarnMessage() {
        }

        @Override
        public String getMessage() {
            String warnMessage = String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u5269\u4f59\u989d\u5ea6\u4e3a\u201c%1$s\u201d\uff0c\u8bf7\u53ca\u65f6\u8c03\u6574\u201c%2$s\u201d\u7684\u8ba1\u5212\u989d\u5ea6\u3002", (String)"ControlParamResultDTO_2", (String)"tmc-fpm-business", (Object[])new Object[0]), this.getAmountFormat(this.remainAmount), this.getDimensionName());
            return warnMessage;
        }

        public WarnMessage(String billNo, FundPlanSystem system, List<String> dimensionNameList, BigDecimal planAmount, BigDecimal warnAmount, BigDecimal remainAmount, AmountUnit amtUnit) {
            super(billNo, system, dimensionNameList, planAmount, amtUnit);
            this.warnAmount = warnAmount;
            this.remainAmount = remainAmount;
        }

        public BigDecimal getWarnAmount() {
            return this.warnAmount;
        }

        public void setWarnAmount(BigDecimal warnAmount) {
            this.warnAmount = warnAmount;
        }

        public BigDecimal getRemainAmount() {
            return this.remainAmount;
        }

        public void setRemainAmount(BigDecimal remainAmount) {
            this.remainAmount = remainAmount;
        }
    }

    public static class ErrorMessage
    extends Message {
        private BigDecimal realAmount;
        private BigDecimal availableAmount;
        private boolean notMatch;
        private String subjectName;

        public ErrorMessage() {
        }

        @Override
        public String getMessage() {
            if (this.notMatch) {
                return String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u989d\u5ea6\u6821\u9a8c\u672a\u901a\u8fc7\u3002\u8ba1\u5212\u79d1\u76ee\u201c%1$s\u201d\u5df2\u542f\u7528\u6309\u660e\u7ec6\u9879\u63a7\u5236\uff0c\u4f46\u5355\u636e\u201c%2$s\u201d\u65e0\u6cd5\u7cbe\u786e\u5339\u914d\u5230\u751f\u6548\u7684\u542b\u53d7\u63a7\u7ef4\u5ea6\u7ec4\u5408\u201c%3$s\u201d\u4e0b\u7684\u8ba1\u5212\u989d\u5ea6\u8bb0\u5f55\u3002\u8bf7\u68c0\u67e5\u8ba1\u5212\u7f16\u5236\u60c5\u51b5\u6216\u201c\u4e1a\u52a1\u53d6\u6570\u89c4\u5219\u201d\u914d\u7f6e\u4fe1\u606f\u3002", (String)"ControlParamResultDTO_0", (String)"tmc-fpm-business", (Object[])new Object[0]), this.getSystem().getName(), this.subjectName, this.getBillNo(), this.getDimensionName());
            }
            String errorMessage = String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u989d\u5ea6\u4e0d\u8db3\uff0c\u5355\u636e\u201c%1$s\u201d\u5339\u914d\u5230\u201c%2$s\u201d\u4f53\u7cfb\u4e0b\u7684\u201c%3$s\u201d\u7684\u8d44\u91d1\u8ba1\u5212\u4f59\u989d\u4e0d\u8db3\uff0c\u5f53\u524d\u5269\u4f59\u53ef\u7528\u91d1\u989d\uff1a%4$s\uff0c\u9884\u8ba1\u672c\u6b21\u5360\u7528\uff08\u5b9e\u9645\u6263\u51cf\uff09\uff1a%5$s\u3002", (String)"ControlParamResultDTO_1", (String)"tmc-fpm-business", (Object[])new Object[0]), this.getBillNo(), this.getSystem().getName(), this.getDimensionName(), this.getAmountFormat(this.availableAmount), this.getAmountFormat(this.realAmount));
            return errorMessage;
        }

        public ErrorMessage(boolean notMatch, String billNo, FundPlanSystem system, String subjectName, List<String> dimensionNameList) {
            super(billNo, system, dimensionNameList, BigDecimal.ZERO, AmountUnit.ONE);
            this.notMatch = notMatch;
            this.subjectName = subjectName;
        }

        public ErrorMessage(String billNo, FundPlanSystem system, List<String> dimensionNameList, BigDecimal planAmount, BigDecimal realAmount, BigDecimal availableAmount, AmountUnit amtUnit) {
            super(billNo, system, dimensionNameList, planAmount, amtUnit);
            this.realAmount = realAmount;
            this.availableAmount = availableAmount;
        }

        public BigDecimal getRealAmount() {
            return this.realAmount;
        }

        public void setRealAmount(BigDecimal realAmount) {
            this.realAmount = realAmount;
        }

        public BigDecimal getAvailableAmount() {
            return this.availableAmount;
        }

        public void setAvailableAmount(BigDecimal availableAmount) {
            this.availableAmount = availableAmount;
        }
    }

    public static abstract class Message {
        private String billNo;
        private List<String> dimensionNameList;
        private BigDecimal planAmount;
        private AmountUnit amtUnit;
        private FundPlanSystem system;

        public Message() {
        }

        public Message(String billNo, FundPlanSystem system, List<String> dimensionNameList, BigDecimal planAmount, AmountUnit amtUnit) {
            this.billNo = billNo;
            this.dimensionNameList = dimensionNameList;
            this.planAmount = planAmount;
            this.amtUnit = amtUnit;
            this.system = system;
        }

        public String getBillNo() {
            return this.billNo;
        }

        public void setBillNo(String billNo) {
            this.billNo = billNo;
        }

        public List<String> getDimensionNameList() {
            return this.dimensionNameList;
        }

        public void setDimensionNameList(List<String> dimensionNameList) {
            this.dimensionNameList = dimensionNameList;
        }

        public String getDimensionName() {
            if (CollectionUtils.isEmpty(this.dimensionNameList)) {
                return "";
            }
            return this.dimensionNameList.stream().collect(Collectors.joining("/"));
        }

        public String getDimensionName(String delimiter) {
            if (CollectionUtils.isEmpty(this.dimensionNameList)) {
                return "";
            }
            return this.dimensionNameList.stream().collect(Collectors.joining(delimiter));
        }

        public BigDecimal getPlanAmount() {
            return this.planAmount;
        }

        public void setPlanAmount(BigDecimal planAmount) {
            this.planAmount = planAmount;
        }

        public AmountUnit getAmtUnit() {
            return this.amtUnit;
        }

        public void setAmtUnit(AmountUnit amtUnit) {
            this.amtUnit = amtUnit;
        }

        public FundPlanSystem getSystem() {
            return this.system;
        }

        public void setSystem(FundPlanSystem system) {
            this.system = system;
        }

        public String getAmountFormat(BigDecimal amount) {
            if (Objects.isNull(amount)) {
                amount = BigDecimal.ZERO;
            }
            BigDecimal convert = AmountUtil.convert((AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)this.amtUnit.name())), (AmountUnitEnum)AmountUnitEnum.ONE, (BigDecimal)amount);
            int scale = this.getScale(convert);
            return String.format("%." + scale + "f", convert).concat(AmountUnit.ONE.getName());
        }

        private int getScale(BigDecimal bigDecimal) {
            if (NumberUtils.equals((BigDecimal)CommonUtils.getBigDecimalValue(bigDecimal), (BigDecimal)BigDecimal.ZERO)) {
                return 2;
            }
            String plainString = bigDecimal.toPlainString();
            String[] split = plainString.split("\\.");
            if (split.length <= 1) {
                return 2;
            }
            String str = split[1];
            str = str.replaceAll("0+$", "");
            return str.length();
        }

        public abstract String getMessage();
    }
}

