/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceDetailInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.PlanRecordInfo;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class ActualReleaseControlExecuteStrategy
extends AbstractControlExecuteStrategy {
    public ActualReleaseControlExecuteStrategy(ControlContext controlContext) {
        super(controlContext);
    }

    @Override
    public void beforeDoControl() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Map<String, ControlTraceDetailInfo> controlTraceDetailInfoMap = this.getControlTraceDetailInfoMap();
        ArrayList<ControlExecuteParam> newParam = new ArrayList<ControlExecuteParam>(4);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            ControlTraceDetailInfo controlTraceDetailInfo;
            String traceKey = this.controlStrategyDelegate.getControlTraceMapKey(controlExecuteParam);
            if (!controlTraceDetailInfoMap.containsKey(traceKey) || !(controlTraceDetailInfo = controlTraceDetailInfoMap.get(traceKey)).hasCurrent()) continue;
            this.fillAndGenerateReleaseInfoForCurrentIfNeed(newParam, controlExecuteParam, controlTraceDetailInfo);
        }
        controlExecuteParamList.addAll(newParam);
        Iterator<ControlExecuteParam> iterator = controlExecuteParamList.iterator();
        while (iterator.hasNext()) {
            ControlExecuteParam next = iterator.next();
            PlanExecuteRecord originalPlanExecuteRecord = next.getOriginalPlanExecuteRecord();
            if (!Objects.isNull(originalPlanExecuteRecord) && !EmptyUtil.isEmpty((BigDecimal)next.getActAmount())) continue;
            iterator.remove();
        }
    }

    private void fillAndGenerateReleaseInfoForCurrentIfNeed(List<ControlExecuteParam> newParam, ControlExecuteParam controlExecuteParam, ControlTraceDetailInfo controlTraceDetailInfo) {
        List<PlanRecordInfo> currentPlanRecordInfo = controlTraceDetailInfo.getCurrentPlanRecordInfo();
        String groupKey = this.controlStrategyDelegate.getGroupKey(controlExecuteParam.getBillBizInfo(), controlExecuteParam.getMatchRule());
        Map<String, List<PlanRecordInfo>> currentPlanRecordInfoMap = currentPlanRecordInfo.stream().collect(Collectors.groupingBy(planRecordInfo -> {
            PlanExecuteRecord planExecuteRecord = planRecordInfo.getPlanExecuteRecord();
            BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
            Long matchRuleId = planExecuteRecord.getMatchRuleId();
            return this.controlStrategyDelegate.getGroupKey(billBizInfo, matchRuleId);
        }));
        List currentRealPlanRecordInfo = currentPlanRecordInfoMap.getOrDefault(groupKey, Collections.emptyList());
        if (EmptyUtil.isEmpty(currentRealPlanRecordInfo)) {
            return;
        }
        BigDecimal originalActAmount = controlExecuteParam.getExecuteActAmount();
        this.fillMatchInfo(controlExecuteParam, ((PlanRecordInfo)currentRealPlanRecordInfo.get(0)).getPlanExecuteRecord());
        for (int i = 1; i < currentRealPlanRecordInfo.size(); ++i) {
            ControlExecuteParam copy = controlExecuteParam.copy();
            copy.setActAmount(originalActAmount, true);
            this.fillMatchInfo(copy, ((PlanRecordInfo)currentRealPlanRecordInfo.get(i)).getPlanExecuteRecord());
            newParam.add(copy);
        }
    }

    private Map<String, ControlTraceDetailInfo> getControlTraceDetailInfoMap() {
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        HashMap<String, ControlTraceDetailInfo> controlTraceDetailInfoMap = new HashMap<String, ControlTraceDetailInfo>(controlTraceInfoMap.size());
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            List executeRecordList;
            ArrayList controlTraceInfoList;
            String key = this.controlStrategyDelegate.getControlTraceMapKey(controlExecuteParam);
            if (controlTraceDetailInfoMap.containsKey(key) || EmptyUtil.isEmpty(controlTraceInfoList = new ArrayList(controlTraceInfoMap.getOrDefault(key, Collections.emptyList())))) continue;
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            Optional<ControlTraceInfo> first = controlTraceInfoList.stream().filter(info -> Objects.equals(info.getBillId(), billBizInfo.getBillId())).filter(info -> Objects.equals(info.getEntityType(), billBizInfo.getEntityType())).findFirst();
            ControlTraceDetailInfo controlTraceDetailInfo = new ControlTraceDetailInfo();
            controlTraceDetailInfoMap.put(key, controlTraceDetailInfo);
            List<Object> list = executeRecordList = first.isPresent() ? first.get().getExecuteRecordList() : Collections.emptyList();
            if (EmptyUtil.isNoEmpty(executeRecordList)) {
                List<PlanRecordInfo> planRecordInfoList = executeRecordList.stream().filter(p -> p.getDeleteStatus() == false).filter(p -> p.getExecuteOpType() == PlanExecuteOpType.WRITE).map(PlanRecordInfo::new).collect(Collectors.toList());
                controlTraceDetailInfo.setCurrentPlanRecordInfo(planRecordInfoList);
            }
            controlTraceInfoList.remove(first.orElse(null));
            for (int i = 0; i < controlTraceInfoList.size(); ++i) {
                ControlTraceInfo controlTraceInfo = (ControlTraceInfo)controlTraceInfoList.get(i);
                List<PlanRecordInfo> upperPlanRecordInfoList = controlTraceInfo.getExecuteRecordList().stream().filter(p -> p.getDeleteStatus() == false).filter(p -> p.getExecuteOpType() == PlanExecuteOpType.WRITE).map(PlanRecordInfo::new).collect(Collectors.toList());
                controlTraceDetailInfo.addUpperPlanRecordInfo(upperPlanRecordInfoList);
            }
        }
        return controlTraceDetailInfoMap;
    }

    private void fillMatchInfo(ControlExecuteParam controlExecuteParam, PlanExecuteRecord planExecuteRecord) {
        BigDecimal waitReleaseAmt = controlExecuteParam.getExecuteActAmount();
        this.controlStrategyDelegate.fillMatchInfo(controlExecuteParam, planExecuteRecord);
        BigDecimal unReleaseAmt = planExecuteRecord.getUnReleaseAmt();
        waitReleaseAmt = waitReleaseAmt.compareTo(unReleaseAmt) > 0 ? unReleaseAmt : waitReleaseAmt;
        controlExecuteParam.setActAmount(waitReleaseAmt.negate(), true);
    }
}

