/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTracePlanRecordSort;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class ActualWriteControlExecuteStrategy
extends AbstractControlExecuteStrategy {
    public ActualWriteControlExecuteStrategy(ControlContext controlContext) {
        super(controlContext);
    }

    @Override
    public ControlUpdateInfo handleRecord() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        ControlUpdateInfo controlUpdateInfo = new ControlUpdateInfo();
        logger.info("\u5220\u9664\u5f02\u5e38\u6570\u636e\u3002\u3002\u3002\u3002\u3002");
        this.controlStrategyDelegate.deleteErrorRecordIfNeed(controlUpdateInfo);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            PlanExecuteRecord currentPlanExecuteRecord = this.controlStrategyDelegate.createPlanExecuteRecord(controlExecuteParam);
            currentPlanExecuteRecord.setAclRemainAmt(currentPlanExecuteRecord.getActAmount());
            String key = String.join((CharSequence)"#", controlExecuteParam.getBillBizInfo().getBillId().toString(), currentPlanExecuteRecord.getSystemId().toString());
            List<ControlTraceInfo> controlTraceInfoList = controlTraceInfoMap.getOrDefault(key, Collections.emptyList());
            ControlTracePlanRecordSort controlTracePlanRecordSort = this.controlStrategyDelegate.sortedExecuteRecord(controlTraceInfoList, key);
            this.deleteReleaseIfExists(controlTracePlanRecordSort, currentPlanExecuteRecord, controlUpdateInfo);
            this.cancelActualWriteIfExists(controlTracePlanRecordSort, currentPlanExecuteRecord, controlUpdateInfo);
            this.processCurrentOrUpperOccupyIfExists(controlTracePlanRecordSort, currentPlanExecuteRecord, controlUpdateInfo);
            this.controlStrategyDelegate.addWaitConsumeInfo(currentPlanExecuteRecord);
            currentPlanExecuteRecord.setControlTraceId(this.controlContext.getControlTraceId(currentPlanExecuteRecord.getBillBizInfo().getBillId()));
            controlUpdateInfo.addSavePlanExecuteRecord(currentPlanExecuteRecord);
        }
        this.controlStrategyDelegate.fillCompleteControlUpdateInfo(controlUpdateInfo);
        return controlUpdateInfo;
    }

    private void processCurrentOrUpperOccupyIfExists(ControlTracePlanRecordSort controlTracePlanRecordSort, PlanExecuteRecord currentPlanExecuteRecord, ControlUpdateInfo controlUpdateInfo) {
        boolean hasPreOccupy = controlTracePlanRecordSort.hasOccupy(currentPlanExecuteRecord);
        FundPlanSystem system = this.controlContext.getSystem(currentPlanExecuteRecord.getSystemId());
        ReportPeriodType reportPeriodType = system.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportPeriodId(), currentPlanExecuteRecord.getReportTypeId())).findFirst().get();
        if (!hasPreOccupy) {
            logger.info("\u4e1a\u52a1\u5355\u636e\uff1a{}\uff0c\u4f53\u7cfb\uff1a{}\uff0c\u7f16\u62a5\u7c7b\u578b\uff1a{}\uff0c\u672c\u5355\u636e\u53ca\u5176\u4e0a\u7ea7\u4e0d\u5b58\u5728\u9884\u5360\u8bb0\u5f55", new Object[]{currentPlanExecuteRecord.getBillBizInfo().getBillNo(), system.getName(), reportPeriodType.getName()});
            return;
        }
        BigDecimal currentActualAmt = currentPlanExecuteRecord.getActAmount();
        boolean needCreateOccupyRecord = true;
        AtomicBoolean sameDim = new AtomicBoolean(false);
        while (currentActualAmt.compareTo(BigDecimal.ZERO) != 0) {
            PlanExecuteRecord releasePlanExecuteRecord;
            PlanExecuteRecord suitRecord = controlTracePlanRecordSort.getSuitRecord(currentPlanExecuteRecord, sameDim);
            if (sameDim.get()) {
                needCreateOccupyRecord = false;
            }
            if (suitRecord == null) break;
            BigDecimal occupyAmt = suitRecord.getUnReleaseAmt();
            if (this.controlStrategyDelegate.largeThan(currentActualAmt, occupyAmt)) {
                releasePlanExecuteRecord = this.controlStrategyDelegate.getReleasePlanExecuteRecord(currentPlanExecuteRecord, suitRecord, PlanExecuteOpType.PRE_OCCUPY_RELEASE, occupyAmt);
                controlUpdateInfo.addSavePlanExecuteRecord(releasePlanExecuteRecord);
                BigDecimal releaseAmt = occupyAmt.negate();
                this.controlStrategyDelegate.updateWithHoldingAmt(releasePlanExecuteRecord, releaseAmt, false, true);
                currentActualAmt = currentActualAmt.add(releaseAmt);
                suitRecord.updateUnReleaseAmt(occupyAmt);
                controlTracePlanRecordSort.updateRecord(suitRecord);
                continue;
            }
            releasePlanExecuteRecord = this.controlStrategyDelegate.getReleasePlanExecuteRecord(currentPlanExecuteRecord, suitRecord, PlanExecuteOpType.PRE_OCCUPY_RELEASE, currentActualAmt);
            this.controlStrategyDelegate.updateWithHoldingAmt(releasePlanExecuteRecord, false, true);
            controlUpdateInfo.addSavePlanExecuteRecord(releasePlanExecuteRecord);
            suitRecord.updateUnReleaseAmt(currentActualAmt);
            controlTracePlanRecordSort.updateRecord(suitRecord);
            break;
        }
        if (!needCreateOccupyRecord) {
            return;
        }
        PlanExecuteRecord actualGenOccupyRecord = this.controlStrategyDelegate.generateRecordFormPlanExecuteRecord(currentPlanExecuteRecord, p -> {
            p.setBizOpName(currentPlanExecuteRecord.getBizOpName());
            p.setOriginalRecordId(0L);
            p.setRelateRecordId(currentPlanExecuteRecord.getId());
            p.setExecuteOpType(PlanExecuteOpType.PRE_OCCUPY_WRITE);
            p.setActAmount(currentPlanExecuteRecord.getActAmount());
        });
        controlUpdateInfo.addSavePlanExecuteRecord(actualGenOccupyRecord);
        PlanExecuteRecord releasePlanExecuteRecord = this.controlStrategyDelegate.getReleasePlanExecuteRecord(currentPlanExecuteRecord, actualGenOccupyRecord, PlanExecuteOpType.PRE_OCCUPY_RELEASE);
        this.controlStrategyDelegate.updateWithHoldingAmt(releasePlanExecuteRecord, false, true);
        controlUpdateInfo.addSavePlanExecuteRecord(releasePlanExecuteRecord);
    }

    private void cancelUpperActualWriteIfExists(ControlTracePlanRecordSort controlTracePlanRecordSort, PlanExecuteRecord currentPlanExecuteRecord, ControlUpdateInfo controlUpdateInfo) {
        Collection<PlanExecuteRecord> upperActualWriteRecordList = controlTracePlanRecordSort.getUpperByExecuteOp(PlanExecuteOpType.WRITE, currentPlanExecuteRecord);
        if (EmptyUtil.isEmpty(upperActualWriteRecordList)) {
            return;
        }
        FundPlanSystem system = this.controlContext.getSystem(currentPlanExecuteRecord.getSystemId());
        ReportPeriodType reportPeriodType = system.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportPeriodId(), currentPlanExecuteRecord.getReportTypeId())).findFirst().get();
        this.doCancelWriteActualRecords(currentPlanExecuteRecord, controlUpdateInfo, upperActualWriteRecordList, controlTracePlanRecordSort);
    }

    private void cancelActualWriteIfExists(ControlTracePlanRecordSort controlTracePlanRecordSort, PlanExecuteRecord currentPlanExecuteRecord, ControlUpdateInfo controlUpdateInfo) {
        Collection<PlanExecuteRecord> waitCancelActualWriteRecordList = controlTracePlanRecordSort.getCurrentByExecuteOp(PlanExecuteOpType.WRITE, currentPlanExecuteRecord);
        if (EmptyUtil.isEmpty(waitCancelActualWriteRecordList)) {
            this.cancelUpperActualWriteIfExists(controlTracePlanRecordSort, currentPlanExecuteRecord, controlUpdateInfo);
            return;
        }
        FundPlanSystem system = this.controlContext.getSystem(currentPlanExecuteRecord.getSystemId());
        ReportPeriodType reportPeriodType = system.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportPeriodId(), currentPlanExecuteRecord.getReportTypeId())).findFirst().get();
        this.doCancelWriteActualRecords(currentPlanExecuteRecord, controlUpdateInfo, waitCancelActualWriteRecordList, controlTracePlanRecordSort);
    }

    private void doCancelWriteActualRecords(PlanExecuteRecord currentPlanExecuteRecord, ControlUpdateInfo controlUpdateInfo, Collection<PlanExecuteRecord> waitCancelActualWriteRecordList, ControlTracePlanRecordSort controlTracePlanRecordSort) {
        if (EmptyUtil.isEmpty(waitCancelActualWriteRecordList)) {
            return;
        }
        Map<Long, List<PlanExecuteRecord>> actualWriteRelateRecordMap = controlTracePlanRecordSort.getUpperByExecuteOps(waitCancelActualWriteRecordList.iterator().next(), PlanExecuteOpType.PRE_OCCUPY_WRITE, PlanExecuteOpType.PRE_OCCUPY_RELEASE, PlanExecuteOpType.CANCEL).values().stream().flatMap(Collection::stream).filter(p -> EmptyUtil.isNoEmpty((Long)p.getRelateRecordId())).collect(Collectors.groupingBy(PlanExecuteRecord::getRelateRecordId));
        for (PlanExecuteRecord waitCancelActualWriteRecord : waitCancelActualWriteRecordList) {
            boolean isHolding;
            boolean bl = isHolding = waitCancelActualWriteRecord.getExecuteStatus() == PlanExecuteStatus.WITHHOLDING;
            if (waitCancelActualWriteRecord.getExecuteStatus() != PlanExecuteStatus.WITHHOLDING) {
                logger.info("\u5f85\u53d6\u6d88\u7684\u5b9e\u5360\u8bb0\u5f55:{}\u4e0d\u662f\u9884\u6263\u51cf\u72b6\u6001\uff0c\u9700\u8981\u751f\u6210\u4e00\u7b14\u5b9e\u5360\u53d6\u6d88\u8bb0\u5f55", (Object)waitCancelActualWriteRecord);
                PlanExecuteRecord actualWriteCancelRecord = this.controlStrategyDelegate.getReleasePlanExecuteRecord(currentPlanExecuteRecord, waitCancelActualWriteRecord, PlanExecuteOpType.CANCEL, waitCancelActualWriteRecord.getActAmount());
                controlUpdateInfo.addSavePlanExecuteRecord(actualWriteCancelRecord);
            }
            waitCancelActualWriteRecord.setDeleteStatus(isHolding);
            controlTracePlanRecordSort.markConsumed(waitCancelActualWriteRecord);
            controlUpdateInfo.addUpdatePlanExecuteRecord(waitCancelActualWriteRecord);
            this.releaseActualWithHoldingAmt(waitCancelActualWriteRecord);
            List actualWriteRelateRecordList = actualWriteRelateRecordMap.getOrDefault(waitCancelActualWriteRecord.getId(), Collections.emptyList());
            if (EmptyUtil.isEmpty(actualWriteRelateRecordList)) continue;
            for (PlanExecuteRecord actualWriteRelateRecord : actualWriteRelateRecordList) {
                actualWriteRelateRecord.setDeleteStatus(isHolding);
                controlUpdateInfo.addUpdatePlanExecuteRecord(actualWriteRelateRecord);
                if (actualWriteRelateRecord.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_WRITE) {
                    this.controlStrategyDelegate.updateWithHoldingAmt(actualWriteRelateRecord, waitCancelActualWriteRecord.getActAmount(), true, true);
                    actualWriteRelateRecord.setUnReleaseAmt(actualWriteRelateRecord.getUnReleaseAmt().subtract(waitCancelActualWriteRecord.getActAmount()));
                    controlTracePlanRecordSort.updateRecord(actualWriteRelateRecord);
                }
                if (actualWriteRelateRecord.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_RELEASE) {
                    this.controlStrategyDelegate.updateWithHoldingAmt(actualWriteRelateRecord, actualWriteRelateRecord.getActAmount(), true, true);
                    PlanExecuteRecord occupyRecord = controlTracePlanRecordSort.getById(actualWriteRelateRecord.getOriginalRecordId());
                    if (occupyRecord == null) {
                        logger.info("\u9884\u5360\u91ca\u653e\u8bb0\u5f55\uff1a{}\u5bf9\u5e94\u7684\u539f\u59cb\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u4e3a\u5f02\u5e38\u6570\u636e", (Object)actualWriteRelateRecord);
                        continue;
                    }
                    occupyRecord.setUnReleaseAmt(occupyRecord.getUnReleaseAmt().add(actualWriteRelateRecord.getActAmount().abs()));
                    controlTracePlanRecordSort.updateRecord(occupyRecord);
                }
                if (actualWriteRelateRecord.getExecuteOpType() != PlanExecuteOpType.CANCEL) continue;
                this.controlStrategyDelegate.updateWithHoldingAmt(actualWriteRelateRecord, actualWriteRelateRecord.getActAmount(), false, false);
            }
        }
    }

    private void deleteReleaseIfExists(ControlTracePlanRecordSort controlTracePlanRecordSort, PlanExecuteRecord currentPlanExecuteRecord, ControlUpdateInfo controlUpdateInfo) {
        List releasePlanExecuteRecordList = controlTracePlanRecordSort.getCurrentByExecuteOp(PlanExecuteOpType.RELEASE, currentPlanExecuteRecord).stream().filter(p -> p.getDeleteStatus() == false).filter(PlanExecuteRecord::isNotTempConsume).filter(p -> p.getExecuteStatus() == PlanExecuteStatus.SUCCESSFUL || p.getExecuteStatus() == PlanExecuteStatus.WITHHOLDING).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(releasePlanExecuteRecordList)) {
            return;
        }
        FundPlanSystem system = this.controlContext.getSystem(currentPlanExecuteRecord.getSystemId());
        ReportPeriodType reportPeriodType = system.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportPeriodId(), currentPlanExecuteRecord.getReportTypeId())).findFirst().get();
        Map actualWriteRecordMap = controlTracePlanRecordSort.getCurrentByExecuteOp(PlanExecuteOpType.WRITE, currentPlanExecuteRecord).stream().collect(Collectors.toMap(PlanExecuteRecord::getId, Function.identity(), (a, b) -> a));
        for (PlanExecuteRecord waitDeleteReleaseRecord : releasePlanExecuteRecordList) {
            this.releaseActualWithHoldingAmt(waitDeleteReleaseRecord);
            waitDeleteReleaseRecord.markTempConsume();
            BigDecimal actAmount = waitDeleteReleaseRecord.getActAmount();
            PlanExecuteRecord actualWriteRecord = (PlanExecuteRecord)actualWriteRecordMap.get(waitDeleteReleaseRecord.getOriginalRecordId());
            if (Objects.isNull(actualWriteRecord)) {
                logger.info("\u5b9e\u5360\u8fd4\u8fd8\u8bb0\u5f55\uff1a{}\uff0c\u5bf9\u5e94\u7684\u5b9e\u5360\u8bb0\u5f55id:{}\u4e0d\u5b58\u5728\uff0c\u4e3a\u5f02\u5e38\u6570\u636e", (Object)waitDeleteReleaseRecord.getRecordNumber(), (Object)waitDeleteReleaseRecord.getOriginalRecordId());
                throw new KDBizException("");
            }
            BigDecimal unReleaseAmt = actualWriteRecord.getUnReleaseAmt();
            actualWriteRecord.setUnReleaseAmt(unReleaseAmt.add(actAmount));
            controlTracePlanRecordSort.updateRecord(actualWriteRecord);
        }
    }

    private void releaseActualWithHoldingAmt(PlanExecuteRecord withHoldingRecord) {
        this.releaseActualWithHoldingAmt(withHoldingRecord, withHoldingRecord.getActAmount());
    }

    private void releaseActualWithHoldingAmt(PlanExecuteRecord withHoldingRecord, BigDecimal releaseAmt) {
        this.controlStrategyDelegate.updateWithHoldingAmt(withHoldingRecord, releaseAmt, true, false);
    }
}

