/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import org.apache.commons.collections4.MapUtils;

public class AvailableAmtReportOrgPostProcessor
implements IControlExecuteParamPostProcessor {
    private Map<Long, Long> systemReportOrgMap;
    private String reportOrgNumber;
    private static final Log logger = LogFactory.getLog(AvailableAmtReportOrgPostProcessor.class);

    public AvailableAmtReportOrgPostProcessor(Map<Long, Long> systemReportOrgMap, String reportOrgNumber) {
        this.systemReportOrgMap = systemReportOrgMap;
        this.reportOrgNumber = reportOrgNumber;
    }

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        if (MapUtils.isEmpty(this.systemReportOrgMap)) {
            return;
        }
        Iterator<ControlExecuteParam> iterator = controlExecuteParamList.iterator();
        while (iterator.hasNext()) {
            ControlExecuteParam controlExecuteParam = iterator.next();
            Long systemId = controlExecuteParam.getSystemId();
            Long reportOrgId = this.systemReportOrgMap.get(systemId);
            if (EmptyUtil.isNoEmpty((Long)reportOrgId)) {
                controlExecuteParam.setReportOrgId(reportOrgId);
                continue;
            }
            String message = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u6ca1\u6709\u7f16\u7801\u3010%2$s\u3011\u7684\u7f16\u62a5\u4e3b\u4f53\u3002", (String)"AvailableAmtReportOrgPostProcessor_0", (String)"tmc-fpm-business", (Object[])new Object[0]), controlContext.getSystem(systemId).getName(), this.reportOrgNumber);
            logger.warn(message);
            iterator.remove();
        }
    }

    @Override
    public int getOrder() {
        return -8;
    }
}

