/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fpm.business.domain.enums.ReportValueFormulaTypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.business.utils.FpmDataServiceHelper;
import kd.tmc.fpm.common.enums.DimMemberFromEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.MetricMemberDataTypeEnum;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.enums.MetricMemberUseTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class BodySystemMetricUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(BodySystemMetricUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        logger.info("[BodySystemUpgradeServiceImpl] >>>> \u4f53\u7cfb\u6570\u636e\u5f00\u59cb\u5347\u7ea7... ");
        String selectProp = "id";
        DynamicObject[] allSystem = TmcDataServiceHelper.load((String)"fpm_bodysysmanage", (String)selectProp, null);
        if (allSystem == null || allSystem.length == 0) {
            logger.info("[BodySystemUpgradeServiceImpl] >>>> \u4f53\u7cfb\u6570\u636e\u5347\u7ea7\u7ed3\u675f, \u4f53\u7cfb\u67e5\u8be2\u4e3a\u7a7a");
            return;
        }
        Arrays.stream(allSystem).forEach(item -> {
            try {
                this.doUpdate((DynamicObject)item);
            }
            catch (Exception e) {
                logger.error("[BodySystemUpgradeServiceImpl] >>>> ", (Throwable)e);
            }
        });
        logger.info("[BodySystemUpgradeServiceImpl] >>>> \u4f53\u7cfb\u6570\u636e\u5347\u7ea7\u7ed3\u675f, \u5171\u8ba1\u5347\u7ea7{}\u6761\u6570\u636e... ", (Object)allSystem.length);
    }

    private void doUpdate(DynamicObject item) {
        DynamicObject dimension;
        logger.info("[BodySystemUpgradeServiceImpl] >>>> \u4f53\u7cfb\u6570\u636e\u6b63\u5728\u5347\u7ea7{}", item.getPkValue());
        boolean dimensionExist = TmcDataServiceHelper.exists((String)"fpm_dimension", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", item.getPkValue()), new QFilter("number", "=", (Object)DimsionEnums.METRIC.getNumber())});
        if (dimensionExist) {
            logger.info("[BodySystemUpgradeServiceImpl] >>>> \u4f53\u7cfb{}\u5df2\u5b58\u5728\u5ea6\u91cf\u7ef4\u5ea6\uff0c\u7ef4\u5ea6\u65e0\u9700\u5347\u7ea7 ", item.getPkValue());
            dimension = FpmDataServiceHelper.loadSingle("fpm_dimension", new QFilter[]{new QFilter("bodysystem", "=", item.getPkValue()), new QFilter("number", "=", (Object)DimsionEnums.METRIC.getNumber())});
        } else {
            dimension = this.createDem(DimsionEnums.METRIC, item, DBServiceHelper.genGlobalLongId());
            TmcOperateServiceHelper.execOperate((String)"save", (String)"fpm_dimension", (DynamicObject[])new DynamicObject[]{dimension}, (OperateOption)OperateOption.create());
        }
        boolean exists = TmcDataServiceHelper.exists((String)"fpm_member", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", item.getPkValue()), new QFilter("dimtype", "=", (Object)DimsionEnums.METRIC.getNumber()), new QFilter("preset", "=", (Object)Boolean.TRUE)});
        if (exists) {
            logger.info("[BodySystemUpgradeServiceImpl] >>>> \u4f53\u7cfb{}\u5df2\u5b58\u5728\u9884\u7f6e\u5ea6\u91cf\uff0c\u9884\u7f6e\u5ea6\u91cf\u65e0\u9700\u5347\u7ea7 ", item.getPkValue());
            String prop = "id,metricuse,metricpresettype";
            DynamicObject[] metricMembers = TmcDataServiceHelper.load((String)"fpm_member", (String)prop, (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", item.getPkValue()), new QFilter("dimtype", "=", (Object)DimsionEnums.METRIC.getNumber()), new QFilter("preset", "=", (Object)Boolean.TRUE)});
            if (metricMembers == null || metricMembers.length == 0) {
                return;
            }
            logger.info("[BodySystemUpgradeServiceImpl] >>>> \u4f53\u7cfb{}\u5df2\u5b58\u5728\u9884\u7f6e\u5ea6\u91cf\uff0c\u9700\u5904\u7406\u9519\u8bef\u9884\u5236\u6570\u636e ", item.getPkValue());
            for (DynamicObject metricMember : metricMembers) {
                String type = metricMember.getString("metricpresettype");
                TemplateMetricType templateMetricType = TemplateMetricType.valueOf(type);
                switch (templateMetricType) {
                    case LOCKAMT: 
                    case ACTMAT: {
                        metricMember.set("metricuse", (Object)MetricMemberUseTypeEnum.EXECUTE.getValue());
                        break;
                    }
                    case REPORTPLANAMT: 
                    case ORIGINALPLANAMT: {
                        metricMember.set("metricuse", (Object)MetricMemberUseTypeEnum.AUTH.getValue());
                        break;
                    }
                }
                SaveServiceHelper.update((DynamicObject)metricMember);
            }
        } else {
            List<DynamicObject> metricModels = MetricFieldHelper.initMetricModels(item, dimension);
            TmcDataServiceHelper.save((DynamicObject[])metricModels.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject createDem(DimsionEnums dimEnums, DynamicObject model, Long id) {
        DynamicObject dimAdd = BusinessDataServiceHelper.newDynamicObject((String)"fpm_dimension");
        dimAdd.set("basedata", (Object)dimEnums.getNumber());
        dimAdd.set("number", (Object)dimEnums.getNumber());
        dimAdd.set("name", (Object)dimEnums.getName());
        dimAdd.set("bodysystem", (Object)model);
        dimAdd.set("status", (Object)BillStatusEnum.AUDIT.getValue());
        dimAdd.set("enable", (Object)1);
        dimAdd.set("id", (Object)id);
        if (dimEnums == DimsionEnums.ORG) {
            dimAdd.set("basedatabiz", (Object)"08");
            dimAdd.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
            dimAdd.set("relbasedata", (Object)"bos_org");
        }
        if (dimEnums == DimsionEnums.PERIOD) {
            dimAdd.set("memberfrom", (Object)DimMemberFromEnum.CUSTOM.getCode());
        }
        if (dimEnums == DimsionEnums.CURRENCY) {
            dimAdd.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
            dimAdd.set("relbasedata", (Object)"bd_currency");
        }
        if (dimEnums == DimsionEnums.SUBJECT || dimEnums == DimsionEnums.METRIC) {
            dimAdd.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
        }
        return dimAdd;
    }

    static class MetricFieldHelper {
        private static final Map<TemplateMetricType, Pair<String, String>> FORMULA_MAP = new HashMap<TemplateMetricType, Pair<String, String>>(8);
        private static final Map<TemplateMetricType, String> DESC_MAP = new HashMap<TemplateMetricType, String>(16);

        MetricFieldHelper() {
        }

        public static List<DynamicObject> initMetricModels(DynamicObject model, DynamicObject dimension) {
            ArrayList<DynamicObject> metricList = new ArrayList<DynamicObject>(16);
            List allPreSetMetric = Arrays.stream(TemplateMetricType.values()).filter(item -> TemplateMetricType.CUSTOM != item).collect(Collectors.toList());
            int index = 1;
            for (TemplateMetricType metricType : allPreSetMetric) {
                DynamicObject metric = MetricFieldHelper.createMetricObject(model, dimension, index);
                MetricFieldHelper.setDefaultMetricType(metricType, metric);
                metricList.add(metric);
                ++index;
            }
            return metricList;
        }

        private static void setDefaultMetricType(TemplateMetricType metricType, DynamicObject metric) {
            if (TemplateMetricType.ADJUSTAMT == metricType || TemplateMetricType.AVAILABLEAMT == metricType || TemplateMetricType.EXECUTEAMT == metricType || TemplateMetricType.EXECUTEPERCENT == metricType || TemplateMetricType.DEVIATIONPERCENT == metricType) {
                metric.set("metrictype", (Object)MetricMemberTypeEnum.ANALYSE.getValue());
            } else {
                metric.set("metrictype", (Object)MetricMemberTypeEnum.BASE.getValue());
            }
            if (TemplateMetricType.PLANREFERENCEAMT == metricType || TemplateMetricType.PLANAMT == metricType || TemplateMetricType.REPORTPLANAMT == metricType || TemplateMetricType.ORIGINALPLANAMT == metricType) {
                metric.set("metricuse", (Object)MetricMemberUseTypeEnum.AUTH.getValue());
            } else if (TemplateMetricType.LOCKAMT == metricType || TemplateMetricType.ACTMAT == metricType) {
                metric.set("metricuse", (Object)MetricMemberUseTypeEnum.EXECUTE.getValue());
            } else {
                metric.set("metricuse", (Object)MetricMemberUseTypeEnum.SELECT.getValue());
            }
            if (TemplateMetricType.EXECUTEPERCENT == metricType || TemplateMetricType.DEVIATIONPERCENT == metricType) {
                metric.set("metricdatatype", (Object)MetricMemberDataTypeEnum.PERCENT.getValue());
            } else {
                metric.set("metricdatatype", (Object)MetricMemberDataTypeEnum.MONEY.getValue());
            }
            metric.set("name", (Object)metricType.getName());
            metric.set("fullname", (Object)metricType.getName());
            Pair<String, String> formulaPair = FORMULA_MAP.get(metricType);
            metric.set("computeformula", (Object)Optional.ofNullable(formulaPair).map(Pair::getRight).orElse(""));
            metric.set("computeformulavalue_tag", (Object)Optional.ofNullable(formulaPair).map(Pair::getLeft).orElse(""));
            metric.set("description", (Object)DESC_MAP.get(metricType));
            metric.set("metricpresettype", (Object)metricType.getCode());
        }

        private static DynamicObject createMetricObject(DynamicObject model, DynamicObject dimension, int index) {
            String indexStr = String.valueOf(index);
            StringBuilder number = new StringBuilder("M0");
            if (indexStr.length() >= 2) {
                number.append(indexStr);
            } else {
                number.append("0").append(indexStr);
            }
            DynamicObject dynamicObject = TmcDataServiceHelper.newDynamicObject((String)"fpm_member");
            dynamicObject.set("bodysystem", model.getPkValue());
            dynamicObject.set("number", (Object)number.toString());
            dynamicObject.set("preset", (Object)Boolean.TRUE);
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("dimension", (Object)dimension);
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("level", (Object)1);
            dynamicObject.set("isleaf", (Object)1);
            dynamicObject.set("parent", (Object)0L);
            dynamicObject.set("dimtype", (Object)DimsionEnums.METRIC.getNumber());
            dynamicObject.set("longnumber", (Object)number.toString());
            dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
            dynamicObject.set("serial", (Object)System.nanoTime());
            return dynamicObject;
        }

        static {
            FORMULA_MAP.put(TemplateMetricType.ADJUSTAMT, (Pair<String, String>)Pair.of((Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.REPORT_QUOTA.getValue()), (Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.REPORT_QUOTA.getName())));
            FORMULA_MAP.put(TemplateMetricType.AVAILABLEAMT, (Pair<String, String>)Pair.of((Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.PRE_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getValue()), (Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.PRE_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getName())));
            FORMULA_MAP.put(TemplateMetricType.EXECUTEAMT, (Pair<String, String>)Pair.of((Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getValue()), (Object)(ReportValueFormulaTypeEnum.PLAN_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getName())));
            FORMULA_MAP.put(TemplateMetricType.EXECUTEPERCENT, (Pair<String, String>)Pair.of((Object)(ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getValue() + "/" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue()), (Object)(ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getName() + "/" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getName())));
            FORMULA_MAP.put(TemplateMetricType.DEVIATIONPERCENT, (Pair<String, String>)Pair.of((Object)("(" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getValue() + ")/" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getValue()), (Object)("(" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getName() + "-" + ReportValueFormulaTypeEnum.EXECUTED_QUOTA.getName() + ")/" + ReportValueFormulaTypeEnum.PLAN_QUOTA.getName())));
            DESC_MAP.put(TemplateMetricType.PLANAMT, ResManager.loadKDString((String)"\u6700\u65b0\u751f\u6548\u7684\u8ba1\u5212\u989d\u5ea6", (String)"BodySystemMetricUpgradeServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.REPORTPLANAMT, ResManager.loadKDString((String)"\u4e0b\u7ea7\u4e3b\u4f53\u5f80\u4e0a\u4e0a\u62a5\u7684\u989d\u5ea6", (String)"BodySystemMetricUpgradeServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.ORIGINALPLANAMT, ResManager.loadKDString((String)"\u5ba1\u6279\u6838\u5b9a\u540e\u7684\u989d\u5ea6", (String)"BodySystemMetricUpgradeServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.PLANREFERENCEAMT, ResManager.loadKDString((String)"\u4ece\u4e1a\u52a1\u7aef\u667a\u80fd\u6293\u53d6\u751f\u6210\u7684\u989d\u5ea6", (String)"BodySystemMetricUpgradeServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.LOCKAMT, ResManager.loadKDString((String)"\u9884\u5360\u6570", (String)"BodySystemMetricUpgradeServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.ACTMAT, ResManager.loadKDString((String)"\u5b9e\u5360\u6570", (String)"BodySystemMetricUpgradeServiceImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.ADJUSTAMT, ResManager.loadKDString((String)"\u672c\u671f\u8c03\u6574\u7684\u5408\u8ba1\u603b\u989d", (String)"BodySystemMetricUpgradeServiceImpl_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.AVAILABLEAMT, ResManager.loadKDString((String)"\u751f\u6548\u8ba1\u5212\u7684\u5269\u4f59\u672a\u4f7f\u7528\u989d\u5ea6", (String)"BodySystemMetricUpgradeServiceImpl_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.EXECUTEAMT, ResManager.loadKDString((String)"\u672a\u5b9e\u9645\u6267\u884c\u7684\u5269\u4f59\u989d\u5ea6", (String)"BodySystemMetricUpgradeServiceImpl_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.EXECUTEPERCENT, ResManager.loadKDString((String)"\u6267\u884c\u7387", (String)"BodySystemMetricUpgradeServiceImpl_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
            DESC_MAP.put(TemplateMetricType.DEVIATIONPERCENT, ResManager.loadKDString((String)"\u504f\u5dee\u7387", (String)"BodySystemMetricUpgradeServiceImpl_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }
}

