/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodControlStrategyType;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.DetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.control.ReportType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.query.BalanceResult;
import kd.tmc.fpm.business.domain.model.query.BalanceResultInfo;
import kd.tmc.fpm.business.domain.model.query.BalanceResultMainInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.service.IControlBizService;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dto.ControlExcuteServiceLogParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.QueryDetailParam;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.DetailCurrentControlDataFillControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.NewMatchInfoBackFillBalanceQueryControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.NewMatchInfoBackFillControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ControlBizService
implements IControlBizService {
    private IDimensionRepository dimRepo = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private IControlRepository controlRepo = FpmServiceFactory.getBizService(IControlRepository.class);
    private IReportDataQueryService reportDataQueryService;
    private IReportRepository repository = FpmServiceFactory.getBizService(IReportRepository.class);
    private static Log logger = LogFactory.getLog(ControlBizService.class);

    public ControlBizService() {
        this.reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
    }

    @Override
    public BalanceResult queryBalance(ControlContext controlContext, List<ControlExcuteServiceLogParamDTO> executeServiceLogParamDTOList, Map<String, BalanceResultInfo.DimensionAndDetailType> configMap) {
        logger.info("\u6267\u884c\u63a7\u5236\u53c2\u6570\u8f6c\u6362:{}\u3002\u3002\u3002\u3002\u3002", CommonUtils.getSubListForSize(executeServiceLogParamDTOList, 20));
        List<ControlExecuteParam> controlExecuteParamList = ConverterUtils.convertList(ControlExecuteParam.class, executeServiceLogParamDTOList);
        controlContext.setCheckDetailControl(true);
        Set<Long> systemIds = controlExecuteParamList.stream().map(ControlExecuteParam::getSystemId).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(systemIds)) {
            return BalanceResult.success();
        }
        List<ControlStrategy> controlStrategies = this.controlRepo.loadStrategy(systemIds, true);
        controlContext.addControlStrategy(controlStrategies);
        this.invokeControlParamProcessor(controlContext, controlExecuteParamList);
        if (EmptyUtil.isEmpty(controlExecuteParamList)) {
            return BalanceResult.success();
        }
        logger.info("\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e:{}\u3002\u3002\u3002\u3002\u3002", CommonUtils.getSubListForSize(executeServiceLogParamDTOList, 20));
        controlContext.setControlExecuteParamList(controlExecuteParamList);
        NewMatchInfoBackFillControlExecuteStrategy matchInfoBackFillControlExecuteStrategy = this.getMatchInfoBackFillControlExecuteStrategy(controlContext);
        matchInfoBackFillControlExecuteStrategy.beforeDoControl();
        FpmOperateResult<ControlResult> validate = matchInfoBackFillControlExecuteStrategy.validate();
        if (!validate.isSuccess()) {
            String errMsg = String.join((CharSequence)";", validate.getMessageList());
            logger.error(errMsg);
            return BalanceResult.fail(errMsg);
        }
        ControlResult controlResult = validate.getData();
        if (controlResult.isFailed()) {
            String errMsg = controlResult.getErrMsg();
            logger.error(errMsg);
            return BalanceResult.fail(errMsg);
        }
        HashSet<DimensionInfoBean> dimensionInfoBeans = new HashSet<DimensionInfoBean>(controlExecuteParamList.size());
        ArrayList<BalanceResultInfo> balanceResultInfoList = new ArrayList<BalanceResultInfo>(controlExecuteParamList.size());
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            ReportData reportData = controlExecuteParam.getReportData();
            if (EmptyUtil.isEmpty((Object)reportData)) continue;
            Long systemId = controlExecuteParam.getSystemId();
            FundPlanSystem system = controlContext.getSystem(systemId);
            ControlTime controlTime = controlContext.getControlTime(systemId);
            if (EmptyUtil.isEmpty((Object)controlTime)) {
                logger.info("\u4f53\u7cfb{}\uff0c\u4e0d\u5b58\u5728\u6709\u6548\u7684\u63a7\u5236\u6267\u884c\u65f6\u673a", (Object)system.getName());
            }
            Long reportOrgId = controlExecuteParam.getReportOrgId();
            Long periodTypeId = controlExecuteParam.getReportTypeId();
            ControlStrategy controlStrategy = controlContext.getControlStrategy(systemId, periodTypeId, reportOrgId);
            boolean needCheckStrategy = this.getNeedCheckStrategy(controlContext, controlExecuteParam);
            if (EmptyUtil.isEmpty((Object)controlStrategy) && !needCheckStrategy) {
                logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u7f16\u62a5\u7c7b\u578b\uff1a{}\uff0c\u4e0d\u5728\u6267\u884c\u63a7\u5236\u65f6\u673a\u914d\u7f6e\u7684\u53d7\u63a7\u53ca\u9884\u5360\u7684\u7f16\u62a5\u7c7b\u578b\u8303\u56f4\u5185\uff0c\u4e0d\u5b58\u5728\u63a7\u5236\u7b56\u7565\uff0c\u4e0d\u6821\u9a8c\uff0c\u81ea\u52a8\u751f\u6210\u865a\u62df\u7684\u63a7\u5236\u7b56\u7565");
                controlStrategy = this.generateControlStrategy(system, periodTypeId);
                controlContext.addControlStrategy(Collections.singletonList(controlStrategy));
            }
            if (Objects.isNull(controlStrategy)) {
                Dimension orgDimension = system.getMainDimensionByDimType(DimensionType.ORG);
                DimMember orgMember = orgDimension.getAllDimMemberList().stream().filter(dimMember -> Objects.equals(reportOrgId, dimMember.getId())).findFirst().get();
                ReportPeriodType periodType = system.getReportTypeList().stream().filter(reportPeriodType -> Objects.equals(periodTypeId, reportPeriodType.getReportPeriodId())).findFirst().get();
                String errorMessage = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u7f16\u62a5\u4e3b\u4f53\u3010%2$s\u3011\u7f16\u62a5\u7c7b\u578b\u3010%3$s\u3011\u6ca1\u6709\u6709\u6548\u7684\u63a7\u5236\u7b56\u7565", (String)"ControlBizService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), system.getName(), orgMember.getName(), periodType.getName());
                logger.info(errorMessage);
                return BalanceResult.fail(errorMessage);
            }
            reportData = this.getReportData(controlContext, controlExecuteParam, controlStrategy);
            if (!dimensionInfoBeans.add(DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, td -> td.getDimType().isSystemDim()))) continue;
            Object dimValByDimType = reportData.getDimValByDimType(DimensionType.SUBJECTS, null);
            ControlStrategyDetail controlStrategyDetail = controlStrategy.getControlStrategyDetails().stream().filter(detail -> Objects.equals(dimValByDimType, detail.getSubjectId())).findFirst().orElse(null);
            balanceResultInfoList.add(BalanceResultInfo.builder().fundPlanSystem(system).reportData(reportData).controlStrategyDetail(controlStrategyDetail).periodControlStrategy(controlStrategy.getPeriodControlStrategyType()).dimensionConfig(configMap).build(new BalanceResultMainInfo()));
        }
        return BalanceResult.success(balanceResultInfoList);
    }

    private ReportData getReportData(ControlContext controlContext, ControlExecuteParam controlExecuteParam, ControlStrategy controlStrategy) {
        List<ReportData> list = this.getReportDataList(controlContext, controlExecuteParam);
        Map<Boolean, Map<Long, List<ReportData>>> mainReportGroupMap = list.stream().collect(Collectors.groupingBy(ReportData::isMainTable, Collectors.groupingBy(ReportData::getReportId)));
        Map<Long, List<ReportData>> reportDataMap = mainReportGroupMap.get(Boolean.FALSE);
        if (!MapUtils.isNotEmpty(reportDataMap)) {
            reportDataMap = mainReportGroupMap.get(Boolean.TRUE);
        }
        if (EmptyUtil.isEmpty(list = reportDataMap.entrySet().iterator().next().getValue())) {
            return controlExecuteParam.getReportData();
        }
        ReportData rd = list.get(0);
        ReportData reportData = new ReportData(rd);
        reportData.setId(EmptyUtil.isEmpty(rd.getSourceIdList()) ? rd.getId() : rd.getSourceIdList().get(0));
        reportData.clearAmt();
        list.forEach(reportData::add);
        return reportData;
    }

    private List<ReportData> getReportDataList(ControlContext controlContext, ControlExecuteParam controlExecuteParam) {
        QueryIndexInfo<Long, ReportData> queryIndexInfo = this.getQueryIndexInfo(controlContext, controlExecuteParam);
        FundPlanSystem system = controlContext.getSystem(controlExecuteParam.getSystemId());
        ControlStrategyDetailControlInfo controlStrategyDetailControlInfo = controlContext.getControlStrategyDetailControlInfo();
        DetailControlInfo detailControlInfo = controlStrategyDetailControlInfo.getDetailControlInfo(controlExecuteParam);
        Long subjectId = controlExecuteParam.getSubjectId();
        Set<Long> optionalDimIds = detailControlInfo.getOptionalDimIds(subjectId);
        DimensionInfoBean copy = controlExecuteParam.getDimensionInfoBean().copy();
        List dimensionIdList = copy.getDimensionIdList();
        HashSet<Long> waitDelete = new HashSet<Long>(4);
        for (int i = dimensionIdList.size() - 1; i >= 4; --i) {
            Long dimensionId = (Long)dimensionIdList.get(i);
            if (optionalDimIds.contains(dimensionId)) continue;
            waitDelete.add(dimensionId);
        }
        waitDelete.forEach(arg_0 -> ((DimensionInfoBean)copy).removeDimensionInfo(arg_0));
        ReportData reportData = controlExecuteParam.getReportData();
        Object periodMemId = reportData.getDimValByDimType(DimensionType.PERIOD);
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        if (detailControlInfo.getControlStrategy().getPeriodControlStrategyType() == PeriodControlStrategyType.CURRENT_CONTROL && !Objects.equals(periodMemId, reportData.getReportPeriodId())) {
            copy.replaceValueIfContains(periodDim.getId(), (Object)reportData.getReportPeriodId());
        }
        List<ReportData> list = queryIndexInfo.findList(copy);
        Set<Long> detailDimIds = detailControlInfo.getDetailDimIds(subjectId);
        BitMap<Long, Long> detailDimBitMap = controlExecuteParam.getDetailDimBitMap();
        Set allDetailDimIds = list.stream().map(rd -> detailDimBitMap.getKeys(rd.getId())).flatMap(Collection::stream).collect(Collectors.toSet());
        detailDimIds.removeIf(t -> !allDetailDimIds.contains(t));
        if (EmptyUtil.isNoEmpty(detailDimIds)) {
            Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(reportData, detailDimIds);
            Predicate<ReportData> detailFieldMatchFilter = DimensionInfoHelper.getDetailFieldMatchFilter(detailDimValueMap);
            list = list.stream().filter(detailFieldMatchFilter).collect(Collectors.toList());
        }
        return list;
    }

    private QueryIndexInfo<Long, ReportData> getQueryIndexInfo(ControlContext controlContext, ControlExecuteParam controlExecuteParam) {
        List<ReportData> matchedReportDataList = new ArrayList<ReportData>(controlExecuteParam.getMatchedReportDataList());
        matchedReportDataList.addAll(controlExecuteParam.getMatchedSameReportDataList());
        matchedReportDataList.addAll(controlExecuteParam.getOptionalMaybeNeedReportDataList());
        matchedReportDataList = CommonUtils.getDistinctList(matchedReportDataList, ReportData::getId);
        FundPlanSystem system = controlContext.getSystem(controlExecuteParam.getSystemId());
        return QueryIndexInfoMapGenerator.buildReportDataIndex(matchedReportDataList, system);
    }

    private NewMatchInfoBackFillControlExecuteStrategy getMatchInfoBackFillControlExecuteStrategy(ControlContext controlContext) {
        return new NewMatchInfoBackFillBalanceQueryControlExecuteStrategy(new DetailCurrentControlDataFillControlExecuteStrategy(new AbstractControlExecuteStrategy(controlContext){}));
    }

    private void invokeControlParamProcessor(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        List<IControlExecuteParamPostProcessor> controlExecuteParamPostProcessorList = controlContext.getControlExecuteParamPostProcessorList();
        if (EmptyUtil.isEmpty(controlExecuteParamPostProcessorList)) {
            return;
        }
        controlExecuteParamPostProcessorList.sort(Comparator.comparing(IControlExecuteParamPostProcessor::getOrder));
        for (IControlExecuteParamPostProcessor controlExecuteParamPostProcessor : controlExecuteParamPostProcessorList) {
            controlExecuteParamPostProcessor.postProcess(controlContext, controlExecuteParamList);
        }
    }

    @Override
    public BalanceResult queryBalanceDetail(QueryDetailParam queryDetailParam) {
        Long reportId = queryDetailParam.getReportId();
        Report report = this.repository.getReportForControl(Collections.singleton(reportId)).get(reportId);
        ReportData reportMainData = this.getReportData(queryDetailParam);
        if (Objects.isNull(reportMainData)) {
            return BalanceResult.success(Collections.emptyList());
        }
        FundPlanSystem fundPlanSystem = this.dimRepo.loadSystem(report.getSystemId());
        List<ControlStrategyDetail.DetailControlBasis> subjectDetailControlBasis = this.getSubjectDetailControlBasis(report, reportMainData, fundPlanSystem);
        if (CollectionUtils.isEmpty(subjectDetailControlBasis)) {
            return BalanceResult.success(Collections.emptyList());
        }
        Map<String, BalanceResultInfo.DimensionAndDetailType> dimensionConfig = this.filterByDetailControlBasis(queryDetailParam, subjectDetailControlBasis, fundPlanSystem);
        Set dimensionIds = subjectDetailControlBasis.stream().map(ControlStrategyDetail.DetailControlBasis::getDimensionId).collect(Collectors.toSet());
        Object periodMemId = queryDetailParam.getDimensionValMap().get(new BalanceResultInfo.DimensionAndDetailType(DimensionType.PERIOD));
        Map dimensionMap = fundPlanSystem.getDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
        DimValueListInfo dimValueListInfo = new DimValueListInfo();
        List<TemplateDim> dimList = reportMainData.getDimList();
        List<Object> dataDimValList = reportMainData.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            DimensionType dimType = templateDim.getDimType();
            Long dimensionId = templateDim.getDimensionId();
            Dimension dimension = (Dimension)dimensionMap.get(dimensionId);
            if (dimType.isPeriodDim() && !Objects.equals(periodMemId, dataDimValList.get(i))) {
                DimMember periodDimMem = dimension.getAllDimMemberList().stream().filter(dimMember -> Objects.equals(periodMemId, dimMember.getId())).findFirst().get();
                dimValueListInfo.addDimensionListValue(dimension, periodDimMem.getChildren().stream().map(DimMember::getId).collect(Collectors.toList()));
                continue;
            }
            if (dimType.isSystemDim()) {
                dimValueListInfo.addDimensionValue(dimension, dataDimValList.get(i));
                continue;
            }
            if (!dimensionIds.contains(dimensionId)) continue;
            dimValueListInfo.addDimensionValue(dimension, dimension.getDimType().isDetailDim() && dimension.getDetailDimType().isExtraField() ? String.valueOf(dataDimValList.get(i)) : dataDimValList.get(i));
        }
        if (dimValueListInfo.isEmpty()) {
            return BalanceResult.success(Collections.emptyList());
        }
        List<ReportData> reportDataList = this.reportDataQueryService.queryReportDataForAllSystem(t -> {
            t.setDimIdList(dimValueListInfo.getDimensionList());
            t.setDimValList(dimValueListInfo.getDimValueList());
            t.setReportIdS(Collections.singletonList(report.getId()));
            t.setNeedDimIfValueIsNotEmpty(true);
        });
        Set<Long> detailDimIds = subjectDetailControlBasis.stream().filter(detailControlBasis -> detailControlBasis.getDimensionType().isDetailDim()).map(ControlStrategyDetail.DetailControlBasis::getDimensionId).collect(Collectors.toSet());
        Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(reportMainData, detailDimIds);
        Predicate<ReportData> detailFieldMatchFilter = DimensionInfoHelper.getDetailFieldMatchFilter(detailDimValueMap);
        reportDataList = reportDataList.stream().filter(detailFieldMatchFilter).collect(Collectors.toList());
        Map<Integer, Long> seqCustomDimMap = new CustomDimSeqServiceImpl().loadSeqCustomDimMap(fundPlanSystem.getId());
        ArrayList<BalanceResultInfo> balanceResultInfoList = new ArrayList<BalanceResultInfo>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            balanceResultInfoList.add(BalanceResultInfo.builder().fundPlanSystem(fundPlanSystem).reportData(reportData).dimensionConfig(dimensionConfig).seqCustomDimMap(seqCustomDimMap).build());
        }
        return BalanceResult.success(balanceResultInfoList);
    }

    private Map<String, BalanceResultInfo.DimensionAndDetailType> filterByDetailControlBasis(QueryDetailParam queryDetailParam, List<ControlStrategyDetail.DetailControlBasis> subjectDetailControlBasis, FundPlanSystem fundPlanSystem) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Set detailTypes = subjectDetailControlBasis.stream().map(basis -> {
            if (basis.getDimensionType() != DimensionType.DETAILDIM) {
                return new BalanceResultInfo.DimensionAndDetailType(basis.getDimensionType());
            }
            atomicBoolean.set(true);
            Optional<Dimension> first = fundPlanSystem.getDetailDimList().stream().filter(detail -> Objects.equals(detail.getId(), basis.getDimensionId())).findFirst();
            return new BalanceResultInfo.DimensionAndDetailType(DimensionType.DETAILDIM, first.get().getDetailDimType());
        }).collect(Collectors.toSet());
        HashMap<String, BalanceResultInfo.DimensionAndDetailType> map = new HashMap<String, BalanceResultInfo.DimensionAndDetailType>(8);
        Map<String, BalanceResultInfo.DimensionAndDetailType> configMap = queryDetailParam.getConfigMap();
        for (Map.Entry<String, BalanceResultInfo.DimensionAndDetailType> entry : configMap.entrySet()) {
            Optional<String> first;
            BalanceResultInfo.DimensionAndDetailType detailType = entry.getValue();
            if (atomicBoolean.get() && detailType.getDimensionType() != DimensionType.DETAILDIM) {
                map.put(entry.getKey(), detailType);
                continue;
            }
            if (detailType.getDetailDimType() == DetailDimType.COUNTERPARTY_NAME && (first = configMap.entrySet().stream().filter(en -> ((BalanceResultInfo.DimensionAndDetailType)en.getValue()).getDetailDimType() == DetailDimType.CONNTERPARTY_TYPE).map(Map.Entry::getKey).findFirst()).isPresent()) {
                String key = first.get();
                map.put(key, configMap.get(key));
            }
            map.put(entry.getKey(), detailType);
        }
        return map;
    }

    private List<ControlStrategyDetail.DetailControlBasis> getSubjectDetailControlBasis(Report report, ReportData reportMainData, FundPlanSystem fundPlanSystem) {
        List<ControlStrategyDetail.DetailControlBasis> detailControlBasisList;
        Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        Object currPeriodMemberId = reportMainData.getDimValByDimType(DimensionType.PERIOD, null);
        PeriodMember currPeriodMember = (PeriodMember)periodDim.getAllDimMemberList().stream().filter(item -> item.getId().equals(currPeriodMemberId)).findFirst().get();
        Long reportOrgId = (Long)reportMainData.getDimValByDimType(DimensionType.ORG, null);
        ControlStrategy strategy = this.controlRepo.loadStrategy(report.getSystemId(), currPeriodMember.getPeriodTypeId(), reportOrgId, true);
        if (EmptyUtil.isEmpty((Object)strategy)) {
            ReportPeriodType reportPeriodType = fundPlanSystem.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportPeriodId(), currPeriodMember.getPeriodTypeId())).findFirst().orElseGet(() -> new ReportPeriodType());
            logger.info("\u4f53\u7cfb\u3010{}\u3011\uff0c\u7f16\u62a5\u7c7b\u578b\u3010\u3011\u6ca1\u6709\u5bf9\u5e94\u7684\u63a7\u5236\u7b56\u7565", (Object)fundPlanSystem.getName(), (Object)reportPeriodType.getName());
            return Collections.emptyList();
        }
        Object dimValByDimType = reportMainData.getDimValByDimType(DimensionType.SUBJECTS, null);
        ControlStrategyDetail controlStrategyDetail = strategy.getControlStrategyDetails().stream().filter(detail -> Objects.equals(dimValByDimType, detail.getSubjectId())).findFirst().orElse(null);
        if (Objects.isNull(controlStrategyDetail) || !controlStrategyDetail.getDetailControl().booleanValue() || CollectionUtils.isEmpty(detailControlBasisList = controlStrategyDetail.getDetailControlBasisList())) {
            logger.info("\u8ba1\u5212\u79d1\u76ee\uff1a{},\u6ca1\u6709\u5f00\u542f\u6309\u660e\u7ec6\u9879\u63a7\u5236\uff0c\u6216\u672a\u914d\u7f6e\u660e\u7ec6\u63a7\u5236\u9879", (Object)(Objects.isNull(controlStrategyDetail) ? "" : controlStrategyDetail.getSubjectName()));
            return Collections.emptyList();
        }
        return detailControlBasisList;
    }

    private ReportData getReportData(QueryDetailParam queryDetailParam) {
        ReportDataQueryObject queryDataObject = new ReportDataQueryObject();
        queryDataObject.setIdList(Collections.singletonList((Long)queryDetailParam.getReportDataId()));
        queryDataObject.setNeedDimIfValueIsNotEmpty(true);
        List<ReportDataQueryResult> reportDataQueryResults = this.reportDataQueryService.queryReportData(queryDataObject);
        List<ReportData> reportDataList = ReportHelper.convert(reportDataQueryResults);
        return CollectionUtils.isEmpty(reportDataList) ? null : reportDataList.get(0);
    }

    private boolean getNeedCheckStrategy(ControlContext controlContext, ControlExecuteParam controlExecuteParam) {
        Long systemId = controlExecuteParam.getSystemId();
        ControlTime controlTime = controlContext.getControlTime(systemId);
        if (Objects.isNull(controlTime)) {
            return false;
        }
        FundPlanSystem system = controlContext.getSystem(systemId);
        List<Long> controlledReportTypeIds = controlTime.getControledReportTypeIds();
        if (EmptyUtil.isEmpty(controlledReportTypeIds)) {
            logger.info("\u4f53\u7cfb{}\uff0c\u6267\u884c\u63a7\u5236\u65f6\u673a\u6ca1\u6709\u914d\u7f6e\u53d7\u63a7\u53ca\u9884\u5360\u7684\u7f16\u62a5\u7c7b\u578b\uff0c\u6240\u6709\u7f16\u62a5\u7c7b\u578b\u90fd\u6821\u9a8c\u63a7\u5236\u7b56\u7565", (Object)system.getName());
            return true;
        }
        Long periodTypeId = controlExecuteParam.getReportTypeId();
        return controlledReportTypeIds.contains(periodTypeId);
    }

    private ControlStrategy generateControlStrategy(FundPlanSystem fundPlanSystem, Long periodTypeId) {
        ControlStrategy controlStrategy = new ControlStrategy();
        controlStrategy.setId(0L);
        controlStrategy.setSystemId(fundPlanSystem.getId());
        controlStrategy.setName("");
        controlStrategy.setNumber("");
        controlStrategy.setUnAvailableWarn(0);
        controlStrategy.setEnable(Boolean.TRUE);
        ReportType reportType = new ReportType();
        List<ReportPeriodType> reportTypeList = fundPlanSystem.getReportTypeList();
        ReportPeriodType reportPeriodType = reportTypeList.stream().filter(rpd -> Objects.equals(rpd.getReportPeriodId(), periodTypeId)).findFirst().get();
        reportType.setId(periodTypeId);
        reportType.setNumber(reportPeriodType.getNumber());
        reportType.setName(reportPeriodType.getName());
        reportType.setPeriodType(reportPeriodType.getPeriodType());
        reportType.setDetailPeriodType(reportPeriodType.getDetailPeriodType());
        controlStrategy.setReportType(Collections.singletonList(reportType));
        controlStrategy.setPeriodControlStrategyType(PeriodControlStrategyType.CURRENT_CONTROL);
        controlStrategy.setControlStrategyDetails(Collections.emptyList());
        controlStrategy.setApplyReportOrgs(Collections.emptyList());
        return controlStrategy;
    }
}

