/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.repository.IControlRequestUpdateInfoRepository;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ControlContextFillBackPostProcessor
implements IControlExecuteParamPostProcessor {
    private static final Log logger = LogFactory.getLog(ControlContextFillBackPostProcessor.class);
    private IDimensionRepository dimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private IControlRepository controlRepository = FpmServiceFactory.getBizService(IControlRepository.class);
    private IControlRequestUpdateInfoRepository controlRequestUpdateInfoRepository = FpmServiceFactory.getBizService(IControlRequestUpdateInfoRepository.class);

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> paramDTOList) {
        logger.info("\u586b\u5145\u5b8c\u6574\u4e0a\u4e0b\u6587start\u3002\u3002\u3002\u3002\u3002");
        List<BillMatchRule> billMatchRules = paramDTOList.stream().map(ControlExecuteParam::getMatchRule).collect(Collectors.toList());
        controlContext.addBillMatchRule(billMatchRules);
        Set<Long> systemIds = billMatchRules.stream().map(BillMatchRule::getSystemId).collect(Collectors.toSet());
        List<FundPlanSystem> systemList = this.dimensionRepository.loadSystems(systemIds);
        for (FundPlanSystem system : systemList) {
            controlContext.addSystem(system);
        }
        PlanExecuteOpType planExecuteOpType = controlContext.getPlanExecuteOpType();
        if (planExecuteOpType == PlanExecuteOpType.PRE_OCCUPY_WRITE || planExecuteOpType == PlanExecuteOpType.PRE_OCCUPY_DELETE) {
            if (EmptyUtil.isEmpty(systemIds)) {
                return;
            }
            List<ControlStrategy> controlStrategies = this.controlRepository.loadStrategy(systemIds, true);
            controlContext.addControlStrategy(controlStrategies);
        }
        this.getAndFillMaxRequestId(controlContext);
        logger.info("\u586b\u5145\u5b8c\u6574\u4e0a\u4e0b\u6587end\u3002\u3002\u3002\u3002");
    }

    private void getAndFillMaxRequestId(ControlContext controlContext) {
        if (!controlContext.getPlanExecuteOpType().isPositiveOp()) {
            return;
        }
        Long currentConsumedMaxRequestId = this.controlRequestUpdateInfoRepository.getCurrentInitMinRequestId();
        controlContext.setCurrentMinRequestId(currentConsumedMaxRequestId);
    }

    @Override
    public int getOrder() {
        return -90;
    }
}

