/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.model.control.DimensionMemberMappingParam;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.DetailDimensionMappingManager;
import kd.tmc.fpm.business.mvc.service.dimmapping.impl.DimensionMemberMappingManager;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ControlExecuteParamPostProcessorImpl
implements IControlExecuteParamPostProcessor {
    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        ArrayList objectDimensionMemberMappingParam = new ArrayList(controlExecuteParamList.size());
        List dimensionMemberMappingParamList = controlExecuteParamList.stream().map(p -> {
            DimensionMemberMappingParam.DimensionMemberMappingParamBuilder objBuilder = DimensionMemberMappingParam.builder();
            objectDimensionMemberMappingParam.add(objBuilder.billBizInfo(p.getBillBizInfo()).billMatchRule(p.getMatchRule()).fundPlanSystem(controlContext.getSystem(p.getSystemId())).callBack((dimension, value) -> {
                if (dimension.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                    p.setActAmount(CommonUtils.getBigDecimalValue(value));
                }
            }).build());
            DimensionMemberMappingParam.DimensionMemberMappingParamBuilder builder = DimensionMemberMappingParam.builder();
            return builder.billBizInfo(p.getBillBizInfo()).billMatchRule(p.getMatchRule()).fundPlanSystem(controlContext.getSystem(p.getSystemId())).callBack((dimension, memberId) -> {
                if (dimension.getDimType().isOrgDim()) {
                    p.setReportOrgId((Long)memberId);
                    return;
                }
                if (dimension.getDimType().isSubjectDim()) {
                    p.setSubjectId((Long)memberId);
                    return;
                }
            }).build();
        }).collect(Collectors.toList());
        DimensionMemberMappingManager memberMappingManager = new DimensionMemberMappingManager();
        controlExecuteParamList.stream().map(ControlExecuteParam::getSystemId).map(controlContext::getSystem).map(FundPlanSystem::getMainDimList).flatMap(Collection::stream).filter(dimension -> dimension.getDimType().isSubjectDim() || dimension.getDimType().isOrgDim()).map(Dimension::getId).forEach(memberMappingManager::addDimensionId);
        memberMappingManager.process(dimensionMemberMappingParamList);
        DetailDimensionMappingManager detailDimensionMappingManager = new DetailDimensionMappingManager();
        controlExecuteParamList.stream().map(ControlExecuteParam::getSystemId).map(controlContext::getSystem).map(system -> system.getDetailDimensionByDetailType(DetailDimType.PLAN_AMOUNT)).map(Dimension::getId).forEach(detailDimensionMappingManager::addDimensionId);
        if (controlContext.getPlanExecuteOpType().isRelease() || controlContext.getPlanExecuteOpType().isUpdate()) {
            return;
        }
        detailDimensionMappingManager.process(objectDimensionMemberMappingParam);
    }

    @Override
    public int getOrder() {
        return -10;
    }
}

