/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;

public class ControlExecuteTimeUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ControlExecuteTimeUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        logger.info("\u63a7\u5236\u65f6\u673a\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
        QFilter qFilter = new QFilter("controlledreporttype.fbasedataid", "is null", null);
        DynamicObject[] executeTimes = BusinessDataServiceHelper.load((String)"fpm_executetime", (String)"number,bodysys,controlledreporttype", (QFilter[])new QFilter[]{qFilter});
        List bodysysIds = Arrays.stream(executeTimes).filter(o -> EmptyUtil.isNoEmpty((DynamicObject)o.getDynamicObject("bodysys"))).map(o -> o.getDynamicObject("bodysys").getPkValue()).collect(Collectors.toList());
        DynamicObject[] bodySystems = BusinessDataServiceHelper.load((Object[])bodysysIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage"));
        Map bodySystemRelationMap = Arrays.stream(bodySystems).collect(Collectors.toMap(o -> o.getPkValue(), Function.identity()));
        for (DynamicObject executeTime : executeTimes) {
            DynamicObject bodySysDy = executeTime.getDynamicObject("bodysys");
            if (EmptyUtil.isEmpty((DynamicObject)bodySysDy)) continue;
            Object bodysysId = bodySysDy.getPkValue();
            DynamicObject bodySystem = (DynamicObject)bodySystemRelationMap.get(bodysysId);
            DynamicObjectCollection applyrereportentry = bodySystem.getDynamicObjectCollection("applyrereportentry");
            List<DynamicObject> rerportTypeDys = applyrereportentry.stream().filter(o -> o.getString("rereporttypestatus").equals("enable")).map(o -> o.getDynamicObject("rerporttype")).collect(Collectors.toList());
            DynamicObjectCollection controlTypeLst = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)executeTime, (String)"controlledreporttype", (DynamicObject[])rerportTypeDys.toArray(new DynamicObject[0]));
            executeTime.set("controlledreporttype", (Object)controlTypeLst);
        }
        SaveServiceHelper.save((DynamicObject[])executeTimes);
        logger.info("\u63a7\u5236\u65f6\u673a\u6570\u636e\u5347\u7ea7\u7ed3\u675f");
    }
}

