/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.ControlRequestStatus;
import kd.tmc.fpm.business.domain.model.control.ControlRequestUpdateInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IControlRequestUpdateInfoRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ControlRequestUpdateInfoRepository;
import kd.tmc.fpm.business.mvc.service.control.serial.ControlSerialManager;
import kd.tmc.fpm.business.mvc.service.control.serial.ControlUpdateSerialManager;
import kd.tmc.fpm.business.utils.CommonUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ControlRequestUpdateRecordManager {
    private static final Log logger = LogFactory.getLog(ControlRequestUpdateRecordManager.class);
    private static IControlRequestUpdateInfoRepository controlRequestUpdateInfoRepository = new ControlRequestUpdateInfoRepository();
    private static IReportDataQueryService reportDataQueryService = new ReportDataQueryService();
    private ControlRequestUpdateInfo controlRequestUpdateInfo;
    private List<ControlRequestUpdateInfo> preControlRequestUpdateInfoList;
    private List<ReportData> concurrentReportDataList;

    private ControlRequestUpdateRecordManager(ControlRequestUpdateInfo controlRequestUpdateInfo) {
        this.controlRequestUpdateInfo = controlRequestUpdateInfo;
        this.preControlRequestUpdateInfoList = new ArrayList<ControlRequestUpdateInfo>(8);
        this.concurrentReportDataList = Collections.emptyList();
    }

    public static ControlRequestUpdateRecordManager getInstance(ControlRequestUpdateInfo controlRequestUpdateInfo) {
        if (Objects.isNull(controlRequestUpdateInfo)) {
            throw new KDBizException("ControlRequestUpdateInfo should not null");
        }
        FpmOperateResult result = CommonUtils.processInNewTransaction(() -> {
            Long serial = ControlSerialManager.getControlSerialManager().incrementAndGet();
            controlRequestUpdateInfo.setId(DB.genGlobalLongId());
            controlRequestUpdateInfo.setRequestId(serial);
            logger.info("\u521d\u59cb\u5316\u5f53\u524d\u8bf7\u6c42\u66f4\u65b0\u5bf9\u8c61\uff1a{},\u5e8f\u53f7\uff1a{}", (Object)controlRequestUpdateInfo, (Object)serial);
            controlRequestUpdateInfoRepository.save(controlRequestUpdateInfo);
            return FpmOperateResult.success();
        });
        ControlRequestUpdateRecordManager.checkFailThrow(result);
        ControlRequestUpdateRecordManager controlRequestUpdateRecordManager = new ControlRequestUpdateRecordManager(controlRequestUpdateInfo);
        return controlRequestUpdateRecordManager;
    }

    public static ControlRequestUpdateRecordManager getInstanceByRequestId(Long requestId) {
        return ControlRequestUpdateRecordManager.getInstanceByRequestId(requestId, requestId);
    }

    public static ControlRequestUpdateRecordManager getInstanceByRequestId(Long requestId, Long currentMinRequestId) {
        logger.info("\u83b7\u53d6requestId\uff1a{}\u7684\u63a7\u5236\u8bf7\u6c42\u66f4\u65b0\u8bb0\u5f55\u7ba1\u7406\u5668", (Object)requestId);
        AtomicReference atomicReference = new AtomicReference();
        FpmOperateResult operateResult = CommonUtils.processInNewTransaction(() -> {
            ControlUpdateSerialManager.getControlUpdateSerialManager().increment();
            List<ControlRequestUpdateInfo> controlRequestUpdateInfoLessThanRequestId = controlRequestUpdateInfoRepository.getControlRequestUpdateInfoLessThanRequestId(requestId, currentMinRequestId);
            if (EmptyUtil.isEmpty(controlRequestUpdateInfoLessThanRequestId)) {
                return FpmOperateResult.success();
            }
            Map requestUpdateInfoMap = controlRequestUpdateInfoLessThanRequestId.stream().collect(Collectors.toMap(ControlRequestUpdateInfo::getRequestId, Function.identity(), (a, b) -> a));
            ControlRequestUpdateInfo controlRequestUpdateInfo = (ControlRequestUpdateInfo)requestUpdateInfoMap.get(requestId);
            ControlRequestUpdateRecordManager manager = new ControlRequestUpdateRecordManager(controlRequestUpdateInfo);
            atomicReference.set(manager);
            if (controlRequestUpdateInfoLessThanRequestId.size() == 1) {
                logger.info("\u5f53\u524d\u8bf7\u6c42:{} \u6ca1\u6709\u8ddf\u5176\u4ed6\u7ebf\u7a0b\u4ea7\u751f\u5e76\u53d1\u3002\u3002\u3002", (Object)requestId);
                return FpmOperateResult.success(controlRequestUpdateInfoLessThanRequestId);
            }
            Set<Long> reportDataIds = controlRequestUpdateInfo.getReportDataIds();
            if (EmptyUtil.isEmpty(reportDataIds)) {
                return FpmOperateResult.success(controlRequestUpdateInfoLessThanRequestId);
            }
            List<ReportData> reportDataList = reportDataQueryService.queryReportData(t -> t.setIdList(new ArrayList<Long>(reportDataIds)));
            manager.concurrentReportDataList = reportDataList;
            return FpmOperateResult.success(controlRequestUpdateInfoLessThanRequestId.stream().filter(info -> info.getControlRequestStatus().isInit()).collect(Collectors.toList()));
        });
        ControlRequestUpdateRecordManager.checkFailThrow(operateResult);
        ControlRequestUpdateRecordManager controlRequestUpdateRecordManager = (ControlRequestUpdateRecordManager)atomicReference.get();
        if (Objects.isNull(controlRequestUpdateRecordManager)) {
            throw new KDBizException("requestId:{} ControlRequestUpdateRecordManager is null");
        }
        List controlRequestUpdateInfoList = (List)operateResult.getData();
        ControlRequestUpdateRecordManager.fillPreRecordIfNeed(controlRequestUpdateRecordManager, controlRequestUpdateInfoList);
        logger.info("\u5f53\u524d\u8bf7\u6c42:{}\uff0c\u5f53\u524d\u7ebf\u7a0b\u6267\u884c\u524d\u5b58\u5728\uff1a{}\u4e2a\u5e76\u53d1\u8bf7\u6c42", (Object)requestId, (Object)controlRequestUpdateRecordManager.getPreControlRequestUpdateInfoList().size());
        return controlRequestUpdateRecordManager;
    }

    public static void updateConsumed(Long requestId) {
        if (EmptyUtil.isEmpty((Long)requestId)) {
            return;
        }
        logger.info("\u51c6\u5907\u66f4\u65b0{}\u4e3a\u5df2\u6d88\u8d39", (Object)requestId);
        ControlRequestUpdateRecordManager instanceByRequestId = ControlRequestUpdateRecordManager.getInstanceByRequestId(requestId);
        instanceByRequestId.updateControlRequestConsumed();
    }

    private static void fillPreRecordIfNeed(ControlRequestUpdateRecordManager controlRequestUpdateRecordManager, List<ControlRequestUpdateInfo> controlRequestUpdateInfoList) {
        ControlRequestUpdateInfo controlRequestUpdateInfo = controlRequestUpdateRecordManager.getControlRequestUpdateInfo();
        if (!controlRequestUpdateInfo.getPlanExecuteOpType().isOccupy()) {
            return;
        }
        Long requestId = controlRequestUpdateInfo.getRequestId();
        Set<Long> reportDataIds = controlRequestUpdateInfo.getReportDataIds();
        for (ControlRequestUpdateInfo info : controlRequestUpdateInfoList) {
            if (Objects.equals(info, controlRequestUpdateInfo)) continue;
            if (!info.getControlRequestStatus().isInit()) {
                logger.info("\u5f53\u524d\u8bf7\u6c42\uff1a{}\u7684\u524d\u7f6e\u8bf7\u6c42\uff1a{}\u5df2\u7ecf\u4e0d\u662f\u521d\u59cb\u72b6\u6001", (Object)requestId, (Object)info.getRequestId());
                continue;
            }
            Set<Long> concurrentReportDataIds = info.getReportDataIds();
            Collection intersection = CollectionUtils.intersection(reportDataIds, concurrentReportDataIds);
            if (EmptyUtil.isEmpty((Collection)intersection)) {
                logger.info("\u5f53\u524d\u8bf7\u6c42\uff1a{}\u4e0e\u524d\u7f6e\u5e76\u53d1\u8bf7\u6c42:{}\u4e0d\u5b58\u5728\u6570\u636e\u4ea4\u96c6", (Object)requestId, (Object)info.getRequestId());
                continue;
            }
            controlRequestUpdateRecordManager.addPreControlRequestUpdateInfo(info);
        }
    }

    public static void deleteControlUpdateRecordInfoIfNeed(Long requestId) {
        if (EmptyUtil.isEmpty((Long)requestId)) {
            return;
        }
        ControlRequestUpdateRecordManager controlRequestUpdateRecordManager = ControlRequestUpdateRecordManager.getInstanceByRequestId(requestId);
        controlRequestUpdateRecordManager.updateControlRequestToDelete();
    }

    public List<ReportData> getConcurrentReportDataList() {
        return this.concurrentReportDataList;
    }

    public void addPreControlRequestUpdateInfo(ControlRequestUpdateInfo controlRequestUpdateInfo) {
        if (this.preControlRequestUpdateInfoList.contains(controlRequestUpdateInfo)) {
            return;
        }
        this.preControlRequestUpdateInfoList.add(controlRequestUpdateInfo);
    }

    public void updateControlRequestToConsume() {
        logger.info("\u9884\u5904\u7406\u5b8c\u6bd5\uff0c\u66f4\u65b0\uff1acontrolRequestUpdateInfo\uff1a{}\u4e3a\u5f85\u6d88\u8d39", (Object)this.controlRequestUpdateInfo.getRequestId());
        this.controlRequestUpdateInfo.setControlRequestStatus(ControlRequestStatus.WAIT_CONSUME);
        controlRequestUpdateInfoRepository.update(this.controlRequestUpdateInfo);
    }

    public void updateControlRequestConsumed() {
        logger.info("confirm\u5b8c\u6bd5\uff0c\u66f4\u65b0\uff1acontrolRequestUpdateInfo\uff1a{}\u4e3a\u5df2\u6d88\u8d39", (Object)this.controlRequestUpdateInfo.getRequestId());
        this.controlRequestUpdateInfo.setControlRequestStatus(ControlRequestStatus.CONSUMED);
        FpmOperateResult result = CommonUtils.processInTransaction(() -> {
            controlRequestUpdateInfoRepository.update(this.controlRequestUpdateInfo);
            return FpmOperateResult.success();
        });
        ControlRequestUpdateRecordManager.checkFailThrow(result);
    }

    public void updateControlRequestToDeleteNotNewTransaction() {
        logger.info("\u9884\u5904\u7406\u5b8c\u6bd5\uff0c\u66f4\u65b0\uff1acontrolRequestUpdateInfo\uff1a{}\u4e3a\u5f85\u6d88\u8d39", (Object)this.controlRequestUpdateInfo.getRequestId());
        this.controlRequestUpdateInfo.setControlRequestStatus(ControlRequestStatus.DELETED);
        controlRequestUpdateInfoRepository.update(this.controlRequestUpdateInfo);
    }

    public void updateControlRequestToDelete() {
        logger.info("\u7b2c\u4e8c\u6b21\u63a7\u5236\u6821\u9a8c\u4e0d\u901a\u8fc7\u6216rollback\uff0c\u66f4\u65b0\uff1acontrolRequestUpdateInfo\uff1a{}\u5df2\u5220\u9664", (Object)this.controlRequestUpdateInfo.getRequestId());
        this.updateControlRequestUpdateInfoStatus(ControlRequestStatus.DELETED);
    }

    private <T> void updateControlRequestUpdateInfoStatus(ControlRequestStatus status) {
        FpmOperateResult result = CommonUtils.processInTransactionRequiresNew(() -> {
            this.controlRequestUpdateInfo.setControlRequestStatus(status);
            controlRequestUpdateInfoRepository.update(this.controlRequestUpdateInfo);
            return FpmOperateResult.success();
        });
        ControlRequestUpdateRecordManager.checkFailThrow(result);
    }

    public ControlRequestUpdateInfo getControlRequestUpdateInfo() {
        return this.controlRequestUpdateInfo;
    }

    public List<ControlRequestUpdateInfo> getPreControlRequestUpdateInfoList() {
        return this.preControlRequestUpdateInfoList;
    }

    private static <T> void checkFailThrow(FpmOperateResult<T> fpmOperateResult) {
        if (fpmOperateResult.isSuccess()) {
            return;
        }
        throw new KDBizException(String.join((CharSequence)".", fpmOperateResult.getMessageList()));
    }
}

