/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.IExecuteTimeService;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ControlTimeCheckProcessor
implements IControlExecuteParamPostProcessor {
    private static final Log logger = LogFactory.getLog(ControlTimeCheckProcessor.class);
    private IExecuteTimeService executeTimeService = FpmServiceFactory.getBizService(IExecuteTimeService.class);

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        Iterator<ControlExecuteParam> iterator = controlExecuteParamList.iterator();
        logger.info("\u6821\u9a8c\u6267\u884c\u63a7\u5236\u65f6\u673astart:\u539f\u5927\u5c0f\uff1a{}\u3002\u3002\u3002\u3002\u3002", (Object)controlExecuteParamList.size());
        while (iterator.hasNext()) {
            boolean hasConfig;
            ControlExecuteParam controlExecuteParam = iterator.next();
            Long systemId = controlExecuteParam.getSystemId();
            ControlTime controlTime = controlContext.getControlTime(systemId);
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            if (controlTime == null) {
                iterator.remove();
                continue;
            }
            if (Objects.equals(controlContext.getOpName(), "inspect-repair") || (hasConfig = this.executeTimeService.hasConfig(controlTime, controlContext.getOpName(), billBizInfo.getEntityType(), controlContext.getPlanExecuteOpType()))) continue;
            iterator.remove();
        }
        logger.info("\u6821\u9a8c\u6267\u884c\u63a7\u5236\u65f6\u673aend:\u6821\u9a8c\u540e\u5927\u5c0f\uff1a{}\u3002\u3002\u3002\u3002\u3002", (Object)controlExecuteParamList.size());
    }

    @Override
    public int getOrder() {
        return -100;
    }
}

