/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillControlTraceIdInfo;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.ControlPreTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.domain.model.control.ControlTraceDetailInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceIdInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.control.PlanRecordInfo;
import kd.tmc.fpm.business.helper.ControlBOTPHelper;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.service.IControlTraceService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class ControlTraceServiceImpl
implements IControlTraceService {
    private IControlRepository controlRepository = FpmServiceFactory.getBizService(IControlRepository.class);
    private static Log logger = LogFactory.getLog(ControlTraceServiceImpl.class);

    @Override
    public List<ControlTraceInfo> getControlTraceInfo(BillBizInfo billBizInfo, Long systemId) {
        return this.getControlTraceInfo(billBizInfo, systemId, null);
    }

    @Override
    public List<ControlTraceInfo> getControlTraceInfo(BillBizInfo billBizInfo, Long systemId, Predicate<PlanExecuteRecord> predicate) {
        List<ControlBOTPInfo> controlBotpInfoLst;
        if (Objects.isNull(predicate)) {
            predicate = this.getSuccessAndWithHoldingPredicate();
        }
        if (Objects.isNull(controlBotpInfoLst = ControlBOTPHelper.findUpBill(billBizInfo.getEntityType(), billBizInfo.getBillId()))) {
            controlBotpInfoLst = new ArrayList<ControlBOTPInfo>(1);
        }
        Predicate<String> configBillFilter = this.getConfigBillFilter(systemId);
        controlBotpInfoLst = controlBotpInfoLst.stream().filter(info -> configBillFilter.test(info.getEntityType())).collect(Collectors.toList());
        ControlBOTPInfo controlBOTPInfoCurrent = new ControlBOTPInfo();
        controlBOTPInfoCurrent.setId(billBizInfo.getBillId());
        controlBOTPInfoCurrent.setEntityType(billBizInfo.getEntityType());
        controlBOTPInfoCurrent.setLevel(-1);
        controlBotpInfoLst.add(controlBOTPInfoCurrent);
        HashSet<Long> upperBillIdSet = new HashSet<Long>(controlBotpInfoLst.size());
        HashSet<String> upperBillTypes = new HashSet<String>(16);
        Map<String, ControlBOTPInfo> botpInfoMap = this.fillUpperBillInfoAndGetBillInfoMap(controlBotpInfoLst, upperBillIdSet, upperBillTypes);
        Comparator<PlanExecuteRecord> comparator = this.getComparator(botpInfoMap);
        Predicate<PlanExecuteRecord> filter = this.getFilter(botpInfoMap);
        filter = filter.and(predicate);
        List<PlanExecuteRecord> records = this.controlRepository.loadPlanExecuteRecordBySystem(upperBillIdSet, upperBillTypes, Collections.singleton(systemId));
        if (EmptyUtil.isEmpty(records)) {
            return Collections.emptyList();
        }
        TreeMap<Integer, ControlTraceInfo> traceInfoMap = new TreeMap<Integer, ControlTraceInfo>(Integer::compareTo);
        Consumer<PlanExecuteRecord> consumer = this.getConsumer(traceInfoMap, botpInfoMap);
        records.stream().filter(filter::test).sorted(comparator::compare).forEach(consumer::accept);
        ArrayList<ControlTraceInfo> controlTraceInfoList = new ArrayList<ControlTraceInfo>(traceInfoMap.values());
        this.logger(controlTraceInfoList, systemId);
        return controlTraceInfoList;
    }

    private void logger(List<ControlTraceInfo> controlTraceInfoList, Long systemId) {
        if (EmptyUtil.isEmpty(controlTraceInfoList)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (ControlTraceInfo controlTraceInfo : controlTraceInfoList) {
            List<PlanExecuteRecord> executeRecordList = controlTraceInfo.getExecuteRecordList();
            sb.append("systemId:").append(systemId).append("billId:").append(controlTraceInfo.getBillId()).append(",entityType:").append(controlTraceInfo.getEntityType()).append(",billNo:").append(controlTraceInfo.getBillNo()).append(",executePlanRecords:").append(EmptyUtil.isEmpty(executeRecordList) ? 0 : executeRecordList.size()).append(";");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            logger.info(sb.toString());
        }
    }

    private Predicate<PlanExecuteRecord> getSuccessAndWithHoldingPredicate() {
        return planExecuteRecord -> {
            if (planExecuteRecord.getDeleteStatus().booleanValue()) {
                return false;
            }
            if (planExecuteRecord.getExecuteStatus() == PlanExecuteStatus.SUCCESSFUL) {
                return true;
            }
            return planExecuteRecord.getExecuteStatus() == PlanExecuteStatus.WITHHOLDING;
        };
    }

    @Override
    public ControlTraceInfo getLastBillControlTraceInfo(BillBizInfo billBizInfo) {
        return null;
    }

    @Override
    public ControlTraceDetailInfo getControlTraceDetailInfo(BillBizInfo billBizInfo, Long systemId) {
        return this.getControlTraceDetailInfo(billBizInfo, systemId, planExecuteRecord -> true);
    }

    @Override
    public ControlTraceDetailInfo getControlTraceDetailInfo(BillBizInfo billBizInfo, Long systemId, Predicate<PlanExecuteRecord> predicate) {
        ControlTraceDetailInfo traceDetailInfo = new ControlTraceDetailInfo();
        List<ControlTraceInfo> controlTraceInfoList = this.getControlTraceInfo(billBizInfo, systemId, predicate);
        if (EmptyUtil.isEmpty(controlTraceInfoList)) {
            return traceDetailInfo;
        }
        ControlTraceInfo controlTraceInfoCurrent = controlTraceInfoList.get(0);
        traceDetailInfo.setCurrentPlanRecordInfo(controlTraceInfoCurrent.getExecuteRecordList().stream().filter(predicate::test).map(planExecuteRecord -> new PlanRecordInfo((PlanExecuteRecord)planExecuteRecord)).collect(Collectors.toList()));
        for (int i = 1; i < controlTraceInfoList.size(); ++i) {
            ControlTraceInfo controlTraceInfo = controlTraceInfoList.get(i);
            traceDetailInfo.addUpperPlanRecordInfo(controlTraceInfo.getExecuteRecordList().stream().filter(predicate::test).map(planExecuteRecord -> new PlanRecordInfo((PlanExecuteRecord)planExecuteRecord)).collect(Collectors.toList()));
        }
        return traceDetailInfo;
    }

    @Override
    public ControlTraceIdInfo getControlTraceIds(List<BillBizInfo> billBizInfoList) {
        ControlTraceIdInfo controlTraceIdInfo = new ControlTraceIdInfo();
        for (BillBizInfo billBizInfo : billBizInfoList) {
            List<ControlBOTPInfo> controlBotpInfoLst = ControlBOTPHelper.findUpBill(billBizInfo.getEntityType(), billBizInfo.getBillId());
            this.addCurrent(controlBotpInfoLst, billBizInfo);
            HashSet<Long> upperBillIdSet = new HashSet<Long>(controlBotpInfoLst.size());
            HashSet<String> upperBillTypes = new HashSet<String>(16);
            this.fillUpperBillInfoAndGetBillInfoMap(controlBotpInfoLst, upperBillIdSet, upperBillTypes);
            List<BillControlTraceIdInfo> billControlTraceIdInfoList = this.controlRepository.loadControlTraceIdByBillInfo(upperBillIdSet, upperBillTypes);
            Map<String, List<BillControlTraceIdInfo>> entityTypeBillControlTraceIdMap = billControlTraceIdInfoList.stream().collect(Collectors.groupingBy(BillControlTraceIdInfo::getEntityType));
            controlBotpInfoLst.sort(Comparator.comparing(ControlBOTPInfo::getLevel));
            Long controlTraceId = controlBotpInfoLst.get(controlBotpInfoLst.size() - 1).getId();
            boolean isFirst = true;
            for (ControlBOTPInfo controlBOTPInfo : controlBotpInfoLst) {
                List<BillControlTraceIdInfo> billControlTraceIdInfos = entityTypeBillControlTraceIdMap.get(controlBOTPInfo.getEntityType());
                if (EmptyUtil.isEmpty(billControlTraceIdInfos)) continue;
                controlTraceId = billControlTraceIdInfos.get(0).getControlTraceId();
                isFirst = false;
                break;
            }
            controlTraceIdInfo.addControlTraceId(controlTraceId, billBizInfo, isFirst);
        }
        return controlTraceIdInfo;
    }

    private void addCurrent(List<ControlBOTPInfo> controlBotpInfoLst, BillBizInfo billBizInfo) {
        ControlBOTPInfo controlBOTPInfoCurrent = new ControlBOTPInfo();
        controlBOTPInfoCurrent.setId(billBizInfo.getBillId());
        controlBOTPInfoCurrent.setEntityType(billBizInfo.getEntityType());
        controlBOTPInfoCurrent.setLevel(-1);
        controlBotpInfoLst.add(controlBOTPInfoCurrent);
    }

    private Map<String, ControlBOTPInfo> fillUpperBillInfoAndGetBillInfoMap(List<ControlBOTPInfo> controlBotpInfoLst, Set<Long> upperBillIdSet, Set<String> upperBillTypes) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, ControlBOTPInfo> map = new HashMap<String, ControlBOTPInfo>(controlBotpInfoLst.size());
        for (ControlBOTPInfo info : controlBotpInfoLst) {
            Long billId = info.getId();
            String entityType = info.getEntityType();
            upperBillIdSet.add(billId);
            upperBillTypes.add(entityType);
            sb.append(ResManager.loadKDString((String)"\u5f85\u67e5\u8be2\u4e0a\u6e38\u5355\u636eId:", (String)"ControlTraceServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0])).append(billId).append(",").append(ResManager.loadKDString((String)"\u5f85\u67e5\u8be2\u4e0a\u6e38\u5355\u636e\u7c7b\u578b\uff1a", (String)"ControlTraceServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0])).append(entityType).append(",").append(ResManager.loadKDString((String)"\u5f85\u67e5\u8be2\u5355\u636e\u672a\u7b2c\uff1a", (String)"ControlTraceServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0])).append(info.getLevel()).append(ResManager.loadKDString((String)"\u5c42\u4e0a\u6e38\u5355\u636e\uff1b", (String)"ControlTraceServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]));
            String key = String.join((CharSequence)"#", String.valueOf(billId), entityType);
            map.putIfAbsent(key, info);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            logger.info(sb.toString());
        }
        return map;
    }

    private Comparator<PlanExecuteRecord> getComparator(Map<String, ControlBOTPInfo> infoMap) {
        return (o1, o2) -> {
            Integer levelTwo;
            Long billIdOne = o1.getBillBizInfo().getBillId();
            String entityTypeOne = o1.getBillBizInfo().getEntityType();
            String keyOne = String.join((CharSequence)"#", String.valueOf(billIdOne), entityTypeOne);
            ControlBOTPInfo controlBOTPInfoOne = (ControlBOTPInfo)infoMap.get(keyOne);
            if (Objects.isNull(controlBOTPInfoOne)) {
                return -1;
            }
            Long billIdTwo = o2.getBillBizInfo().getBillId();
            String entityTypeTwo = o2.getBillBizInfo().getEntityType();
            String keyTwo = String.join((CharSequence)"#", String.valueOf(billIdTwo), entityTypeTwo);
            ControlBOTPInfo controlBOTPInfoSec = (ControlBOTPInfo)infoMap.get(keyTwo);
            if (Objects.isNull(controlBOTPInfoSec)) {
                return 1;
            }
            Integer levelOne = controlBOTPInfoOne.getLevel();
            if (Objects.equals(levelOne, levelTwo = controlBOTPInfoSec.getLevel())) {
                return Objects.compare(o1.getExecuteDate(), o2.getExecuteDate(), Date::compareTo);
            }
            return levelOne - levelTwo;
        };
    }

    private Predicate<PlanExecuteRecord> getFilter(Map<String, ControlBOTPInfo> botpInfoMap) {
        return planExecuteRecord -> {
            Long billId = planExecuteRecord.getBillBizInfo().getBillId();
            String entityType = planExecuteRecord.getBillBizInfo().getEntityType();
            String key = String.join((CharSequence)"#", String.valueOf(billId), entityType);
            return botpInfoMap.containsKey(key);
        };
    }

    private Consumer<PlanExecuteRecord> getConsumer(Map<Integer, ControlTraceInfo> traceInfoMap, Map<String, ControlBOTPInfo> botpInfoMap) {
        return planExecuteRecord -> {
            Long billId = planExecuteRecord.getBillBizInfo().getBillId();
            String entityType = planExecuteRecord.getBillBizInfo().getEntityType();
            String key = String.join((CharSequence)"#", String.valueOf(billId), entityType);
            ControlBOTPInfo controlBOTPInfo = (ControlBOTPInfo)botpInfoMap.get(key);
            Integer level = controlBOTPInfo.getLevel();
            String billNo = planExecuteRecord.getBillBizInfo().getBillNo();
            ControlTraceInfo controlTraceInfo = traceInfoMap.computeIfAbsent(level, k -> {
                ControlTraceInfo traceInfo = new ControlTraceInfo();
                traceInfo.setBillId(billId);
                traceInfo.setBillNo(billNo);
                traceInfo.setEntityType(entityType);
                return traceInfo;
            });
            controlTraceInfo.getExecuteRecordList().add((PlanExecuteRecord)planExecuteRecord);
        };
    }

    private Predicate<String> getConfigBillFilter(Long systemId) {
        List<ControlTime> controlTimes = this.controlRepository.loadControlTime(systemId, true);
        HashSet entityTypes = new HashSet(16);
        if (EmptyUtil.isEmpty(controlTimes)) {
            return entityTypes::contains;
        }
        for (ControlTime controlTime : controlTimes) {
            List<ControlPreTime> controlPreTimeList = controlTime.getControlPreTimeList();
            if (EmptyUtil.isEmpty(controlPreTimeList)) continue;
            entityTypes.addAll(controlPreTimeList.stream().map(ControlPreTime::getBizBill).collect(Collectors.toSet()));
            List<ControlActTime> controlActTimeList = controlTime.getControlActTimeList();
            if (EmptyUtil.isEmpty(controlActTimeList)) continue;
            entityTypes.addAll(controlActTimeList.stream().map(ControlActTime::getBizBill).collect(Collectors.toSet()));
        }
        return entityTypes::contains;
    }
}

