/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.common.enums.DimMemberFromEnum;
import kd.tmc.fpm.common.enums.DimensionRelEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;

public class DimensionFieldsUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(DimensionFieldsUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        logger.info("[DimensionFieldsUpgradeServiceImpl] >>>> \u7ef4\u5ea6\u5b57\u6bb5\u6570\u636e\u5f00\u59cb\u5347\u7ea7... ");
        String selectProp = "id,basedata,bodysystem,memberfrom,relbasedata,dimensionrel";
        ArrayList<String> baseData = new ArrayList<String>();
        baseData.add(DimsionEnums.METRIC.getNumber());
        baseData.add(DimsionEnums.SUBJECT.getNumber());
        QFilter qFilter = new QFilter("basedata", "not in", baseData);
        DynamicObjectCollection allDimensions = QueryServiceHelper.query((String)"fpm_dimension", (String)selectProp, (QFilter[])new QFilter[]{qFilter});
        if (CollectionUtils.isEmpty((Collection)allDimensions)) {
            logger.info("[DimensionFieldsUpgradeServiceImpl] >>>> \u7ef4\u5ea6\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a\uff0c\u5347\u7ea7\u7ed3\u675f... ");
            return;
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        Map<Object, List<DynamicObject>> dimMapBySystem = allDimensions.stream().collect(Collectors.groupingBy(item -> item.getLong("bodysystem")));
        for (Map.Entry<Object, List<DynamicObject>> entry : dimMapBySystem.entrySet()) {
            List<DynamicObject> dimensions = entry.getValue();
            int count = 1;
            for (DynamicObject di : dimensions) {
                DynamicObject dimension = TmcDataServiceHelper.newDynamicObject((String)"fpm_dimension");
                dimension.set("id", di.get("id"));
                DimsionEnums dimsionEnums = DimsionEnums.getDimsionByNumber((String)di.getString("basedata"));
                switch (dimsionEnums) {
                    case ORG: {
                        dimension.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
                        dimension.set("relbasedata", (Object)"bos_org");
                        break;
                    }
                    case COMPANY: {
                        dimension.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
                        dimension.set("relbasedata", (Object)"bos_org");
                        if (count == 1) {
                            dimension.set("dimensionrel", (Object)DimensionRelEnum.CUSTOM_1.getCode());
                        } else if (count == 2) {
                            dimension.set("dimensionrel", (Object)DimensionRelEnum.CUSTOM_2.getCode());
                        }
                        ++count;
                        break;
                    }
                    case SETLTMENT: {
                        dimension.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
                        dimension.set("relbasedata", (Object)"bd_settlementtype");
                        if (count == 1) {
                            dimension.set("dimensionrel", (Object)DimensionRelEnum.CUSTOM_1.getCode());
                        } else if (count == 2) {
                            dimension.set("dimensionrel", (Object)DimensionRelEnum.CUSTOM_2.getCode());
                        }
                        ++count;
                        break;
                    }
                    case PERIOD: {
                        dimension.set("memberfrom", (Object)DimMemberFromEnum.CUSTOM.getCode());
                        break;
                    }
                    case CURRENCY: {
                        dimension.set("memberfrom", (Object)DimMemberFromEnum.BASE_INFO.getCode());
                        dimension.set("relbasedata", (Object)"bd_currency");
                        break;
                    }
                }
                saveList.add(dimension);
            }
        }
        SaveServiceHelper.update((DynamicObject[])saveList.toArray(new DynamicObject[0]));
        logger.info("[DimensionFieldsUpgradeServiceImpl] >>>> \u7ef4\u5ea6\u5b57\u6bb5\u6570\u636e\u5347\u7ea7\u7ed3\u675f, \u5171\u8ba1\u5347\u7ea7{}\u6761\u6570\u636e... ", (Object)allDimensions.size());
    }
}

