/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.impl.DataSaveServiceImpl;
import kd.tmc.fpm.business.dataproc.save.impl.SyncShrekReportDataSaveServiceImpl;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.EvalReportData;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecordMore;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombinationCurrencyMap;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionVal;
import kd.tmc.fpm.business.domain.model.sumplan.MainSubReport;
import kd.tmc.fpm.business.domain.model.sumplan.ReportKey;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.domain.service.impl.ReportService;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.mvc.service.IEvaluateAmtBizService;
import kd.tmc.fpm.business.mvc.service.dto.EvalDetailParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.EvalLoadParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.WaitApprovedAmountAmtDTO;
import kd.tmc.fpm.business.mvc.service.dto.WaitApprovedAmountAmtInfoResultDTO;
import kd.tmc.fpm.business.mvc.service.impl.RelateReportDataManager;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.LogFormatUtil;
import kd.tmc.fpm.business.utils.ReportUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections4.MapUtils;

public class EvaluateAmtBizServiceImpl
implements IEvaluateAmtBizService {
    private ISumPlanRepository sumPlanRepository = new SumPlanRepository();
    private IReportDataQueryService reportDataQueryService = new ReportDataQueryService();
    private IReportRepository reportRepository = new ReportRepository();
    private ITemplateRepository templateRepository = new TemplateRepository();
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private IReportService reportService = new ReportService();
    private ICustomDimSeqService iCustomDimSeqService = FpmServiceFactory.getBizService(ICustomDimSeqService.class);
    private static Log LOGGER = LogFactory.getLog(EvaluateAmtBizServiceImpl.class);

    @Override
    public ApprovedAmountRecord load(Long sumReportId, List<String> reportDataIdList, boolean needDetailEntry) {
        LOGGER.info("\u91d1\u989d\u6838\u5b9a\uff0c\u53ea\u52a0\u8f7d\u5de6\u4fa7\u5206\u5f55\uff1a\u6c47\u603b\u989d\u5ea6\u4fe1\u606f\uff0c\u6c47\u603b\u8bb0\u5f55id:{}, \u6c47\u603b\u6838\u5b9a\u8ba1\u5212\u7f16\u5236\u6570\u636eid:{}", (Object)sumReportId, reportDataIdList);
        List<Long> collect = EmptyUtil.isEmpty(reportDataIdList) ? Collections.emptyList() : reportDataIdList.stream().filter(StringUtils::isNotEmpty).map(s -> s.split(",")).flatMap(Arrays::stream).map(String::trim).map(Long::valueOf).collect(Collectors.toList());
        return this.sumPlanRepository.loadApprovedAmtBySumId(sumReportId, collect, false);
    }

    @Override
    public List<ApprovedAmountAmtDetailInfo> load(Long sumRecordId, Long approvalId, Boolean isDetail) {
        LOGGER.info("\u67e5\u8be2\u91d1\u989d\u6838\u5b9a\u5f85\u6838\u5b9a\u8bb0\u5f55\u4fe1\u606f\uff0c\u6c47\u603b\u8bb0\u5f55id:{}, \u5de6\u4fa7\u5206\u5f55\u6838\u5b9a\u8bb0\u5f55id:{}\uff0c\u662f\u5426\u660e\u7ec6\u6838\u5b9a:{}", new Object[]{sumRecordId, approvalId, isDetail});
        List<ApprovedAmountAmtDetailInfo> detailInfoList = this.sumPlanRepository.loadApprovedAmtBySumId(sumRecordId, approvalId, isDetail);
        this.removeDeletedSumPlanDetailInfo(detailInfoList);
        return detailInfoList;
    }

    @Override
    public ApprovedAmountRecordMore load(EvalLoadParamDTO evalLoadParamDTO) {
        ApprovedAmountRecordMore approvedAmountRecordMore = new ApprovedAmountRecordMore();
        List<String> reportDataIdList = evalLoadParamDTO.getReportDataIdList();
        ApprovedAmountRecord approvedAmountRecord = this.load(evalLoadParamDTO.getSumRecordId(), reportDataIdList, false);
        if (CollectionUtils.isEmpty(reportDataIdList) && EmptyUtil.isEmpty((Object)approvedAmountRecord)) {
            return null;
        }
        SumPlanRecord sumPlanRecord = this.sumPlanRepository.loadSumPlanRecord(evalLoadParamDTO.getSumRecordId());
        if (EmptyUtil.isEmpty((Object)approvedAmountRecord)) {
            approvedAmountRecord = new ApprovedAmountRecord();
            approvedAmountRecord.setMember(evalLoadParamDTO.getSumOrgId());
            approvedAmountRecord.setSystemId(evalLoadParamDTO.getSystemId());
            approvedAmountRecord.setOrgReportType(evalLoadParamDTO.getReportTypeId());
            approvedAmountRecord.setOrgReportPeriod(sumPlanRecord.getReportPeriodId());
            approvedAmountRecord.setAmountUnit(sumPlanRecord.getAmountUnit());
            approvedAmountRecord.setExRateDate(sumPlanRecord.getRateDate());
            approvedAmountRecord.setExRateTable(sumPlanRecord.getExchangeRateTableId());
        }
        approvedAmountRecordMore.setEnable(sumPlanRecord.getReportStatus() == ReportStatus.ENABLE);
        approvedAmountRecordMore.setRecord(approvedAmountRecord);
        this.fillApprovedAmountRecordMore(approvedAmountRecordMore, evalLoadParamDTO);
        approvedAmountRecordMore.setCustomDimSeqMap(this.iCustomDimSeqService.loadCustomDimSeqMap(sumPlanRecord.getSystemId()));
        return approvedAmountRecordMore;
    }

    @Override
    public FpmOperateResult<Void> updateUnCompleteApprovedRecord(ApprovedAmountRecord approvedAmountRecord, SumPlanRecord sumPlanRecord, FundPlanSystem fundPlanSystem, List<Long> approvalIds) {
        HashSet<Long> approvalIdSet = new HashSet<Long>(approvalIds);
        List<ApprovedAmountAmtDetailInfo> approvalIdDetailInfoList = approvedAmountRecord.getAmountAmtInfoList().stream().filter(item -> approvalIdSet.contains(item.getReportDataId())).map(ApprovedAmountAmtInfo::getAmtDetailInfoList).flatMap(Collection::stream).collect(Collectors.toList());
        this.removeDeletedSumPlanDetailInfo(approvalIdDetailInfoList);
        Set existDetailInfoIdSet = approvalIdDetailInfoList.stream().map(ApprovedAmountAmtDetailInfo::getId).collect(Collectors.toSet());
        for (ApprovedAmountAmtInfo approvedAmountAmtInfo : approvedAmountRecord.getAmountAmtInfoList()) {
            if (!approvalIdSet.contains(approvedAmountAmtInfo.getReportDataId())) continue;
            approvedAmountAmtInfo.getAmtDetailInfoList().removeIf(detailInfo -> !existDetailInfoIdSet.contains(detailInfo.getId()));
        }
        Long systemId = sumPlanRecord.getSystemId();
        Long orgReportType = sumPlanRecord.getReportType();
        SumPlanParamConfig sumPlanParamConfig = this.sumPlanRepository.loadSumConfigBySystem(systemId, Collections.singleton(orgReportType), false).get(0);
        List<Long> allSubReportOrgIds = this.loadAllSubOrgIds(sumPlanParamConfig, sumPlanRecord.getOrgId(), sumPlanRecord.getReportPeriodId(), sumPlanRecord.getReportStatus() == ReportStatus.ENABLE);
        HashSet<Long> allSubReportOrgIdSet = new HashSet<Long>(allSubReportOrgIds);
        Map<Long, List<Long>> loadCurrencyMap = this.loadCurrencyMap(sumPlanParamConfig, sumPlanRecord.getOrgId());
        Dimension currencyDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.CURRENCY);
        Map<Long, DimMember> currencyMemberMap = currencyDim.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        Map sumReportDataMap = sumPlanRecord.getSumPlanReportList().get(0).getReportDataList().stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
        for (ApprovedAmountAmtInfo approvedAmountAmtInfo : approvedAmountRecord.getAmountAmtInfoList()) {
            if (!approvalIdSet.contains(approvedAmountAmtInfo.getReportDataId())) continue;
            ReportData sumReportData = (ReportData)sumReportDataMap.get(approvedAmountAmtInfo.getReportDataId());
            Long currencyId = (Long)sumReportData.getDimValByDimensionId(currencyDim.getId());
            List mapCurrencyIds = loadCurrencyMap.computeIfAbsent(currencyId, val -> new ArrayList(2));
            if (!mapCurrencyIds.contains(currencyId)) {
                mapCurrencyIds.add(currencyId);
            }
            WaitApprovedAmountAmtDTO waitApprovedAmountAmtDTO = WaitApprovedAmountAmtDTO.builder().sumRecordId(sumPlanRecord.getId()).allSubOrgId(allSubReportOrgIdSet).reportDataIdStr(approvedAmountAmtInfo.getReportDataIdStr()).currencyId(currencyId).currencyIds(loadCurrencyMap.get(currencyId)).build();
            List<WaitApprovedAmountAmtInfoResultDTO> waitApprovedAmountAmtInfoResultDTOS = this.loadWaitApprovedAmountAmtInfo(waitApprovedAmountAmtDTO);
            Set approvedPlanReportDataIdSet = approvedAmountAmtInfo.getAmtDetailInfoList().stream().map(ApprovedAmountAmtDetailInfo::getReportDataId).collect(Collectors.toSet());
            BigDecimal sumReportDataEvaluateAmt = BigDecimal.ZERO;
            LinkedList<ApprovedAmountAmtDetailInfo> addDetailInfoList = new LinkedList<ApprovedAmountAmtDetailInfo>();
            for (WaitApprovedAmountAmtInfoResultDTO waitApprovedDTO : waitApprovedAmountAmtInfoResultDTOS) {
                ReportData reportData = waitApprovedDTO.getReportData();
                if (waitApprovedDTO.getLevel() == 1) {
                    BigDecimal realSourceAmt = this.getAddSumReportDataEvaluateAmt(reportData, sumReportData, currencyDim, currencyMemberMap, approvedAmountRecord.getExRateTable(), approvedAmountRecord.getExRateDate(), waitApprovedDTO.getEvaluateAmt());
                    sumReportDataEvaluateAmt = sumReportDataEvaluateAmt.add(realSourceAmt);
                }
                if (approvedPlanReportDataIdSet.contains(waitApprovedDTO.getReportData().getId())) continue;
                ApprovedAmountAmtDetailInfo detailInfo2 = new ApprovedAmountAmtDetailInfo();
                detailInfo2.setFillUser(EmptyUtil.isEmpty((Long)waitApprovedDTO.getFillUser()) ? Long.valueOf(RequestContext.get().getCurrUserId()) : waitApprovedDTO.getFillUser());
                detailInfo2.setApprovedAmt(waitApprovedDTO.getEvaluateAmt());
                detailInfo2.setOriginalApprovedAmt(waitApprovedDTO.getReportData().getOriginalPlanAmt());
                detailInfo2.setReportDataId(waitApprovedDTO.getReportData().getId());
                detailInfo2.setPlanReportNumber(waitApprovedDTO.getReport().getNumber());
                detailInfo2.setReportId(waitApprovedDTO.getReport().getId());
                detailInfo2.setEvalDetail(false);
                addDetailInfoList.add(detailInfo2);
            }
            approvedAmountAmtInfo.setApprovedAmt(sumReportDataEvaluateAmt);
            approvedAmountAmtInfo.getAmtDetailInfoList().addAll(addDetailInfoList);
        }
        try (TXHandle tx = TX.required();){
            this.sumPlanRepository.saveApprovedAmountRecord(approvedAmountRecord);
        }
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult save(ApprovedAmountRecord approvedAmountRecord) {
        ApprovedAmountRecord amountRecord = this.sumPlanRepository.loadApprovedAmtBySumId(approvedAmountRecord.getSumPlanRecordId());
        this.removeDeletedSumPlanApprovedRecord(amountRecord);
        this.convertApprovalAmt(approvedAmountRecord);
        if (amountRecord == null) {
            SumPlanRecord sumPlanRecord = this.sumPlanRepository.loadSumPlanRecord(approvedAmountRecord.getSumPlanRecordId());
            if (EmptyUtil.isEmpty((Long)approvedAmountRecord.getMember())) {
                LOGGER.info("\u9996\u6b21\u6838\u5b9a\uff0c\u4ece\u660e\u7ec6\u8868\u4fdd\u5b58\uff0c\u4ece\u6c47\u603b\u8bb0\u5f55\u5355\u83b7\u53d6\u5355\u5934\u4fe1\u606f,\u6c47\u603b\u8bb0\u5f55id\uff1a{}", (Object)approvedAmountRecord.getSumPlanRecordId());
                approvedAmountRecord.setNumber(sumPlanRecord.getNumber());
                approvedAmountRecord.setSystemId(sumPlanRecord.getSystemId());
                approvedAmountRecord.setSummaryt(sumPlanRecord.getSumPlanSumType());
                approvedAmountRecord.setMember(sumPlanRecord.getOrgId());
                approvedAmountRecord.setOrgReportType(sumPlanRecord.getReportPeriodTypeId());
                approvedAmountRecord.setOrgReportPeriod(sumPlanRecord.getReportPeriodId());
                approvedAmountRecord.setExRateTable(sumPlanRecord.getExchangeRateTableId());
                approvedAmountRecord.setExRateDate(sumPlanRecord.getRateDate());
                approvedAmountRecord.setNumber(sumPlanRecord.getNumber());
            }
            amountRecord = approvedAmountRecord;
            this.transferApprovedAmtUnitBeforeSave(approvedAmountRecord, sumPlanRecord.getAmountUnit());
        } else {
            this.transferApprovedAmtUnitBeforeSave(approvedAmountRecord, amountRecord.getAmountUnit());
            List<ApprovedAmountAmtInfo> amountAmtInfoList = approvedAmountRecord.getAmountAmtInfoList();
            this.updateSameAndAddDiff(amountRecord.getAmountAmtInfoList(), amountAmtInfoList);
        }
        FpmOperateResult checkAmtRoundResult = this.checkApprovedRecordAmtRoundBeforeSave(amountRecord);
        if (!checkAmtRoundResult.isSuccess()) {
            return checkAmtRoundResult;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.updateUnderlyingReportDataNew(amountRecord);
                FpmOperateResult saveResult = this.sumPlanRepository.saveApprovedAmountRecord(amountRecord);
                if (!saveResult.isSuccess()) {
                    List<String> errorMsgList = saveResult.getMessageList();
                    throw new KDBizException(errorMsgList.stream().collect(Collectors.joining(",")));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error(e.getMessage(), (Throwable)e);
                FpmOperateResult fpmOperateResult = FpmOperateResult.error(e.getMessage());
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return fpmOperateResult;
            }
        }
        return FpmOperateResult.success();
    }

    @Override
    public List<WaitApprovedAmountAmtInfoResultDTO> loadWaitApprovedAmountAmtInfo(WaitApprovedAmountAmtDTO waitApprovedAmountAmtDTO) {
        String reportDataIdStr = waitApprovedAmountAmtDTO.getReportDataIdStr();
        List<Long> sumReportDataIdList = Arrays.stream(reportDataIdStr.split(",")).map(Long::valueOf).collect(Collectors.toList());
        List<ReportData> sumReportDataList = this.getReportDataQueryResults(sumReportDataIdList);
        Report sumReport = this.getReport(sumReportDataList.get(0).getReportId(), (ReportNeedPropDTO rp) -> rp.setNeedTemplate(true));
        ReportTemplate sumReportTemplate = sumReport.getTemplate();
        Set<Long> sumOrgIds = waitApprovedAmountAmtDTO.getAllSubOrgId();
        List<Long> currencyIds = waitApprovedAmountAmtDTO.getCurrencyIds();
        List<ReportData> directReportData = this.getDirectReportData(sumReportDataList, sumReportTemplate, waitApprovedAmountAmtDTO);
        Set<Long> reportIds = directReportData.stream().map(ReportData::getReportId).collect(Collectors.toSet());
        List<Report> reports = this.getReport(reportIds, (ReportNeedPropDTO rp) -> rp.setNeedTemplate(true));
        Map<Long, Report> reportMap = reports.stream().collect(Collectors.toMap(Report::getId, Function.identity()));
        List<WaitApprovedAmountAmtInfoResultDTO> list = new ArrayList<WaitApprovedAmountAmtInfoResultDTO>(directReportData.size());
        List<ReportData> soredReportDataList = directReportData.stream().filter(rd -> !rd.isAuxiliaryInfo()).sorted(Comparator.comparing(this::getScore)).collect(Collectors.toList());
        this.removeMainReportChildReportDataIfNeed(reportMap, soredReportDataList);
        ArrayList<Long> childTemplateIds = new ArrayList<Long>(4);
        HashSet<String> uniqueSet = new HashSet<String>(soredReportDataList.size());
        Set<EvalDimensionCombination> evalDimensionCombinationSet = EvalDimensionCombination.getEvalDimensionCombinationSetByReportDataSet(sumReportDataList, sumReportTemplate);
        Set<EvalDimensionCombination> dimensionCombinations = this.updateSubOrgAndCurrency(evalDimensionCombinationSet, sumOrgIds, currencyIds);
        boolean enable = waitApprovedAmountAmtDTO.isEnable();
        HashMap<String, List<ReportData>> uniqueSubReportDataMap = new HashMap<String, List<ReportData>>(16);
        HashMap<String, ReportTemplate> mainTemplateMap = new HashMap<String, ReportTemplate>(16);
        LOGGER.info("\u5f00\u59cb\u7b5b\u9009\u6c47\u603b\u989d\u5ea6\u4fe1\u606f\uff1a{} \u7684\u4e0b\u7ea7\u5f85\u6838\u5b9a\u7684\u7f16\u5236\u6570\u636e", (Object)reportDataIdStr);
        for (ReportData rd2 : soredReportDataList) {
            ReportTemplate template;
            WaitApprovedAmountAmtInfoResultDTO resultDTO = new WaitApprovedAmountAmtInfoResultDTO();
            Report report = reportMap.get(rd2.getReportId());
            resultDTO.setReport(report);
            resultDTO.setReportData(rd2);
            resultDTO.setLevel(1);
            resultDTO.setParentSubjectId(0L);
            EvalDimensionCombination combination = EvalDimensionCombination.getEvalDimensionCombinationByReportData(rd2, sumReportTemplate);
            if (!enable && !dimensionCombinations.contains(combination) || (template = report.getTemplate()).getTemplateType() == TemplateType.DETAIL) continue;
            Object subjectId = rd2.getDimValByDimType(DimensionType.SUBJECTS, null);
            String orgSubjectKey = rd2.getDimValByDimType(DimensionType.ORG, null).toString() + "_" + subjectId;
            combination = EvalDimensionCombination.getEvalDimensionCombinationByReportData(rd2, templateDim -> templateDim.getDimType() == DimensionType.SUBJECTS || templateDim.getDimType() == DimensionType.PERIOD || templateDim.getDimType() == DimensionType.CURRENCY);
            String key = combination.getUniqueKey();
            if (rd2.isMainTable()) {
                uniqueSet.add(key);
                mainTemplateMap.putIfAbsent(orgSubjectKey, report.getTemplate());
            } else if (uniqueSet.contains(key)) {
                LOGGER.info("\u5f53\u524d\u7f16\u5236\u6570\u636e:{}\uff0c\u5728\u4e3b\u8868\u4e2d\u5b58\u5728\u7f16\u62a5\u4e3b\u4f53:{},\u79d1\u76ee:{},\u5e01\u79cd\uff1a{}\u4e00\u6837\u7684\u6570\u636e\uff0c\u5ffd\u7565\u5b50\u8868\u6570\u636e", (Object)rd2.getId());
                List subReportDataList = uniqueSubReportDataMap.computeIfAbsent(key, k -> new ArrayList(4));
                subReportDataList.add(rd2);
                continue;
            }
            List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
            Optional<TemplateAccountSetting> first = accountSettings.stream().filter(as -> Objects.equals(subjectId, as.getAccountMemId())).findFirst();
            if (!first.isPresent()) {
                LOGGER.warn("\u79d1\u76eeid\uff1a{}\uff0c\u4e0d\u5728\u4e3b\u8868\u6a21\u677f\uff1a{}\uff0c\u914d\u7f6e\u7684\u79d1\u76ee\u5c5e\u6027\u914d\u7f6e\u4e2d", subjectId, (Object)template.getNumber());
                continue;
            }
            TemplateAccountSetting templateAccountSetting = first.get();
            ReportInputType inputType = templateAccountSetting.getInputType();
            resultDTO.setFillWay(inputType == null ? "" : inputType.getNumber());
            Long childTemplateId = templateAccountSetting.getChildTemplateId();
            if (!template.isMainTable()) {
                childTemplateId = template.getId();
            }
            resultDTO.setChildTemplateId(childTemplateId);
            if (EmptyUtil.isNoEmpty((Long)childTemplateId)) {
                childTemplateIds.add(childTemplateId);
            }
            resultDTO.setEvaluateAmt(rd2.getOriginalPlanAmt());
            list.add(resultDTO);
        }
        if (EmptyUtil.isEmpty(childTemplateIds)) {
            LOGGER.info("\u6240\u6709\u5f85\u6838\u5b9a\u8bb0\u5f55\u4e2d\u4e0d\u5305\u542b\u660e\u7ec6\u586b\u62a5\uff0c\u76f4\u63a5\u8fd4\u56de");
            return list;
        }
        list = this.dealMainMapMoreChild(list, sumReportTemplate, uniqueSubReportDataMap);
        if (enable) {
            waitApprovedAmountAmtDTO.setAllChildReportDataIds(new HashSet<Long>(waitApprovedAmountAmtDTO.getAllReportDataIds()));
        }
        this.dealFixedDetailSubjectChildren(list, childTemplateIds, reportMap, waitApprovedAmountAmtDTO);
        return list;
    }

    private void removeMainReportChildReportDataIfNeed(Map<Long, Report> reportMap, List<ReportData> soredReportDataList) {
        Iterator<ReportData> iterator = soredReportDataList.iterator();
        while (iterator.hasNext()) {
            ReportData next = iterator.next();
            if (!next.isMainTable()) continue;
            Long subjectId = (Long)next.getDimValByDimType(DimensionType.SUBJECTS);
            Report report = reportMap.get(next.getReportId());
            List<TemplateAccountSetting> accountSettings = report.getTemplate().getAccountSettings();
            Optional<TemplateAccountSetting> first = accountSettings.stream().filter(as -> Objects.equals(subjectId, as.getAccountMemId())).findFirst();
            if (first.isPresent()) continue;
            iterator.remove();
        }
    }

    @Override
    public List<ApprovedAmountAmtDetailInfo> queryDirectionDownLevel(Long sumRecordId, List<Long> downReportDataIdList) {
        SumPlanRecord sumPlanRecord = this.sumPlanRepository.loadSumPlanRecord(sumRecordId);
        Long systemId = sumPlanRecord.getSystemId();
        Long sumOrgId = sumPlanRecord.getOrgId();
        Long reportType = sumPlanRecord.getReportPeriodTypeId();
        SumPlanParamConfig sumPlanParamConfig = this.sumPlanRepository.loadSumConfigBySystem(systemId, Collections.singleton(reportType), false).get(0);
        SumPlanParamConfigInfo configInfo = sumPlanParamConfig.getConfigInfoList().stream().filter(info -> Objects.equals(sumOrgId, info.getOrgMemberId())).findFirst().get();
        ArrayList<Long> subSumOrgIdList = new ArrayList<Long>(4);
        this.getDirectorDownLevelSumOrg(configInfo.getChildren(), subSumOrgIdList);
        if (EmptyUtil.isEmpty(subSumOrgIdList)) {
            return Collections.emptyList();
        }
        List<SumPlanRecord> sumPlanRecords = this.sumPlanRepository.loadSumPlanRecord(subSumOrgIdList, sumPlanRecord.getReportPeriodId());
        List<Long> sumPlanRecordIdList = sumPlanRecords.stream().map(SumPlanRecord::getId).collect(Collectors.toList());
        List<ApprovedAmountAmtDetailInfo> downDetailInfoList = this.sumPlanRepository.loadDownOrgApprovedAmt(sumPlanRecordIdList, downReportDataIdList);
        LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u76f4\u63a5\u4e0b\u7ea7\u6838\u5b9a\u8bb0\u5f55\uff0c\u4e0b\u7ea7\u6c47\u603b\u7f16\u5236\u8bb0\u5f55ids\uff1a{}\uff0c\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u6570\u636eids:{}", subSumOrgIdList, downReportDataIdList);
        if (EmptyUtil.isEmpty(downDetailInfoList)) {
            return Collections.emptyList();
        }
        return this.mergeApprovalDetailInfo(downDetailInfoList);
    }

    @Override
    public List<WaitApprovedAmountAmtInfoResultDTO> loadWaitApprovedAmountDetailInfo(List<EvalDetailParamDTO> evalDetailParamDTO, boolean enable) {
        if (EmptyUtil.isEmpty(evalDetailParamDTO)) {
            return Collections.emptyList();
        }
        Map childTemplateIdReportDataIdSetMap = evalDetailParamDTO.stream().collect(Collectors.groupingBy(EvalDetailParamDTO::getChildTemplateId, Collectors.mapping(EvalDetailParamDTO::getReportDataId, Collectors.toSet())));
        List<Long> reportDataIdList = evalDetailParamDTO.stream().map(EvalDetailParamDTO::getReportDataId).collect(Collectors.toList());
        List<ReportData> reportDataList = this.listReportDataQueryResult(reportDataIdList, reportDataQueryObject -> reportDataQueryObject.setNeedDimIfValueIsNotEmpty(true));
        Map mainReportDataMap = reportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity()));
        Set<Long> reportIds = reportDataList.stream().map(ReportData::getReportId).collect(Collectors.toSet());
        Map<Long, Report> mainReportMap = this.getReport(reportIds, (ReportNeedPropDTO t) -> t.setNeedTemplate(true)).stream().collect(Collectors.toMap(Report::getId, Function.identity()));
        Map templateDimMap = reportDataList.stream().map(ReportData::getDimList).flatMap(Collection::stream).filter(td -> !td.isDetailDim()).collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity(), (a, b) -> a));
        HashMap<Long, Dimension> dimensionMap = new HashMap<Long, Dimension>(4);
        HashMap<Long, Set> dimensionValueMap = new HashMap<Long, Set>(4);
        Set<EvalDimensionCombination> evalDimensionCombinations = EvalDimensionCombination.getEvalDimensionCombinationSetByReportDataSet(reportDataList);
        for (ReportData reportData : reportDataList) {
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dimValList = reportData.getDimValList();
            HashSet dimensionIdSet = new HashSet(dimensionMap.keySet());
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                Long dimensionId = templateDim.getDimensionId();
                Dimension dimension = this.getDimension(templateDim);
                dimensionMap.put(dimensionId, dimension);
                Set valSet = dimensionValueMap.computeIfAbsent(dimensionId, key -> new HashSet(4));
                valSet.add(dimValList.get(i));
            }
            if (EmptyUtil.isEmpty(dimensionIdSet)) continue;
            for (Long dimensionId : dimensionIdSet) {
                dimensionMap.putIfAbsent(dimensionId, this.getDimension((TemplateDim)templateDimMap.get(dimensionId)));
                Set objects = dimensionValueMap.computeIfAbsent(dimensionId, key -> new HashSet(8));
                objects.add(0L);
            }
        }
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(dimensionMap.values());
        queryObject.setDimIdList(dimensionList);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            Long key2 = dimension.getId();
            ArrayList valList = new ArrayList((Collection)dimensionValueMap.get(key2));
            dimValList.add(valList);
        }
        queryObject.setDimValList(dimValList);
        queryObject.setMainTable(Boolean.FALSE);
        queryObject.setReportStatus(enable ? ReportStatus.ENABLE : ReportStatus.REPORTING);
        queryObject.setReportPeriodId(reportDataList.get(0).getReportPeriodId());
        List<ReportDataQueryResult> queryResults = this.reportDataQueryService.queryReportData(queryObject);
        List<ReportData> dataList = ReportHelper.convert(queryResults);
        ArrayList<WaitApprovedAmountAmtInfoResultDTO> waitApprovedAmountAmtInfoResultDTOList = new ArrayList<WaitApprovedAmountAmtInfoResultDTO>(dataList.size());
        Set<Long> reportIdSet = dataList.stream().map(ReportData::getReportId).collect(Collectors.toSet());
        ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
        reportNeedPropDTO.setNeedTemplate(true);
        List<Report> reports = this.reportRepository.loadSimpleReport(reportIdSet, reportNeedPropDTO);
        Map reportMap = reports.stream().collect(Collectors.toMap(Report::getId, Function.identity()));
        Set childTemplateIdSet = evalDetailParamDTO.stream().map(EvalDetailParamDTO::getChildTemplateId).collect(Collectors.toSet());
        LOGGER.info("\u4e3b\u8868\u660e\u7ec6\u6c47\u603b\u6570\u636e\u7ef4\u5ea6\u7ec4\u5408\uff1a{}", evalDimensionCombinations);
        for (ReportData reportData : dataList) {
            Report report = (Report)reportMap.get(reportData.getReportId());
            ReportTemplate template = report.getTemplate();
            if (!childTemplateIdSet.contains(template.getId())) continue;
            Set mainReportDataIdSet = childTemplateIdReportDataIdSetMap.get(template.getId());
            Set<ReportData> mainReportDataSet = mainReportDataMap.entrySet().stream().filter(entry -> mainReportDataIdSet.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
            if (!this.matches(mainReportDataSet, reportData, mainReportMap)) continue;
            WaitApprovedAmountAmtInfoResultDTO resultDTO = new WaitApprovedAmountAmtInfoResultDTO();
            resultDTO.setEvaluateAmt(reportData.getOriginalPlanAmt());
            resultDTO.setReportData(reportData);
            resultDTO.setReport(report);
            waitApprovedAmountAmtInfoResultDTOList.add(resultDTO);
        }
        return waitApprovedAmountAmtInfoResultDTOList;
    }

    private boolean matches(Set<ReportData> mainReportDataSet, ReportData reportData, Map<Long, Report> mainReportMap) {
        for (ReportData mainReportData : mainReportDataSet) {
            EvalDimensionCombination mainDimensionCombination;
            ReportTemplate mainReportTemplate = mainReportMap.get(mainReportData.getReportId()).getTemplate();
            EvalDimensionCombination dimensionCombination = EvalDimensionCombination.getEvalDimensionCombinationByReportData(reportData, mainReportTemplate);
            if (!Objects.equals(dimensionCombination, mainDimensionCombination = EvalDimensionCombination.getEvalDimensionCombinationByReportData(mainReportData, mainReportTemplate))) continue;
            return true;
        }
        LOGGER.info("\u7f16\u5236\u6570\u636e\uff1a{}\uff0c\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5728\u4e3b\u8868\u7ef4\u5ea6\u7ec4\u5408\u4e2d", (Object)reportData.getId());
        return false;
    }

    private Report getReport(Long reportId, Consumer<ReportNeedPropDTO> consumer) {
        return this.getReport(Collections.singleton(reportId), consumer).get(0);
    }

    private List<Report> getReport(Set<Long> reportIds, Consumer<ReportNeedPropDTO> consumer) {
        ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
        if (EmptyUtil.isNoEmpty(consumer)) {
            consumer.accept(reportNeedPropDTO);
        }
        return this.reportRepository.loadSimpleReport(reportIds, reportNeedPropDTO);
    }

    private void dealFixedDetailSubjectChildren(List<WaitApprovedAmountAmtInfoResultDTO> list, List<Long> childTemplateIds, Map<Long, Report> reportMap, WaitApprovedAmountAmtDTO waitApprovedAmountAmtDTO) {
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u6240\u6709\u56fa\u5b9a\u5b50\u8868\u4e0b\u7684\u5f85\u6838\u5b9a\u8bb0\u5f55\uff0c\u5b50\u6a21\u677fid:{}", childTemplateIds);
        List<ReportTemplate> reportTemplates = this.templateRepository.loadTemplateBak(childTemplateIds);
        Map<Long, ReportTemplate> fixedTemMap = reportTemplates.stream().filter(reportTemplate -> reportTemplate.getTemplateType() == TemplateType.FIXED).collect(Collectors.toMap(ReportTemplate::getId, Function.identity()));
        if (CollectionUtils.isEmpty(fixedTemMap)) {
            LOGGER.info("\u6240\u6709\u5b50\u8868\u90fd\u4e3a\u660e\u7ec6\u8868\uff0c\u4e0d\u5904\u7406\uff0c\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        LOGGER.info("\u5f85\u5904\u7406\u56fa\u5b9a\u5b50\u8868\u6a21\u677fid\uff1a{}", fixedTemMap.keySet());
        List<WaitApprovedAmountAmtInfoResultDTO> fixedDetailInoutList = list.stream().filter(rs -> fixedTemMap.containsKey(rs.getChildTemplateId())).collect(Collectors.toList());
        List<ReportData> reportDataChildList = this.getAllChildReportData(fixedTemMap, fixedDetailInoutList, waitApprovedAmountAmtDTO);
        if (EmptyUtil.isEmpty(reportDataChildList)) {
            LOGGER.info("\u6240\u6709\u660e\u7ec6\u586b\u62a5\u56fa\u5b9a\u5b50\u8868\u6ca1\u6709\u586b\u62a5\u7f16\u5236\u6570\u636e\uff0c\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        Set<Long> childReportIds = reportDataChildList.stream().filter(rd -> !reportMap.containsKey(rd.getReportId())).map(ReportData::getReportId).collect(Collectors.toSet());
        List<Report> reports = this.getReport(childReportIds, (ReportNeedPropDTO t) -> t.setNeedTemplate(true));
        reportMap.putAll(reports.stream().collect(Collectors.toMap(Report::getId, Function.identity(), (a, b) -> a)));
        HashMap<Long, Set> reportFormulaMap = new HashMap<Long, Set>(16);
        Map<EvalDimensionCombination, List<ReportData>> groupByOrg = reportDataChildList.stream().filter(rd -> fixedTemMap.containsKey(((Report)reportMap.get(rd.getReportId())).getTemplate().getId())).collect(Collectors.groupingBy(rd -> EvalDimensionCombination.getEvalDimensionCombinationByReportData(rd, t -> t.getDimType() != DimensionType.SUBJECTS)));
        for (Map.Entry<EvalDimensionCombination, List<ReportData>> entry : groupByOrg.entrySet()) {
            List<ReportData> dataList = entry.getValue();
            if (EmptyUtil.isEmpty(dataList)) continue;
            HashMap map = new HashMap(2);
            Optional<ReportData> dataOptional = dataList.stream().filter(rd -> fixedTemMap.containsKey(((Report)reportMap.get(rd.getReportId())).getTemplate().getId())).filter(rd -> {
                Optional<WaitApprovedAmountAmtInfoResultDTO> first = fixedDetailInoutList.stream().filter(fixedDetail -> rd.getDimValList().containsAll(fixedDetail.getReportData().getDimValList())).findFirst();
                if (first.isPresent()) {
                    map.put(rd.getId(), first.get());
                    return true;
                }
                return false;
            }).findFirst();
            if (!dataOptional.isPresent()) continue;
            ReportData subMainReportData = dataOptional.get();
            WaitApprovedAmountAmtInfoResultDTO infoResultDTO = (WaitApprovedAmountAmtInfoResultDTO)map.get(subMainReportData.getId());
            Object rootSubject = subMainReportData.getDimValByDimType(DimensionType.SUBJECTS, null);
            ReportTemplate template = reportMap.get(subMainReportData.getReportId()).getTemplate();
            TemplateAccountSetting rootAccountSetting = template.getAccountSettings().stream().filter(as -> Objects.equals(rootSubject, as.getAccountMemId())).findFirst().get();
            Set formulaMemberSet = reportFormulaMap.computeIfAbsent(subMainReportData.getReportId(), key -> new HashSet(8));
            this.getAllFormulaMemberSet(formulaMemberSet, rootAccountSetting);
            if (formulaMemberSet.contains(rootAccountSetting.getAccountMemId())) {
                infoResultDTO.setSubFormula(true);
            }
            infoResultDTO.setReportData(subMainReportData);
            infoResultDTO.setFillWay(rootAccountSetting.getInputType().getNumber());
            this.populateChildren(infoResultDTO, rootAccountSetting, dataList, reportMap, formulaMemberSet, infoResultDTO.getLevel());
        }
    }

    private List<ReportData> getAllChildReportData(Map<Long, ReportTemplate> fixedTemMap, List<WaitApprovedAmountAmtInfoResultDTO> fixedDetailInoutList, WaitApprovedAmountAmtDTO waitApprovedAmountAmtDTO) {
        LOGGER.info("\u5f00\u59cb\u67e5\u8be2\u6240\u6709\u56fa\u5b9a\u5b50\u8868\u4e0b\u7b26\u5408\u6761\u4ef6\u7684\u7f16\u5236\u6570\u636e");
        HashMap<Long, Dimension> dimensionMap = new HashMap<Long, Dimension>(8);
        HashMap<Long, Set> valSetMap = new HashMap<Long, Set>(8);
        boolean enable = waitApprovedAmountAmtDTO.isEnable();
        Map templateDimMap = fixedDetailInoutList.stream().map(WaitApprovedAmountAmtInfoResultDTO::getReportData).map(ReportData::getDimList).flatMap(Collection::stream).filter(td -> !td.isDetailDim()).collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity(), (a, b) -> a));
        for (WaitApprovedAmountAmtInfoResultDTO fixedDetailInout : fixedDetailInoutList) {
            Set objects;
            ReportData reportData = fixedDetailInout.getReportData();
            Long childTemplateId = fixedDetailInout.getChildTemplateId();
            HashSet<Long> dimensionIdSet = new HashSet<Long>(templateDimMap.keySet());
            ReportTemplate childReportTemplate = fixedTemMap.get(childTemplateId);
            List<TemplateAccountSetting> accountSettings = childReportTemplate.getAccountSettings();
            Object subjectId = reportData.getDimValByDimType(DimensionType.SUBJECTS, null);
            TemplateAccountSetting templateAccountSetting = accountSettings.stream().filter(as -> Objects.equals(as.getAccountMemId(), subjectId)).findFirst().get();
            HashSet<Long> allChildSubjectIds = new HashSet<Long>(4);
            this.getAllChildSubjects(allChildSubjectIds, templateAccountSetting);
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dimValList = reportData.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                if (templateDim.isDetailDim()) continue;
                dimensionIdSet.remove(templateDim.getDimensionId());
                dimensionMap.putIfAbsent(templateDim.getDimensionId(), this.getDimension(templateDim));
                objects = valSetMap.computeIfAbsent(templateDim.getDimensionId(), key -> new HashSet(8));
                if (templateDim.getDimType() == DimensionType.SUBJECTS) {
                    objects.addAll(allChildSubjectIds);
                    continue;
                }
                objects.add(dimValList.get(i));
            }
            if (EmptyUtil.isEmpty(dimensionIdSet)) continue;
            for (Long dimensionId : dimensionIdSet) {
                dimensionMap.putIfAbsent(dimensionId, this.getDimension((TemplateDim)templateDimMap.get(dimensionId)));
                objects = valSetMap.computeIfAbsent(dimensionId, key -> new HashSet(8));
                objects.add(0L);
            }
        }
        ReportDataQueryObject queryObj = new ReportDataQueryObject();
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(dimensionMap.values());
        ArrayList<List<Object>> valList = new ArrayList<List<Object>>(dimensionMap.size());
        for (Dimension dimension : dimensionList) {
            Set objectSet = (Set)valSetMap.get(dimension.getId());
            valList.add(new ArrayList(objectSet));
        }
        queryObj.setDimIdList(dimensionList);
        queryObj.setDimValList(valList);
        queryObj.setMainTable(Boolean.FALSE);
        queryObj.setReportStatus(enable ? ReportStatus.ENABLE : ReportStatus.REPORTING);
        if (enable) {
            if (EmptyUtil.isEmpty(waitApprovedAmountAmtDTO.getAllChildReportDataIds())) {
                return Collections.emptyList();
            }
            queryObj.setIdList(new ArrayList<Long>(waitApprovedAmountAmtDTO.getAllChildReportDataIds()));
        }
        LOGGER.info("\u67e5\u8be2\u6240\u6709\u660e\u7ec6\u586b\u62a5\u5b50\u8868\u6570\u636e\uff0c\u7ef4\u5ea6\u7ec4\u5408\uff1a{},\u7ef4\u5ea6\u503c\uff1a{}", dimensionList, valList);
        return ReportHelper.convert(this.reportDataQueryService.queryReportData(queryObj));
    }

    private void getAllFormulaMemberSet(Set<Long> formulaMemberSet, TemplateAccountSetting rootAccountSetting) {
        List<TemplateAccountSetting> children;
        if (EmptyUtil.isEmpty((Object)rootAccountSetting)) {
            return;
        }
        if (rootAccountSetting.getInputType() == ReportInputType.FORMULA) {
            Set<Long> formulaSubjectMemberIds = this.getFormulaSubjectMemberIds(rootAccountSetting.getFormula());
            formulaMemberSet.addAll(formulaSubjectMemberIds);
        }
        if (EmptyUtil.isEmpty(children = rootAccountSetting.getChildren())) {
            return;
        }
        for (TemplateAccountSetting child : children) {
            this.getAllFormulaMemberSet(formulaMemberSet, child);
        }
    }

    private void populateChildren(WaitApprovedAmountAmtInfoResultDTO infoResultDTO, TemplateAccountSetting accountSetting, List<ReportData> dataList, Map<Long, Report> reportMap, Set<Long> formulaMemberSet, int level) {
        List<TemplateAccountSetting> children = accountSetting.getChildren();
        if (EmptyUtil.isEmpty(children)) {
            LOGGER.info("\u586b\u5145\u5b50\u8868\u4e0b\u7ea7\u79d1\u76ee\u6570\u636e\uff0c\u79d1\u76ee\uff1a{}\u6ca1\u6709\u4e0b\u7ea7\u79d1\u76ee\uff0c\u76f4\u63a5\u8fd4\u56de", (Object)accountSetting.getAccountMemId());
            return;
        }
        ReportData parentReportData = infoResultDTO.getReportData();
        EvalDimensionCombination parentCombination = EvalDimensionCombination.getEvalDimensionCombinationByReportData(parentReportData);
        for (TemplateAccountSetting as : children) {
            EvalDimensionCombination copy = parentCombination.copy(t -> {
                if (t.getDimensionType() == DimensionType.SUBJECTS) {
                    t.setValue(as.getAccountMemId());
                }
            });
            Optional<ReportData> first = dataList.stream().filter(rd -> {
                EvalDimensionCombination combination = EvalDimensionCombination.getEvalDimensionCombinationByReportData(rd);
                return Objects.equals(combination, copy);
            }).findFirst();
            if (!first.isPresent()) continue;
            ReportData reportData = first.get();
            WaitApprovedAmountAmtInfoResultDTO resultDTO = new WaitApprovedAmountAmtInfoResultDTO();
            resultDTO.setReport(reportMap.get(reportData.getReportId()));
            resultDTO.setReportData(reportData);
            resultDTO.setLevel(level + 1);
            resultDTO.setParentSubjectId(accountSetting.getAccountMemId());
            resultDTO.setEvaluateAmt(reportData.getOriginalPlanAmt());
            resultDTO.setFillWay(as.getInputType().getNumber());
            if (formulaMemberSet.contains(as.getAccountMemId())) {
                resultDTO.setSubFormula(true);
            }
            infoResultDTO.getChildren().add(resultDTO);
            this.populateChildren(infoResultDTO, as, dataList, reportMap, formulaMemberSet, level + 1);
        }
    }

    private Set<Long> getAllChildSubjects(Set<Long> allChildSubjectIds, TemplateAccountSetting templateAccountSetting) {
        if (EmptyUtil.isEmpty((Object)templateAccountSetting)) {
            return allChildSubjectIds;
        }
        allChildSubjectIds.add(templateAccountSetting.getAccountMemId());
        List<TemplateAccountSetting> children = templateAccountSetting.getChildren();
        if (EmptyUtil.isEmpty(children)) {
            return allChildSubjectIds;
        }
        for (TemplateAccountSetting child : children) {
            this.getAllChildSubjects(allChildSubjectIds, child);
        }
        return allChildSubjectIds;
    }

    private List<ReportData> getDirectReportData(List<ReportData> sumReportDataList, ReportTemplate sumReportTemplate, WaitApprovedAmountAmtDTO waitApprovedAmountAmtDTO) {
        Set<EvalDimensionCombination> dimensionCombinations;
        if (EmptyUtil.isEmpty(sumReportDataList)) {
            return Collections.emptyList();
        }
        boolean enable = waitApprovedAmountAmtDTO.isEnable();
        if (enable) {
            dimensionCombinations = Collections.singleton(EvalDimensionCombination.getEvalDimensionCombinationByReportData(sumReportDataList.get(0), t -> t.getDimType() == DimensionType.SUBJECTS));
        } else {
            Set<EvalDimensionCombination> combinationSetByReportDataSet = EvalDimensionCombination.getEvalDimensionCombinationSetByReportDataSet(sumReportDataList);
            dimensionCombinations = this.updateSubOrgAndCurrency(combinationSetByReportDataSet, waitApprovedAmountAmtDTO.getAllSubOrgId(), waitApprovedAmountAmtDTO.getCurrencyIds());
        }
        return this.queryReportDataByDimensionCombination(sumReportTemplate, dimensionCombinations, reportDataQueryObject -> {
            reportDataQueryObject.setReportStatus(enable ? ReportStatus.ENABLE : ReportStatus.REPORTING);
            if (enable) {
                LOGGER.info("\u8054\u67e5\uff0c\u62a5\u8868\u5df2\u751f\u6548\uff0c\u53ea\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u5b58\u5728\u7684\u7f16\u5236id\u6570\u636e");
                reportDataQueryObject.setIdList(new ArrayList<Long>(waitApprovedAmountAmtDTO.getAllReportDataIds()));
            }
            reportDataQueryObject.setReportPlanType(ReportPlanType.REPORTPLAN);
            reportDataQueryObject.setReportPeriodId(((ReportData)sumReportDataList.get(0)).getReportPeriodId());
            LOGGER.info("\u67e5\u8be2\u6c47\u603b\u989d\u5ea6\u7f16\u5236\u6570\u636e\uff1a{} \u7684\u4e0b\u7ea7\u7f16\u5236\u6570\u636e\uff0c\u67e5\u8be2\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a{}\uff0c\u7ef4\u5ea6\u503c:{}", new Object[]{sumReportDataList.stream().map(ReportData::getId).collect(Collectors.toList()), reportDataQueryObject.getDimIdList(), reportDataQueryObject.getDimIdList()});
        });
    }

    private int getScore(ReportData reportData) {
        return reportData.isMainTable() ? 1 : 10;
    }

    private Dimension getDimension(TemplateDim templateDim) {
        Dimension dimension = new Dimension();
        dimension.setDimType(templateDim.getDimType());
        dimension.setDetailDimType(templateDim.getDetailDimType());
        dimension.setId(templateDim.getDimensionId());
        return dimension;
    }

    private void updateSameAndAddDiff(List<ApprovedAmountAmtInfo> dataBaseAmountAmtInfoList, List<ApprovedAmountAmtInfo> waitApprovedAmountAmtInfos) {
        LOGGER.info("\u5f00\u59cb\u5904\u7406\u5df2\u5b58\u5728\u7684\u91d1\u989d\u6838\u5b9a\u9879\u548c\u65b0\u589e\u7684\u91d1\u989d\u6838\u5b9a\u9879");
        if (EmptyUtil.isEmpty(dataBaseAmountAmtInfoList)) {
            dataBaseAmountAmtInfoList.addAll(waitApprovedAmountAmtInfos);
            return;
        }
        Map amountAmtInfoMap = waitApprovedAmountAmtInfos.stream().collect(Collectors.toMap(ApprovedAmountAmtInfo::getReportDataId, Function.identity()));
        Map<Long, Map> approvedDetailMap = waitApprovedAmountAmtInfos.stream().collect(Collectors.toMap(ApprovedAmountAmtInfo::getReportDataId, info -> EmptyUtil.isEmpty(info.getAmtDetailInfoList()) ? Collections.emptyMap() : info.getAmtDetailInfoList().stream().collect(Collectors.toMap(ApprovedAmountAmtDetailInfo::getReportDataId, Function.identity()))));
        for (ApprovedAmountAmtInfo dataBaseApprovedAmountAmtInfo : dataBaseAmountAmtInfoList) {
            Long dataBaseReportDataId = dataBaseApprovedAmountAmtInfo.getReportDataId();
            Map waitDetailInfoMap = approvedDetailMap.get(dataBaseReportDataId);
            if (CollectionUtils.isEmpty((Map)waitDetailInfoMap)) {
                LOGGER.info("\u5f53\u524d\u6c47\u603b\u989d\u5ea6\u4fe1\u606f\u8ba1\u5212\u7f16\u5236id:{} \u672c\u6b21\u672a\u6838\u5b9a,\u4e0d\u66f4\u65b0", (Object)dataBaseApprovedAmountAmtInfo.getReportDataId());
                continue;
            }
            ApprovedAmountAmtInfo approvedAmountAmtInfo = (ApprovedAmountAmtInfo)amountAmtInfoMap.get(dataBaseReportDataId);
            if (EmptyUtil.isNoEmpty((Object)approvedAmountAmtInfo)) {
                dataBaseApprovedAmountAmtInfo.setApprovedAmt(approvedAmountAmtInfo.getApprovedAmt());
                dataBaseApprovedAmountAmtInfo.setReportDataIdStr(approvedAmountAmtInfo.getReportDataIdStr());
            }
            List<ApprovedAmountAmtDetailInfo> dataBaseAmtDetailInfoList = dataBaseApprovedAmountAmtInfo.getAmtDetailInfoList();
            Set detailReportDataIdSet = dataBaseAmtDetailInfoList.stream().map(ApprovedAmountAmtDetailInfo::getReportDataId).collect(Collectors.toSet());
            HashSet waitDetailReportDataIdSet = new HashSet(waitDetailInfoMap.keySet());
            waitDetailReportDataIdSet.retainAll(detailReportDataIdSet);
            if (CollectionUtils.isEmpty(waitDetailReportDataIdSet)) {
                LOGGER.info("\u5f53\u524d\u6c47\u603b\u989d\u5ea6\u4fe1\u606f\u8ba1\u5212\u7f16\u5236id:{} \u4e3a\u9996\u6b21\u6838\u5b9a\uff0c\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u6838\u5b9a\u8fc7\u7684\u5f85\u6838\u5b9a\u8bb0\u5f55\uff0c\u76f4\u63a5\u5168\u90e8\u6dfb\u52a0\u6240\u6709\u7684\u5f85\u6838\u5b9a\u7684\u8bb0\u5f55\u4fe1\u606f\uff1a{}", waitDetailInfoMap.values());
                dataBaseAmtDetailInfoList.addAll(waitDetailInfoMap.values());
            } else {
                dataBaseAmtDetailInfoList.stream().filter(detailInfo -> waitDetailReportDataIdSet.contains(detailInfo.getReportDataId())).forEach(detail -> {
                    ApprovedAmountAmtDetailInfo waitApprovedAmountAmtDetailInfo = (ApprovedAmountAmtDetailInfo)waitDetailInfoMap.get(detail.getReportDataId());
                    detail.setDataBaseApproveAmt(detail.getApprovedAmt());
                    detail.setApprovedAmt(waitApprovedAmountAmtDetailInfo.getApprovedAmt());
                    detail.setOriginalApprovedAmt(waitApprovedAmountAmtDetailInfo.getOriginalApprovedAmt());
                    detail.setAmountUnit(waitApprovedAmountAmtDetailInfo.getAmountUnit());
                    detail.setEvalAdjustReason(waitApprovedAmountAmtDetailInfo.getEvalAdjustReason());
                    detail.setApproved(true);
                    Long fillUser = waitApprovedAmountAmtDetailInfo.getFillUser();
                    fillUser = EmptyUtil.isEmpty((Long)fillUser) ? detail.getFillUser() : fillUser;
                    fillUser = EmptyUtil.isEmpty((Long)fillUser) ? Long.valueOf(RequestContext.get().getCurrUserId()) : fillUser;
                    detail.setFillUser(fillUser);
                });
                dataBaseAmtDetailInfoList.addAll(waitDetailInfoMap.entrySet().stream().map(Map.Entry::getValue).filter(detailInfo -> !waitDetailReportDataIdSet.contains(detailInfo.getReportDataId())).collect(Collectors.toList()));
            }
            approvedDetailMap.remove(dataBaseReportDataId);
        }
        if (CollectionUtils.isEmpty(approvedDetailMap)) {
            return;
        }
        for (ApprovedAmountAmtInfo approvedAmountAmtInfo : waitApprovedAmountAmtInfos) {
            if (EmptyUtil.isEmpty(approvedAmountAmtInfo.getAmtDetailInfoList()) || !approvedDetailMap.containsKey(approvedAmountAmtInfo.getReportDataId())) continue;
            dataBaseAmountAmtInfoList.add(approvedAmountAmtInfo);
        }
    }

    private void removeDeletedSumPlanApprovedRecord(ApprovedAmountRecord amountRecord) {
        if (amountRecord == null) {
            return;
        }
        List<Long> reportDataIdList = amountRecord.getAmountAmtInfoList().stream().map(ApprovedAmountAmtInfo::getAmtDetailInfoList).flatMap(Collection::stream).map(ApprovedAmountAmtDetailInfo::getReportDataId).collect(Collectors.toList());
        List<ReportData> reportDataQueryResults = this.getReportDataQueryResults(reportDataIdList);
        List existReportDataIdList = reportDataQueryResults.stream().map(ReportData::getId).collect(Collectors.toList());
        reportDataIdList.removeAll(existReportDataIdList);
        if (EmptyUtil.isEmpty(reportDataIdList)) {
            return;
        }
        HashSet<Long> notExistReportDataIdSet = new HashSet<Long>(reportDataIdList);
        LOGGER.info("\u4fdd\u5b58\u524d\u5bf9\u5df2\u5220\u9664\u7684\u53c2\u4e0e\u6838\u5b9a\u7684\u5e26\u6838\u5b9a\u8bb0\u5f55\u4fe1\u606f\u8fdb\u884c\u5220\u9664\uff0c\u5df2\u5220\u9664\u7684\u8ba1\u5212\u7f16\u5236\u6570\u636eid:{}", notExistReportDataIdSet);
        List<ApprovedAmountAmtInfo> amountAmtInfoList = amountRecord.getAmountAmtInfoList();
        for (ApprovedAmountAmtInfo amountAmtInfo : amountAmtInfoList) {
            List<ApprovedAmountAmtDetailInfo> amtDetailInfoList = amountAmtInfo.getAmtDetailInfoList();
            if (EmptyUtil.isEmpty(amtDetailInfoList)) continue;
            Iterator<ApprovedAmountAmtDetailInfo> iterator = amtDetailInfoList.iterator();
            BigDecimal total = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                ApprovedAmountAmtDetailInfo next = iterator.next();
                if (notExistReportDataIdSet.contains(next.getReportDataId())) {
                    iterator.remove();
                    LOGGER.info("\u5220\u9664\u5f53\u524d\u6838\u5b9a\u8be6\u60c5\u4fe1\u606f:{}", (Object)next);
                    continue;
                }
                total = total.add(next.getApprovedAmt());
            }
            LOGGER.info("\u91cd\u65b0\u8ba1\u7b97\u540e\u7684\u6838\u5b9a\u91d1\u989d\uff1a", (Object)total);
            amountAmtInfo.setApprovedAmt(total);
        }
    }

    private void removeDeletedSumPlanDetailInfo(List<ApprovedAmountAmtDetailInfo> detailInfoList) {
        if (EmptyUtil.isEmpty(detailInfoList)) {
            return;
        }
        List<Long> reportDataIdList = detailInfoList.stream().map(ApprovedAmountAmtDetailInfo::getReportDataId).collect(Collectors.toList());
        List<ReportData> reportDataQueryResults = this.getReportDataQueryResults(reportDataIdList);
        List existReportDataIdList = reportDataQueryResults.stream().map(ReportData::getId).collect(Collectors.toList());
        reportDataIdList.removeAll(existReportDataIdList);
        if (EmptyUtil.isEmpty(reportDataIdList)) {
            return;
        }
        LOGGER.info("\u5b58\u5728\u5df2\u53c2\u4e0e\u6838\u5b9a\u7684\u7f16\u5236\u6570\u636e\u5220\u9664\u7684\u60c5\u51b5\uff0c\u9700\u8981\u5bf9\u6838\u5b9a\u8bb0\u5f55\u4fe1\u606f\u8fdb\u884c\u5220\u9664,\u5df2\u5220\u9664\u5f85\u6838\u5b9a\u7f16\u5236\u6570\u636eid:{}", reportDataIdList);
        Iterator<ApprovedAmountAmtDetailInfo> iterator = detailInfoList.iterator();
        HashSet<Long> notExistReportDataIdSet = new HashSet<Long>(reportDataIdList);
        while (iterator.hasNext()) {
            ApprovedAmountAmtDetailInfo next = iterator.next();
            if (!notExistReportDataIdSet.contains(next.getReportDataId())) continue;
            LOGGER.info("\u5220\u9664\u5f53\u524d\u6838\u5b9a\u8be6\u60c5\u4fe1\u606f:{}", (Object)next);
            iterator.remove();
        }
    }

    private List<ReportData> getReportDataQueryResults(List<Long> reportDataIdList) {
        return this.listReportDataQueryResult(reportDataIdList, null);
    }

    private List<ReportData> listReportDataQueryResult(List<Long> reportDataIdList, Consumer<ReportDataQueryObject> consumer) {
        if (EmptyUtil.isEmpty(reportDataIdList)) {
            return new ArrayList<ReportData>(0);
        }
        ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
        reportDataQueryObject.setIdList(reportDataIdList);
        if (consumer != null) {
            consumer.accept(reportDataQueryObject);
        }
        return ReportHelper.convert(this.reportDataQueryService.queryReportData(reportDataQueryObject));
    }

    private Set<Long> getFormulaSubjectMemberIds(String formula) {
        String[] formulaItemArr = formula.replaceAll("\\(", "").replaceAll("\\)", "").split("[\\+|\\-]");
        HashSet<Long> subjectIdSet = new HashSet<Long>(formulaItemArr.length);
        for (String formulaItem : formulaItemArr) {
            if (!formulaItem.matches("^(\\[)[0-9]+(\\])$")) continue;
            Long subjectId = Long.valueOf(formulaItem.replace("[", "").replace("]", ""));
            subjectIdSet.add(subjectId);
        }
        return subjectIdSet;
    }

    private Set<EvalDimensionCombination> updateSubOrgAndCurrency(Set<EvalDimensionCombination> evalDimensionCombinationSet, Collection<Long> sumOrgIds, List<Long> currencyIds) {
        if (EmptyUtil.isEmpty(sumOrgIds) && EmptyUtil.isEmpty(currencyIds)) {
            return new HashSet<EvalDimensionCombination>(8);
        }
        HashSet<EvalDimensionCombination> evalDimensionCombinations = new HashSet<EvalDimensionCombination>(evalDimensionCombinationSet.size() * (sumOrgIds.size() + currencyIds.size()));
        for (EvalDimensionCombination evalDimensionCombination : evalDimensionCombinationSet) {
            EvalDimensionCombination copy;
            if (EmptyUtil.isEmpty(currencyIds) && EmptyUtil.isNoEmpty(sumOrgIds)) {
                for (Long sumOrgId : sumOrgIds) {
                    copy = evalDimensionCombination.copy(t -> {
                        DimensionType dimensionType = t.getDimensionType();
                        if (dimensionType == DimensionType.ORG) {
                            t.setValue(sumOrgId);
                        }
                    });
                    evalDimensionCombinations.add(copy);
                }
                continue;
            }
            if (EmptyUtil.isNoEmpty(currencyIds) && EmptyUtil.isEmpty(sumOrgIds)) {
                for (Long currencyId : currencyIds) {
                    copy = evalDimensionCombination.copy(t -> {
                        DimensionType dimensionType = t.getDimensionType();
                        if (dimensionType == DimensionType.CURRENCY) {
                            t.setValue(currencyId);
                        }
                    });
                    evalDimensionCombinations.add(copy);
                }
                continue;
            }
            for (Long sumOrgId : sumOrgIds) {
                for (Long currencyId : currencyIds) {
                    EvalDimensionCombination copy2 = evalDimensionCombination.copy(t -> {
                        DimensionType dimensionType = t.getDimensionType();
                        if (dimensionType == DimensionType.ORG) {
                            t.setValue(sumOrgId);
                        }
                        if (dimensionType == DimensionType.CURRENCY) {
                            t.setValue(currencyId);
                        }
                    });
                    evalDimensionCombinations.add(copy2);
                }
            }
        }
        return evalDimensionCombinations;
    }

    private void fillApprovedAmountRecordMore(ApprovedAmountRecordMore approvedAmountRecordMore, EvalLoadParamDTO evalLoadParamDTO) {
        ApprovedAmountRecord approvedAmountRecord = approvedAmountRecordMore.getRecord();
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(approvedAmountRecord.getSystemId());
        approvedAmountRecordMore.setFundPlanSystem(fundPlanSystem);
        this.fillCurrencyMap(approvedAmountRecordMore);
        this.fillReportData(approvedAmountRecordMore, evalLoadParamDTO);
    }

    private void fillCurrencyMap(ApprovedAmountRecordMore approvedAmountRecordMore) {
        List<SumPlanRecord> sumPlanRecords;
        List<Long> subAuditOrgIds;
        ApprovedAmountRecord record = approvedAmountRecordMore.getRecord();
        Long systemId = record.getSystemId();
        Long orgReportType = record.getOrgReportType();
        Long sumOrgId = record.getMember();
        SumPlanParamConfig sumPlanParamConfig = this.sumPlanRepository.loadSumConfigBySystem(systemId, Collections.singleton(orgReportType), false).get(0);
        approvedAmountRecordMore.setSumPlanParamConfig(sumPlanParamConfig);
        if (EmptyUtil.isEmpty((Object)sumPlanParamConfig)) {
            return;
        }
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        if (EmptyUtil.isEmpty(configInfoList)) {
            return;
        }
        HashSet<Long> notReportingOrgIds = new HashSet<Long>(4);
        if (!approvedAmountRecordMore.isEnable() && EmptyUtil.isNoEmpty(subAuditOrgIds = configInfoList.stream().filter(info -> Objects.equals(sumOrgId, info.getOrgMemberId())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).distinct().collect(Collectors.toList())) && EmptyUtil.isNoEmpty(sumPlanRecords = this.sumPlanRepository.loadSumPlanRecord(subAuditOrgIds, record.getOrgReportPeriod()))) {
            Set reportingOrgIds = sumPlanRecords.stream().filter(sr -> sr.getReportStatus() == ReportStatus.REPORTING).map(SumPlanRecord::getReportOrg).collect(Collectors.toSet());
            subAuditOrgIds.removeAll(reportingOrgIds);
            notReportingOrgIds.addAll(subAuditOrgIds);
        }
        Set notReportingSubOrgIds = configInfoList.stream().filter(SumPlanParamConfigInfo::isSumAuditNode).filter(info -> notReportingOrgIds.contains(info.getOrgMemberId())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        List<Long> subAuditOrgIdList = configInfoList.stream().filter(info -> Objects.equals(sumOrgId, info.getOrgMemberId())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).filter(info -> !info.isSumAuditNode()).map(SumPlanParamConfigInfo::getOrgMemberId).filter(id -> !notReportingSubOrgIds.contains(id)).collect(Collectors.toList());
        approvedAmountRecordMore.setAllSubOrgIds(subAuditOrgIdList);
        Map<Long, List<Long>> currencyMap = configInfoList.stream().filter(info -> Objects.equals(sumOrgId, info.getOrgMemberId())).map(SumPlanParamConfigInfo::getCurrencyMapCase).filter(Objects::nonNull).map(SumPlanParamConfigInfo.CurrencyMapCase::getCurrencyMapCaseInfoList).filter(Objects::nonNull).flatMap(Collection::stream).filter(info -> EmptyUtil.isNoEmpty((Long)info.getSumCurrencyId()) && EmptyUtil.isNoEmpty(info.getSubOrgReportCurrencyId())).collect(Collectors.toMap(SumPlanParamConfigInfo.CurrencyMapCaseInfo::getSumCurrencyId, SumPlanParamConfigInfo.CurrencyMapCaseInfo::getSubOrgReportCurrencyId));
        for (Map.Entry<Long, List> entry : currencyMap.entrySet()) {
            Long sumCurrencyId = entry.getKey();
            List mapCurrencyIds = entry.getValue();
            if (mapCurrencyIds.contains(sumCurrencyId)) continue;
            mapCurrencyIds.add(sumCurrencyId);
        }
        approvedAmountRecordMore.setCurrencyListMap(currencyMap);
    }

    private List<Long> loadAllSubOrgIds(SumPlanParamConfig sumPlanParamConfig, Long sumOrgId, Long reportPeriodId, boolean isEnable) {
        List<SumPlanRecord> sumPlanRecords;
        List<Long> subAuditOrgIds;
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        if (EmptyUtil.isEmpty(configInfoList)) {
            return new ArrayList<Long>(0);
        }
        HashSet<Long> notReportingOrgIds = new HashSet<Long>(4);
        if (!isEnable && EmptyUtil.isNoEmpty(subAuditOrgIds = configInfoList.stream().filter(info -> Objects.equals(sumOrgId, info.getOrgMemberId())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).distinct().collect(Collectors.toList())) && EmptyUtil.isNoEmpty(sumPlanRecords = this.sumPlanRepository.loadSumPlanRecord(subAuditOrgIds, reportPeriodId))) {
            Set reportingOrgIds = sumPlanRecords.stream().filter(sr -> sr.getReportStatus() == ReportStatus.REPORTING).map(SumPlanRecord::getReportOrg).collect(Collectors.toSet());
            subAuditOrgIds.removeAll(reportingOrgIds);
            notReportingOrgIds.addAll(subAuditOrgIds);
        }
        Set notReportingSubOrgIds = configInfoList.stream().filter(SumPlanParamConfigInfo::isSumAuditNode).filter(info -> notReportingOrgIds.contains(info.getOrgMemberId())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        return configInfoList.stream().filter(info -> Objects.equals(sumOrgId, info.getOrgMemberId())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).filter(info -> !info.isSumAuditNode()).map(SumPlanParamConfigInfo::getOrgMemberId).filter(id -> !notReportingSubOrgIds.contains(id)).collect(Collectors.toList());
    }

    private Map<Long, List<Long>> loadCurrencyMap(SumPlanParamConfig sumPlanParamConfig, Long sumOrgId) {
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        if (EmptyUtil.isEmpty(configInfoList)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<Long, List<Long>> currencyMap = configInfoList.stream().filter(info -> Objects.equals(sumOrgId, info.getOrgMemberId())).map(SumPlanParamConfigInfo::getCurrencyMapCase).filter(Objects::nonNull).map(SumPlanParamConfigInfo.CurrencyMapCase::getCurrencyMapCaseInfoList).filter(Objects::nonNull).flatMap(Collection::stream).filter(info -> EmptyUtil.isNoEmpty((Long)info.getSumCurrencyId()) && EmptyUtil.isNoEmpty(info.getSubOrgReportCurrencyId())).collect(Collectors.toMap(SumPlanParamConfigInfo.CurrencyMapCaseInfo::getSumCurrencyId, SumPlanParamConfigInfo.CurrencyMapCaseInfo::getSubOrgReportCurrencyId));
        for (Map.Entry<Long, List> entry : currencyMap.entrySet()) {
            Long sumCurrencyId = entry.getKey();
            List mapCurrencyIds = entry.getValue();
            if (mapCurrencyIds.contains(sumCurrencyId)) continue;
            mapCurrencyIds.add(sumCurrencyId);
        }
        return currencyMap;
    }

    private BigDecimal getAddSumReportDataEvaluateAmt(ReportData reportData, ReportData sumReportData, Dimension currencyDim, Map<Long, DimMember> currencyMemberMap, Long exRateTableId, Date exRateDate, BigDecimal evaluateAmt) {
        DimMember sourceCurrency = currencyMemberMap.get(reportData.getDimValByDimensionId(currencyDim.getId()));
        DimMember targetCurrency = currencyMemberMap.get(sumReportData.getDimValByDimensionId(currencyDim.getId()));
        Long sourceCurrencyId = sourceCurrency.getSourceId();
        Long targetCurrencyId = targetCurrency.getSourceId();
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (!Objects.equals(sourceCurrencyId, targetCurrencyId)) {
            exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTableId, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)exRateDate);
        }
        if (exchangeRate == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6ca1\u6709\u7ef4\u62a4\u6e90\u5e01\u79cd\u201c%1$s\u201d\u5230\u76ee\u6807\u5e01\u79cd\u201c%2$s\u201d\u7684\u6c47\u7387\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"EvaluateAmtBizServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceCurrency.getName(), targetCurrency.getName()));
        }
        AmountUnitEnum sourceAmtUnitEnum = AmountUnit.convert(reportData.getAmountUnit());
        AmountUnitEnum targetAmtUnitEnum = AmountUnit.convert(sumReportData.getAmountUnit());
        return AmountUtil.convert((AmountUnitEnum)sourceAmtUnitEnum, (AmountUnitEnum)targetAmtUnitEnum, (BigDecimal)evaluateAmt.multiply(exchangeRate));
    }

    private void fillReportData(ApprovedAmountRecordMore approvedAmountRecordMore, EvalLoadParamDTO evalLoadParamDTO) {
        List<Long> sumReportDataIdList;
        List<String> reportDataIdList = evalLoadParamDTO.getReportDataIdList();
        ApprovedAmountRecord approvedAmountRecord = approvedAmountRecordMore.getRecord();
        if (EmptyUtil.isEmpty(reportDataIdList)) {
            reportDataIdList = approvedAmountRecord.getAmountAmtInfoList().stream().map(ApprovedAmountAmtInfo::getReportDataIdStr).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
        if (EmptyUtil.isEmpty(sumReportDataIdList = reportDataIdList.stream().filter(StringUtils::isNotEmpty).map(idStr -> idStr.split(",")).filter(arr -> ((String[])arr).length > 0).map(arr -> arr[0]).map(Long::valueOf).collect(Collectors.toList()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u5143\u683c\u6ca1\u6709\u5bf9\u5e94\u7684\u6c47\u603b\u7f16\u5236\u6570\u636e\uff0c\u8bf7\u786e\u8ba4", (String)"EvaluateAmtBizServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        List<ReportData> sumReportDataList = this.getReportDataQueryResults(sumReportDataIdList);
        Long reportId = sumReportDataList.get(0).getReportId();
        Report report = this.getReport(reportId, (ReportNeedPropDTO rp) -> rp.setNeedTemplate(true));
        approvedAmountRecordMore.setSumPlanReport(report);
        ReportTemplate template = report.getTemplate();
        Map<Long, List<Long>> currencyListMap = approvedAmountRecordMore.getCurrencyListMap();
        Set<EvalDimensionCombination> evalDimensionCombinationSet = EvalDimensionCombination.getEvalDimensionCombinationSetByReportDataSet(sumReportDataList, template);
        LOGGER.info("\u5f53\u524d\u6c47\u603b\u8868\uff1a{}\u7b5b\u9009\u6570\u636e\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a{}", (Object)report.getNumber(), evalDimensionCombinationSet);
        List<EvalDimensionCombinationCurrencyMap> currencyMapList = this.sourceCurrencyMap(evalDimensionCombinationSet, currencyListMap);
        Map<EvalDimensionCombination, EvalDimensionCombinationCurrencyMap> currencyMapMap = currencyMapList.stream().map(edcc -> edcc.currencyMapEntity(true)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<Long> currencyIds = currencyMapList.stream().map(EvalDimensionCombinationCurrencyMap::getCurrencyIdList).filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Set<EvalDimensionCombination> dimensionCombinations = this.updateSubOrgAndCurrency(evalDimensionCombinationSet, Collections.emptyList(), currencyIds);
        dimensionCombinations.addAll(evalDimensionCombinationSet);
        List<ReportData> reportDataList = this.queryReportDataByDimensionCombination(template, dimensionCombinations, t -> {
            t.setReportPlanType(ReportPlanType.SUMPLAN);
            t.setReportIdS(Collections.singletonList(report.getId()));
            t.setReportPeriodId(((ReportData)sumReportDataList.get(0)).getReportPeriodId());
        });
        HashMap<EvalDimensionCombinationCurrencyMap, List<ReportData>> reportDataGroupMap = new HashMap<EvalDimensionCombinationCurrencyMap, List<ReportData>>(reportDataIdList.size());
        for (ReportData reportData : reportDataList) {
            EvalDimensionCombination dimensionCombination;
            EvalDimensionCombination combination = EvalDimensionCombination.getEvalDimensionCombinationByReportData(reportData, template);
            LOGGER.info("\u5f53\u524d\u7f16\u5236\u6570\u636e:{},\u6c47\u603b\u6a21\u677f\u5b9a\u4e49\u5185\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a{}", (Object)reportData.getId(), (Object)combination);
            EvalDimensionCombinationCurrencyMap evalDimensionCombinationCurrencyMap = currencyMapMap.get(combination);
            if (EmptyUtil.isEmpty((Object)evalDimensionCombinationCurrencyMap)) {
                LOGGER.info("\u7f16\u5236\u6570\u636e\uff1a{}\uff0c\u7684\u7ef4\u5ea6\u7ec4\u5408{}\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684EvalDimensionCombinationCurrencyMap,\u4e3a\u7ef4\u5ea6\u4ea4\u53c9\u6570\u636e", (Object)reportData.getId(), (Object)combination);
                continue;
            }
            EvalDimensionCombination sourceCombination = evalDimensionCombinationCurrencyMap.getCombination();
            if (!Objects.equals(sourceCombination, dimensionCombination = evalDimensionCombinationCurrencyMap.getConvertEvalDimensionCombination(combination))) {
                LOGGER.info("\u6c47\u603b\u7f16\u5236\u6570\u636e\u7ef4\u5ea6\u7ec4\u5408\uff1a{}\uff0c\u4e0e\u7f16\u5236\u6570\u636e\uff1a{}\u7ef4\u5ea6\u7ec4\u5408\uff1a{}\u8f6c\u6362\u6210\u5458\u5e01\u79cd\u540e\u7684\u7ef4\u5ea6\u7ec4\u5408\uff1a{}\u4e0d\u4e00\u81f4", new Object[]{sourceCombination, reportData.getId(), combination, dimensionCombination});
                continue;
            }
            List reportDataListGroup = reportDataGroupMap.computeIfAbsent(evalDimensionCombinationCurrencyMap, key -> new ArrayList(8));
            reportDataListGroup.add(reportData);
        }
        this.mergeReportData(reportDataGroupMap, approvedAmountRecordMore);
    }

    private void mergeReportData(Map<EvalDimensionCombinationCurrencyMap, List<ReportData>> reportDataGroupMap, ApprovedAmountRecordMore approvedAmountRecordMore) {
        StringBuilder sb = new StringBuilder();
        FundPlanSystem fundPlanSystem = approvedAmountRecordMore.getFundPlanSystem();
        ApprovedAmountRecord record = approvedAmountRecordMore.getRecord();
        List<ApprovedAmountAmtInfo> amountAmtInfoList = record.getAmountAmtInfoList();
        Map amountAmtInfoMap = amountAmtInfoList.stream().collect(Collectors.toMap(ApprovedAmountAmtInfo::getReportDataId, Function.identity()));
        ArrayList<EvalReportData> evalReportDataList = new ArrayList<EvalReportData>(reportDataGroupMap.size());
        AmountUnit targetAmountUnit = record.getAmountUnit();
        for (Map.Entry<EvalDimensionCombinationCurrencyMap, List<ReportData>> entry : reportDataGroupMap.entrySet()) {
            EvalDimensionCombinationCurrencyMap key = entry.getKey();
            List<ReportData> value = entry.getValue();
            List reportDataList = value.stream().sorted(Comparator.comparing(ReportData::getId)).collect(Collectors.toList());
            Long initReportDataId = ((ReportData)reportDataList.get(0)).getId();
            EvalReportData evalReportData = null;
            for (ReportData reportData : reportDataList) {
                Long reportDataId = reportData.getId();
                sb.append(reportDataId).append(",");
                this.currencyReportData(reportData, fundPlanSystem, key.getCurrencyId(), targetAmountUnit, (sourceCurrencyMem, targetCurrencyMem) -> {
                    Date exRateDate = record.getExRateDate();
                    Long exRateTable = record.getExRateTable();
                    BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exRateTable, (Long)sourceCurrencyMem.getSourceId(), (Long)targetCurrencyMem.getSourceId(), (Date)exRateDate);
                    if (Objects.isNull(exchangeRate)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u6ca1\u6709\u7ef4\u62a4\u6e90\u5e01\u79cd\u201c%1$s\u201d\u5230\u76ee\u6807\u5e01\u79cd\u201c%2$s\u201d\u7684\u6c47\u7387\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c\u3002", (String)"EvaluateAmtBizServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceCurrencyMem.getName(), targetCurrencyMem.getName()));
                    }
                    return exchangeRate;
                });
                if (evalReportData == null) {
                    LOGGER.info("\u5c06\u6c47\u603b\u7f16\u5236\u6570\u636e\u5bf9\u8c61\uff1a{},\u4e0a\u62a5\u989d\u5ea6\uff1a{}\uff0c\u6838\u5b9a\u989d\u5ea6\uff1a{}\uff0c\u8f6c\u6362\u4e3a\u91d1\u989d\u6838\u5b9a\u6570\u636e\u5bf9\u8c61", new Object[]{reportDataId, reportData.getReportPlanAmt(), reportData.getOriginalPlanAmt()});
                    evalReportData = new EvalReportData(reportData);
                    this.updateCurrency(evalReportData, key.getCurrencyId());
                } else {
                    LOGGER.info("\u5408\u5e76\u6c47\u603b\u7f16\u5236\u6570\u636e\uff0c\u91d1\u989d\u6838\u5b9a\u7f16\u5236\u6570\u636e\uff1a{}\uff0c\u4e0a\u62a5\u989d\u5ea6\uff1a{}\uff0c\u6838\u5b9a\u989d\u5ea6\uff1a{}\uff0c\u5f85\u5408\u5e76\u7684\u7f16\u5236\u6570\u636e\uff1a{}\uff0c\u7ecf\u8fc7\u5e01\u79cd\u6362\u7b97\u540e\u7684\u4e0a\u62a5\u989d\u5ea6\uff1a{}\uff0c\u6838\u5b9a\u989d\u5ea6\uff1a{}", new Object[]{evalReportData.getId(), evalReportData.getReportPlanAmt(), evalReportData.getOriginalPlanAmt(), reportDataId, reportData.getReportPlanAmt(), reportData.getOriginalPlanAmt()});
                    evalReportData.addReportData(reportData);
                }
                if (!amountAmtInfoMap.containsKey(reportDataId)) continue;
                initReportDataId = reportDataId;
            }
            if (evalReportData == null) continue;
            if (sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
                evalReportData.setReportDataIdStr(sb.toString());
            }
            evalReportData.setApprovalReportDataId(initReportDataId);
            sb.delete(0, sb.length());
            evalReportDataList.add(evalReportData);
        }
        approvedAmountRecordMore.setReportDataList(evalReportDataList);
    }

    private void updateCurrency(EvalReportData evalReportData, Long currencyId) {
        List<TemplateDim> dimList = evalReportData.getDimList();
        List<Object> dimValList = evalReportData.getDimValList();
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim templateDim = dimList.get(i);
            if (templateDim.getDimType() != DimensionType.CURRENCY) continue;
            if (Objects.equals(dimValList.get(i), currencyId)) {
                return;
            }
            LOGGER.info("\u91d1\u989d\u6838\u5b9a\u6570\u636e\u5bf9\u8c61\uff1a{},\u5b58\u5728\u5e01\u79cd\u6620\u5c04\uff0c\u66f4\u65b0\u663e\u793a\u5e01\u79cd\uff1a{}", (Object)evalReportData.getId(), (Object)currencyId);
            dimValList.set(i, currencyId);
            return;
        }
    }

    private void currencyReportData(ReportData reportData, FundPlanSystem fundPlanSystem, Long targetCurrencyMemberId, AmountUnit targetAmountUnit, BiFunction<DimMember, DimMember, BigDecimal> rateFunction) {
        AmountUnit sourceAmountUnit = reportData.getAmountUnit();
        Object sourceCurrencyMemberId = reportData.getDimValByDimType(DimensionType.CURRENCY, null);
        if (Objects.equals(sourceCurrencyMemberId, targetCurrencyMemberId) && sourceAmountUnit == targetAmountUnit) {
            return;
        }
        Dimension currencyDimension = fundPlanSystem.getMainDimensionByDimType(DimensionType.CURRENCY);
        List<DimMember> allDimMemberList = currencyDimension.getAllDimMemberList();
        Map memberMap = allDimMemberList.stream().filter(dm -> Objects.equals(dm.getId(), sourceCurrencyMemberId) || Objects.equals(dm.getId(), targetCurrencyMemberId)).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        BigDecimal reportPlanAmt = reportData.getReportPlanAmt();
        reportPlanAmt = this.convertAmt(reportPlanAmt, (DimMember)memberMap.get(sourceCurrencyMemberId), sourceAmountUnit, (DimMember)memberMap.get(targetCurrencyMemberId), targetAmountUnit, rateFunction);
        reportData.setReportPlanAmt(reportPlanAmt);
        BigDecimal originalPlanAmt = reportData.getOriginalPlanAmt();
        originalPlanAmt = this.convertAmt(originalPlanAmt, (DimMember)memberMap.get(sourceCurrencyMemberId), sourceAmountUnit, (DimMember)memberMap.get(targetCurrencyMemberId), targetAmountUnit, rateFunction);
        reportData.setOriginalPlanAmt(originalPlanAmt);
        reportData.setAmountUnit(targetAmountUnit);
    }

    private BigDecimal convertAmt(BigDecimal sourceAmt, DimMember sourceCurrencyMem, AmountUnit sourceAmountUnit, DimMember targetCurrencyMem, AmountUnit targetAmountUnit, BiFunction<DimMember, DimMember, BigDecimal> rateFunction) {
        if (EmptyUtil.isEmpty((BigDecimal)sourceAmt)) {
            return BigDecimal.ZERO;
        }
        if (sourceAmountUnit != targetAmountUnit) {
            BigDecimal convertAmt = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.get((String)sourceAmountUnit.getNumber()), (AmountUnitEnum)AmountUnitEnum.ONE, (BigDecimal)sourceAmt);
            sourceAmt = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)AmountUnitEnum.get((String)targetAmountUnit.getNumber()), (BigDecimal)convertAmt);
        }
        if (Objects.equals(sourceCurrencyMem.getId(), targetCurrencyMem.getId())) {
            return sourceAmt;
        }
        return sourceAmt.multiply(rateFunction.apply(sourceCurrencyMem, targetCurrencyMem));
    }

    private List<EvalDimensionCombinationCurrencyMap> sourceCurrencyMap(Set<EvalDimensionCombination> evalDimensionCombinationSet, Map<Long, List<Long>> currencyListMap) {
        ArrayList<EvalDimensionCombinationCurrencyMap> currencyMapList = new ArrayList<EvalDimensionCombinationCurrencyMap>(evalDimensionCombinationSet.size());
        if (CollectionUtils.isEmpty(currencyListMap)) {
            for (EvalDimensionCombination evalDimensionCombination : evalDimensionCombinationSet) {
                Long currencyValue = (Long)evalDimensionCombination.getValueByDimType(DimensionType.CURRENCY);
                if (EmptyUtil.isEmpty((Long)currencyValue)) continue;
                currencyMapList.add(new EvalDimensionCombinationCurrencyMap(evalDimensionCombination, currencyValue, Collections.emptyList()));
            }
            return currencyMapList;
        }
        for (EvalDimensionCombination combination : evalDimensionCombinationSet) {
            List<EvalDimensionVal> evalDimensionValList = combination.getEvalDimensionValList();
            EvalDimensionVal currencyDimensionVal = evalDimensionValList.stream().filter(evalDimensionVal -> evalDimensionVal.getDimensionType() == DimensionType.CURRENCY).findFirst().get();
            Long value = (Long)currencyDimensionVal.getValue();
            if (currencyListMap.containsKey(value)) {
                List<Long> mapCurrency = currencyListMap.get(value);
                if (!mapCurrency.contains(value)) {
                    mapCurrency.add(value);
                }
                currencyMapList.add(new EvalDimensionCombinationCurrencyMap(combination, value, mapCurrency));
                continue;
            }
            for (Map.Entry<Long, List<Long>> entry : currencyListMap.entrySet()) {
                if (!entry.getValue().contains(value)) continue;
                combination = combination.copy(t -> {
                    if (t.getDimensionType() == DimensionType.CURRENCY) {
                        t.setValue(entry.getKey());
                    }
                });
                currencyMapList.add(new EvalDimensionCombinationCurrencyMap(combination, entry.getKey(), entry.getValue()));
            }
        }
        return currencyMapList;
    }

    private List<ReportData> queryReportDataByDimensionCombination(ReportTemplate template, Set<EvalDimensionCombination> dimensionCombinations, Consumer<ReportDataQueryObject> consumer) {
        Map<Long, List<EvalDimensionVal>> listMap = dimensionCombinations.stream().map(EvalDimensionCombination::getEvalDimensionValList).flatMap(Collection::stream).collect(Collectors.groupingBy(EvalDimensionVal::getDimensionId));
        List<TemplateDim> dimList = template.getAllTemplateDim();
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>(dimList.size());
        ArrayList<List<Object>> dimensionValList = new ArrayList<List<Object>>(dimList.size());
        for (int i = 0; i < dimList.size(); ++i) {
            Long dimensionId;
            List evalDimensionValList;
            Set dimValSet;
            TemplateDim templateDim = dimList.get(i);
            if (templateDim.isDetailDim() || EmptyUtil.isEmpty(dimValSet = (evalDimensionValList = listMap.getOrDefault(dimensionId = templateDim.getDimensionId(), Collections.emptyList())).stream().map(EvalDimensionVal::getValue).collect(Collectors.toSet()))) continue;
            dimensionList.add(this.getDimension(templateDim));
            dimensionValList.add(new ArrayList(dimValSet));
        }
        ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
        reportDataQueryObject.setDimIdList(dimensionList);
        reportDataQueryObject.setDimValList(dimensionValList);
        reportDataQueryObject.setNeedDimIfValueIsNotEmpty(true);
        if (consumer != null) {
            consumer.accept(reportDataQueryObject);
        }
        List<ReportDataQueryResult> subReportDataQueryResults = this.reportDataQueryService.queryReportData(reportDataQueryObject);
        return ReportHelper.convert(subReportDataQueryResults);
    }

    private List<ApprovedAmountAmtDetailInfo> mergeApprovalDetailInfo(List<ApprovedAmountAmtDetailInfo> downDetailInfoList) {
        HashMap<Long, ApprovedAmountAmtDetailInfo> downDetailInfoMap = new HashMap<Long, ApprovedAmountAmtDetailInfo>(16);
        LOGGER.info("\u5f00\u59cb\u5408\u5e76\u76f4\u63a5\u4e0b\u7ea7\u6838\u5b9a\u8bb0\u5f55");
        for (ApprovedAmountAmtDetailInfo detailInfo : downDetailInfoList) {
            Long reportDataId = detailInfo.getReportDataId();
            ApprovedAmountAmtDetailInfo mergedDetailInfo = (ApprovedAmountAmtDetailInfo)downDetailInfoMap.get(reportDataId);
            if (EmptyUtil.isEmpty((Object)mergedDetailInfo)) {
                mergedDetailInfo = detailInfo;
                downDetailInfoMap.put(reportDataId, mergedDetailInfo);
                LOGGER.info("\u8ba1\u5212\u7f16\u5236\u6570\u636eid:{}\uff0c\u9996\u6b21\u5408\u5e76\uff0c\u6838\u5b9a\u8bb0\u5f55id:{},\u5f53\u524d\u6838\u5b9a\u989d\u5ea6\uff1a{}", new Object[]{reportDataId, detailInfo.getId(), mergedDetailInfo.getApprovedAmt()});
                continue;
            }
            BigDecimal beforeApprovedAmt = mergedDetailInfo.getApprovedAmt();
            BigDecimal approvedAmt = detailInfo.getApprovedAmt();
            mergedDetailInfo.setApprovedAmt(beforeApprovedAmt.add(approvedAmt));
            LOGGER.info("\u8ba1\u5212\u7f16\u5236\u6570\u636eid:{}\uff0c\u4e0e\u5176\u4ed6\u6c47\u603b\u7f16\u5236\u8bb0\u5f55\u7684\u6838\u5b9a\u8bb0\u5f55\u5408\u5e76,\u6838\u5b9a\u8bb0\u5f55id\uff1a{}\uff0c\u5408\u5e76\u540e\u7684\u6838\u5b9a\u989d\u5ea6\uff1a{}=\u6838\u5b9a\u524d\u7684\u6838\u5b9a\u989d\u5ea6\uff1a{}+\u5f53\u524d\u5f85\u5408\u5e76\u7684\u6838\u5b9a\u989d\u5ea6:{}", new Object[]{reportDataId, detailInfo.getId(), mergedDetailInfo.getApprovedAmt(), beforeApprovedAmt, approvedAmt});
        }
        return new ArrayList<ApprovedAmountAmtDetailInfo>(downDetailInfoMap.values());
    }

    private List<Long> getDirectorDownLevelSumOrg(List<SumPlanParamConfigInfo> children, List<Long> subSumOrgIdList) {
        if (EmptyUtil.isEmpty(children)) {
            return subSumOrgIdList;
        }
        for (SumPlanParamConfigInfo info : children) {
            if (info.isSumAuditNode()) {
                subSumOrgIdList.add(info.getOrgMemberId());
                continue;
            }
            List<SumPlanParamConfigInfo> subChildren = info.getChildren();
            this.getDirectorDownLevelSumOrg(subChildren, subSumOrgIdList);
        }
        return subSumOrgIdList;
    }

    private List<WaitApprovedAmountAmtInfoResultDTO> dealMainMapMoreChild(List<WaitApprovedAmountAmtInfoResultDTO> list, ReportTemplate sumReportTemplate, Map<String, List<ReportData>> uniqueSubReportDataMap) {
        ArrayList<WaitApprovedAmountAmtInfoResultDTO> finalList = new ArrayList<WaitApprovedAmountAmtInfoResultDTO>(list.size() + 10);
        for (WaitApprovedAmountAmtInfoResultDTO resultDTO : list) {
            ReportData reportData = resultDTO.getReportData();
            EvalDimensionCombination evalDimensionCombinationByReportData = EvalDimensionCombination.getEvalDimensionCombinationByReportData(reportData, sumReportTemplate);
            String uniqueKey = evalDimensionCombinationByReportData.getUniqueKey();
            List<ReportData> subReportDataList = uniqueSubReportDataMap.get(uniqueKey);
            if (EmptyUtil.isEmpty(subReportDataList) || subReportDataList.size() == 1) {
                finalList.add(resultDTO);
                continue;
            }
            for (ReportData subRd : subReportDataList) {
                WaitApprovedAmountAmtInfoResultDTO copy = resultDTO.copy();
                copy.setReportData(subRd);
                copy.setEvaluateAmt(subRd.getOriginalPlanAmt());
                finalList.add(copy);
            }
        }
        return finalList;
    }

    private void updateUnderlyingReportDataNew(ApprovedAmountRecord approvedAmountRecord) {
        ReportCalculate reportCalculate = new ReportCalculate(approvedAmountRecord);
        reportCalculate.calculateAndSave();
    }

    private void convertApprovalAmt(ApprovedAmountRecord approvedAmountRecord) {
        List<ApprovedAmountAmtInfo> amountAmtInfoList = approvedAmountRecord.getAmountAmtInfoList();
        if (EmptyUtil.isEmpty(amountAmtInfoList)) {
            return;
        }
        Map<Long, AmountUnit> reportAmountMap = this.getReportAmountMap(amountAmtInfoList);
        for (ApprovedAmountAmtInfo approvedAmountAmtInfo : amountAmtInfoList) {
            List<ApprovedAmountAmtDetailInfo> amtDetailInfoList = approvedAmountAmtInfo.getAmtDetailInfoList();
            for (ApprovedAmountAmtDetailInfo amtDetailInfo : amtDetailInfoList) {
                Long reportId = amtDetailInfo.getReportId();
                AmountUnit amountUnit = reportAmountMap.get(reportId);
                if (amountUnit == null) {
                    throw new KDBizException("reportId :" + reportId + " amountUnit is null");
                }
                BigDecimal approvedAmt = amtDetailInfo.getApprovedAmt();
                approvedAmt = AmountUtil.convert((AmountUnitEnum)AmountUnit.convert(AmountUnit.ONE), (AmountUnitEnum)AmountUnit.convert(amountUnit), (BigDecimal)approvedAmt);
                amtDetailInfo.setApprovedAmt(approvedAmt);
                amtDetailInfo.setOriginalApprovedAmt(AmountUtil.convert((AmountUnitEnum)AmountUnit.convert(AmountUnit.ONE), (AmountUnitEnum)AmountUnit.convert(amountUnit), (BigDecimal)amtDetailInfo.getOriginalApprovedAmt()));
            }
        }
    }

    private Map<Long, AmountUnit> getReportAmountMap(List<ApprovedAmountAmtInfo> amountAmtInfoList) {
        Set reportDataIds = amountAmtInfoList.stream().map(ApprovedAmountAmtInfo::getAmtDetailInfoList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.groupingBy(ApprovedAmountAmtDetailInfo::getReportId)).values().stream().filter(EmptyUtil::isNoEmpty).map(list -> ((ApprovedAmountAmtDetailInfo)list.get(0)).getReportDataId()).collect(Collectors.toSet());
        String placeHolder = reportDataIds.stream().map(id -> "?").collect(Collectors.joining(","));
        Object[] params = reportDataIds.toArray();
        return (Map)DB.query((DBRoute)DBRouteConst.TMC, (String)("select fid,famountunit from t_fpm_reportdatamain where fentryid in ( " + placeHolder + ")"), (Object[])params, resultSet -> {
            HashMap<Long, AmountUnit> reportAmountUnitMap = new HashMap<Long, AmountUnit>(16);
            while (resultSet.next()) {
                long reportId = resultSet.getLong("fid");
                String amountUnitStr = resultSet.getString("famountunit");
                reportAmountUnitMap.put(reportId, AmountUnit.getByNumber(amountUnitStr));
            }
            return reportAmountUnitMap;
        });
    }

    @Override
    public List<MainSubReport> groupMainSubReport(List<Report> reportList, ApprovedAmountRecord approvedAmountRecord) {
        MainSubReport mainSubReport;
        Map<Boolean, List<Report>> groupMainSubReportMap = reportList.stream().collect(Collectors.groupingBy(r -> r.getTemplate().isMainTable()));
        List subReportList = groupMainSubReportMap.getOrDefault(Boolean.FALSE, Collections.emptyList());
        List mainReportList = groupMainSubReportMap.getOrDefault(Boolean.TRUE, Collections.emptyList());
        Map<Long, List<Report>> groupBySubTemReportMap = subReportList.stream().collect(Collectors.groupingBy(r -> r.getTemplate().getId()));
        ArrayList<MainSubReport> mainSubReportList = new ArrayList<MainSubReport>(8);
        for (Report mainReport : mainReportList) {
            ReportTemplate mainTemplate = mainReport.getTemplate();
            List<OrgMember> mainReportOrgList = mainReport.getCompanyMemberList();
            List<TemplateAccountSetting> accountSettings = mainTemplate.getAccountSettings();
            Set childTemplateIds = accountSettings.stream().filter(as -> as.getInputType() == ReportInputType.DETAIL_INPUT && EmptyUtil.isNoEmpty((Long)as.getChildTemplateId())).map(TemplateAccountSetting::getChildTemplateId).collect(Collectors.toSet());
            mainSubReport = new MainSubReport(mainReport);
            for (Long childTemplateId : childTemplateIds) {
                if (!groupBySubTemReportMap.containsKey(childTemplateId)) continue;
                List<Report> subReports = groupBySubTemReportMap.get(childTemplateId);
                Iterator<Report> iterator = subReports.iterator();
                while (iterator.hasNext()) {
                    Report next = iterator.next();
                    List<OrgMember> subReportOrgList = next.getCompanyMemberList();
                    if (!EmptyUtil.isNoEmpty(mainReportOrgList) || !EmptyUtil.isNoEmpty(subReportOrgList) || !Objects.equals(mainReportOrgList.get(0).getId(), subReportOrgList.get(0).getId())) continue;
                    mainSubReport.addChildReport(next);
                    iterator.remove();
                    subReportList.remove(next);
                }
                if (!EmptyUtil.isEmpty(subReports)) continue;
                groupBySubTemReportMap.remove(childTemplateId);
            }
            mainSubReportList.add(mainSubReport);
        }
        if (EmptyUtil.isEmpty(subReportList)) {
            return mainSubReportList;
        }
        HashMap<ReportKey, MainSubReport> mainSubReportMap = new HashMap<ReportKey, MainSubReport>(16);
        for (Report subReport : subReportList) {
            List<OrgMember> companyMemberList = subReport.getCompanyMemberList();
            if (EmptyUtil.isEmpty(companyMemberList)) continue;
            Long orgId = companyMemberList.get(0).getId();
            ReportKey reportKey = new ReportKey(orgId, approvedAmountRecord.getOrgReportPeriod(), subReport.getParentTemplateId());
            mainSubReport = mainSubReportMap.computeIfAbsent(reportKey, k -> new MainSubReport(this.reportRepository.queryParentReport(reportKey.getOrgId(), reportKey.getPeriodId(), reportKey.getTemplateId())));
            if (Objects.isNull(mainSubReport.getMainReport())) {
                mainSubReportMap.remove(reportKey);
                continue;
            }
            mainSubReport.addChildReport(subReport);
        }
        mainSubReportList.addAll(mainSubReportMap.values());
        return mainSubReportList;
    }

    private void transferApprovedAmtUnitBeforeSave(ApprovedAmountRecord approvedAmountRecord, AmountUnit saveAmtUnit) {
        List<ApprovedAmountAmtInfo> amountAmtInfoList = approvedAmountRecord.getAmountAmtInfoList();
        if (EmptyUtil.isEmpty(amountAmtInfoList)) {
            return;
        }
        if (!Objects.equals((Object)approvedAmountRecord.getAmountUnit(), (Object)saveAmtUnit)) {
            AmountUnitEnum sourceAmtUnit = AmountUnit.convert(approvedAmountRecord.getAmountUnit());
            AmountUnitEnum targetAmtUnit = AmountUnit.convert(saveAmtUnit);
            amountAmtInfoList.forEach(amountAmtInfo -> {
                BigDecimal approvedAmt = amountAmtInfo.getApprovedAmt();
                approvedAmt = AmountUtil.convert((AmountUnitEnum)sourceAmtUnit, (AmountUnitEnum)targetAmtUnit, (BigDecimal)approvedAmt);
                amountAmtInfo.setApprovedAmt(approvedAmt);
            });
            approvedAmountRecord.setAmountUnit(saveAmtUnit);
        }
    }

    private static void checkApprovedDetailAmtRoundBeforeSave(List<ReportData> reportDataList, FundPlanSystem fundPlanSystem) {
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        String errorMsg = ResManager.loadKDString((String)"\u7f16\u5236\u6570\u636eid\uff1a\u3010%1$s\u3011\uff0c\u7ef4\u5ea6\u7ec4\u5408\u3010%2$s\u3011\u586b\u62a5\u7684\u6838\u5b9a\u989d\u5ea6\u3010%3$s %4$s\u3011\u8d85\u51fa\u6700\u5927\u6570\u503c\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002\n", (String)"EvaluateAmtBizServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]);
        for (ReportData data : reportDataList) {
            if (ReportHelper.checkAmtRound(data.getOriginalPlanAmt())) continue;
            throw new KDBizException(String.format(errorMsg, data.getId(), LogFormatUtil.formatReportData(data, fundPlanSystem), data.getOriginalPlanAmt(), data.getAmountUnit().name()));
        }
    }

    private FpmOperateResult checkApprovedRecordAmtRoundBeforeSave(ApprovedAmountRecord approvedAmountRecord) {
        List<ApprovedAmountAmtInfo> amountAmtInfoList = approvedAmountRecord.getAmountAmtInfoList();
        if (!EmptyUtil.isEmpty(amountAmtInfoList)) {
            AmountUnit saveAmtUnit = approvedAmountRecord.getAmountUnit();
            List<String> errorMsgList = amountAmtInfoList.stream().map(amountAmtInfo -> this.checkAmtRoundBeforeSave(amountAmtInfo.getApprovedAmt(), saveAmtUnit)).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (!EmptyUtil.isEmpty(errorMsgList)) {
                return FpmOperateResult.error(errorMsgList);
            }
        }
        return FpmOperateResult.success();
    }

    private String checkAmtRoundBeforeSave(BigDecimal amt, AmountUnit amountUnit) {
        if (amt != null) {
            String errorMsg = ResManager.loadKDString((String)"\u586b\u62a5\u7684\u6838\u5b9a\u989d\u5ea6\u3010%1$s %2$s\u3011\u8d85\u51fa\u6700\u5927\u6570\u503c\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002\n", (String)"EvaluateAmtBizServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]);
            if (!ReportHelper.checkAmtRound(amt)) {
                return String.format(errorMsg, amt, amountUnit != null ? amountUnit.getName() : "");
            }
        }
        return "";
    }

    static class ReportCalculate {
        private final EvaluateAmtBizServiceImpl evaluateAmtBizService;
        private final IDimensionRepository dimensionRepository = new DimensionRepository();
        private final ReportDataQueryService reportDataQueryService = new ReportDataQueryService();
        private final IDataSaveService dataSaveService = new SyncShrekReportDataSaveServiceImpl(new DataSaveServiceImpl());
        private final ApprovedAmountRecord approvedAmountRecord;
        private final FundPlanSystem fundPlanSystem;
        private boolean calculate;
        private final Map<Long, ApprovedAmountAmtDetailInfo> detailInfoMap;
        private final List<ReportData> reportDataList;
        private final Map<Long, Report> reportMap;
        private final Map<Long, PeriodMember> period2ParentPeriodMemberMap;

        public ReportCalculate(ApprovedAmountRecord approvedAmountRecord) {
            this.evaluateAmtBizService = new EvaluateAmtBizServiceImpl();
            this.approvedAmountRecord = approvedAmountRecord;
            this.fundPlanSystem = this.dimensionRepository.loadSystem(approvedAmountRecord.getSystemId());
            this.detailInfoMap = new HashMap<Long, ApprovedAmountAmtDetailInfo>(16);
            this.reportDataList = new ArrayList<ReportData>(16);
            this.reportMap = new HashMap<Long, Report>(16);
            this.period2ParentPeriodMemberMap = new HashMap<Long, PeriodMember>(16);
            this.init();
        }

        public void calculateAndSave() {
            List<ReportData> reportDataList;
            Map<Long, List<ReportData>> allMainReportMap;
            List<ReportData> relateReportDataListBySource;
            if (!this.calculate) {
                return;
            }
            Map<Boolean, Map<Long, List<ReportData>>> mainChildGroupReportMap = this.reportDataList.stream().collect(Collectors.groupingBy(ReportData::isMainTable, Collectors.mapping(Function.identity(), Collectors.groupingBy(ReportData::getReportId))));
            List<ReportData> allChildReportDataList = this.reportDataList.stream().filter(rd -> !rd.isMainTable()).collect(Collectors.toList());
            Map<Long, List<ReportData>> childReportMap = mainChildGroupReportMap.get(Boolean.FALSE);
            Map<Long, Report> childMainReportMap = this.getChildMainReportMap(new ArrayList<Report>(this.reportMap.values()));
            HashMap<Long, Report> waitUpdateMainReportMap = new HashMap<Long, Report>(16);
            if (MapUtils.isNotEmpty(childReportMap)) {
                RelateReportDataManager relateReportDataManager = new RelateReportDataManager();
                relateReportDataManager.setCalculateRollData(true);
                relateReportDataManager.buildManager(allChildReportDataList, null);
                for (Map.Entry<Long, List<ReportData>> entry : childReportMap.entrySet()) {
                    Long childReportId = entry.getKey();
                    List<ReportData> childReportDataList = entry.getValue();
                    Report currentChildReport = this.reportMap.get(childReportId);
                    List<ReportData> updateReportDataList = new ArrayList<ReportData>(childReportDataList);
                    if (!currentChildReport.getTemplate().getTemplateType().isDetail()) {
                        relateReportDataListBySource = relateReportDataManager.getRelateReportDataListBySource(childReportDataList);
                        relateReportDataListBySource.addAll(childReportDataList);
                        updateReportDataList = relateReportDataManager.reCalculateRelateDataByDAGAndCompletionIndex(relateReportDataListBySource);
                        updateReportDataList.addAll(childReportDataList);
                        updateReportDataList = CommonUtils.getDistinctList(updateReportDataList, ReportData::getId);
                    }
                    EvaluateAmtBizServiceImpl.checkApprovedDetailAmtRoundBeforeSave(updateReportDataList, this.fundPlanSystem);
                    this.dataSaveService.updateBySqlInfo(() -> "update t_fpm_reportdatamain set forgplanamt=? where fentryid=?", updateReportDataList, (t, d) -> {
                        d.add(t.getOriginalPlanAmt());
                        d.add(t.getId());
                    });
                    Report childReport = this.evaluateAmtBizService.reportRepository.loadReport(childReportId);
                    Report mainReport = childMainReportMap.get(childReportId);
                    this.evaluateAmtBizService.reportService.sumToParent(mainReport, childReport, this.fundPlanSystem);
                    this.cleanMainReportData(mainReport);
                    waitUpdateMainReportMap.put(mainReport.getId(), mainReport);
                }
            }
            if (MapUtils.isNotEmpty(allMainReportMap = mainChildGroupReportMap.get(Boolean.TRUE))) {
                for (Map.Entry<Long, List<ReportData>> entry : allMainReportMap.entrySet()) {
                    Long mainReportId = entry.getKey();
                    List<ReportData> mainReportDataList = entry.getValue();
                    Report mainReport = waitUpdateMainReportMap.computeIfAbsent(mainReportId, k -> this.reportMap.get(mainReportId));
                    List<ReportData> reportDataList2 = mainReport.getReportDataList();
                    if (reportDataList2 == null) {
                        reportDataList2 = new ArrayList<ReportData>(16);
                        mainReport.setReportDataList(reportDataList2);
                    }
                    reportDataList2.addAll(mainReportDataList);
                }
            }
            if (EmptyUtil.isEmpty(reportDataList = waitUpdateMainReportMap.values().stream().map(Report::getReportDataList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()))) {
                return;
            }
            RelateReportDataManager mainTableReportRelateManager = new RelateReportDataManager();
            mainTableReportRelateManager.setCalculateRollData(true);
            mainTableReportRelateManager.buildManager(reportDataList, null);
            for (Report mainReport : waitUpdateMainReportMap.values()) {
                List<ReportData> mainReportDataList = mainReport.getReportDataList();
                if (EmptyUtil.isEmpty(mainReportDataList)) continue;
                List currentMainReportDataList = reportDataList.stream().map(rd -> {
                    ReportData reportData = new ReportData((ReportData)rd);
                    reportData.setId(rd.getId());
                    return reportData;
                }).collect(Collectors.toList());
                relateReportDataListBySource = mainTableReportRelateManager.getRelateReportDataListBySource(mainReportDataList);
                relateReportDataListBySource.addAll(mainReportDataList);
                List<ReportData> updateReportDataList = mainTableReportRelateManager.reCalculateRelateDataByDAGAndCompletionIndex(relateReportDataListBySource);
                updateReportDataList.addAll(currentMainReportDataList);
                updateReportDataList = CommonUtils.getDistinctList(updateReportDataList, ReportData::getId);
                EvaluateAmtBizServiceImpl.checkApprovedDetailAmtRoundBeforeSave(updateReportDataList, this.fundPlanSystem);
                this.dataSaveService.updateBySqlInfo(() -> "update t_fpm_reportdatamain set forgplanamt=? where fentryid=?", updateReportDataList, (t, d) -> {
                    d.add(t.getOriginalPlanAmt());
                    d.add(t.getId());
                });
            }
        }

        private void cleanMainReportData(Report mainReport) {
            List<ReportData> mainReportDataList = mainReport.getReportDataList();
            if (EmptyUtil.isEmpty(mainReportDataList)) {
                return;
            }
            ReportTemplate template = mainReport.getTemplate();
            Set mainNotDetailInputSubjects = template.getAccountSettings().stream().filter(templateAccountSetting -> templateAccountSetting.getInputType() != ReportInputType.DETAIL_INPUT).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
            mainReportDataList.removeIf(rd -> mainNotDetailInputSubjects.contains((Long)rd.getDimValByDimType(DimensionType.SUBJECTS)));
            QueryIndexInfo queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(this.reportDataList, this.fundPlanSystem);
            mainReportDataList.removeIf(rd -> queryIndexInfo.findOne(DimensionInfoHelper.getDimensionInfoBean(rd)) == null);
        }

        private Map<Long, Report> getChildMainReportMap(List<Report> reportList) {
            List<MainSubReport> mainSubReports = this.evaluateAmtBizService.groupMainSubReport(reportList, this.approvedAmountRecord);
            HashMap<Long, Report> childMainReportMap = new HashMap<Long, Report>(16);
            for (MainSubReport mainSubReport : mainSubReports) {
                List<Report> childReports = mainSubReport.getChildReports();
                if (EmptyUtil.isEmpty(childReports)) continue;
                for (Report childReport : childReports) {
                    childMainReportMap.put(childReport.getId(), mainSubReport.getMainReport());
                }
            }
            return childMainReportMap;
        }

        private void init() {
            List<ApprovedAmountAmtInfo> amountAmtInfoList = this.approvedAmountRecord.getAmountAmtInfoList();
            if (EmptyUtil.isEmpty(amountAmtInfoList)) {
                return;
            }
            amountAmtInfoList.stream().map(ApprovedAmountAmtInfo::getAmtDetailInfoList).filter(t -> !CollectionUtils.isEmpty((Collection)t)).flatMap(Collection::stream).filter(ApprovedAmountAmtDetailInfo::isUpdate).forEach(t -> this.detailInfoMap.put(t.getReportDataId(), (ApprovedAmountAmtDetailInfo)t));
            if (MapUtils.isEmpty(this.detailInfoMap)) {
                return;
            }
            this.calculate = true;
            List reportDataQueryResults = this.evaluateAmtBizService.getReportDataQueryResults(new ArrayList<Long>(this.detailInfoMap.keySet()));
            this.reportDataList.addAll(reportDataQueryResults);
            Set reportIds = this.reportDataList.stream().map(ReportData::getReportId).collect(Collectors.toSet());
            List reportList = this.evaluateAmtBizService.getReport(reportIds, (Consumer<ReportNeedPropDTO>)r -> {
                r.setNeedTemplate(true);
                r.setNeedReportPeriodType(true);
                r.setNeedPeriodMember(true);
                r.setNeedCompanyMember(true);
            });
            reportList.forEach(report -> this.reportMap.put(report.getId(), (Report)report));
            reportList.stream().map(ReportUtils::getPeriodMemberIdReportPeriodMap).forEach(this.period2ParentPeriodMemberMap::putAll);
            this.queryParentReportData();
        }

        private void queryParentReportData() {
            DimValueListInfo dimValueListInfo = new DimValueListInfo();
            Dimension periodDim = this.fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
            Map dimensionMap = this.fundPlanSystem.getMainDimList().stream().collect(Collectors.toMap(Dimension::getId, Function.identity(), (a, b) -> a));
            for (ReportData reportData : this.reportDataList) {
                Long periodMemberId = (Long)reportData.getDimValByDimType(DimensionType.PERIOD);
                PeriodMember periodMember = this.period2ParentPeriodMemberMap.get(periodMemberId);
                if (Objects.isNull(periodMember)) {
                    LOGGER.warn("\u671f\u95f4id\uff1a{}\u7684\u7ef4\u5ea6\u6210\u5458\u5df2\u5220\u9664\uff0c\u6216\u8005\u5b83\u7684\u4e0a\u7ea7\u671f\u95f4\u6210\u5458\u5df2\u5220\u9664\u3002", (Object)periodMemberId);
                    continue;
                }
                Long parentPeriodId = periodMember.getId();
                if (Objects.equals(parentPeriodId, periodMemberId)) continue;
                List<TemplateDim> dimList = reportData.getDimList();
                List<Object> dataDimValList = reportData.getDimValList();
                for (int i = 0; i < dimList.size(); ++i) {
                    TemplateDim templateDim = dimList.get(i);
                    DimensionType dimType = templateDim.getDimType();
                    if (dimType.isDetailDim()) continue;
                    Dimension dimension = (Dimension)dimensionMap.get(templateDim.getDimensionId());
                    if (dimension == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u4f53\u7cfb\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6", (String)"ReportDataQueryService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    }
                    if (dimType.isPeriodDim()) {
                        dimValueListInfo.addDimensionValue(periodDim, parentPeriodId);
                        continue;
                    }
                    if (dimType.isSystemDim()) {
                        dimValueListInfo.addDimensionValue(dimension, dataDimValList.get(i));
                        continue;
                    }
                    dataDimValList.add(dataDimValList.get(0));
                    dataDimValList.add(0L);
                }
            }
            if (dimValueListInfo.isEmpty()) {
                this.updateApprovalReportData(periodDim, Collections.emptyList());
                return;
            }
            List<ReportData> reportDataListForParentPeriod = this.reportDataQueryService.queryReportDataForAllSystem(t -> {
                t.setDimIdList(dimValueListInfo.getDimensionList());
                t.setDimValList(dimValueListInfo.getDimValueList());
                t.setNeedDimIfValueIsNotEmpty(true);
                t.setReportIdS(new ArrayList<Long>(this.reportMap.keySet()));
                t.setReportPlanType(ReportPlanType.REPORTPLAN);
            });
            this.updateApprovalReportData(periodDim, reportDataListForParentPeriod);
        }

        private void updateApprovalReportData(Dimension periodDim, List<ReportData> reportDataListForParentPeriod) {
            QueryIndexInfo<Long, ReportData> queryIndexInfo = EmptyUtil.isEmpty(reportDataListForParentPeriod) ? QueryIndexInfo.buildEmptyIndexInfo(16) : QueryIndexInfoMapGenerator.buildReportDataIndex(reportDataListForParentPeriod, this.fundPlanSystem);
            HashMap<Long, ReportData> parentReportDataMap = new HashMap<Long, ReportData>(16);
            for (ReportData reportData : this.reportDataList) {
                BigDecimal diffAmt;
                ApprovedAmountAmtDetailInfo detailInfo = this.detailInfoMap.get(reportData.getId());
                if (detailInfo == null || NumberUtils.equalsZero((BigDecimal)(diffAmt = CommonUtils.getBigDecimalValue(detailInfo.getApprovedAmt()).subtract(detailInfo.getDataBaseApproveAmt())))) continue;
                reportData.addOriginalPlanAmt(diffAmt);
                Long periodMemberId = (Long)reportData.getDimValByDimensionId(periodDim.getId());
                PeriodMember parentPeriodMember = this.period2ParentPeriodMemberMap.get(periodMemberId);
                if (Objects.isNull(parentPeriodMember)) {
                    LOGGER.warn("\u671f\u95f4id\uff1a{}\u7684\u7ef4\u5ea6\u6210\u5458\u5df2\u5220\u9664\uff0c\u6216\u8005\u5b83\u7684\u4e0a\u7ea7\u671f\u95f4\u6210\u5458\u5df2\u5220\u9664\u3002", (Object)periodMemberId);
                    continue;
                }
                Long parentPeriodMemberId = parentPeriodMember.getId();
                DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
                Object oldValue = dimensionInfoBean.replaceValueIfContains(periodDim.getId(), (Object)parentPeriodMemberId);
                if (Objects.equals(oldValue, parentPeriodMemberId)) continue;
                ReportData reportDataForDimInfo = this.getReportDataForDimInfo(queryIndexInfo, dimensionInfoBean, reportData.getReportId());
                if (reportDataForDimInfo == null) {
                    LOGGER.warn("\u7f16\u5236\u6570\u636eid:{}\uff0c\u7ef4\u5ea6\u7ec4\u5408\uff1a{}\uff0c\u4e0a\u7ea7\u671f\u95f4id:{}\uff0c\u5bf9\u5e94\u7684\u7f16\u5236\u6570\u636e\u4e3a\u7a7a\u3002", new Object[]{reportData.getId(), dimensionInfoBean, parentPeriodMemberId});
                    continue;
                }
                reportDataForDimInfo.addOriginalPlanAmt(diffAmt);
                parentReportDataMap.putIfAbsent(reportDataForDimInfo.getId(), reportDataForDimInfo);
            }
            if (MapUtils.isEmpty(parentReportDataMap)) {
                return;
            }
            this.reportDataList.addAll(parentReportDataMap.values());
        }

        private ReportData getReportDataForDimInfo(QueryIndexInfo<Long, ReportData> queryIndexInfo, DimensionInfoBean dimensionInfoBean, Long reportId) {
            List<ReportData> list = queryIndexInfo.findList(dimensionInfoBean);
            if (EmptyUtil.isEmpty(list)) {
                return null;
            }
            if ((list = list.stream().filter(rd -> Objects.equals(rd.getReportId(), reportId)).collect(Collectors.toList())).size() > 1) {
                LOGGER.warn("\u7ef4\u5ea6\u7ec4\u5408\uff1a{}\u6709\u591a\u6761\u6570\u636e", (Object)dimensionInfoBean);
            }
            return list.get(0);
        }
    }
}

