/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.business.cache.data.CellDataSource;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.execbiasanalys.ExecBiasAnalys;
import kd.tmc.fpm.business.domain.model.report.MetricHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportDataWrapper;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.IExecBiasAnalysBizService;
import kd.tmc.fpm.business.mvc.service.IExecBiasAnalysisManageService;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.impl.ExecBiasAnalysBizServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.ReportManageService;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanBizServiceImpl;
import kd.tmc.fpm.business.mvc.service.impl.SumPlanManageServiceImpl;
import kd.tmc.fpm.business.spread.datamanager.CellDataUpdateInfo;
import kd.tmc.fpm.business.spread.datamanager.IReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactoryV2;
import kd.tmc.fpm.business.spread.datamanager.impl.ReportDataManagerV2;
import kd.tmc.fpm.business.spread.datamanager.impl.SpreadAuxiliaryDataReceiver;
import kd.tmc.fpm.business.spread.generator.executor.IReportDataProcessExecutor;
import kd.tmc.fpm.business.spread.generator.executor.ReportDataProcessExecutorFactory;
import kd.tmc.fpm.business.utils.MutexAuxiliarySaveHelper;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.spread.widget.core.Cell;

public class ExecBiasAnalysisManageServiceImpl
implements IExecBiasAnalysisManageService {
    private static Log logger = LogFactory.getLog(ExecBiasAnalysisManageServiceImpl.class);
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private IExecBiasAnalysBizService execBiasAnalysisBizService = new ExecBiasAnalysBizServiceImpl();
    private ISumPlanBizService sumPlanBizService = new SumPlanBizServiceImpl();
    private IDimensionRepository dimRepo = new DimensionRepository();

    @Override
    public FpmOperateResult<IReportDataManagerV2> save(IReportDataManagerV2 dataManager, CellDataSource dataSource, Long id) {
        FpmOperateResult<ExecBiasAnalys> execBiasAnalysOperateResult = this.execBiasAnalysisBizService.load(id);
        ExecBiasAnalys oldExecBiasAnalys = execBiasAnalysOperateResult.getData();
        Report report = EmptyUtil.isEmpty((Object)oldExecBiasAnalys.getReport()) ? (Report)oldExecBiasAnalys.getSumPlanReportList().get(0) : oldExecBiasAnalys.getReport();
        ArrayList<ReportDataWrapper> reportDataWrapperList = new ArrayList<ReportDataWrapper>(16);
        if (report.getReportPlanType() == ReportPlanType.SUMPLAN) {
            dataManager.reverseDataToReportDataReceiver(dataSource, new SpreadAuxiliaryDataReceiver(report, reportDataWrapperList));
            MutexAuxiliarySaveHelper.MutexAuxiliarySaveInfo saveInfo = new MutexAuxiliarySaveHelper.MutexAuxiliarySaveInfo(oldExecBiasAnalys.getSourcebill(), report, MutexAuxiliarySaveHelper.InputType.EXEC_BIAS_SUM_PLAN);
            MutexAuxiliarySaveHelper.getInstance(saveInfo).saveOrUpdateAuxiliaryReportDataForFix(reportDataWrapperList);
            return FpmOperateResult.success(dataManager);
        }
        dataManager.reverseDataToReportDataReceiver(dataSource, new SpreadAuxiliaryDataReceiver(report, reportDataWrapperList));
        MutexAuxiliarySaveHelper.MutexAuxiliarySaveInfo saveInfo = new MutexAuxiliarySaveHelper.MutexAuxiliarySaveInfo(oldExecBiasAnalys.getSourcebill(), report, MutexAuxiliarySaveHelper.InputType.EXEC_BIAS_REPORT);
        MutexAuxiliarySaveHelper.getInstance(saveInfo).saveOrUpdateAuxiliaryReportDataForFix(reportDataWrapperList);
        return FpmOperateResult.success(dataManager);
    }

    @Override
    public FpmOperateResult<Void> closeExecBiasAnalysReport(IReportDataManagerV2 manager) {
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> loadReport(Long reportId, Long systemId, IFpmPageCacheService cacheService) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(ReportManageService.class.getSimpleName());){
            span.addTag("Loading system");
            FundPlanSystem system = this.dimensionRepository.loadSystem(systemId);
            span.addTag("loadReport");
            FpmOperateResult<Report> reportFpmOperateResult = this.execBiasAnalysisBizService.loadReport(reportId, system, null);
            if (!reportFpmOperateResult.isSuccess()) {
                FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.error(reportFpmOperateResult.getMessageList());
                return fpmOperateResult;
            }
            Report report = reportFpmOperateResult.getData();
            report.getTemplate().setTotalSumVisible(false);
            span.addTag("Loading manager");
            ReportDataManagerV2 manager = ReportDataManagerFactoryV2.getExecBiasAnalysisDataManager(system, report, cacheService);
            FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.success(manager);
            return fpmOperateResult;
        }
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> loadReport(Long reportId, IFpmPageCacheService cacheService, MetricHeader metricHeader) {
        FpmOperateResult<Report> reportFpmOperateResult = this.execBiasAnalysisBizService.loadReport(reportId, metricHeader);
        if (!reportFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
        }
        Report report = reportFpmOperateResult.getData();
        FundPlanSystem system = this.dimensionRepository.loadSystem(report.getSystemId());
        ReportTemplate template = report.getTemplate();
        template.setTotalSumVisible(false);
        ReportDataManagerV2 manager = ReportDataManagerFactoryV2.getExecBiasAnalysisDataManager(system, report, cacheService);
        return FpmOperateResult.success(manager);
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> loadSumReport(Long id, Long systemId, SumPlanHeader sumPlanHeader, IFpmPageCacheService cacheService) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanManageServiceImpl.class.getSimpleName());){
            span.addTag("load sumPlanReport step1: load system");
            FundPlanSystem system = this.dimRepo.loadSystem(systemId);
            span.addTag("load sumPlanReport step2: load SumPlanRecord");
            FpmOperateResult<SumPlanRecord> result = this.execBiasAnalysisBizService.loadSumReport(id, system, sumPlanHeader);
            if (!result.isSuccess()) {
                FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.error(result.getMessageList());
                return fpmOperateResult;
            }
            SumPlanReport sumPlanReport = result.getData().getSumPlanReportList().get(0);
            sumPlanReport.getTemplate().setTotalSumVisible(false);
            span.addTag("load sumPlanReport step2: convert ReportModel");
            ReportDataManagerV2 manager = ReportDataManagerFactoryV2.getExecBiasAnalysisSumPlanDataManager(system, sumPlanReport, sumPlanHeader == null ? null : sumPlanHeader.getPageDimMemberIds(), cacheService);
            FpmOperateResult<IReportDataManagerV2> fpmOperateResult = FpmOperateResult.success(manager);
            return fpmOperateResult;
        }
    }

    @Override
    public FpmOperateResult<List<Cell>> updateReportData(IReportDataManagerV2 dataManager, CellDataSource cellDataSource, List<CellDataUpdateInfo> updateInfoList) {
        dataManager.updateCellData(updateInfoList, cellDataSource);
        return FpmOperateResult.success(dataManager.getNeedUpdateValList());
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> submit(IReportDataManagerV2 manager, CellDataSource dataSource, Long id) {
        return this.save(manager, dataSource, id);
    }

    @Override
    public FpmOperateResult<IReportDataManagerV2> delete(IReportDataManagerV2 dataManager, CellDataSource dataSource, Long id) {
        FpmOperateResult<ExecBiasAnalys> execBiasAnalysOperateResult = this.execBiasAnalysisBizService.load(id);
        ExecBiasAnalys oldExecBiasAnalys = execBiasAnalysOperateResult.getData();
        Report report = EmptyUtil.isEmpty((Object)oldExecBiasAnalys.getReport()) ? (Report)oldExecBiasAnalys.getSumPlanReportList().get(0) : oldExecBiasAnalys.getReport();
        this.execBiasAnalysisBizService.delete(report);
        return FpmOperateResult.success(dataManager);
    }

    @Override
    public FpmOperateResult<ReportCalcModel> loadReportCalcModelByMetricHeader(IReportDataManagerV2 manager, List<Long> pageDimS, CellDataSource dataSource, MetricHeader metricHeader) {
        FundPlanSystem system = manager.getSystem();
        Long reportId = manager.getReportId();
        FpmOperateResult<Report> reportFpmOperateResult = this.execBiasAnalysisBizService.loadReport(reportId, system, metricHeader);
        if (!reportFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
        }
        Report report = reportFpmOperateResult.getData();
        report.getTemplate().setTotalSumVisible(false);
        IReportDataProcessExecutor reportExecutor = ReportDataProcessExecutorFactory.getExecBiasAnalysisExecutor(system, report, EmptyUtil.isEmpty(pageDimS) ? null : pageDimS);
        ReportModel reportModel = new ReportModel();
        reportExecutor.executeAction(reportModel);
        manager.setCurrCalcModel(reportModel.getReportCalcModelList().get(0));
        manager.updateFormulaManager();
        return FpmOperateResult.success(manager.getCurrCalcModel());
    }
}

