/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.IExecContrOpService;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.utils.AmountUtil;

public class ExecContrOpServiceImpl
implements IExecContrOpService {
    @Override
    public PlanExecuteRecord cancelRealAmtRecord(PlanExecuteRecord baseRecord, List<Tuple<BigDecimal, ReportData>> updateParams, List<PlanExecuteRecord> updateRecords, Map<Long, BigDecimal> sumFlagMap) {
        PlanExecuteRecord cancelRecord = baseRecord.clone();
        cancelRecord.setExecuteOpType(PlanExecuteOpType.CANCEL);
        updateRecords.add(cancelRecord);
        for (ReportData reportData : baseRecord.getMatchedReportDataList()) {
            BigDecimal originValue = BigDecimal.ZERO;
            originValue = sumFlagMap.containsKey(reportData.getId()) ? sumFlagMap.get(reportData.getId()) : reportData.getActAmt();
            BigDecimal cancelAmount = baseRecord.getActAmount();
            AmountUnit amountUnit = reportData.getAmountUnit();
            cancelAmount = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (BigDecimal)cancelAmount);
            cancelAmount = originValue.subtract(cancelAmount);
            sumFlagMap.put(reportData.getId(), cancelAmount);
            updateParams.add((Tuple<BigDecimal, ReportData>)Tuple.create((Object)cancelAmount, (Object)reportData));
        }
        return cancelRecord;
    }

    @Override
    public void deleteRecordAndUpdateAmt(PlanExecuteRecord executeRecord, List<Tuple<BigDecimal, ReportData>> updateParams, Map<Long, BigDecimal> sumFlagMap) {
        executeRecord.setDeleteStatus(true);
        for (ReportData reportData : executeRecord.getMatchedReportDataList()) {
            BigDecimal originValue = BigDecimal.ZERO;
            if (sumFlagMap.containsKey(reportData.getId())) {
                originValue = sumFlagMap.get(reportData.getId());
            } else {
                switch (executeRecord.getExecuteOpType()) {
                    case WRITE: 
                    case CANCEL: 
                    case RELEASE: {
                        originValue = reportData.getActAmt();
                        break;
                    }
                    case PRE_OCCUPY_WRITE: 
                    case PRE_OCCUPY_RELEASE: {
                        originValue = reportData.getLockAmt();
                    }
                }
            }
            BigDecimal bizAmount = executeRecord.getActAmount();
            if (executeRecord.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_RELEASE) {
                bizAmount = bizAmount.negate();
            }
            AmountUnit amountUnit = reportData.getAmountUnit();
            bizAmount = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (BigDecimal)bizAmount);
            switch (executeRecord.getExecuteOpType()) {
                case WRITE: 
                case RELEASE: 
                case PRE_OCCUPY_WRITE: {
                    bizAmount = originValue.subtract(bizAmount);
                    break;
                }
                case CANCEL: 
                case PRE_OCCUPY_RELEASE: {
                    bizAmount = originValue.add(bizAmount);
                }
            }
            sumFlagMap.put(reportData.getId(), bizAmount);
            updateParams.add((Tuple<BigDecimal, ReportData>)Tuple.create((Object)bizAmount, (Object)reportData));
        }
    }

    @Override
    public PlanExecuteRecord generateOccupyRecord(PlanExecuteRecord baseRecord) {
        PlanExecuteRecord occupyRecord = baseRecord.clone();
        occupyRecord.setExecuteOpType(PlanExecuteOpType.PRE_OCCUPY_WRITE);
        occupyRecord.setExecuteDate(new Date());
        occupyRecord.setExecuteStatus(PlanExecuteStatus.INITIALIZE);
        occupyRecord.setOriginalRecordId(baseRecord.getId());
        return occupyRecord;
    }

    @Override
    public PlanExecuteRecord genCancelPreOccupyRecord(PlanExecuteRecord baseRecord) {
        PlanExecuteRecord occupyRecord = baseRecord.clone();
        occupyRecord.setExecuteOpType(PlanExecuteOpType.PRE_OCCUPY_RELEASE);
        occupyRecord.setExecuteDate(new Date());
        occupyRecord.setExecuteStatus(PlanExecuteStatus.INITIALIZE);
        occupyRecord.setOriginalRecordId(baseRecord.getId());
        occupyRecord.setActAmount(baseRecord.getActAmount().negate());
        return occupyRecord;
    }

    @Override
    public PlanExecuteRecord releasePreOccRecord(PlanExecuteRecord baseRecord, List<Tuple<BigDecimal, ReportData>> updateParams, List<PlanExecuteRecord> updateRecords, Long relationId, BigDecimal realseAmt, Map<Long, BigDecimal> sumFlagMap) {
        PlanExecuteRecord releaseRecord = baseRecord.clone();
        releaseRecord.setExecuteOpType(PlanExecuteOpType.PRE_OCCUPY_RELEASE);
        releaseRecord.setActAmount(realseAmt == null ? baseRecord.getActAmount().negate() : realseAmt);
        releaseRecord.setOriginalRecordId(baseRecord.getId());
        releaseRecord.setRelateRecordId(relationId);
        updateRecords.add(releaseRecord);
        if (!CollectionUtils.isEmpty(baseRecord.getMatchedReportDataList())) {
            for (ReportData reportData : baseRecord.getMatchedReportDataList()) {
                BigDecimal originValue = BigDecimal.ZERO;
                originValue = sumFlagMap.containsKey(reportData.getId()) ? sumFlagMap.get(reportData.getId()) : reportData.getLockAmt();
                BigDecimal releaseAmount = realseAmt == null ? baseRecord.getActAmount().negate() : realseAmt;
                BigDecimal realAmt = releaseAmount.negate();
                AmountUnit amountUnit = reportData.getAmountUnit();
                realAmt = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (BigDecimal)realAmt);
                realAmt = originValue.subtract(realAmt);
                sumFlagMap.put(reportData.getId(), realAmt);
                updateParams.add((Tuple<BigDecimal, ReportData>)Tuple.create((Object)realAmt, (Object)reportData));
            }
        }
        return releaseRecord;
    }
}

