/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlPreTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.mvc.service.IExecuteTimeService;
import kd.tmc.fpm.business.mvc.service.impl.ControlBizService;
import org.apache.commons.collections.CollectionUtils;

public class ExecuteTimeServiceImpl
implements IExecuteTimeService {
    private static Log logger = LogFactory.getLog(ControlBizService.class);

    @Override
    public boolean hasConfig(ControlTime controlTime, String operatorCode, String billCode, PlanExecuteOpType planExecuteOpType) {
        if (Objects.isNull(operatorCode)) {
            logger.info("\u64cd\u4f5c\u4ee3\u7801\u4e3a\u7a7a");
            return false;
        }
        if (EmptyUtil.isEmpty((Object)controlTime)) {
            logger.info("\u6ca1\u6709\u6267\u884c\u65f6\u673a\u914d\u7f6e");
            return false;
        }
        Long systemId = controlTime.getSystemId();
        if (!controlTime.getEnable().booleanValue()) {
            logger.info("\u4f53\u7cfb:{}\u4e0b\u7684\u6267\u884c\u65f6\u673a\u4e3a\u7981\u7528\u72b6\u6001", (Object)controlTime.getSystemId());
            return false;
        }
        switch (planExecuteOpType) {
            case CANCEL: 
            case WRITE: 
            case RELEASE: 
            case UPDATE: {
                List<ControlActTime> controlActTimeList = controlTime.getControlActTimeList();
                if (CollectionUtils.isEmpty(controlActTimeList)) {
                    logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{}\u672a\u9884\u5360\u6267\u884c\u65f6\u673a\u914d\u7f6e", (Object)systemId, (Object)billCode);
                    return false;
                }
                return this.checkAclConfig(systemId, controlActTimeList, billCode, operatorCode, planExecuteOpType);
            }
            case PRE_OCCUPY_DELETE: 
            case PRE_OCCUPY_RELEASE: 
            case PRE_OCCUPY_WRITE: {
                List<ControlPreTime> controlPreTimeList = controlTime.getControlPreTimeList();
                if (CollectionUtils.isEmpty(controlPreTimeList)) {
                    logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{}\u672a\u5b9e\u5360\u6267\u884c\u65f6\u673a\u914d\u7f6e", (Object)systemId, (Object)billCode);
                    return false;
                }
                return this.checkPreConfig(systemId, controlPreTimeList, billCode, operatorCode, planExecuteOpType);
            }
        }
        return false;
    }

    private boolean checkAclConfig(Long systemId, List<ControlActTime> controlActTimeList, String billCode, String operatorCode, PlanExecuteOpType planExecuteOpType) {
        if (CollectionUtils.isEmpty(controlActTimeList)) {
            return false;
        }
        List actTimeList = controlActTimeList.stream().filter(controlActTime -> StringUtils.equals((CharSequence)billCode.trim(), (CharSequence)controlActTime.getBizBill().trim())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(actTimeList)) {
            return false;
        }
        operatorCode = operatorCode.split("-")[0];
        for (ControlActTime controlActTime2 : actTimeList) {
            switch (planExecuteOpType) {
                case CANCEL: {
                    List<String> cancelActTime = controlActTime2.getCancelActTime();
                    if (!CollectionUtils.isNotEmpty(cancelActTime) || !cancelActTime.contains(operatorCode)) break;
                    return true;
                }
                case WRITE: {
                    List<String> actTime = controlActTime2.getActTime();
                    if (!CollectionUtils.isNotEmpty(actTime) || !actTime.contains(operatorCode)) break;
                    return true;
                }
                case RELEASE: {
                    List<String> actReleaseTime = controlActTime2.getReleaseActTime();
                    if (!CollectionUtils.isNotEmpty(actReleaseTime) || !actReleaseTime.contains(operatorCode)) break;
                    return true;
                }
                case UPDATE: {
                    List<String> actUpdateTime = controlActTime2.getActUpdateTime();
                    if (!EmptyUtil.isNoEmpty(actUpdateTime) || !actUpdateTime.contains(operatorCode)) break;
                    return true;
                }
            }
        }
        logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c\u64cd\u4f5c\u7f16\u7801\uff1a{},\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5b9e\u5360\u65f6\u673a\u914d\u7f6e", new Object[]{systemId, billCode, operatorCode});
        return false;
    }

    private boolean checkPreConfig(Long systemId, List<ControlPreTime> controlPreTimeList, String billCode, String operatorCode, PlanExecuteOpType planExecuteOpType) {
        if (CollectionUtils.isEmpty(controlPreTimeList)) {
            return false;
        }
        List preTimeListList = controlPreTimeList.stream().filter(controlPreActTime -> StringUtils.equals((CharSequence)billCode.trim(), (CharSequence)controlPreActTime.getBizBill().trim())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(preTimeListList)) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{}\u4e3a\u914d\u7f6e\u9884\u5360\u6267\u884c\u65f6\u673a", (Object)systemId, (Object)billCode);
            return false;
        }
        operatorCode = operatorCode.split("-")[0];
        for (ControlPreTime controlPreTime : preTimeListList) {
            switch (planExecuteOpType) {
                case PRE_OCCUPY_DELETE: {
                    List<String> cancelPreTime = controlPreTime.getCancelPreTime();
                    if (!CollectionUtils.isNotEmpty(cancelPreTime) || !cancelPreTime.contains(operatorCode.split("-")[0])) break;
                    return true;
                }
                case PRE_OCCUPY_RELEASE: {
                    List<String> releasePreTime = controlPreTime.getReleasePreTime();
                    if (!CollectionUtils.isNotEmpty(releasePreTime) || !releasePreTime.contains(operatorCode)) break;
                    return true;
                }
                case PRE_OCCUPY_WRITE: {
                    List<String> preTime = controlPreTime.getPreTime();
                    if (!CollectionUtils.isNotEmpty(preTime) || !preTime.contains(operatorCode)) break;
                    return true;
                }
            }
        }
        logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u5355\u636e\u7f16\u53f7\uff1a{}\uff0c\u64cd\u4f5c\u7f16\u7801\uff1a{},\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u9884\u5360\u65f6\u673a\u914d\u7f6e", new Object[]{systemId, billCode, operatorCode});
        return false;
    }
}

