/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IControlRepository;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.AbstractDecorationControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import org.apache.commons.collections4.MapUtils;

public class FailoverControlExecuteStrategy
extends AbstractDecorationControlExecuteStrategy {
    private IControlRepository controlRepository = FpmServiceFactory.getBizService(IControlRepository.class);

    public FailoverControlExecuteStrategy(AbstractControlExecuteStrategy controlExecuteStrategy) {
        super(controlExecuteStrategy);
    }

    @Override
    public FpmOperateResult<ControlResult> validate() {
        this.fillErrorMsgIfNeed();
        this.saveErrorPlanExecuteRecord();
        return FpmOperateResult.success(this.controlResult);
    }

    private void fillErrorMsgIfNeed() {
        FpmOperateResult<ControlResult> resultFpmOperateResult = this.abstractControlExecuteStrategy.validate();
        if (Objects.isNull(resultFpmOperateResult)) {
            return;
        }
        if (resultFpmOperateResult.isSuccess()) {
            return;
        }
        String errorMsg = String.join((CharSequence)",", Optional.ofNullable(resultFpmOperateResult.getMessageList()).orElseGet(Collections::emptyList));
        if (EmptyUtil.isNoEmpty((String)errorMsg)) {
            this.doFillErrorMsg(errorMsg);
            return;
        }
        ControlResult resultData = resultFpmOperateResult.getData();
        String errMsg = resultData.getErrMsg();
        if (EmptyUtil.isNoEmpty((String)errMsg)) {
            this.doFillErrorMsg(errMsg);
            return;
        }
        Map<Long, String> errIdMsgInfo = resultData.getBillIdErrorMsgInfoMap();
        this.doFillErrorMsg(errIdMsgInfo);
    }

    private void doFillErrorMsg(Map<Long, String> errIdMsgInfo) {
        if (MapUtils.isEmpty(errIdMsgInfo)) {
            return;
        }
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Iterator<ControlExecuteParam> iterator = controlExecuteParamList.iterator();
        while (iterator.hasNext()) {
            ControlExecuteParam controlExecuteParam = iterator.next();
            String errorMsg = errIdMsgInfo.getOrDefault(controlExecuteParam.getBillBizInfo().getBillId(), "");
            if (EmptyUtil.isEmpty((String)errorMsg)) continue;
            controlExecuteParam.setFailedCause(errorMsg);
            this.controlContext.addFailedControlExecuteParam(controlExecuteParam);
            iterator.remove();
        }
    }

    private void doFillErrorMsg(String errorMsg) {
        this.controlContext.getControlExecuteParamList().forEach(controlExecuteParam -> {
            controlExecuteParam.setFailedCause(errorMsg);
            this.controlContext.addFailedControlExecuteParam((ControlExecuteParam)controlExecuteParam);
        });
        this.controlContext.getControlExecuteParamList().clear();
    }

    private void saveErrorPlanExecuteRecord() {
        List<ControlExecuteParam> failedControlExecuteParamList = this.controlContext.getFailedControlExecuteParamList();
        if (EmptyUtil.isEmpty(failedControlExecuteParamList)) {
            return;
        }
        ArrayList<PlanExecuteRecord> planExecuteRecordList = new ArrayList<PlanExecuteRecord>(failedControlExecuteParamList.size());
        for (ControlExecuteParam controlExecuteParam : failedControlExecuteParamList) {
            PlanExecuteRecord planExecuteRecord = this.controlStrategyDelegate.createPlanExecuteRecord(controlExecuteParam);
            planExecuteRecord.setExecuteStatus(PlanExecuteStatus.FAILURE);
            planExecuteRecord.setExecuteDate(DateUtils.getCurrentDate());
            planExecuteRecord.setErrReason(controlExecuteParam.getFailedCause());
            planExecuteRecordList.add(planExecuteRecord);
        }
        try (TXHandle tx = TX.requiresNew();){
            this.controlRepository.savePlanExecuteRecord(planExecuteRecordList);
        }
        planExecuteRecordList.forEach(p -> this.controlResult.addFailedExecuteRecordId(p.getBillBizInfo().getBillId(), p.getId()));
    }
}

