/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.List;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.AbstractDecorationControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class FastFailControlExecuteStrategy
extends AbstractDecorationControlExecuteStrategy {
    public FastFailControlExecuteStrategy(AbstractControlExecuteStrategy controlExecuteStrategy) {
        super(controlExecuteStrategy);
    }

    @Override
    public FpmOperateResult<ControlResult> validate() {
        super.validate();
        List<ControlExecuteParam> failedControlExecuteParamList = this.controlContext.getFailedControlExecuteParamList();
        failedControlExecuteParamList.forEach(controlExecuteParam -> this.controlResult.addErrMsg(controlExecuteParam.getBillBizInfo().getBillId(), controlExecuteParam.getFailedCause()));
        if (this.controlResult.isSuccess() && this.controlResult.hasError()) {
            this.controlResult.setErrMsg(String.join((CharSequence)"\r\n", this.controlResult.getBillIdErrorMsgInfoMap().values()));
        }
        return FpmOperateResult.success(this.controlResult);
    }
}

