/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTracePlanRecordSort;
import kd.tmc.fpm.business.domain.model.control.ControlUpdateInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.AbstractDecorationControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class GenericReleaseControlExecuteStrategy
extends AbstractDecorationControlExecuteStrategy {
    public GenericReleaseControlExecuteStrategy(AbstractControlExecuteStrategy controlExecuteStrategy) {
        super(controlExecuteStrategy);
    }

    @Override
    public ControlUpdateInfo handleRecord() {
        ControlUpdateInfo info = super.handleRecord();
        if (this.hasDetail(info)) {
            return info;
        }
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        ControlUpdateInfo controlUpdateInfo = new ControlUpdateInfo();
        logger.info("\u5220\u9664\u5f02\u5e38\u6570\u636e\u3002\u3002\u3002\u3002\u3002");
        this.controlStrategyDelegate.deleteErrorRecordIfNeed(controlUpdateInfo);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            PlanExecuteRecord originalPlanExecuteRecord = controlExecuteParam.getOriginalPlanExecuteRecord();
            if (Objects.isNull(originalPlanExecuteRecord)) continue;
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            String key = String.join((CharSequence)"#", billBizInfo.getBillId().toString(), controlExecuteParam.getSystemId().toString());
            List<ControlTraceInfo> traceInfoList = controlTraceInfoMap.getOrDefault(key, Collections.emptyList());
            ControlTracePlanRecordSort controlTracePlanRecordSort = this.controlStrategyDelegate.sortedExecuteRecord(traceInfoList, key);
            this.controlStrategyDelegate.processCurrentHoldingRecordIfNeed(controlUpdateInfo, controlTracePlanRecordSort, controlExecuteParam);
            PlanExecuteRecord actualReleasePlanExecuteRecord = this.controlStrategyDelegate.createPlanExecuteRecord(controlExecuteParam);
            actualReleasePlanExecuteRecord.setOriginalRecordId(originalPlanExecuteRecord.getId());
            originalPlanExecuteRecord.updateUnReleaseAmt(actualReleasePlanExecuteRecord.getActAmount());
            if (this.controlContext.getPlanExecuteOpType().isActRelease()) {
                originalPlanExecuteRecord.updateAclRemainAmt(actualReleasePlanExecuteRecord.getActAmount());
                actualReleasePlanExecuteRecord.setAclRemainAmt(originalPlanExecuteRecord.getAclRemainAmt());
            }
            controlUpdateInfo.addSavePlanExecuteRecord(actualReleasePlanExecuteRecord);
        }
        this.controlStrategyDelegate.fillCompleteControlUpdateInfo(controlUpdateInfo);
        return controlUpdateInfo;
    }

    private boolean hasDetail(ControlUpdateInfo info) {
        if (Objects.isNull(info)) {
            return false;
        }
        if (EmptyUtil.isNoEmpty(info.getUpdateAmountInfoList())) {
            return true;
        }
        if (EmptyUtil.isNoEmpty(info.getSavePlanExecuteRecordList())) {
            return true;
        }
        return EmptyUtil.isNoEmpty(info.getUpdatePlanExecuteRecordList());
    }
}

