/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.DetailControlInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.AbstractDecorationControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.DetailCurrentControlDataFillControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections4.MapUtils;

public class MatchInfoReportDataSelectorControlExecuteStrategy
extends AbstractDecorationControlExecuteStrategy {
    private ControlStrategyDetailControlInfo controlStrategyDetailControlInfo;

    public MatchInfoReportDataSelectorControlExecuteStrategy(AbstractControlExecuteStrategy controlExecuteStrategy) {
        super(new DetailCurrentControlDataFillControlExecuteStrategy(controlExecuteStrategy));
        this.controlStrategyDetailControlInfo = this.controlContext.getControlStrategyDetailControlInfo();
    }

    @Override
    public FpmOperateResult<ControlResult> validate() {
        if (!this.controlContext.getPlanExecuteOpType().isPositiveOp()) {
            return super.validate();
        }
        logger.info("\u9884\u5360\u6216\u5b9e\u5360\uff0c\u660e\u7ec6\u8868\u53ef\u80fd\u5339\u914d\u5230\u591a\u6761\u540c\u7ef4\u5ea6\u6570\u636e\uff0c\u51c6\u5907\u7b5b\u9009\u51fa\u6700\u4f73\u8bb0\u5f55\u3002\u3002\u3002\u3002");
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            List<ReportData> detailReportDataList;
            List<ReportData> matchedSameReportDataList;
            if (EmptyUtil.isEmpty((Object)controlExecuteParam.getReportData()) || controlExecuteParam.getReportData().isMainTable() || EmptyUtil.isEmpty(matchedSameReportDataList = controlExecuteParam.getMatchedSameReportDataList()) || EmptyUtil.isEmpty(detailReportDataList = this.filter(controlExecuteParam))) continue;
            detailReportDataList.sort(this.getDetailComparator(controlExecuteParam));
            ReportData actualReportData = detailReportDataList.get(0);
            this.controlContext.getControlAmountCache().init(detailReportDataList, controlExecuteParam.getSystemId());
            DimInfo dimInfo = DimInfo.getInstance(controlExecuteParam);
            ReportData sameDim = this.findSameDim(dimInfo);
            if (sameDim != null) {
                Optional<ReportData> first = detailReportDataList.stream().filter((? super T rd) -> Objects.equals(rd.getId(), sameDim.getId())).findFirst();
                if (!first.isPresent()) continue;
                ReportData actualRd = first.get();
                this.setSuitReportData(controlExecuteParam, actualRd, true);
                continue;
            }
            this.setSuitReportData(controlExecuteParam, actualReportData);
        }
        logger.info("\u7b5b\u9009\u5b8c\u6bd5\u3002\u3002\u3002\u3002");
        return super.validate();
    }

    private ReportData findSameDim(DimInfo dimInfo) {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Map systemBillMap = controlExecuteParamList.stream().filter((? super T controlExecuteParam) -> EmptyUtil.isNoEmpty(controlExecuteParam.getMatchedSameReportDataList())).collect(Collectors.groupingBy(ControlExecuteParam::getSystemId, Collectors.mapping(ControlExecuteParam::getBillBizInfo, Collectors.toList())));
        for (Map.Entry entry : systemBillMap.entrySet()) {
            List billBizInfoList = entry.getValue();
            for (BillBizInfo billBizInfo : billBizInfoList) {
                List<ControlTraceInfo> controlTraceInfoList = this.controlContext.getControlTraceInfo(entry.getKey(), billBizInfo.getBillId());
                if (EmptyUtil.isEmpty(controlTraceInfoList)) continue;
                for (ControlTraceInfo controlTraceInfo : controlTraceInfoList) {
                    List planExecuteRecordList;
                    List<PlanExecuteRecord> executeRecordList = controlTraceInfo.getExecuteRecordList();
                    if (EmptyUtil.isEmpty(executeRecordList) || EmptyUtil.isEmpty(planExecuteRecordList = executeRecordList.stream().filter((? super T p) -> p.getExecuteOpType().isPositiveOp()).filter((? super T p) -> CommonUtils.getValueIfNull(p.getUnReleaseAmt()).compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList()))) continue;
                    for (PlanExecuteRecord planExecuteRecord : planExecuteRecordList) {
                        ReportData reportData = planExecuteRecord.getReportData();
                        DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
                        DimInfo dimInfo1 = new DimInfo(dimensionInfoBean);
                        Map<TemplateDim, Object> detailMatchInfo = planExecuteRecord.getDetailMatchInfo();
                        if (MapUtils.isNotEmpty(detailMatchInfo)) {
                            detailMatchInfo.forEach((k, v) -> dimInfo1.addDetailDimInfo(k.getDimensionId(), v));
                        }
                        if (!Objects.equals(dimInfo, dimInfo1)) continue;
                        return reportData;
                    }
                }
            }
        }
        return null;
    }

    private Comparator<ReportData> getDetailComparator(ControlExecuteParam controlExecuteParam) {
        BitMap<Long, Long> detailDimBitMap = controlExecuteParam.getDetailDimBitMap();
        return (o1, o2) -> {
            Integer size2;
            Integer size = detailDimBitMap.getKeys(o1.getId()).size();
            return size.equals(size2 = Integer.valueOf(detailDimBitMap.getKeys(o2.getId()).size())) ? o2.getAvailableAmt().compareTo(o1.getAvailableAmt()) : size2.compareTo(size);
        };
    }

    private void setSuitReportData(ControlExecuteParam controlExecuteParam, ReportData actualRd) {
        this.setSuitReportData(controlExecuteParam, actualRd, false);
    }

    private void setSuitReportData(ControlExecuteParam controlExecuteParam, ReportData actualRd, boolean fromParent) {
        ReportData reportData = controlExecuteParam.getReportData();
        if (Objects.equals(reportData.getId(), actualRd.getId())) {
            return;
        }
        logger.info("\u4e1a\u52a1\u5355\u636e\uff1a{}\uff0c\u4f53\u7cfb\uff1a{}\uff0c\u5339\u914d\u7ef4\u5ea6\uff1a{}\uff0c\u5339\u914d\u5230\u7684\u660e\u7ec6\u7ef4\u5ea6\uff1a{}\uff0c\u539f\u7f16\u5236\u6570\u636eid\uff1a{}\uff0c\u7b5b\u9009\u540e\u7684\u6700\u4f73\u7f16\u5236\u6570\u636eid\uff1a{},\u662f\u5426\u6765\u81ea\u7236\u7ea7\u7b5b\u9009\uff1a{}", new Object[]{controlExecuteParam.getBillBizInfo().getBillNo(), this.controlContext.getSystem(controlExecuteParam.getSystemId()).getName(), controlExecuteParam.getDimensionInfoBean(), controlExecuteParam.getDetailMatchedDimIdS(), reportData.getId(), actualRd.getId(), fromParent});
        controlExecuteParam.setReportData(actualRd);
        controlExecuteParam.reBuildDetailDimensionInfo();
        List<ReportData> matchedSameReportDataList = controlExecuteParam.getMatchedSameReportDataList();
        List<ReportData> matchedReportDataList = controlExecuteParam.getMatchedReportDataList();
        matchedSameReportDataList.remove(actualRd);
        matchedSameReportDataList.add(reportData);
        matchedReportDataList.remove(reportData);
        matchedReportDataList.add(actualRd);
        List<ReportData> optionalMaybeNeedReportDataList = controlExecuteParam.getOptionalMaybeNeedReportDataList();
        Set optionalIds = optionalMaybeNeedReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        if (!optionalIds.contains(reportData.getId())) {
            optionalMaybeNeedReportDataList.add(reportData);
        }
    }

    private List<ReportData> filter(ControlExecuteParam controlExecuteParam) {
        if (!this.controlContext.getPlanExecuteOpType().isOccupy()) {
            return controlExecuteParam.getAllDetailReportDataList();
        }
        List<ReportData> detailReportDataList = controlExecuteParam.getAllDetailReportDataList();
        DetailControlInfo detailControlInfo = this.controlStrategyDetailControlInfo.getDetailControlInfo(controlExecuteParam);
        if (EmptyUtil.isEmpty((Object)detailControlInfo)) {
            return detailReportDataList;
        }
        Set<Long> detailDimIds = detailControlInfo.getDetailDimIds(controlExecuteParam.getSubjectId());
        if (EmptyUtil.isEmpty(detailDimIds)) {
            return detailReportDataList;
        }
        BitMap<Long, Long> detailDimBitMap = controlExecuteParam.getDetailDimBitMap();
        List<Long> list = detailDimBitMap.findList(detailDimIds);
        if (EmptyUtil.isEmpty(list)) {
            controlExecuteParam.setAccurateMatch(false);
            return Collections.emptyList();
        }
        HashSet<Long> reportDataIds = new HashSet<Long>(list);
        return detailReportDataList.stream().filter((? super T rd) -> reportDataIds.contains(rd.getId())).collect(Collectors.toList());
    }

    static class DimInfo {
        private DimensionInfoBean dimensionInfoBean;
        private Map<Long, Object> detailDimMap;

        public DimInfo(DimensionInfoBean dimensionInfoBean) {
            this.dimensionInfoBean = dimensionInfoBean;
            this.detailDimMap = new HashMap<Long, Object>(16);
        }

        public void addDetailDimInfo(Long detailDimId, Object detailDimValue) {
            this.detailDimMap.put(detailDimId, detailDimValue);
        }

        public DimensionInfoBean getDimensionInfoBean() {
            return this.dimensionInfoBean;
        }

        public void setDimensionInfoBean(DimensionInfoBean dimensionInfoBean) {
            this.dimensionInfoBean = dimensionInfoBean;
        }

        public Map<Long, Object> getDetailDimMap() {
            return this.detailDimMap;
        }

        public void setDetailDimMap(Map<Long, Object> detailDimMap) {
            this.detailDimMap = detailDimMap;
        }

        public static DimInfo getInstance(ControlExecuteParam controlExecuteParam) {
            BitMap<Long, Long> detailDimBitMap;
            Set<Long> keys;
            DimInfo dimInfo = new DimInfo(controlExecuteParam.getDimensionInfoBean());
            ReportData reportData = controlExecuteParam.getReportData();
            Map<Long, Object> detailDimValueMap = DimensionInfoHelper.getDetailDimValueMap(reportData, keys = (detailDimBitMap = controlExecuteParam.getDetailDimBitMap()).getKeys(reportData.getId()));
            if (MapUtils.isEmpty(detailDimValueMap)) {
                return dimInfo;
            }
            detailDimValueMap.forEach(dimInfo::addDetailDimInfo);
            return dimInfo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DimInfo dimInfo = (DimInfo)o;
            return Objects.equals(this.dimensionInfoBean, dimInfo.dimensionInfoBean) && Objects.equals(this.detailDimMap, dimInfo.detailDimMap);
        }

        public int hashCode() {
            return Objects.hash(this.dimensionInfoBean, this.detailDimMap);
        }
    }
}

