/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlActTime;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.domain.model.control.ControlPreTime;
import kd.tmc.fpm.business.domain.model.control.ControlTime;
import kd.tmc.fpm.business.helper.ControlBOTPHelper;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class MultiSourceInfoPostProcessor
implements IControlExecuteParamPostProcessor {
    private static final Log logger = LogFactory.getLog(MultiSourceInfoPostProcessor.class);

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        List billBizInfoList = controlExecuteParamList.stream().map(ControlExecuteParam::getBillBizInfo).distinct().collect(Collectors.toList());
        Set<String> entityTypes = this.getAllEntityTypesFromAllControlTime(controlContext, controlExecuteParamList);
        logger.info("\u5f00\u59cb\u5224\u65ad\u5408\u5e76\u4e0b\u63a8\u6807\u8bc6\uff0c\u6240\u6709\u76f8\u5173\u4f53\u7cfb\u914d\u7f6e\u7684\u4e1a\u52a1\u5355\u636e\u7c7b\u578b\uff1a{}", entityTypes);
        HashSet<Long> multiSourceIds = new HashSet<Long>(16);
        block0: for (BillBizInfo billBizInfo : billBizInfoList) {
            String entityType = billBizInfo.getEntityType();
            List<ControlBOTPInfo> controlBOTPInfoList = this.filterBotp(entityTypes, billBizInfo);
            String currentUpperEntityType = "";
            int count = 0;
            for (ControlBOTPInfo controlBOTPInfo : controlBOTPInfoList) {
                String upperEntityType = controlBOTPInfo.getEntityType();
                if (Objects.equals(entityType, upperEntityType)) continue;
                if (EmptyUtil.isEmpty((String)currentUpperEntityType)) {
                    currentUpperEntityType = upperEntityType;
                    ++count;
                    continue;
                }
                if (!Objects.equals(currentUpperEntityType, upperEntityType)) continue block0;
                if (++count <= 1) continue;
                controlContext.registerMultiSource(billBizInfo.getBillId());
                multiSourceIds.add(billBizInfo.getBillId());
                continue block0;
            }
        }
        logger.info("\u5408\u5e76\u4e0b\u63a8\u4e1a\u52a1\u5355\u636eid\uff1a{}", multiSourceIds);
    }

    private Set<String> getAllEntityTypesFromAllControlTime(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        HashSet<String> entityTypes = new HashSet<String>(16);
        Set systemIds = controlExecuteParamList.stream().map(ControlExecuteParam::getSystemId).collect(Collectors.toSet());
        for (Long systemId : systemIds) {
            List<ControlPreTime> controlPreTimeList;
            ControlTime controlTime = controlContext.getControlTime(systemId);
            List<ControlActTime> controlActTimeList = controlTime.getControlActTimeList();
            if (EmptyUtil.isNoEmpty(controlActTimeList)) {
                controlActTimeList.stream().map(ControlActTime::getBizBill).forEach(entityTypes::add);
            }
            if (!EmptyUtil.isNoEmpty(controlPreTimeList = controlTime.getControlPreTimeList())) continue;
            controlPreTimeList.stream().map(ControlPreTime::getBizBill).forEach(entityTypes::add);
        }
        return entityTypes;
    }

    private List<ControlBOTPInfo> filterBotp(Set<String> entityTypes, BillBizInfo billBizInfo) {
        List<ControlBOTPInfo> upBill = ControlBOTPHelper.findUpBill(billBizInfo.getEntityType(), billBizInfo.getBillId());
        if (EmptyUtil.isEmpty(upBill)) {
            return Collections.emptyList();
        }
        return upBill.stream().filter(controlBOTPInfo -> entityTypes.contains(controlBOTPInfo.getEntityType())).collect(Collectors.toList());
    }

    @Override
    public int getOrder() {
        return 10;
    }
}

