/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MatchPropType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.match.MatchInfo;
import kd.tmc.fpm.business.domain.model.match.MatchParam;
import kd.tmc.fpm.business.domain.model.match.MatchResult;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.ControlResult;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.impl.AbstractDecorationControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.match.IControlMatchService;
import kd.tmc.fpm.business.mvc.service.match.factory.ControlMatchServiceFactory;
import kd.tmc.fpm.business.mvc.service.match.validate.impl.MatchValidatorDelegate;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import org.apache.commons.collections.CollectionUtils;

public class NewMatchInfoBackFillControlExecuteStrategy
extends AbstractDecorationControlExecuteStrategy {
    protected IControlMatchService matchService;
    protected FpmOperateResult<List<MatchResult>> matchResultListResult;

    public NewMatchInfoBackFillControlExecuteStrategy(AbstractControlExecuteStrategy controlExecuteStrategy) {
        super(controlExecuteStrategy);
        this.matchService = ControlMatchServiceFactory.getDefaultControlMatchService(this.controlContext);
    }

    public NewMatchInfoBackFillControlExecuteStrategy(AbstractControlExecuteStrategy controlExecuteStrategy, IControlMatchService matchService) {
        super(controlExecuteStrategy);
        this.matchService = matchService;
    }

    @Override
    public void beforeDoControl() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        ArrayList<MatchParam> matchParamList = new ArrayList<MatchParam>(controlExecuteParamList.size());
        HashSet<String> mergeKeys = new HashSet<String>(64);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            String mergeKey = controlExecuteParam.getMergeKey();
            if (mergeKeys.contains(mergeKey)) continue;
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            BillMatchRule matchRule = controlExecuteParam.getMatchRule();
            Long systemId = matchRule.getSystemId();
            FundPlanSystem system = this.controlContext.getSystem(systemId);
            MatchParam matchParam = new MatchParam();
            matchParam.setMatchRule(matchRule);
            matchParam.setBillBizInfo(billBizInfo);
            matchParam.setFundPlanSystem(system);
            matchParam.setSubjectId(controlExecuteParam.getSubjectId());
            matchParam.setReportOrgId(controlExecuteParam.getReportOrgId());
            matchParam.setUniqueId(controlExecuteParam.getUniqueId());
            matchParamList.add(matchParam);
            mergeKeys.add(controlExecuteParam.getUniqueId());
        }
        this.matchResultListResult = this.matchService.match(matchParamList);
        super.beforeDoControl();
    }

    @Override
    public FpmOperateResult<ControlResult> validate() {
        logger.info("\u5f00\u59cb\u5339\u914d\u6821\u9a8c\u3002\u3002\u3002\u3002");
        MatchValidatorDelegate matchValidatorDelegate = new MatchValidatorDelegate(this.controlContext, this.matchResultListResult);
        matchValidatorDelegate.validate();
        this.fillAddControlExecuteParam();
        return super.validate();
    }

    protected void fillAddControlExecuteParam() {
        this.fillAddControlExecuteParamIfNeed();
        if (this.controlContext.getPlanExecuteOpType().isOccupyOp() && this.controlResult.hasError()) {
            this.controlContext.getControlExecuteParamList().removeIf(c -> Objects.isNull(c.getReportData()));
            return;
        }
        this.fillRateInfo();
    }

    private void fillRateInfo() {
        Map<String, DynamicObject> currencyIdMap = this.fillCurrencyMatchInfoAndReportIds();
        ControlAmountCache controlAmountCache = this.controlContext.getControlAmountCache();
        for (ControlExecuteParam controlExecuteParam : this.controlContext.getControlExecuteParamList()) {
            ReportData reportData = controlExecuteParam.getReportData();
            FundPlanSystem system = this.controlContext.getSystem(controlExecuteParam.getSystemId());
            ControlExecuteParam originalControlExecuteParam = this.controlContext.getOriginalControlExecuteParam(controlExecuteParam.getMergeKey());
            if (EmptyUtil.isNoEmpty((Object)originalControlExecuteParam)) {
                controlExecuteParam.setRateDate(originalControlExecuteParam.getRateDate());
                controlExecuteParam.setRate(originalControlExecuteParam.getRate());
                continue;
            }
            Dimension currencyDim = system.getMainDimensionByDimType(DimensionType.CURRENCY);
            Object currencyMemberId = reportData.getDimValByDimType(DimensionType.CURRENCY, null);
            DimMember currencyMember = currencyDim.getAllDimMemberList().stream().filter(cm -> Objects.equals(currencyMemberId, cm.getId())).findFirst().get();
            Long targetCurrencyId = currencyMember.getSourceId();
            BillMatchRule matchRule = controlExecuteParam.getMatchRule();
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            MatchMapping currencyMatchMapping = matchRule.getMappings().stream().filter(m -> Objects.equals(currencyDim.getId(), m.getDimId())).findFirst().get();
            String matchCurrencyProp = currencyMatchMapping.getBizProp();
            String matchedCurrencyName = billBizInfo.getBizProps().stream().filter(p -> Objects.equals(p.getBizProp(), matchCurrencyProp)).map(BizProps::getValue).filter(Objects::nonNull).map(Object::toString).map(String::trim).findFirst().get();
            String key = String.join((CharSequence)"#", currencyMatchMapping.getMatchPropType().getProp(), matchedCurrencyName);
            DynamicObject matchCurrencyDy = currencyIdMap.get(key);
            if (Objects.isNull(matchCurrencyDy)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u3010%1$s\u3011\u5339\u914d\u5230\u7684\u5e01\u79cd\u3010%2$s\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5e01\u79cd\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u64cd\u4f5c", (String)"NewMatchInfoBackFillControlExecuteStrategy_0", (String)"tmc-fpm-business", (Object[])new Object[0]), billBizInfo.getBillNo(), matchedCurrencyName);
                throw new KDBizException(errMsg);
            }
            Long sourceCurrencyId = matchCurrencyDy.getLong("id");
            String sourceCurrencyName = matchCurrencyDy.getString("name");
            logger.info("targetCurrencyId = {},targetCurrencyName:{}\uff0ccurrencyId of matchedReportData: {},currencyName of matchedReportData:{}", new Object[]{targetCurrencyId, currencyMember.getName(), sourceCurrencyId, sourceCurrencyName});
            Report report = this.controlStrategyDelegate.getReportById(reportData.getReportId());
            BigDecimal exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)report.getExchangeRateTableId(), (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)report.getExchangeRateDate());
            controlExecuteParam.setRateDate(report.getExchangeRateDate());
            controlExecuteParam.setRate(exchangeRate);
            controlAmountCache.init(controlExecuteParam.getMatchedReportDataList(), controlExecuteParam.getSystemId());
        }
    }

    private Map<String, DynamicObject> fillCurrencyMatchInfoAndReportIds() {
        HashMap<String, DynamicObject> currencyIdMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Set> currencyValueMap = new HashMap<String, Set>(32);
        for (ControlExecuteParam controlExecuteParam : this.controlContext.getControlExecuteParamList()) {
            BillMatchRule matchRule = controlExecuteParam.getMatchRule();
            FundPlanSystem system = this.controlContext.getSystem(matchRule.getSystemId());
            Dimension currencyDim = system.getMainDimensionByDimType(DimensionType.CURRENCY);
            MatchMapping currencyMatchMapping = matchRule.getMappings().stream().filter(matchMapping -> Objects.equals(matchMapping.getDimId(), currencyDim.getId())).findFirst().get();
            String bizProp = currencyMatchMapping.getBizProp();
            MatchPropType matchPropType = currencyMatchMapping.getMatchPropType();
            String currencyValue = controlExecuteParam.getBillBizInfo().getBizProps().stream().filter(matchedBizProp -> Objects.equals(matchedBizProp.getBizProp(), bizProp)).map(BizProps::getValue).filter(Objects::nonNull).map(String::valueOf).map(String::trim).findFirst().get();
            Set currencyValueSet = currencyValueMap.computeIfAbsent(matchPropType.getProp(), key -> new HashSet());
            currencyValueSet.add(currencyValue);
        }
        for (Map.Entry entry : currencyValueMap.entrySet()) {
            DynamicObjectCollection currencyDC;
            String entryKey = (String)entry.getKey();
            String selectFields = String.join((CharSequence)",", "id", entryKey);
            if (!Objects.equals(entryKey, MatchPropType.NAME.getProp())) {
                selectFields = String.join((CharSequence)",", selectFields, MatchPropType.NAME.getProp());
            }
            if (EmptyUtil.isEmpty((DynamicObjectCollection)(currencyDC = QueryServiceHelper.query((String)"bd_currency", (String)selectFields, (QFilter[])new QFilter[]{new QFilter(entryKey, "in", entry.getValue())})))) continue;
            for (DynamicObject dynamicObject : currencyDC) {
                String key2 = String.join((CharSequence)"#", entryKey, dynamicObject.getString(entryKey));
                currencyIdMap.putIfAbsent(key2, dynamicObject);
            }
        }
        return currencyIdMap;
    }

    protected void fillAddControlExecuteParamIfNeed() {
        List<MatchResult> matchResultList = this.matchResultListResult.getData();
        List<ControlExecuteParam> controlParamList = this.controlContext.getControlExecuteParamList();
        if (CollectionUtils.isEmpty(matchResultList)) {
            controlParamList.clear();
            return;
        }
        Map<String, List<MatchResult>> matchResultGroupMap = matchResultList.stream().collect(Collectors.groupingBy(this::getMatchResultGroupKey));
        ArrayList<ControlExecuteParam> newParam = new ArrayList<ControlExecuteParam>(4);
        MatchResultProcess matchResultProcess = this.getMatchResultProcess();
        Iterator<ControlExecuteParam> iterator = controlParamList.iterator();
        while (iterator.hasNext()) {
            ControlExecuteParam controlExecuteParam = iterator.next();
            List<MatchResult> matchDataResultList = this.getMatchDataResultList(matchResultGroupMap, controlExecuteParam);
            if (EmptyUtil.isEmpty(matchDataResultList)) {
                iterator.remove();
                continue;
            }
            MatchResult matchResult = matchDataResultList.get(0);
            matchResultProcess.process(controlExecuteParam, matchResult);
            if (!matchResult.isSuccess()) {
                iterator.remove();
            }
            for (int i = 1; i < matchDataResultList.size(); ++i) {
                ControlExecuteParam copy = controlExecuteParam.copy();
                MatchResult mr = matchDataResultList.get(i);
                matchResultProcess.process(copy, mr);
                if (!mr.isSuccess()) continue;
                newParam.add(copy);
            }
        }
        controlParamList.addAll(newParam);
    }

    public MatchResultProcess getMatchResultProcess() {
        if (this.controlContext.getPlanExecuteOpType().isOccupy()) {
            return new OccupyFailedMatchResultProcess(this);
        }
        return new ActualFailedMatchResultProcess(this);
    }

    private List<MatchResult> getMatchDataResultList(Map<String, List<MatchResult>> matchResultGroupMap, ControlExecuteParam controlExecuteParam) {
        String key = this.controlStrategyDelegate.getGroupKey(controlExecuteParam.getBillBizInfo(), controlExecuteParam.getMatchRule());
        List<MatchResult> matchResultList = matchResultGroupMap.get(key);
        if (EmptyUtil.isNoEmpty(matchResultList)) {
            return matchResultList;
        }
        String mergeKey = controlExecuteParam.getMergeKey();
        if (EmptyUtil.isEmpty((String)mergeKey)) {
            return matchResultList;
        }
        ControlExecuteParam originalControlExecuteParam = this.controlContext.getOriginalControlExecuteParam(mergeKey);
        key = this.controlStrategyDelegate.getGroupKey(originalControlExecuteParam.getBillBizInfo(), originalControlExecuteParam.getMatchRule());
        matchResultList = matchResultGroupMap.get(key);
        return matchResultList;
    }

    private String getMatchResultGroupKey(MatchResult matchResult) {
        return this.controlStrategyDelegate.getGroupKey(matchResult.getBillBizInfo(), matchResult.getMatchRule());
    }

    private void fillMatchInfo(ControlExecuteParam controlExecuteParam, MatchResult matchResult) {
        controlExecuteParam.setMatchedReportDataList(new ArrayList<ReportData>(matchResult.getMatchedReportDataList()));
        controlExecuteParam.setMatchedSameReportDataList(new ArrayList<ReportData>(matchResult.getSameDimReportDataList()));
        controlExecuteParam.setOptionalMaybeNeedReportDataList(new ArrayList<ReportData>(matchResult.getOptionalReportDataList()));
        logger.info("\u5339\u914d\u5230\u7684\u7f16\u5236\u6570\u636e\u6761\u6570:{}", (Object)matchResult.getMatchedReportDataList().size());
        controlExecuteParam.setReportData(matchResult.getReportData());
        controlExecuteParam.setDetailDimBitMap(matchResult.getMatchedDetailDim());
        controlExecuteParam.setReportTypeId(matchResult.getReportTypeId());
        controlExecuteParam.setAccurateMatch(matchResult.isAccurateMatched());
        controlExecuteParam.setDimensionInfoBean(matchResult.getDimensionInfoBean().copy());
    }

    static class ActualFailedMatchResultProcess
    extends SuccessMatchResultProcess {
        public ActualFailedMatchResultProcess(NewMatchInfoBackFillControlExecuteStrategy matchInfoBackFillControlExecuteStrategy) {
            super(matchInfoBackFillControlExecuteStrategy);
        }

        @Override
        public void process(ControlExecuteParam controlExecuteParam, MatchResult matchResult) {
            super.process(controlExecuteParam, matchResult);
            if (matchResult.isSuccess()) {
                return;
            }
            if (!this.matchInfoBackFillControlExecuteStrategy.controlContext.getPlanExecuteOpType().isWrite()) {
                return;
            }
            controlExecuteParam.setFailedCause(matchResult.getErrorMsg());
            MatchInfo matchInfo = matchResult.getMatchException().getMatchInfo();
            controlExecuteParam.setReportTypeId(Objects.isNull(matchInfo) ? matchResult.getReportTypeId() : matchInfo.getReportTypeId());
            this.matchInfoBackFillControlExecuteStrategy.controlContext.addFailedControlExecuteParam(controlExecuteParam);
        }
    }

    static class OccupyFailedMatchResultProcess
    extends SuccessMatchResultProcess {
        public OccupyFailedMatchResultProcess(NewMatchInfoBackFillControlExecuteStrategy matchInfoBackFillControlExecuteStrategy) {
            super(matchInfoBackFillControlExecuteStrategy);
        }

        @Override
        public void process(ControlExecuteParam controlExecuteParam, MatchResult matchResult) {
            ControlResult controlResult = this.matchInfoBackFillControlExecuteStrategy.controlResult;
            if (controlResult.isError(controlExecuteParam.getBillBizInfo().getBillId())) {
                if (!matchResult.isSuccess()) {
                    controlResult.addErrMsg(controlExecuteParam.getBillBizInfo().getBillId(), matchResult.getErrorMsg());
                }
                return;
            }
            super.process(controlExecuteParam, matchResult);
            if (matchResult.isSuccess()) {
                return;
            }
            if (!this.matchInfoBackFillControlExecuteStrategy.controlContext.getPlanExecuteOpType().isOccupy()) {
                return;
            }
            controlResult.addErrMsg(controlExecuteParam.getBillBizInfo().getBillId(), matchResult.getErrorMsg());
        }
    }

    static class SuccessMatchResultProcess
    implements MatchResultProcess {
        protected NewMatchInfoBackFillControlExecuteStrategy matchInfoBackFillControlExecuteStrategy;

        public SuccessMatchResultProcess(NewMatchInfoBackFillControlExecuteStrategy matchInfoBackFillControlExecuteStrategy) {
            this.matchInfoBackFillControlExecuteStrategy = matchInfoBackFillControlExecuteStrategy;
        }

        @Override
        public void process(ControlExecuteParam controlExecuteParam, MatchResult matchResult) {
            if (matchResult.isSuccess()) {
                this.matchInfoBackFillControlExecuteStrategy.fillMatchInfo(controlExecuteParam, matchResult);
            }
        }
    }

    static interface MatchResultProcess {
        public void process(ControlExecuteParam var1, MatchResult var2);
    }
}

