/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.business.mvc.service.impl.PeriodParamInfo;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;
import kd.tmc.fpm.common.enums.OrgReportTypeEnum;

public class PeriodNumberUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PeriodNumberUpgradeServiceImpl.class);
    public static final String PREFIX_Y = "Y";
    public static final String PREFIX_HY = "HY";
    public static final String PREFIX_SE = "Q";
    public static final String PREFIX_M = "M";
    public static final String PREFIX_TD = "TD";
    public static final String PREFIX_MW = "MW";
    public static final String PREFIX_YW = "YW";
    public static final String PREFIX_D = "D";

    @Override
    public void updateData() {
        DynamicObject[] systemList;
        logger.info("[PeriodNumberUpgradeServiceImpl] >>>> \u671f\u95f4\u7f16\u7801\u6570\u636e\u5f00\u59cb\u5347\u7ea7... ");
        String newReferencePosProp = String.join((CharSequence)",", "number", "id");
        for (DynamicObject sys : systemList = TmcDataServiceHelper.load((String)"fpm_bodysysmanage", (String)newReferencePosProp, (QFilter[])new QFilter[0])) {
            DynamicObject[] periodMembers = BusinessDataServiceHelper.load((String)"fpm_member", (String)"id,number,reporttype", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", sys.getPkValue()), new QFilter("dimtype", "=", (Object)DimsionEnums.PERIOD.getNumber())});
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
            for (DynamicObject periodMember : periodMembers) {
                int finalIndex;
                DynamicObject reportType = periodMember.getDynamicObject("reporttype");
                if (Objects.isNull(reportType)) continue;
                String actType = reportType.getString("orgreportcycle");
                String detailType = reportType.getString("orgreporttype");
                if (StringUtils.isEmpty((CharSequence)detailType)) continue;
                String prefix = this.getPrefix(actType, detailType);
                String number = periodMember.getString("number");
                int yIndex = number.indexOf("_Y");
                int fyIndex = number.indexOf("_FY");
                int n = yIndex > 0 ? yIndex : (finalIndex = fyIndex > 0 ? fyIndex : -1);
                if (finalIndex < 0) continue;
                String substringNumber = number.substring(finalIndex);
                String finalNumber = prefix + substringNumber;
                logger.info("[PeriodNumberUpgradeServiceImpl] >>>> \u4f53\u7cfb[{}]\uff0c\u66f4\u65b0\u524d:[{}]\uff0c\u66f4\u65b0\u540e:[{}]", new Object[]{sys.getPkValue(), number, finalNumber});
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"fpm_member");
                dynamicObject.set("id", periodMember.getPkValue());
                dynamicObject.set("number", (Object)finalNumber);
                updateList.add(dynamicObject);
            }
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
        logger.info("[PeriodNumberUpgradeServiceImpl] >>>> \u671f\u95f4\u7f16\u7801\u6570\u636e\u5347\u7ea7\u7ed3\u675f... ");
    }

    private String getPrefix(String reportCycle, String orgReportType) {
        PeriodParamInfo paramInfo = new PeriodParamInfo();
        if (OrgReportTypeCycleEnum.YEAR.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasYear(true);
            } else if (OrgReportTypeEnum.HALFYEAR.getValue().equals(orgReportType)) {
                paramInfo.setHasHalfYear(true);
                paramInfo.setYearInHYear(true);
            } else if (OrgReportTypeEnum.QUARTER.getValue().equals(orgReportType)) {
                paramInfo.setHasQuarter(true);
                paramInfo.setYearInQuarter(true);
            } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                paramInfo.setHasMonth(true);
                paramInfo.setYearInMonth(true);
            }
        }
        if (OrgReportTypeCycleEnum.HALFYEAR.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasHalfYear(true);
            } else if (OrgReportTypeEnum.QUARTER.getValue().equals(orgReportType)) {
                paramInfo.setHasQuarter(true);
                paramInfo.setHalfYearInQuarter(true);
            } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                paramInfo.setHasMonth(true);
                paramInfo.setHalfyearinMonth(true);
            }
        }
        if (OrgReportTypeCycleEnum.QUARTER.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasQuarter(true);
            } else if (OrgReportTypeEnum.MONTH.getValue().equals(orgReportType)) {
                paramInfo.setHasMonth(true);
                paramInfo.setQuarterinMonth(true);
            }
        }
        if (OrgReportTypeCycleEnum.MONTH.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasMonth(true);
            } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                paramInfo.setHasDay(true);
                paramInfo.setMonthInDay(true);
            } else if (OrgReportTypeEnum.WEEK.getValue().equals(orgReportType)) {
                paramInfo.setHasMonthWeek(true);
                paramInfo.setMonthInMonthWeek(true);
            } else if (OrgReportTypeEnum.TEN.getValue().equals(orgReportType)) {
                paramInfo.setMonthInTenday(true);
                paramInfo.setHastenDay(true);
            }
        }
        if (OrgReportTypeCycleEnum.TEN.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHastenDay(true);
            } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                paramInfo.setHasDay(true);
                paramInfo.setTenDayInDay(true);
            }
        }
        if (OrgReportTypeCycleEnum.WEEK.getValue().equals(reportCycle)) {
            if (EmptyUtil.isEmpty((String)orgReportType)) {
                paramInfo.setHasMonthWeek(true);
            } else if (OrgReportTypeEnum.DAY.getValue().equals(orgReportType)) {
                paramInfo.setHasDay(true);
                paramInfo.setMonthWeekInDay(true);
            }
        }
        if (OrgReportTypeCycleEnum.DAY.getValue().equals(reportCycle)) {
            paramInfo.setHasDay(true);
        }
        return this.getNumber(paramInfo);
    }

    private String getNumber(PeriodParamInfo paramInfo) {
        String pre;
        String prefix = "";
        if (paramInfo.isHasYear()) {
            prefix = PREFIX_Y;
        }
        if (paramInfo.isHasHalfYear()) {
            pre = PREFIX_HY;
            if (paramInfo.isYearInHYear()) {
                pre = "Y_HY";
            }
            prefix = pre;
        }
        if (paramInfo.isHasQuarter()) {
            pre = PREFIX_SE;
            if (paramInfo.isHalfYearInQuarter()) {
                pre = "HY_Q";
            }
            if (paramInfo.isYearInQuarter()) {
                pre = "Y_Q";
            }
            prefix = pre;
        }
        if (paramInfo.isHasMonth()) {
            pre = PREFIX_M;
            if (paramInfo.isQuarterinMonth()) {
                pre = "Q_M";
            }
            if (paramInfo.isHalfyearinMonth()) {
                pre = "HY_M";
            }
            if (paramInfo.isYearInMonth()) {
                pre = "Y_M";
            }
            prefix = pre;
        }
        if (paramInfo.isHastenDay()) {
            pre = PREFIX_TD;
            if (paramInfo.isMonthInTenday()) {
                pre = "M_TD";
            }
            prefix = pre;
        }
        if (paramInfo.isHasYearWeek()) {
            prefix = PREFIX_YW;
        }
        if (paramInfo.isHasMonthWeek()) {
            pre = PREFIX_MW;
            if (paramInfo.isMonthInMonthWeek()) {
                pre = "M_MW";
            }
            prefix = pre;
        }
        if (paramInfo.isHasDay()) {
            pre = PREFIX_D;
            if (paramInfo.isYearWeekInDay()) {
                pre = "YW_D";
            } else if (paramInfo.isMonthWeekInDay()) {
                pre = "MW_D";
                if (paramInfo.isMonthInDay()) {
                    // empty if block
                }
            } else if (paramInfo.isTenDayInDay()) {
                pre = "TD_D";
                if (paramInfo.isMonthInDay()) {
                    // empty if block
                }
            } else if (paramInfo.isMonthInDay()) {
                pre = "M_D";
            }
            prefix = pre;
        }
        return prefix;
    }
}

