/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.ReportDataSaveService;
import kd.tmc.fpm.business.dataproc.save.domain.UpdateResult;
import kd.tmc.fpm.business.domain.enums.AdjustType;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportPlanChangeStatus;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.PlanChangeHeader;
import kd.tmc.fpm.business.domain.model.report.PlanChangeRecord;
import kd.tmc.fpm.business.domain.model.report.PlanChangeReport;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportChangeData;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.DetailEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.MainEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.SourceIdEntryData;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanUpdateInfo;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IPlanChangeService;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.domain.service.ISumPlanService;
import kd.tmc.fpm.business.domain.service.impl.PlanChangeService;
import kd.tmc.fpm.business.domain.service.impl.ReportService;
import kd.tmc.fpm.business.domain.service.impl.SumPlanService;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mq.TMCMQPublisher;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IPlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportUpdateDTO;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.PlanChangeRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.IPlanChangeBizService;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskHandleService;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskHandleServiceImpl;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.bean.FpmContext;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PlanChangeBizServiceImpl
implements IPlanChangeBizService {
    private static Log logger = LogFactory.getLog(PlanChangeBizServiceImpl.class);
    private IPlanChangeRepository repository = new PlanChangeRepository();
    private IReportRepository reportRepository;
    private IDimensionRepository dimensionRepository;
    private IReportService reportService;
    private IPlanChangeService service = new PlanChangeService();
    private ISumPlanService sumPlanService;
    private ISummaryConfigService iSummaryConfigService;
    private ReportDataSaveService reportDataSaveService;
    protected IDataSaveService iDataSaveService;
    private TaskHandleService taskHandleService;

    public PlanChangeBizServiceImpl() {
        this.reportRepository = new ReportRepository();
        this.reportService = new ReportService();
        this.dimensionRepository = new DimensionRepository();
        this.sumPlanService = new SumPlanService();
        this.iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);
        this.reportDataSaveService = new ReportDataSaveService();
        this.iDataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
        this.taskHandleService = new TaskHandleServiceImpl();
    }

    @Override
    public FpmOperateResult<Long> create(Set<Long> reportIdS) {
        logger.info(String.format("\u521b\u5efa\u8c03\u6574\u5355\uff0creportIdS:\u3010%s\u3011", JSON.toJSONString(reportIdS)));
        PlanChangeRecord record = new PlanChangeRecord();
        ReportNeedPropDTO needPropDTO = new ReportNeedPropDTO();
        needPropDTO.setNeedReportPeriodType(true);
        needPropDTO.setNeedPeriodMember(true);
        needPropDTO.setNeedSystemId(true);
        needPropDTO.setNeedCompanyMember(true);
        List<Report> reports = this.reportRepository.loadSimpleReport(reportIdS, needPropDTO);
        Optional<Report> first = reports.stream().filter(item -> item.getTemplate().isMainTable()).findFirst();
        if (!first.isPresent()) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u62a5\u8868\u4e2d\u672a\u627e\u5230\u4e3b\u8868\u3002", (String)"PlanChangeBizServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        Report mainReport = first.get();
        record.setSystemId(mainReport.getSystemId());
        record.setReportOrg(mainReport.getCompanyMemberList().get(0).getId());
        record.setReportType(mainReport.getPeriodMemberList().get(0).getPeriodTypeId());
        record.setReportPeriod(mainReport.getPeriodMemberList().get(0).getId());
        record.setOriginalReportIdList(new ArrayList<Long>(reportIdS));
        record.setAdjustType(AdjustType.AMOUNT_ADDITIONAL);
        record.setApplyDate(new Date());
        record.setMainReportId(mainReport.getId());
        record.setAmountUnit(mainReport.getTemplate().getAmountUnit());
        Long recordId = 0L;
        try (TXHandle h = TX.required();){
            try {
                recordId = this.repository.save(record);
                this.reportRepository.updateBaseInfo(reports.stream().map(report -> new ReportUpdateDTO(report.getId(), ReportPlanChangeStatus.CHANGING)).collect(Collectors.toList()));
            }
            catch (Exception e) {
                h.markRollback();
                logger.error("\u521b\u5efa\u8c03\u6574\u5355\u5f02\u5e38", (Throwable)e);
                FpmOperateResult<Long> fpmOperateResult = FpmOperateResult.error(e.getMessage());
                if (h != null) {
                    if (var9_9 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return fpmOperateResult;
            }
        }
        return FpmOperateResult.success(recordId);
    }

    @Override
    public PlanChangeRecord load(Long id) {
        PlanChangeRecord load = this.repository.load(id);
        this.populateReportDataList(Collections.singleton(load));
        return load;
    }

    @Override
    public PlanChangeRecord loadWithoutOriginalReportData(Long id) {
        return this.repository.load(Collections.singletonList(id), false, true, true).get(0);
    }

    @Override
    public PlanChangeRecord load(Long id, Long reportId, FundPlanSystem system, PlanChangeHeader changeHeader) {
        PlanChangeRecord changeRecord = this.repository.load(id, reportId);
        this.removeReportRollPeriodMemberIfNeed(changeRecord);
        Report report = this.reportRepository.loadReport(reportId);
        PlanChangeReport changeReport = changeRecord.getChangeReportList().stream().filter(o -> o.getReportId().compareTo(reportId) == 0).findAny().get();
        this.service.transfer(report, changeReport, system, changeHeader);
        return changeRecord;
    }

    @Override
    public void save(PlanChangeRecord changeData, FundPlanSystem fundPlanSystem, List<Report> originalReports) {
        Map detailTempChangeReportMap = changeData.getChangeReportList().stream().filter(planChangeReport -> planChangeReport.getTemplate().getTemplateType().isDetail()).collect(Collectors.toMap(planChangeReport -> planChangeReport.getReportId(), Function.identity()));
        if (!detailTempChangeReportMap.isEmpty()) {
            Map originalReportMap = originalReports.stream().collect(Collectors.toMap(Report::getId, Function.identity(), (a, b) -> b));
            detailTempChangeReportMap.forEach((detailReportId, detailPlanChangeReport) -> ReportHelper.checkDetailReportData(fundPlanSystem, (Report)originalReportMap.get(detailReportId), detailPlanChangeReport.getReportDataList()));
        }
        this.removeReportRollPeriodMemberIfNeed(changeData);
        this.removeReportRollPeriodDataIfNeed(changeData, originalReports);
        changeData.getChangeReportList().forEach(planChangeReport -> this.resetReportDataRowValIfDetailTemplate((PlanChangeReport)planChangeReport, fundPlanSystem));
        this.service.beforeSave(changeData, fundPlanSystem, originalReports);
        this.repository.save(changeData);
    }

    @Override
    public FpmOperateResult<Void> asyncAudit(Long id, Long systemId) {
        FpmAssertUtil.isNotNull((Object)id, (String)"plan change id is null");
        FpmAssertUtil.isNotNull((Object)systemId, (String)"systemId is null");
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(DB.genGlobalLongId());
        taskRecord.setTaskType(TaskType.REPORT_PLAN_CHANGE_TASK.name());
        taskRecord.setStatus(TaskStatus.WAITING.name());
        taskRecord.setGroupId(systemId.toString());
        HashMap<String, Long> param = new HashMap<String, Long>(2);
        param.put("planChangeId", id);
        param.put("systemId", systemId);
        taskRecord.setTaskInfo(SerializationUtils.toJsonString(param));
        this.taskHandleService.saveTask(taskRecord);
        TMCMQPublisher.sendFpmDefaultMsg(MQBusinessTypeEnum.LOCAL_SEQUENT_TASK, SerializationUtils.toJsonString((Object)taskRecord));
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult<Set<Long>> audit(Long id) {
        logger.info(String.format("\u8ba1\u5212\u8c03\u6574\u5ba1\u6838\uff0cid:\u3010%s\u3011", id));
        PlanChangeRecord changeData = this.repository.load(Collections.singletonList(id), false, true, true).get(0);
        List<PlanChangeReport> changeReportList = changeData.getChangeReportList();
        Set<Long> reportIdS = changeReportList.stream().map(PlanChangeReport::getReportId).collect(Collectors.toSet());
        List<Report> reportList = this.reportRepository.loadReportWithAllDimension(reportIdS);
        SumPlanParamConfig sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(reportList.get(0).getId());
        Map<Long, Report> mainReportCopyMap = this.sumToParentOrgDataPreDeal(sumPlanParamConfig, reportList);
        Map<Long, ReportChangeData> changeDataMap = changeReportList.stream().map(PlanChangeReport::getReportDataList).flatMap(Collection::stream).map(item -> (ReportChangeData)item).filter(item -> item.getOriginalReportDataId() != null && !item.getOriginalReportDataId().equals(0L)).filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.toMap(ReportChangeData::getOriginalReportDataId, Function.identity()));
        Map<Long, List<ReportChangeData>> changeDataNewMap = changeReportList.stream().map(PlanChangeReport::getReportDataList).flatMap(Collection::stream).map(item -> (ReportChangeData)item).filter(item -> item.getOriginalReportDataId() == null || item.getOriginalReportDataId().equals(0L)).filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.groupingBy(ReportChangeData::getOriginalReportId));
        this.reverseAdjustAmt2OriginalReportData(reportList, changeDataMap);
        this.reverseAdjustDim2OriginalReportData(reportList, changeDataMap);
        FpmContext fpmContext = FpmContext.get();
        FundPlanSystem fundPlanSystem = fpmContext.get("fundSystem") != null ? (FundPlanSystem)fpmContext.get("fundSystem") : this.dimensionRepository.loadSystem(changeData.getSystemId());
        Dimension subject = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        Set subjectIds = subject.getAllDimMemberList().stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection()) && accountMember.getPeriodDirection().isBeginning()).map(DimMember::getId).collect(Collectors.toSet());
        boolean hasChangeBeginPeriod = changeReportList.stream().map(PlanChangeReport::getReportDataList).flatMap(Collection::stream).anyMatch(i -> {
            Object subjectIdObj = i.getDimValByDimType(DimensionType.SUBJECTS);
            return EmptyUtil.isNoEmpty((Object)subjectIdObj) && subjectIds.contains((Long)subjectIdObj);
        });
        for (Report report : reportList) {
            List<ReportChangeData> reportChangeDataList = changeDataNewMap.get(report.getId());
            if (EmptyUtil.isEmpty(reportChangeDataList)) continue;
            if (report.getTemplate().getTemplateType() == TemplateType.DETAIL) {
                Pair colPair;
                HashMap<Object, Integer> dimValAndColMap = new HashMap<Object, Integer>(16);
                List<TemplateDim> colDimList = report.getTemplate().getColDimList();
                Optional<TemplateDim> expandOpt = colDimList.stream().filter(TemplateDim::isExpand).findFirst();
                if (expandOpt.isPresent()) {
                    TemplateDim templateDim = expandOpt.get();
                    this.fillTemplateExpendDimColSequence(templateDim, report, dimValAndColMap);
                    colPair = Pair.of((Object)templateDim, dimValAndColMap);
                } else {
                    Optional<TemplateDim> planAmtOpt = colDimList.stream().filter(item -> item.getDetailDimType() == DetailDimType.PLAN_AMOUNT).findFirst();
                    if (!planAmtOpt.isPresent()) {
                        return FpmOperateResult.error(ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u8ba1\u5212\u91d1\u989d\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"PlanChangeBizServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
                    }
                    TemplateDim planAmtDim = planAmtOpt.get();
                    int sequence = this.calTemplateSequenceIfNeed(report.getTemplate(), planAmtDim);
                    dimValAndColMap.put(sequence, sequence);
                    colPair = Pair.of((Object)planAmtDim, dimValAndColMap);
                }
                Pair<List<Long>, Map<String, Integer>> detailReportPageDimListAndDataMaxRowMapPair = ReportHelper.getDetailReportPageDimListAndDataMaxRowMap(report, report.getTemplate(), fundPlanSystem);
                List pageDimIdList = (List)detailReportPageDimListAndDataMaxRowMapPair.getLeft();
                Map pageDataMaxRowMap = (Map)detailReportPageDimListAndDataMaxRowMapPair.getRight();
                HashMap<String, Integer> pageRowOffsetMap = new HashMap<String, Integer>(4);
                HashMap<String, Integer> pagePreChangeDataRowMap = new HashMap<String, Integer>(4);
                HashMap<Long, Integer> pageDimIdIdxMap = new HashMap<Long, Integer>(4, 1.0f);
                reportChangeDataList.sort(Comparator.comparingInt(ReportData::getRow));
                for (ReportChangeData item2 : reportChangeDataList) {
                    this.rebuildDetailReportChangeDataRowIfAudit(item2, pageDimIdList, pageDataMaxRowMap, pageRowOffsetMap, pageDimIdIdxMap, pagePreChangeDataRowMap);
                    if (((TemplateDim)colPair.getLeft()).getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                        Map right = (Map)colPair.getRight();
                        Map.Entry next = right.entrySet().iterator().next();
                        item2.setCol((Integer)next.getValue());
                    } else {
                        Object dimVal = item2.getDimValByDimType(((TemplateDim)colPair.getLeft()).getDimType(), ((TemplateDim)colPair.getLeft()).getDetailDimType());
                        item2.setCol((Integer)((Map)colPair.getRight()).get(dimVal));
                    }
                    item2.setPlanAmt(item2.getAdjustedPlanAmt());
                    item2.setOriginalPlanAmt(item2.getAdjustedPlanAmt());
                    item2.setDirty(Boolean.TRUE);
                }
            } else if (report.getTemplate().getTemplateType() == TemplateType.FIXED) {
                reportChangeDataList.forEach(item -> {
                    item.setPlanAmt(item.getAdjustedPlanAmt());
                    item.setOriginalPlanAmt(item.getAdjustedPlanAmt());
                    item.setDirty(Boolean.TRUE);
                });
            }
            report.getReportDataList().addAll(reportChangeDataList);
        }
        FpmOperateResult<Void> adjustFormulaAndSummarySubjectResult = this.adjustFormulaAndSummarySubjectReportData(reportList, changeReportList, fundPlanSystem);
        if (!adjustFormulaAndSummarySubjectResult.isSuccess()) {
            return FpmOperateResult.error(adjustFormulaAndSummarySubjectResult.getMessageList());
        }
        this.rebuildAdjustedReportData(reportList, fundPlanSystem);
        FpmOperateResult<List<Long>> sumResult = this.sumToParentOrgData(reportList, mainReportCopyMap, sumPlanParamConfig, fundPlanSystem);
        if (!sumResult.isSuccess()) {
            return FpmOperateResult.error(sumResult.getMessageList());
        }
        Set reportIds = reportList.stream().map(Report::getId).collect(Collectors.toSet());
        reportIds.addAll((Collection)sumResult.getData());
        this.reportDataSaveService.batchUpdateReport(reportList);
        if (hasChangeBeginPeriod) {
            return FpmOperateResult.success(reportIdS);
        }
        return FpmOperateResult.success();
    }

    private FpmOperateResult<List<Long>> sumToParentOrgData(List<Report> adjustedReportList, Map<Long, Report> unAdjustReportMap, SumPlanParamConfig sumPlanParamConfig, FundPlanSystem fundPlanSystem) {
        if (sumPlanParamConfig == null) {
            return FpmOperateResult.success(new ArrayList(0));
        }
        OrgMember orgMember = adjustedReportList.get(0).getCompanyMemberList().get(0);
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        Map configInfoMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
        Long currOrgMemberId = orgMember.getId();
        LinkedList<Long> allParentSumOrgMemberIdList = new LinkedList<Long>();
        while (Objects.nonNull(configInfoMap.get(currOrgMemberId)) && EmptyUtil.isNoEmpty((Long)((SumPlanParamConfigInfo)configInfoMap.get(currOrgMemberId)).getParentId())) {
            Long currParentOrgMemberId = ((SumPlanParamConfigInfo)configInfoMap.get(currOrgMemberId)).getParentId();
            if (configInfoMap.containsKey(currParentOrgMemberId) && ((SumPlanParamConfigInfo)configInfoMap.get(currParentOrgMemberId)).isSumAuditNode()) {
                allParentSumOrgMemberIdList.add(currParentOrgMemberId);
            }
            currOrgMemberId = currParentOrgMemberId;
        }
        if (EmptyUtil.isEmpty(allParentSumOrgMemberIdList)) {
            return FpmOperateResult.success(new ArrayList(0));
        }
        List adjustedMainReportList = adjustedReportList.stream().filter(report -> report.getTemplate().isMainTable()).collect(Collectors.toList());
        ArrayList<Report> waitDealMainReportList = new ArrayList<Report>(adjustedMainReportList.size());
        for (Report adjustedReport : adjustedMainReportList) {
            Report dealReport = unAdjustReportMap.get(adjustedReport.getId());
            Map reportDataMapBeforeAdjust = dealReport.getReportDataList().stream().collect(Collectors.toMap(ReportData::getId, Function.identity(), (a, b) -> a));
            LinkedList<ReportData> adjustDiffReportDataList = new LinkedList<ReportData>();
            for (ReportData adjustedReportData : adjustedReport.getReportDataList()) {
                if (adjustedReportData.isAuxiliaryInfo()) continue;
                if (!reportDataMapBeforeAdjust.containsKey(adjustedReportData.getId())) {
                    adjustedReportData.setDirty(Boolean.TRUE);
                    adjustDiffReportDataList.add(adjustedReportData);
                    continue;
                }
                ReportData dealReportData = (ReportData)reportDataMapBeforeAdjust.get(adjustedReportData.getId());
                BigDecimal adjustAmt = adjustedReportData.getPlanAmt().subtract(dealReportData.getPlanAmt());
                if (NumberUtils.equalsZero((BigDecimal)adjustAmt)) continue;
                dealReportData.setPlanAmt(adjustAmt);
                dealReportData.setDirty(Boolean.TRUE);
                adjustDiffReportDataList.add(dealReportData);
            }
            if (adjustDiffReportDataList.isEmpty()) continue;
            dealReport.setReportDataList(adjustDiffReportDataList);
            waitDealMainReportList.add(dealReport);
        }
        if (EmptyUtil.isEmpty(waitDealMainReportList)) {
            return FpmOperateResult.success(new ArrayList(0));
        }
        PeriodMember periodMember = adjustedReportList.get(0).getPeriodMemberList().get(0);
        LinkedList sumReportIds = new LinkedList();
        ReportQDTO reportQDTO = new ReportQDTO();
        reportQDTO.setReportOrgIdList(allParentSumOrgMemberIdList);
        reportQDTO.setReportPeriodId(periodMember.getId());
        reportQDTO.setReportPlanType(ReportPlanType.SUMPLAN);
        List<Report> reportList = this.reportRepository.loadSimpleReport(reportQDTO, propDTO -> {
            propDTO.setNeedTemplate(true);
            propDTO.setNeedCompanyMember(true);
            propDTO.setNeedPeriodMember(true);
        });
        Map<Long, List<Report>> reportMap = reportList.stream().collect(Collectors.groupingBy(d -> d.getCompanyMemberList().get(0).getId()));
        for (Long parentOrgMemberId : allParentSumOrgMemberIdList) {
            List<Report> sumPlanReportList = reportMap.get(parentOrgMemberId);
            if (EmptyUtil.isEmpty(sumPlanReportList)) continue;
            LinkedList<SumPlanUpdateInfo> sumPlanUpdateInfoList = new LinkedList<SumPlanUpdateInfo>();
            for (Report report2 : sumPlanReportList) {
                FpmOperateResult<SumPlanUpdateInfo> upperSumResult = this.sumPlanService.sumPlanReportChangeUpper(waitDealMainReportList, (SumPlanReport)report2, fundPlanSystem);
                if (!upperSumResult.isSuccess()) {
                    return FpmOperateResult.error(upperSumResult.getMessageList());
                }
                sumPlanUpdateInfoList.add(upperSumResult.getData());
            }
            sumPlanUpdateInfoList.forEach(this::updateParentOrgSumData);
            sumPlanUpdateInfoList.stream().map(SumPlanUpdateInfo::getSumPlanReport).map(Report::getId).forEach(sumReportIds::add);
        }
        return FpmOperateResult.success(sumReportIds);
    }

    private void updateParentOrgSumData(SumPlanUpdateInfo sumPlanUpdateInfo) {
        if (Objects.isNull(sumPlanUpdateInfo)) {
            return;
        }
        List<ReportData> updateReportDataList = sumPlanUpdateInfo.getUpdateReportDataList();
        logger.info("\u5f00\u59cb\u66f4\u65b0\u9700\u8981\u66f4\u65b0\u7684\u7f16\u5236\u6570\u636e\uff1a{}\u6761", (Object)updateReportDataList.size());
        FpmOperateResult<UpdateResult> updateResult = this.iDataSaveService.update(IDataSaveService.Constants.SUM_REPORT_REPORT_DATA_UPDATE_BY_ADJUST, updateReportDataList, (t, d) -> {
            d.add(t.getPlanAmt());
            d.add(t.getId());
        });
        if (!updateResult.isSuccess()) {
            throw new KDBizException(updateResult.getMessageList().stream().collect(Collectors.joining(";")));
        }
        if (Objects.nonNull(sumPlanUpdateInfo.getSumPlanReport())) {
            SumPlanReport sumPlanReport = sumPlanUpdateInfo.getSumPlanReport();
            logger.info("\u5f00\u59cb\u66f4\u65b0sourceId\u6570\u636e:{}\u6761", (Object)sumPlanUpdateInfo.getSaveSourceIdEntryDataSet().size());
            this.iDataSaveService.saveEntryDataThrow(new ArrayList<SourceIdEntryData>(sumPlanUpdateInfo.getSaveSourceIdEntryDataSet()), sumPlanReport.getId());
            List<ReportData> saveReportDataList = sumPlanUpdateInfo.getSaveReportDataList();
            logger.info("\u5f00\u59cb\u4fdd\u5b58\u7f16\u5236\u6570\u636e:{}\u6761", (Object)saveReportDataList.size());
            ArrayList<MainEntryReportData> mainEntryReportDataList = new ArrayList<MainEntryReportData>(saveReportDataList.size());
            ArrayList<DetailEntryReportData> detailEntryReportDataList = new ArrayList<DetailEntryReportData>(saveReportDataList.size());
            for (ReportData reportData : saveReportDataList) {
                MainEntryReportData mainEntryReportData = new MainEntryReportData(reportData);
                mainEntryReportData.setId(reportData.getId());
                mainEntryReportData.setSystemId(sumPlanReport.getSystemId());
                mainEntryReportDataList.add(mainEntryReportData);
                DetailEntryReportData detailEntryReportData = new DetailEntryReportData(reportData);
                detailEntryReportData.setId(reportData.getId());
                detailEntryReportDataList.add(detailEntryReportData);
            }
            this.iDataSaveService.saveEntryDataThrow(mainEntryReportDataList, sumPlanReport.getId());
            this.iDataSaveService.saveEntryDataThrow(detailEntryReportDataList, sumPlanReport.getId());
        }
    }

    private FpmOperateResult<Void> formulaCalcHandle(Report report, FundPlanSystem fundPlanSystem) {
        FpmContext.get().put("dimMetric", EnumSet.of(TemplateMetricType.PLANAMT));
        this.reportService.calculateReport(report, fundPlanSystem);
        return FpmOperateResult.success();
    }

    private void populateReportDataList(Collection<PlanChangeRecord> records) {
        Set<Long> reportIds = records.stream().flatMap(record -> record.getOriginalReportIdList().stream()).collect(Collectors.toSet());
        List<Report> reports = this.reportRepository.loadReport(reportIds);
        Map reportMap = reports.stream().collect(Collectors.toMap(Report::getId, Function.identity()));
        for (PlanChangeRecord record2 : records) {
            List<PlanChangeReport> changeReportList = record2.getChangeReportList();
            for (PlanChangeReport planChangeReport : changeReportList) {
                this.service.changeDataBuildByRD(planChangeReport, (Report)reportMap.get(planChangeReport.getReportId()));
            }
        }
    }

    private void fillSubjectFlowMapIfEmpty(ReportTemplate template, Map<FlowType, Set<Long>> subjectFlowMap, FundPlanSystem fundPlanSystem) {
        if (Objects.isNull(subjectFlowMap)) {
            return;
        }
        if (!subjectFlowMap.isEmpty()) {
            return;
        }
        if (Objects.isNull(template)) {
            return;
        }
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        if (EmptyUtil.isEmpty(allTemplateDim)) {
            return;
        }
        Optional<TemplateDim> first = allTemplateDim.stream().filter(templateDim -> templateDim.getDimType() == DimensionType.SUBJECTS).findFirst();
        if (!first.isPresent()) {
            return;
        }
        List<DimMember> allDimMemberList = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS).getMemberList();
        this.fillSubjectFlowMap(subjectFlowMap, allDimMemberList);
    }

    private void fillSubjectFlowMap(Map<FlowType, Set<Long>> subjectFlowMap, List<DimMember> allDimMemberList) {
        if (EmptyUtil.isEmpty(allDimMemberList)) {
            return;
        }
        for (DimMember dimMember : allDimMemberList) {
            AccountMember accountMember = (AccountMember)dimMember;
            Set subjectIds = subjectFlowMap.computeIfAbsent(accountMember.getFlowType(), key -> new HashSet(16));
            subjectIds.add(accountMember.getId());
            this.fillSubjectFlowMap(subjectFlowMap, accountMember.getChildren());
        }
    }

    private void fillTemplateExpendDimColSequence(TemplateDim templateDim, Report report, Map<Object, Integer> dimValAndColMap) {
        int sequence = this.calTemplateSequenceIfNeed(report.getTemplate(), templateDim);
        if (templateDim.getDimType() != DimensionType.PERIOD) {
            List<Long> memberScope = templateDim.getMemberScope();
            for (Long memberId : memberScope) {
                dimValAndColMap.put(memberId, sequence++);
            }
            return;
        }
        List<PeriodMember> currPeriodMemberList = report.getCurrentReportPeriodDetailIfHasDetail();
        for (PeriodMember periodMember : currPeriodMemberList) {
            dimValAndColMap.put(periodMember.getId(), sequence++);
        }
        boolean isRollContainsDetail = report.isRollContainsDetail();
        ArrayList rollPeriodMemberList = report.getPeriodMemberList().size() == 1 ? new ArrayList(0) : report.getPeriodMemberList().subList(1, report.getPeriodMemberList().size());
        boolean skip = false;
        boolean includeSubSum = templateDim.isIncludeSubSum();
        for (PeriodMember periodMember : rollPeriodMemberList) {
            if (isRollContainsDetail) {
                List detailPeriodMemberList = periodMember.getAllChildMember().stream().map(PeriodMember.class::cast).collect(Collectors.toList());
                sequence = includeSubSum ? sequence + 1 : sequence;
                for (PeriodMember detailPeriodMember : detailPeriodMemberList) {
                    dimValAndColMap.put(detailPeriodMember.getId(), sequence++);
                }
                continue;
            }
            sequence = includeSubSum && !skip ? sequence + 1 : sequence;
            skip = true;
            dimValAndColMap.put(periodMember.getId(), sequence++);
        }
    }

    private void rebuildDetailReportChangeDataRowIfAudit(ReportChangeData reportChangeData, List<Long> pageDimIdList, Map<String, Integer> pageDataMaxRowMap, Map<String, Integer> pageRowOffsetMap, Map<Long, Integer> pageDimIdIdxMap, Map<String, Integer> pagePreChangeDataRowMap) {
        ArrayList<Object> pageDimValList = new ArrayList<Object>(pageDimIdList.size());
        for (Long pageDimId : pageDimIdList) {
            Integer pageDimValIdx = pageDimIdIdxMap.computeIfAbsent(pageDimId, val -> {
                OptionalInt pageDimIdIdxOpt = IntStream.range(0, reportChangeData.getDimList().size()).filter(i -> {
                    Long dimId = reportChangeData.getDimList().get(i).getDimensionId();
                    return Objects.equals(dimId, pageDimId);
                }).findAny();
                return pageDimIdIdxOpt.getAsInt();
            });
            pageDimValList.add(reportChangeData.getDimValList().get(pageDimValIdx));
        }
        String pageDimValStrKey = pageDimValList.stream().map(String::valueOf).collect(Collectors.joining("#"));
        int currPageOldDataMaxRow = pageDataMaxRowMap.get(pageDimValStrKey);
        int rowOffset = pageRowOffsetMap.getOrDefault(pageDimValStrKey, 0);
        int preChangeDataRow = pagePreChangeDataRowMap.getOrDefault(pageDimValStrKey, -1);
        if (reportChangeData.getRow() != preChangeDataRow) {
            pageRowOffsetMap.put(pageDimValStrKey, ++rowOffset);
        }
        pagePreChangeDataRowMap.put(pageDimValStrKey, reportChangeData.getRow());
        reportChangeData.setRow(currPageOldDataMaxRow + rowOffset);
    }

    private void reverseAdjustAmt2OriginalReportData(List<Report> reportList, Map<Long, ReportChangeData> changeDataMap) {
        Set<Long> adjustedReportDataIdSet = changeDataMap.keySet();
        reportList.stream().map(Report::getReportDataList).flatMap(Collection::stream).filter(item -> adjustedReportDataIdSet.contains(item.getId())).forEach(reportData -> {
            ReportChangeData planChangeData = (ReportChangeData)changeDataMap.get(reportData.getId());
            reportData.setPlanAmt(reportData.getPlanAmt().add(planChangeData.getCurrentAdjustAmt()));
            reportData.setDirty(Boolean.TRUE);
        });
    }

    private void reverseAdjustDim2OriginalReportData(List<Report> reportList, Map<Long, ReportChangeData> changeDataMap) {
        Optional<Report> mainReportOpt = reportList.stream().filter(report -> report.getTemplate().isMainTable()).findAny();
        if (!mainReportOpt.isPresent()) {
            return;
        }
        for (ReportData reportData : mainReportOpt.get().getReportDataList()) {
            if (!changeDataMap.containsKey(reportData.getId())) continue;
            ReportChangeData changeData = changeDataMap.get(reportData.getId());
            DimensionInfoBean changeDataDimensionInfo = DimensionInfoHelper.getDimensionInfoBean(changeData);
            DimensionInfoBean reportDataDimensionInfo = DimensionInfoHelper.getDimensionInfoBean(reportData);
            if (changeDataDimensionInfo.getDimensionIdList().size() <= reportDataDimensionInfo.getDimensionIdList().size()) continue;
            reportData.setDimList(changeData.getDimList());
            reportData.setDimValList(changeData.getDimValList());
            reportData.setDirty(Boolean.TRUE);
        }
    }

    private void removeReportRollPeriodMemberIfNeed(PlanChangeRecord planChangeRecord) {
        if (planChangeRecord.getAdjustRollPeriod()) {
            return;
        }
        for (PlanChangeReport planChangeReport : planChangeRecord.getChangeReportList()) {
            TemplateDim templateDim2;
            List<Long> memberScope;
            ReportTemplate template;
            Optional<TemplateDim> first;
            List<PeriodMember> periodMemberList = planChangeReport.getPeriodMemberList();
            if (CollectionUtils.isNotEmpty(periodMemberList) && periodMemberList.size() > 1) {
                planChangeReport.setPeriodMemberList(Collections.singletonList(periodMemberList.get(0)));
            }
            if (!(first = (template = planChangeReport.getTemplate()).getAllTemplateDim().stream().filter(templateDim -> templateDim.getDimType() == DimensionType.PERIOD).findAny()).isPresent() || !CollectionUtils.isNotEmpty(memberScope = (templateDim2 = first.get()).getMemberScope()) || memberScope.size() <= 1) continue;
            templateDim2.setMemberScope(Collections.singletonList(memberScope.get(0)));
        }
    }

    private void removeReportRollPeriodDataIfNeed(PlanChangeRecord planChangeRecord, List<Report> originalReports) {
        Map originalReportMap = originalReports.stream().collect(Collectors.toMap(Report::getId, Function.identity(), (a, b) -> b));
        for (PlanChangeReport planChangeReport : planChangeRecord.getChangeReportList()) {
            Set<Long> allPeriodMemberIdSet = planChangeReport.getAllPeriodMemberIds();
            planChangeReport.getReportDataList().removeIf(rt -> {
                if (!(rt instanceof ReportChangeData)) {
                    return false;
                }
                if (rt.isAuxiliaryInfo()) {
                    return false;
                }
                Object periodMemberId = rt.getDimValByDimType(DimensionType.PERIOD);
                return !allPeriodMemberIdSet.contains(periodMemberId);
            });
            planChangeReport.calNewDataStartRowIfDetailTemplate(((Report)originalReportMap.get(planChangeReport.getReportId())).getReportDataList(), allPeriodMemberIdSet);
        }
    }

    private void resetReportDataRowValIfDetailTemplate(PlanChangeReport planChangeReport, FundPlanSystem system) {
        if (planChangeReport.getTemplate().getTemplateType() != TemplateType.DETAIL) {
            return;
        }
        boolean isPeriodTplExpand = planChangeReport.getTemplate().getColDimList().stream().filter(tpl -> tpl.getDimType().isPeriodDim()).anyMatch(TemplateDim::isExpand);
        int needResetDataMinRow = isPeriodTplExpand ? planChangeReport.getNewDataStartRow() : 1;
        QueryIndexInfo queryIndexInfo = QueryIndexInfoMapGenerator.buildReportDataIndex(planChangeReport.getReportDataList(), system, rd -> rd instanceof ReportChangeData && rd.getRow() >= needResetDataMinRow && EmptyUtil.isEmpty((Long)((ReportChangeData)rd).getOriginalReportDataId()));
        Pair<List<Long>, List<List<Long>>> pageDimAndValGroup = planChangeReport.getTemplate().buildPageDimAndValGroup();
        List pageDimIdList = (List)pageDimAndValGroup.getLeft();
        List pageDimValGroupList = (List)pageDimAndValGroup.getRight();
        for (List pageDimValList : pageDimValGroupList) {
            List pageDimValObjList = pageDimValList.stream().map(item -> item).collect(Collectors.toList());
            DimensionInfoBean pageDimInfoBean = DimensionInfoBean.of((List)pageDimIdList, pageDimValObjList);
            List<ReportData> pageReportDataList = queryIndexInfo.findList(pageDimInfoBean);
            if (CollectionUtils.isEmpty(pageReportDataList)) continue;
            TreeMap sortedMap = pageReportDataList.stream().collect(Collectors.groupingBy(ReportData::getRow, TreeMap::new, Collectors.toCollection(LinkedList::new)));
            int dataStartRow = planChangeReport.getNewDataStartRow();
            for (Map.Entry entry : sortedMap.entrySet()) {
                List dataList = (List)entry.getValue();
                for (ReportData data : dataList) {
                    data.setRow(dataStartRow);
                    data.setDirty(Boolean.TRUE);
                }
                ++dataStartRow;
            }
        }
    }

    private Map<Long, Report> sumToParentOrgDataPreDeal(SumPlanParamConfig sumPlanParamConfig, List<Report> unAdjustReportList) {
        if (sumPlanParamConfig == null || EmptyUtil.isEmpty(unAdjustReportList)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Report mainReport = unAdjustReportList.stream().filter(item -> item.getTemplate().isMainTable()).findAny().get();
        HashMap mainReportCopyMap = Maps.newHashMapWithExpectedSize((int)1);
        Report copy = mainReport.copyReportData();
        mainReportCopyMap.put(copy.getId(), copy);
        return mainReportCopyMap;
    }

    private FpmOperateResult<Void> adjustFormulaAndSummarySubjectReportData(List<Report> adjustingReports, List<PlanChangeReport> changeReportList, FundPlanSystem fundPlanSystem) {
        FpmOperateResult<Void> mainCalcHandleResult;
        Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        HashSet<Long> needCalcReportIdSet = new HashSet<Long>(changeReportList.size());
        for (PlanChangeReport planChangeReport : changeReportList) {
            boolean existFormulaAndSummaryChangeReportData;
            Set formulaAndSummarySubjectIdSet;
            boolean noneExistAdjustData;
            ReportTemplate template = planChangeReport.getTemplate();
            if (!template.getTemplateType().isFixed() || (noneExistAdjustData = planChangeReport.getReportDataList().stream().filter(ReportChangeData.class::isInstance).map(rd -> (ReportChangeData)rd).noneMatch(rd -> !rd.isAuxiliaryInfo())) || EmptyUtil.isEmpty(formulaAndSummarySubjectIdSet = template.getAccountSettings().stream().filter(item -> item.getInputType() == ReportInputType.FORMULA || item.getInputType() == ReportInputType.SUMMARY).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet())) || (existFormulaAndSummaryChangeReportData = planChangeReport.getReportDataList().stream().filter(ReportChangeData.class::isInstance).map(rd -> (ReportChangeData)rd).filter(rd -> !rd.isAuxiliaryInfo()).map(rd -> rd.getDimValByDimensionId(subjectDim.getId())).anyMatch(formulaAndSummarySubjectIdSet::contains))) continue;
            needCalcReportIdSet.add(planChangeReport.getReportId());
        }
        if (needCalcReportIdSet.isEmpty()) {
            return FpmOperateResult.success();
        }
        List subReportList = adjustingReports.stream().filter(item -> !item.getTemplate().isMainTable()).collect(Collectors.toList());
        for (Report subReport : subReportList) {
            FpmOperateResult<Void> calcHandle;
            if (!needCalcReportIdSet.contains(subReport.getId()) || subReport.getTemplate().getTemplateType() != TemplateType.FIXED || (calcHandle = this.formulaCalcHandle(subReport, fundPlanSystem)).isSuccess()) continue;
            return FpmOperateResult.error(calcHandle.getMessageList());
        }
        Report report = adjustingReports.stream().filter(item -> item.getTemplate().isMainTable()).findAny().get();
        if (needCalcReportIdSet.contains(report.getId()) && !(mainCalcHandleResult = this.formulaCalcHandle(report, fundPlanSystem)).isSuccess()) {
            return FpmOperateResult.error(mainCalcHandleResult.getMessageList());
        }
        return FpmOperateResult.success();
    }

    private int calTemplateSequenceIfNeed(ReportTemplate reportTemplate, TemplateDim templateDimOfAmt) {
        int amtCol = templateDimOfAmt.getSequence();
        if (TemplateInfoHelper.hasEnableSubjectFlow(reportTemplate)) {
            TemplateDim subjectTplDim = reportTemplate.getColDimList().stream().filter(tplDim -> tplDim.getDimType().isSubjectDim()).findAny().get();
            int subjectCol = subjectTplDim.getSequence();
            return subjectCol <= amtCol ? amtCol + 1 : amtCol;
        }
        return amtCol;
    }

    private void rebuildAdjustedReportData(List<Report> reportList, FundPlanSystem fundPlanSystem) {
        Optional<Report> mainReportOpt = reportList.stream().filter(report -> report.getTemplate().isMainTable()).findAny();
        reportList.sort(Comparator.comparing(report -> report.getTemplate().isMainTable()));
        for (Report report2 : reportList) {
            ReportTemplate subTemplate;
            Report mainReport;
            ReportTemplate parentTemplate;
            Map<Long, Set<Long>> childReportUnderAllSubjectOfMainReport;
            this.reportService.reBuildReportData(report2, fundPlanSystem, true);
            report2.getReportDataList().stream().filter(rd -> !rd.isEffectFlag()).forEach(rd -> rd.setEffectFlag(true));
            report2.setChangeStatus(ReportPlanChangeStatus.CHANGED);
            if (!mainReportOpt.isPresent() || report2.getTemplate().isMainTable() || !report2.getTemplate().getTemplateType().isFixed() || (childReportUnderAllSubjectOfMainReport = TemplateInfoHelper.getChildReportUnderAllSubjectOfMainReport(parentTemplate = (mainReport = mainReportOpt.get()).getTemplate(), subTemplate = report2.getTemplate())).isEmpty() || childReportUnderAllSubjectOfMainReport.values().stream().noneMatch(subjectIds -> subjectIds.size() > 1)) continue;
            Set detailInputSubjectIdSet = childReportUnderAllSubjectOfMainReport.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
            mainReport.getReportDataList().stream().filter(rd -> !rd.isAuxiliaryInfo()).filter(rd -> {
                Object subjectId = rd.getDimValByDimensionId(subjectDim.getId());
                return detailInputSubjectIdSet.contains(subjectId);
            }).forEach(rd -> {
                rd.setPlanAmt(BigDecimal.ZERO);
                rd.setDirty(Boolean.TRUE);
            });
            Dimension metricDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.METRIC);
            List<MetricMember> planAmtMetricList = metricDim.getAllDimMemberList().stream().map(item -> (MetricMember)item).filter(item -> item.getTemplateMetricType() == TemplateMetricType.PLANAMT).collect(Collectors.toList());
            this.reportService.sumToParent(mainReport, report2, fundPlanSystem, planAmtMetricList);
        }
    }
}

