/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.impl.AbstractControlExecuteStrategy;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class PreOccupyReleaseControlExecuteStrategy
extends AbstractControlExecuteStrategy {
    public PreOccupyReleaseControlExecuteStrategy(ControlContext controlContext) {
        super(controlContext);
    }

    @Override
    public void beforeDoControl() {
        List<ControlExecuteParam> controlExecuteParamList = this.controlContext.getControlExecuteParamList();
        Set bizBillIds = controlExecuteParamList.stream().map(ControlExecuteParam::getBillBizInfo).map(BillBizInfo::getBillId).collect(Collectors.toSet());
        Map<String, List<ControlTraceInfo>> controlTraceInfoMap = this.controlContext.getControlTraceInfoMap();
        Map<String, List<PlanExecuteRecord>> planExecuteRecordMap = controlTraceInfoMap.values().stream().filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(controlTraceInfo -> Objects.equals(controlTraceInfo.getEntityType(), this.controlContext.getEntityType())).filter(controlTraceInfo -> bizBillIds.contains(controlTraceInfo.getBillId())).map(ControlTraceInfo::getExecuteRecordList).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).filter(p -> p.getDeleteStatus() == false).filter(p -> p.getExecuteOpType() == PlanExecuteOpType.PRE_OCCUPY_WRITE).filter(p -> p.getUnReleaseAmt().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.groupingBy(p -> this.controlStrategyDelegate.getGroupKey(p.getBillBizInfo(), p.getMatchRuleId())));
        ArrayList<ControlExecuteParam> newParam = new ArrayList<ControlExecuteParam>(4);
        for (ControlExecuteParam controlExecuteParam : controlExecuteParamList) {
            String groupKey = this.controlStrategyDelegate.getGroupKey(controlExecuteParam.getBillBizInfo(), controlExecuteParam.getMatchRule());
            List planExecuteRecordList = planExecuteRecordMap.getOrDefault(groupKey, Collections.emptyList());
            if (EmptyUtil.isEmpty(planExecuteRecordList)) continue;
            this.fillMatchInfo(controlExecuteParam, (PlanExecuteRecord)planExecuteRecordList.get(0));
            for (int i = 1; i < planExecuteRecordList.size(); ++i) {
                ControlExecuteParam copy = controlExecuteParam.copy();
                this.fillMatchInfo(copy, (PlanExecuteRecord)planExecuteRecordList.get(i));
                newParam.add(copy);
            }
        }
        controlExecuteParamList.addAll(newParam);
        controlExecuteParamList.removeIf(next -> Objects.isNull(next.getOriginalPlanExecuteRecord()));
    }

    private void fillMatchInfo(ControlExecuteParam controlExecuteParam, PlanExecuteRecord planExecuteRecord) {
        this.controlStrategyDelegate.fillMatchInfo(controlExecuteParam, planExecuteRecord);
        controlExecuteParam.setActAmount(planExecuteRecord.getUnReleaseAmt().negate(), true);
    }
}

