/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.control.factory.RelateReportDataManagerFactory;

public class RelateReportDataDiffManager {
    private List<ReportData> sourceReportData;
    private Set<Long> sourceReportDataIds;
    private List<ControlAmountCache.AmountInfo> amountInfoList;
    private boolean needCalculate;
    private IRelateReportDataManager relateReportDataManager;

    public RelateReportDataDiffManager(List<ReportData> sourceReportData, List<ControlAmountCache.AmountInfo> amountInfoList) {
        this(sourceReportData, amountInfoList, null);
    }

    public RelateReportDataDiffManager(List<ReportData> sourceReportData, List<ControlAmountCache.AmountInfo> amountInfoList, IRelateReportDataManager relateReportDataManager) {
        this.sourceReportData = sourceReportData;
        this.amountInfoList = amountInfoList;
        if (EmptyUtil.isEmpty(sourceReportData)) {
            return;
        }
        this.sourceReportDataIds = sourceReportData.stream().map(ReportData::getId).collect(Collectors.toSet());
        this.relateReportDataManager = RelateReportDataManagerFactory.getUpdateRelateReportDataManager(sourceReportData, relateReportDataManager);
        this.needCalculate = true;
    }

    public ControlAmountCache getReCalculateDagControlAmountCache() {
        ControlAmountCache controlAmountCache = new ControlAmountCache();
        if (!this.needCalculate) {
            return controlAmountCache;
        }
        List<ReportData> reportDataList = this.resetData(controlAmountCache);
        List<ReportData> updatedReportDataList = this.relateReportDataManager.reCalculateRelateDataByDAGAndCompletionIndex(reportDataList);
        for (ReportData updatedReportData : updatedReportDataList) {
            controlAmountCache.updateActAmount(updatedReportData.getId(), updatedReportData.getHoldActAmt());
            controlAmountCache.updateLockAmount(updatedReportData.getId(), updatedReportData.getHoldLockAmt());
        }
        return controlAmountCache;
    }

    private List<ReportData> resetData(ControlAmountCache controlAmountCache) {
        List<ReportData> relateReportDataListBySource = this.relateReportDataManager.getRelateReportDataListBySourceCanDiff(this.sourceReportData);
        relateReportDataListBySource.addAll(this.sourceReportData);
        relateReportDataListBySource.stream().collect(Collectors.groupingBy(ReportData::getSystemId)).entrySet().forEach(entry -> controlAmountCache.init((List)entry.getValue(), (Long)entry.getKey()));
        Map amountInfoMap = this.amountInfoList.stream().collect(Collectors.toMap(ControlAmountCache.AmountInfo::getReportDataId, Function.identity(), (a, b) -> a));
        HashSet<Long> distinct = new HashSet<Long>(relateReportDataListBySource.size());
        for (ReportData reportData : relateReportDataListBySource) {
            ControlAmountCache.AmountInfo amountInfo;
            if (!distinct.add(reportData.getId())) continue;
            BigDecimal planAmt = reportData.getPlanAmt();
            reportData.clearAmt();
            reportData.setPlanAmt(planAmt);
            Long reportDataId = reportData.getId();
            if (!this.sourceReportDataIds.contains(reportDataId) || EmptyUtil.isEmpty((Object)(amountInfo = (ControlAmountCache.AmountInfo)amountInfoMap.get(reportDataId)))) continue;
            reportData.setHoldLockAmt(amountInfo.getLockDiffAmt());
            reportData.setHoldActAmt(amountInfo.getActDiffAmt());
        }
        return relateReportDataListBySource;
    }
}

