/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IMatchRuleBizBillQueryService;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.MatchRuleBizBillQParam;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.IInOutCollectSaveService;
import kd.tmc.fpm.business.dataproc.save.IReportDataSaveService;
import kd.tmc.fpm.business.dataproc.save.ISyncShrekReportDataService;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.ApplyStatus;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MatchPropType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportOpType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.SumPlanSumType;
import kd.tmc.fpm.business.domain.enums.TaskStatus;
import kd.tmc.fpm.business.domain.enums.TaskType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateSmartGetValSetType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.formula.ReportTreeNodeFormulaManager;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.MappingInfo;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.inoutpool.InoutCollect;
import kd.tmc.fpm.business.domain.model.report.MetricHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportGenerateInfo;
import kd.tmc.fpm.business.domain.model.report.ReportPrepare;
import kd.tmc.fpm.business.domain.model.report.ReportUniqueCondition;
import kd.tmc.fpm.business.domain.model.report.ReportWorkCalendar;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanUpdateInfo;
import kd.tmc.fpm.business.domain.model.task.TaskRecord;
import kd.tmc.fpm.business.domain.model.template.AuxiliaryField;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.domain.service.ISumPlanService;
import kd.tmc.fpm.business.helper.FpmAsyncCalculateHelper;
import kd.tmc.fpm.business.helper.MatchRuleHelper;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.helper.SumPlanRelationHelper;
import kd.tmc.fpm.business.helper.TemplateInfoHelper;
import kd.tmc.fpm.business.mq.TMCMQPublisher;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IInoutCollectRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.SumPlanDataService;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateService;
import kd.tmc.fpm.business.mvc.service.calculate.ReportCalculateServiceFactory;
import kd.tmc.fpm.business.mvc.service.dto.RecalculateReportPlanAmtParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportCalculateDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportQueryParamDTO;
import kd.tmc.fpm.business.mvc.service.seqtask.TaskHandleService;
import kd.tmc.fpm.business.mvc.service.seqtask.impl.TaskHandleServiceImpl;
import kd.tmc.fpm.business.provider.BaseDataByNameProvider;
import kd.tmc.fpm.business.provider.DimMappingBaseDataProvider;
import kd.tmc.fpm.business.service.smart.getval.service.mapping.strategy.DimMemberMappingStrategy;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.business.utils.WorkCalenderLoadUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.bean.FpmContext;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;
import kd.tmc.fpm.common.enums.ReportPlanStatusEnum;
import kd.tmc.fpm.common.property.ReportProp;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.AmountUtil;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ReportBizService
implements IReportBizService {
    private static Log logger = LogFactory.getLog(ReportBizService.class);
    private IDimensionRepository dimRepo = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private IReportRepository reportRepo = FpmServiceFactory.getBizService(IReportRepository.class);
    private ITemplateRepository tempRepo = FpmServiceFactory.getBizService(ITemplateRepository.class);
    private IReportService reportService = FpmServiceFactory.getBizService(IReportService.class);
    private IReportDataQueryService reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
    private IReportDataSaveService reportDataSaveService;
    private IInoutCollectRepository inoutCollectRep = FpmServiceFactory.getBizService(IInoutCollectRepository.class);
    private ISumPlanRepository sumPlanRepository = FpmServiceFactory.getBizService(ISumPlanRepository.class);
    private ISumPlanService sumPlanService = FpmServiceFactory.getBizService(ISumPlanService.class);
    private IDataSaveService dataSaveService;
    private ISyncShrekReportDataService shrekReportDataService;
    private SumPlanDataService sumPlanDataService;
    private TaskHandleService taskHandleService;
    private ReportCalculateService scopeCalculateService;
    private IMatchRuleBizBillQueryService matchRuleBizBillQueryService;
    private IInOutCollectSaveService iInOutCollectSaveService;

    public ReportBizService() {
        this.reportDataSaveService = FpmServiceFactory.getBizService(IReportDataSaveService.class);
        this.dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
        this.shrekReportDataService = FpmServiceFactory.getBizService(ISyncShrekReportDataService.class);
        this.sumPlanDataService = FpmServiceFactory.getBizService(SumPlanDataService.class);
        this.taskHandleService = new TaskHandleServiceImpl();
        this.scopeCalculateService = ReportCalculateServiceFactory.getScopeService();
        this.matchRuleBizBillQueryService = FpmServiceFactory.getBizService(IMatchRuleBizBillQueryService.class);
        this.iInOutCollectSaveService = FpmServiceFactory.getBizService(IInOutCollectSaveService.class);
    }

    /*
     * Exception decompiling
     */
    @Override
    public FpmOperateResult<List<Long>> generateReportByPrepareId(Long prepareId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void filterReportGenerateInfoList(BitMap<Long, Long> bitMap, List<ReportGenerateInfo> reportGenerateInfoList, FpmOperateResult<List<Long>> result, FundPlanSystem system) {
        if (bitMap.isEmpty()) {
            return;
        }
        Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
        Map dimMemberMap = orgDim.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        Map periodMemberMap = periodDim.getAllDimMemberList().stream().map(PeriodMember.class::cast).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        LinkedHashSet<String> periodNames = new LinkedHashSet<String>(16);
        LinkedHashSet<String> sumOrgNames = new LinkedHashSet<String>(16);
        Iterator<ReportGenerateInfo> iterator = reportGenerateInfoList.iterator();
        while (iterator.hasNext()) {
            Long periodMemberId;
            ReportGenerateInfo reportGenerateInfo = iterator.next();
            Long reportOrgId = reportGenerateInfo.getReportOrgId();
            Set<Long> keys = ListHelper.asSet(reportOrgId, periodMemberId = reportGenerateInfo.getPeriodMemberId());
            Long one = bitMap.findOne(keys);
            if (one == null) continue;
            periodNames.add(((PeriodMember)periodMemberMap.get(periodMemberId)).getName());
            sumOrgNames.add(((DimMember)dimMemberMap.get(reportOrgId)).getName());
            iterator.remove();
        }
        if (EmptyUtil.isNoEmpty(periodNames) && EmptyUtil.isNoEmpty(sumOrgNames)) {
            String message = String.format(ResManager.loadKDString((String)"%1$s\u5f53\u671f\u5b58\u5728\u5df2\u751f\u6548\u7684\u4e0b\u7ea7\u7f16\u62a5\u4e3b\u4f53\u8d44\u91d1\u8ba1\u5212\u5355\u636e\uff0c\u6682\u4e0d\u751f\u6210\u6c47\u603b\u4e3b\u4f53\u201c%2$s\u201d\u7684\u6c47\u603b\u5355\u636e\u3002", (String)"ReportBizService_20", (String)"tmc-fpm-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", periodNames), String.join((CharSequence)"\u3001", sumOrgNames));
            result.setWarnMessage(message);
        }
    }

    private BitMap<Long, Long> queryEffectedDownReport(List<ReportTemplate> templateList, SumPlanParamConfig sumPlanParamConfig, FundPlanSystem system, List<PeriodMember> finalReportPeriodMemList) {
        BitMap<Long, Long> bitMap = new BitMap<Long, Long>(16);
        if (sumPlanParamConfig == null) {
            return bitMap;
        }
        if (EmptyUtil.isEmpty(finalReportPeriodMemList)) {
            return bitMap;
        }
        List sumPlanReportTemplateList = templateList.stream().filter(reportTemplate -> reportTemplate.getTemplateUse().isSummary()).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(sumPlanReportTemplateList)) {
            return bitMap;
        }
        Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
        Map dimMemberMap = orgDim.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        HashMap<Long, Set<Long>> childParentOrgIdMap = new HashMap<Long, Set<Long>>(16);
        Set<Long> reportPeriodIds = finalReportPeriodMemList.stream().map(DimMember::getId).collect(Collectors.toSet());
        Map sumPlanParamConfigInfoMap = sumPlanParamConfig.getConfigInfoList().stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
        for (ReportTemplate sumPlanReportTemplate : sumPlanReportTemplateList) {
            List<Long> userIdList = sumPlanReportTemplate.getUserIdList();
            if (EmptyUtil.isEmpty(userIdList)) continue;
            for (Long userId : userIdList) {
                DimMember orgMember;
                SumPlanParamConfigInfo sumPlanParamConfigInfo = (SumPlanParamConfigInfo)sumPlanParamConfigInfoMap.get(userId);
                if (!sumPlanParamConfigInfo.isSumAuditNode() || (orgMember = (DimMember)dimMemberMap.get(userId)) == null) continue;
                orgMember.getAllChildMember().stream().map(DimMember::getId).forEach(cId -> childParentOrgIdMap.computeIfAbsent((Long)cId, k -> new HashSet(16)).add(orgMember.getId()));
            }
        }
        return this.getEffectedReportBitMap(childParentOrgIdMap, reportPeriodIds);
    }

    private BitMap<Long, Long> getEffectedReportBitMap(Map<Long, Set<Long>> childParentOrgIdMap, Set<Long> reportPeriodIds) {
        String selectFields = String.join((CharSequence)",", "id", "reportperiod", "reportorg");
        Set<Long> allChildren = childParentOrgIdMap.keySet();
        String mainTableProp = String.join((CharSequence)".", "template", "ismaintable");
        String reportPlanUse = String.join((CharSequence)".", "template", "templateuses");
        QFilter qFilter = new QFilter("reportorg", "in", allChildren).and(new QFilter("reportperiod", "in", reportPeriodIds)).and(new QFilter(mainTableProp, "=", (Object)true)).and(new QFilter(reportPlanUse, "=", (Object)TemplateUseType.PLANING.getNumber())).and(new QFilter("planstatus", "=", (Object)ReportPlanStatusEnum.EFFECTIVE.getValue()));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        BitMap<Long, Long> bitMap = new BitMap<Long, Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            long reportId = dynamicObject.getLong("id");
            long reportPeriodId = dynamicObject.getLong("reportperiod");
            long reportOrgId = dynamicObject.getLong("reportorg");
            HashSet<Long> parentOrgIds = new HashSet<Long>(childParentOrgIdMap.getOrDefault(reportOrgId, Collections.emptySet()));
            parentOrgIds.add(reportPeriodId);
            bitMap.addValue(parentOrgIds, (Long)reportId);
        }
        return bitMap;
    }

    private Date getStartDateEnd(ReportPrepare prepare, Date nextYear, ReportWorkCalendar workCalendar) {
        Date nowDate;
        Date startDateEnd = nowDate = new Date();
        if (workCalendar != null && workCalendar.getStartDate() != null && workCalendar.getCalendarSet() != null && workCalendar.getCalendarSet().size() > 0) {
            Set<Date> calendarSet = workCalendar.getCalendarSet();
            int index = 0;
            while (index < prepare.getStartDateDay()) {
                if (startDateEnd.compareTo(nextYear) > 0) {
                    startDateEnd = DateUtils.getNextDay((Date)startDateEnd, (int)(prepare.getStartDateDay() - index - 1));
                    break;
                }
                startDateEnd = DateUtils.getNextDay((Date)startDateEnd, (int)1);
                if (calendarSet.size() <= 0 || !calendarSet.contains(startDateEnd)) continue;
                ++index;
            }
        } else {
            startDateEnd = DateUtils.getNextDay((Date)nowDate, (int)prepare.getStartDateDay());
        }
        return startDateEnd;
    }

    private ReportWorkCalendar getWorkCalendar(Map<Long, ReportWorkCalendar> reportWorkCalendarMap, DimMember orgMember, Date dateFrom, Date dateTo) {
        if (orgMember == null) {
            return null;
        }
        Long sourceId = orgMember.getSourceId();
        if (reportWorkCalendarMap.containsKey(sourceId)) {
            return reportWorkCalendarMap.get(sourceId);
        }
        if (!WorkCalenderLoadUtils.existCalendar(sourceId)) {
            return null;
        }
        ReportWorkCalendar reportWorkCalendar = WorkCalenderLoadUtils.loadWorkCalendar(orgMember, dateFrom, dateTo);
        reportWorkCalendarMap.put(orgMember.getSourceId(), reportWorkCalendar);
        return reportWorkCalendar;
    }

    private List<SumPlanRecord> buildSumPlanRecord(List<Report> reportList, FundPlanSystem system, Map<Long, ReportTemplate> backTemplateMap) {
        List sumPlanReportList = reportList.stream().filter(item -> item.getReportPlanType() == ReportPlanType.SUMPLAN).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sumPlanReportList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        long[] newIdS = DB.genLongIds((String)"fpm_report", (int)sumPlanReportList.size());
        for (int i = 0; i < sumPlanReportList.size(); ++i) {
            Report report = (Report)sumPlanReportList.get(i);
            report.setId(newIdS[i]);
        }
        List mainReportList = sumPlanReportList.stream().filter(item -> item.getTemplate().isMainTable()).collect(Collectors.toList());
        ArrayList<SumPlanRecord> sumPlanRecordList = new ArrayList<SumPlanRecord>(mainReportList.size());
        for (Report report : mainReportList) {
            ArrayList<Report> currSameReportList = new ArrayList<Report>(16);
            currSameReportList.add(report);
            ReportTemplate template = report.getTemplate();
            TemplateDim currencyTplDim = template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.CURRENCY).findFirst().get();
            List<ReportTemplate> statAnalysisTemplateList = template.getStatAnalysisTemplateList();
            List<Long> anaBakTplIdList = statAnalysisTemplateList.stream().map(item -> ((ReportTemplate)backTemplateMap.get(item.getId())).getId()).collect(Collectors.toList());
            int analysisSize = anaBakTplIdList.size();
            List<OrgMember> companyMemberList = report.getCompanyMemberList();
            List<PeriodMember> periodMemberList = report.getPeriodMemberList();
            Long reportPeriodId = periodMemberList.get(0).getId();
            Long reportOrgId = companyMemberList.get(0).getId();
            logger.info("\u5f53\u524d\u6c47\u603b\u4e3b\u8868\uff1aid:{}\uff0creportOrgId:{}\uff0creportPeriodId:{}", new Object[]{report.getId(), reportOrgId, reportPeriodId});
            currSameReportList.addAll(sumPlanReportList.stream().filter(item -> item.getParentTemplateId() != null && item.getParentTemplateId().equals(template.getCopyId()) && item.getCompanyMemberList().get(0).getId().equals(reportOrgId) && item.getPeriodMemberList().get(0).getId().equals(reportPeriodId)).collect(Collectors.toList()));
            logger.info("\u5f53\u524d\u6c47\u603b\u4e3b\u8868+\u5b50\u8868\u6570\u91cf\uff1a{}", (Object)currSameReportList.size());
            SumPlanRecord sumPlanRecord = new SumPlanRecord();
            sumPlanRecord.setSumPlanReportIdList(report.getPeriodMemberList().stream().map(DimMember::getId).collect(Collectors.toList()));
            sumPlanRecord.setSystemId(report.getSystemId());
            sumPlanRecord.setName(report.getName());
            sumPlanRecord.setReportStatus(ReportStatus.DISABLE);
            sumPlanRecord.setReportOrg(reportOrgId);
            sumPlanRecord.setReportType(periodMemberList.get(0).getPeriodTypeId());
            sumPlanRecord.setReportPeriod(reportPeriodId);
            sumPlanRecord.setOriginalReportIdList(currSameReportList.stream().map(Report::getId).collect(Collectors.toList()));
            sumPlanRecord.setSumPlanSumType(SumPlanSumType.REPORTPLAN);
            sumPlanRecord.setOrgId(reportOrgId);
            sumPlanRecord.setReportPeriodTypeId(report.getReportPeriodType().getReportPeriodId());
            sumPlanRecord.setReportPeriodId(reportPeriodId);
            sumPlanRecord.setCurrencyIdList(currencyTplDim.getMemberScope());
            sumPlanRecord.setReportCount(currSameReportList.size() + analysisSize);
            sumPlanRecord.setExchangeRateTableId(report.getExchangeRateTableId());
            sumPlanRecord.setRateDate(report.getExchangeRateDate());
            sumPlanRecord.setAmountUnit(template.getAmountUnit());
            sumPlanRecord.setSumPlanReportIdList(currSameReportList.stream().map(Report::getId).collect(Collectors.toList()));
            sumPlanRecord.setAttachtplIdList(anaBakTplIdList);
            sumPlanRecord.setDeclareStartDate(report.getStartDate());
            sumPlanRecord.setDeclareEndDate(report.getCloseDate());
            sumPlanRecord.setPeriodMemberIdList(report.getPeriodMemberList().stream().map(DimMember::getId).collect(Collectors.toList()));
            sumPlanRecordList.add(sumPlanRecord);
        }
        return sumPlanRecordList;
    }

    @Override
    public FpmOperateResult<Report> loadReport(Long reportId) {
        return this.loadReport(reportId, true, null);
    }

    @Override
    public FpmOperateResult<Report> loadReport(Long reportId, FundPlanSystem system, boolean isQueryRefData) {
        return this.loadReport(reportId, isQueryRefData, system);
    }

    @Override
    public FpmOperateResult<Report> loadReportContainRefData(Long reportId, FundPlanSystem system) {
        return this.loadReport(reportId, true, system);
    }

    private FpmOperateResult<Report> loadReport(Long reportId, boolean isQueryRefData, FundPlanSystem system) {
        try {
            boolean queryRefData;
            Report report = this.reportRepo.loadReport(reportId);
            if (system == null) {
                system = this.dimRepo.loadSystem(report.getSystemId());
            }
            logger.info("\u62a5\u8868\u521d\u59cb\u5316\u6807\u8bc6\uff0c{},{}", (Object)report.getId(), (Object)report.getInitFlag());
            FpmOperateResult<Report> rollDataResult = this.loadRollDataAndAutoPlanAmt(report, system);
            if (!rollDataResult.isSuccess()) {
                return FpmOperateResult.error(rollDataResult.getMessageList());
            }
            PeriodMember referencePeriodMember = report.getReferencePeriodMember();
            boolean bl = queryRefData = isQueryRefData && referencePeriodMember != null;
            if (queryRefData) {
                List<ReportData> reportData = this.loadReferencePeriodReportData(system, report);
                report.getReportDataList().addAll(reportData);
            }
            this.mergeDetailInputReportData(system, report);
            this.trySplitReportData(report, queryRefData);
            TemplateInfoHelper.addSubjectFlowColIfDetailTemplateNeed(report.getTemplate(), system);
            return FpmOperateResult.success(report);
        }
        catch (KDBizException kdBizException) {
            return FpmOperateResult.error(kdBizException.getMessage());
        }
    }

    private void trySplitReportData(Report report, boolean queryRefData) {
        if (report.needSplit()) {
            ReportTemplate template = report.getTemplate();
            ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(report.getReportDataList());
            List auxiliaryReportData = reportDataList.stream().filter(ReportData::isAuxiliaryInfo).collect(Collectors.toList());
            List reportData = reportDataList.stream().filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.toList());
            if (queryRefData) {
                List<ReportData> currentPeriodReportData = reportData.stream().filter(item -> !item.getDimValByDimType(DimensionType.PERIOD).equals(report.getReferencePeriodMember().getId())).collect(Collectors.toList());
                report.setReportDataList(currentPeriodReportData);
            }
            MetricValueUtils.splitMetric(report);
            if (queryRefData) {
                List<ReportData> refReportData = reportData.stream().filter(item -> item.getDimValByDimType(DimensionType.PERIOD).equals(report.getReferencePeriodMember().getId())).collect(Collectors.toList());
                List<Long> metricIdList = template.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportTypeId(), report.getReportPeriodType().getReportPeriodId())).map(TemplateReportType::getReferencePosList).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                List<ReportData> newReportDataList = MetricValueUtils.splitMetric(refReportData, report.getTemplate(), metricIdList);
                report.getReportDataList().addAll(newReportDataList);
            }
            report.getReportDataList().addAll(auxiliaryReportData);
        }
    }

    private void mergeDetailInputReportData(FundPlanSystem system, Report report) {
        if (!report.getTemplate().isMainTable()) {
            return;
        }
        ArrayList<ReportData> resultReportData = new ArrayList<ReportData>(report.getReportDataList());
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        DimensionIndexTree indexTree = report.getIndexTree(system);
        ReportTemplate template = report.getTemplate();
        List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
        Set detailInputSubjects = accountSettings.stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType()).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        List detailInputRdList = report.getReportDataList().stream().filter(item -> !item.isAuxiliaryInfo()).filter(item -> {
            Object subjectMemId = item.getDimValByDimensionId(subjectDim.getId());
            if (subjectMemId == null) {
                return false;
            }
            return detailInputSubjects.contains((Long)subjectMemId);
        }).collect(Collectors.toList());
        Set dimBeanList = detailInputRdList.stream().map(rd -> DimensionInfoHelper.getDimensionInfoBean(rd, template)).collect(Collectors.toSet());
        for (DimensionInfoBean dimensionInfoBean : dimBeanList) {
            TreeNode treeNode = indexTree.find(dimensionInfoBean);
            if (treeNode == null) {
                logger.info("ReportBizService treeNode is null");
                continue;
            }
            List<Object> dataList = treeNode.getDataList();
            if (CollectionUtils.isEmpty(dataList)) {
                logger.info("ReportBizService treeNode dataList is empty");
                continue;
            }
            ReportData sumReportData = new ReportData((ReportData)dataList.get(0));
            sumReportData.clearAmt();
            dataList.forEach(item -> {
                ReportData reportData = (ReportData)item;
                sumReportData.addPlanAmt(reportData.getPlanAmt());
                sumReportData.addActAmt(reportData.getActAmt());
                sumReportData.addLockAmt(reportData.getLockAmt());
                sumReportData.addPlanReferenceAmt(reportData.getPlanReferenceAmt());
                sumReportData.addReportPlanAmt(reportData.getReportPlanAmt());
                sumReportData.addOriginalPlanAmt(reportData.getOriginalPlanAmt());
                resultReportData.remove(reportData);
            });
            resultReportData.add(sumReportData);
        }
        report.setReportDataList(resultReportData);
        report.clearIndexTree();
    }

    private List<ReportData> loadReferencePeriodReportData(FundPlanSystem system, Report report) {
        ReportTemplate template = report.getTemplate();
        PeriodMember referencePeriodMember = report.getReferencePeriodMember();
        ReportQDTO reportQDTO = new ReportQDTO();
        reportQDTO.setReportOrgId(report.getCompanyMemberList().get(0).getId());
        reportQDTO.setBodySysId(system.getId());
        reportQDTO.setReportPeriodId(referencePeriodMember.getId());
        List<Report> reports = this.reportRepo.loadSimpleReport(reportQDTO, prop -> prop.setNeedTemplate(true));
        if (CollectionUtils.isEmpty(reports)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList reportIds = null;
        if (report.getTemplate().isMainTable()) {
            reportIds = reports.stream().filter(item -> item.getTemplate().isMainTable()).map(Report::getId).collect(Collectors.toList());
        } else {
            List subjectDim = report.getTemplate().getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).collect(Collectors.toList());
            Set subjectMemIds = subjectDim.stream().map(TemplateDim::getMemberScope).flatMap(Collection::stream).collect(Collectors.toSet());
            for (Report refReport : reports) {
                TemplateDim templateDim;
                boolean containsAll;
                Object subjectDimOp;
                if (refReport.getTemplate().isMainTable() || !((Optional)(subjectDimOp = refReport.getTemplate().getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst())).isPresent() || !(containsAll = (templateDim = ((Optional)subjectDimOp).get()).getMemberScope().containsAll(subjectMemIds))) continue;
                reportIds = Lists.newArrayList((Object[])new Long[]{refReport.getId()});
                break;
            }
        }
        if (CollectionUtils.isEmpty(reportIds)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ReportDataQueryObject queryDTO = new ReportDataQueryObject();
        queryDTO.setReportIdS(reportIds);
        queryDTO.setEffectFlag(true);
        queryDTO.setMainTable(report.getTemplate().isMainTable());
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(allTemplateDim.size() - 1);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(allTemplateDim.size() - 1);
        for (TemplateDim templateDim : allTemplateDim) {
            if (templateDim.getDimType() == DimensionType.PERIOD) continue;
            Dimension periodDim = system.getMainDimensionByDimType(templateDim.getDimType());
            dimIdList.add(periodDim);
            dimValList.add(new ArrayList<Long>(templateDim.getMemberScope()));
        }
        dimIdList.add(system.getMainDimensionByDimType(DimensionType.PERIOD));
        ArrayList<Long> periodValList = new ArrayList<Long>(1);
        periodValList.add(referencePeriodMember.getId());
        dimValList.add(periodValList);
        this.addCustomMemberIfNeed(dimIdList, dimValList);
        queryDTO.setReportPeriodId(referencePeriodMember.getId());
        queryDTO.setDimIdList(dimIdList);
        queryDTO.setDimValList(dimValList);
        queryDTO.setNeedDimIfValueIsNotEmpty(true);
        List<ReportDataQueryResult> resultList = this.reportDataQueryService.queryReportData(queryDTO);
        if (CollectionUtils.isEmpty(resultList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        List<ReportData> reportDataList = ReportHelper.convert(resultList);
        Map<EvalDimensionCombination, List<ReportData>> dimValMap = reportDataList.stream().collect(Collectors.groupingBy(EvalDimensionCombination::getEvalDimensionCombinationByReportData));
        ArrayList<ReportData> finalAddReportDataList = new ArrayList<ReportData>(reportDataList.size());
        Collection<List<ReportData>> values = dimValMap.values();
        for (List<ReportData> currReportDataList : values) {
            ReportData needCopyData = currReportDataList.get(0);
            BigDecimal reduce = currReportDataList.stream().map(ReportData::getPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal actAmt = currReportDataList.stream().map(ReportData::getActAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal lockAmt = currReportDataList.stream().map(ReportData::getLockAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal reportPlanAmt = currReportDataList.stream().map(ReportData::getReportPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal originalPlanAmt = currReportDataList.stream().map(ReportData::getOriginalPlanAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal planReferenceAmt = currReportDataList.stream().map(ReportData::getPlanReferenceAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            ReportData reportData = new ReportData(needCopyData);
            reportData.setId(needCopyData.getId());
            reportData.setRow(0);
            reportData.setCol(0);
            reportData.setPlanAmt(reduce);
            reportData.setLockAmt(lockAmt);
            reportData.setActAmt(actAmt);
            reportData.setReportPlanAmt(reportPlanAmt);
            reportData.setOriginalPlanAmt(originalPlanAmt);
            reportData.setPlanReferenceAmt(planReferenceAmt);
            finalAddReportDataList.add(reportData);
        }
        this.obtainBeginOfTermData(report, finalAddReportDataList, system);
        List auxIdList = template.getReportTypeList().stream().filter(rt -> Objects.equals(rt.getReportTypeId(), report.getReportPeriodType().getReportPeriodId())).map(TemplateReportType::getAuxiliaryFieldList).flatMap(Collection::stream).map(AuxiliaryField::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(auxIdList)) {
            List<ReportData> refAuxDataList = this.queryRefAuxData(template, system, referencePeriodMember);
            report.getReportDataList().addAll(refAuxDataList);
            finalAddReportDataList.addAll(refAuxDataList);
        }
        return finalAddReportDataList;
    }

    protected void addCustomMemberIfNeed(List<Dimension> dimensionList, List<List<Object>> dimValList) {
        Dimension dimension;
        int i;
        ArrayList allCusMemberId = new ArrayList();
        for (i = 0; i < dimensionList.size(); ++i) {
            dimension = dimensionList.get(i);
            if (!dimension.getDimType().isCustomDim()) continue;
            allCusMemberId.addAll(dimValList.get(i));
        }
        for (i = 0; i < dimensionList.size(); ++i) {
            dimension = dimensionList.get(i);
            if (!dimension.getDimType().isCustomDim()) continue;
            dimValList.set(i, allCusMemberId);
        }
    }

    private void obtainBeginOfTermData(Report report, List<ReportData> finalAddReportDataList, FundPlanSystem system) {
        if (report.getInitFlag().booleanValue() || report.getReportPlanType() != ReportPlanType.REPORTPLAN) {
            return;
        }
        ReportTemplate template = report.getTemplate();
        Set manualInputSubjects = template.getAccountSettings().stream().filter(i -> ReportInputType.isManualInput(i.getInputType().getNumber())).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        Map<Long, Long> endToBeginOfTermMap = DimensionInfoHelper.getAutoPlanAmtBeginEndSubjectReverseMap(system);
        if (endToBeginOfTermMap.isEmpty()) {
            return;
        }
        List endOfTermDataList = finalAddReportDataList.stream().filter(reportData -> {
            Long dimVal = (Long)reportData.getDimValByDimType(DimensionType.SUBJECTS);
            return endToBeginOfTermMap.containsKey(dimVal);
        }).collect(Collectors.toList());
        List sortedPeriodList = report.getCurrentAllPeriodMembers().stream().map(PeriodMember.class::cast).sorted(Comparator.comparing(PeriodMember::getStartDate)).collect(Collectors.toList());
        PeriodMember firstPeriodMember = (PeriodMember)sortedPeriodList.get(0);
        for (ReportData reportData2 : endOfTermDataList) {
            int accountIndex;
            if (reportData2.getActAmt() == null) continue;
            List<TemplateDim> dimList = reportData2.getDimList();
            List<Object> dimValList = reportData2.getDimValList();
            ArrayList<Object> targetDimValList = new ArrayList<Object>(dimValList);
            Long removeId = (Long)targetDimValList.remove(accountIndex = dimList.indexOf(dimList.stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get()));
            Long beginId = endToBeginOfTermMap.get(removeId);
            if (!manualInputSubjects.contains(beginId)) continue;
            targetDimValList.add(accountIndex, beginId);
            int periodIndex = dimList.indexOf(dimList.stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get());
            targetDimValList.remove(periodIndex);
            targetDimValList.add(periodIndex, firstPeriodMember.getId());
            Optional<ReportData> first = report.getReportDataList().stream().filter(item -> item.getDimValList().size() == targetDimValList.size() && new HashSet<Object>(item.getDimValList()).containsAll(targetDimValList)).findFirst();
            if (first.isPresent()) {
                ReportData targetReportData = first.get();
                targetReportData.setPlanAmt(reportData2.getActAmt());
                continue;
            }
            ReportData newReportData = new ReportData();
            newReportData.setActAmt(BigDecimal.ZERO);
            newReportData.setPlanAmt(reportData2.getActAmt());
            newReportData.setLockAmt(BigDecimal.ZERO);
            newReportData.setOriginalPlanAmt(BigDecimal.ZERO);
            newReportData.setOffsetAmt(BigDecimal.ZERO);
            newReportData.setReportPlanAmt(BigDecimal.ZERO);
            newReportData.setVersion(1);
            newReportData.setDimValList(targetDimValList);
            newReportData.setReportPeriodId(report.getPeriodMemberList().get(0).getId());
            newReportData.setAmountUnit(report.getTemplate().getAmountUnit());
            newReportData.setMainTable(report.getTemplate().isMainTable());
            newReportData.setCol(0);
            newReportData.setRow(0);
            newReportData.setDimList(dimList);
            report.getReportDataList().add(newReportData);
        }
    }

    @Override
    public List<ReportData> queryRefAuxData(ReportTemplate template, FundPlanSystem system, PeriodMember referencePeriodMember) {
        ReportDataQueryObject auxDataQueryDTO = new ReportDataQueryObject();
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        int size = allTemplateDim.size() - template.getColDimList().size();
        ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(size);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(size);
        for (TemplateDim templateDim : allTemplateDim) {
            if (templateDim.getLocation() == DimLocation.COL) continue;
            Dimension periodDim = system.getMainDimensionByDimType(templateDim.getDimType());
            dimIdList.add(periodDim);
            dimValList.add(new ArrayList<Long>(templateDim.getMemberScope()));
        }
        auxDataQueryDTO.setReportPeriodId(referencePeriodMember.getId());
        auxDataQueryDTO.setMainTable(template.isMainTable());
        auxDataQueryDTO.setDimIdList(dimIdList);
        auxDataQueryDTO.setDimValList(dimValList);
        auxDataQueryDTO.setEffectFlag(true);
        List<ReportDataQueryResult> resultList = this.reportDataQueryService.queryReportData(auxDataQueryDTO);
        resultList.removeIf(result -> !result.isAuxiliaryInfo());
        return ReportHelper.convert(resultList);
    }

    @Override
    public FpmOperateResult<Report> loadReportNotContRefData(Long reportId, MetricHeader metricHeader) {
        return this.loadReportNotContRefData(reportId, false, metricHeader);
    }

    @Override
    public FpmOperateResult<Report> loadReportNotContRefData(Long reportId, boolean isSplit, MetricHeader metricHeader) {
        try {
            Report report = this.reportRepo.loadReport(reportId);
            FundPlanSystem system = this.dimRepo.loadSystem(report.getSystemId());
            logger.info("\u62a5\u8868\u521d\u59cb\u5316\u6807\u8bc6\uff0c{},{}", (Object)report.getId(), (Object)report.getInitFlag());
            if (!report.getInitFlag().booleanValue()) {
                FpmOperateResult<List<ReportData>> rollDataResult = this.loadRollReportData(report, system, false);
                if (!rollDataResult.isSuccess()) {
                    return FpmOperateResult.error(rollDataResult.getMessageList());
                }
                report.getReportDataList().addAll((Collection<ReportData>)rollDataResult.getData());
            }
            this.mergeDetailInputReportData(system, report);
            if (isSplit) {
                MetricValueUtils.splitMetric(report);
            }
            return FpmOperateResult.success(report);
        }
        catch (KDBizException kdBizException) {
            return FpmOperateResult.error(kdBizException.getMessage());
        }
    }

    @Override
    public FpmOperateResult<Report> loadReportByParam(ReportQueryParamDTO queryParamDTO) {
        FpmOperateResult<Report> rollDataResult;
        FpmAssertUtil.isNotNull((Object)queryParamDTO, (String)"param dto is null");
        FpmAssertUtil.isNotNull((Object)queryParamDTO.getReportId(), (String)"param report id is null");
        Long reportId = queryParamDTO.getReportId();
        Boolean queryRefData = queryParamDTO.getQueryRefData();
        Boolean queryRollData = queryParamDTO.getQueryRollData();
        Report report = this.reportRepo.loadReport(reportId);
        FundPlanSystem system = queryParamDTO.getSystem();
        if (system == null) {
            system = this.dimRepo.loadSystem(report.getSystemId());
        }
        if (queryRollData.booleanValue() && !(rollDataResult = this.loadRollDataAndAutoPlanAmt(report, system)).isSuccess()) {
            return FpmOperateResult.error(rollDataResult.getMessageList());
        }
        PeriodMember referencePeriodMember = report.getReferencePeriodMember();
        if (queryRefData.booleanValue() && Objects.nonNull(referencePeriodMember)) {
            List<ReportData> reportData = this.loadReferencePeriodReportData(system, report);
            report.getReportDataList().addAll(reportData);
        }
        this.mergeDetailInputReportData(system, report);
        this.trySplitReportData(report, queryRefData);
        TemplateInfoHelper.addSubjectFlowColIfDetailTemplateNeed(report.getTemplate(), system);
        return FpmOperateResult.success(report);
    }

    private FpmOperateResult<Report> loadRollDataAndAutoPlanAmt(Report report, FundPlanSystem system) {
        if (report.getInitFlag().booleanValue()) {
            return FpmOperateResult.success();
        }
        FpmOperateResult<List<ReportData>> rollDataResult = this.loadRollReportData(report, system, false);
        if (!rollDataResult.isSuccess()) {
            return FpmOperateResult.error(rollDataResult.getMessageList());
        }
        report.getReportDataList().addAll((Collection<ReportData>)rollDataResult.getData());
        if (!CollectionUtils.isEmpty(report.getReportDataList())) {
            PeriodMember firstPeriod = ReportHelper.getFirstPeriod(report);
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            Map<Long, Long> beginEndSubjectMap = DimensionInfoHelper.getBeginEndSubjectMap(system, false);
            List<ReportData> reportDataList = report.getReportDataList();
            reportDataList.stream().filter(item -> {
                boolean offAutoPlanAmt;
                Object dimVal = item.getDimValByDimensionId(subjectDim.getId());
                if (!(dimVal instanceof Long)) {
                    return false;
                }
                boolean bl = offAutoPlanAmt = !beginEndSubjectMap.containsKey((Long)dimVal);
                if (offAutoPlanAmt) {
                    return false;
                }
                Object periodId = item.getDimValByDimType(DimensionType.PERIOD);
                if (!(periodId instanceof Long)) {
                    return false;
                }
                return Objects.equals(periodId, firstPeriod.getId());
            }).forEach(ReportData::clearAmt);
            HashSet beginEndSet = new HashSet(16);
            beginEndSubjectMap.forEach((k, v) -> {
                beginEndSet.add(k);
                beginEndSet.add(v);
            });
            List<ReportData> beginEndData = reportDataList.stream().filter(item -> {
                Object dimVal = item.getDimValByDimensionId(subjectDim.getId());
                return beginEndSet.contains((Long)dimVal);
            }).collect(Collectors.toList());
            if (!EmptyUtil.isEmpty(beginEndData)) {
                ReportCalculateDTO reportCalculateDTO = new ReportCalculateDTO();
                reportCalculateDTO.setReport(report);
                reportCalculateDTO.setSystem(system);
                reportCalculateDTO.setScopeData(beginEndData);
                this.scopeCalculateService.calculateReport(reportCalculateDTO);
            }
        }
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult<List<ReportData>> loadRollReportData(Report report, FundPlanSystem system) {
        return this.loadRollReportData(report, system, false);
    }

    @Override
    public FpmOperateResult<List<ReportData>> loadRollReportData(Report report, FundPlanSystem system, boolean isSplit) {
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(16);
        ReportPeriodType reportPeriodType = report.getReportPeriodType();
        ReportTemplate template = report.getTemplate();
        logger.info("\u8ba1\u5212\u7f16\u5236\u6eda\u52a8\u7f16\u62a5-\u662f\u5426\u6eda\u52a8\u6570\u636e\u67e5\u8be2\uff0c{}|{}", (Object)reportPeriodType.isRoll(), (Object)(template.getTemplateUse() == TemplateUseType.PLANING ? 1 : 0));
        if (reportPeriodType.isRoll() && template.getTemplateUse() == TemplateUseType.PLANING) {
            List<PeriodMember> periodMemberList = report.getPeriodMemberList();
            Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            PeriodMember currPeriod = periodMemberList.get(0);
            List<PeriodMember> periodDimMemberList = periodDim.getMemberList(PeriodMember.class);
            PeriodType periodType = reportPeriodType.getPeriodType();
            ArrayList<PeriodMember> reportPeriodMemList = new ArrayList<PeriodMember>(8);
            for (PeriodMember periodMember : periodDimMemberList) {
                reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(periodType, reportPeriodType.getReportPeriodId()));
                if (PeriodType.MONTH_WEEK != periodType) continue;
                reportPeriodMemList.addAll(periodMember.getChildMemberByPeriodTypeAndPeriodId(PeriodType.YEAR_WEEK, reportPeriodType.getReportPeriodId()));
            }
            Optional<PeriodMember> prePeriodOp = reportPeriodMemList.stream().filter(item -> item.getStartDate().compareTo(currPeriod.getStartDate()) < 0).max(Comparator.comparing(PeriodMember::getStartDate));
            logger.info("\u5b58\u5728\u4e0a\u4e00\u671f\u95f4\uff0c\u5219\u9700\u8981\u67e5\u8be2\u6eda\u52a8\u6570\u636e\uff0c{}", (Object)prePeriodOp.isPresent());
            if (prePeriodOp.isPresent()) {
                DimensionIndexTree indexTree = report.getIndexTree(system);
                ReportDataQueryObject queryDTO = new ReportDataQueryObject();
                queryDTO.setEffectFlag(true);
                PeriodMember prePeriodMember = prePeriodOp.get();
                queryDTO.setOrgTemplateId(template.getCopyId());
                queryDTO.setReportOrgId(report.getCompanyMemberList().get(0).getId());
                queryDTO.setReportPeriodId(prePeriodMember.getId());
                queryDTO.setSplit(isSplit);
                TemplateDim metricTplDim = template.getMetricTplDim();
                if (EmptyUtil.isNoEmpty((Object)metricTplDim)) {
                    queryDTO.setMetricMemberScope(metricTplDim.getMemberScope());
                }
                ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(1);
                dimIdList.add(periodDim);
                if (template.getTemplateType() == TemplateType.FIXED) {
                    dimIdList.add(subjectDim);
                }
                queryDTO.setDimIdList(dimIdList);
                ReportPeriodType reportType = report.getReportPeriodType();
                ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(1);
                List periDimValList = Objects.nonNull((Object)reportType.getDetailPeriodType()) ? (!report.isRollContainsDetail() ? periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList()) : periodMemberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList())) : periodMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
                dimValList.add(periDimValList);
                if (template.getTemplateType() == TemplateType.FIXED) {
                    List accountIdList = template.getAccountSettings().stream().map(item -> item.getAccountMemId()).collect(Collectors.toList());
                    dimValList.add(accountIdList);
                }
                queryDTO.setDimValList(dimValList);
                List<ReportDataQueryResult> resultList = this.reportDataQueryService.queryReportData(queryDTO);
                resultList = resultList.stream().filter(item -> !NumberUtils.equals((BigDecimal)item.getPlanAmt(), (BigDecimal)BigDecimal.ZERO)).collect(Collectors.toList());
                List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
                List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
                Set detailInputSubjectIds = accountSettings.stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType()).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
                if (template.isMainTable() && !CollectionUtils.isEmpty(detailInputSubjectIds)) {
                    resultList = resultList.stream().filter(item -> item.getDimValList().stream().filter(Objects::nonNull).noneMatch(detailInputSubjectIds::contains)).collect(Collectors.toList());
                }
                for (ReportDataQueryResult reportDataQueryResult : resultList) {
                    TreeNode treeNode;
                    List<Object> currDimValList = reportDataQueryResult.getDimValList();
                    if (EmptyUtil.isNoEmpty((Object)metricTplDim)) {
                        allTemplateDim.add(metricTplDim);
                    }
                    ArrayList<TemplateDim> dimList = new ArrayList<TemplateDim>(reportDataQueryResult.getDimIdList().size());
                    for (Long dimId : reportDataQueryResult.getDimIdList()) {
                        TemplateDim templateDim = allTemplateDim.stream().filter(item -> dimId.equals(item.getDimensionId())).findFirst().get();
                        dimList.add(templateDim);
                    }
                    if (template.getTemplateType() == TemplateType.FIXED && Objects.nonNull(treeNode = indexTree.find(DimensionInfoHelper.getDimensionInfoBean(dimList, currDimValList, td -> {
                        if (isSplit) {
                            return true;
                        }
                        return td.getDimType() != DimensionType.METRIC;
                    }))) && !CollectionUtils.isEmpty(treeNode.getDataList())) continue;
                    ReportData reportData = new ReportData();
                    reportData.setActAmt(reportDataQueryResult.getActAmt());
                    reportData.setPlanAmt(reportDataQueryResult.getPlanAmt());
                    reportData.setLockAmt(reportDataQueryResult.getLockAmt());
                    reportData.setOriginalPlanAmt(reportDataQueryResult.getOriginalPlanAmt());
                    reportData.setOffsetAmt(reportDataQueryResult.getOffsetAmt());
                    reportData.setReportPlanAmt(reportDataQueryResult.getReportPlanAmt());
                    reportData.setVersion(reportDataQueryResult.getVersion() + 1);
                    reportData.setBigDecimalValueOrDefault(reportDataQueryResult.getBigDecimalValue());
                    reportData.setDimValList(currDimValList);
                    reportData.setReportPeriodId(report.getPeriodMemberList().get(0).getId());
                    reportData.setAmountUnit(reportDataQueryResult.getAmountUnit());
                    reportData.setMainTable(template.isMainTable());
                    reportData.setCol(reportDataQueryResult.getCol());
                    reportData.setRow(reportDataQueryResult.getRow());
                    reportData.setSourceIdList(reportDataQueryResult.getSourceIdList());
                    reportData.setDimList(dimList);
                    reportData.putAllMetricVal(reportDataQueryResult.getMetricValMap());
                    reportData.setAuxiliaryValMap(reportDataQueryResult.getAuxiliaryValMap());
                    reportData.setAuxiliaryInfo(!CollectionUtils.isEmpty(reportDataQueryResult.getAuxiliaryValMap()));
                    reportDataList.add(reportData);
                }
                report.clearIndexTree();
            }
            if (template.getTemplateType() == TemplateType.DETAIL) {
                this.rollDataResetPosition(reportDataList, template, reportPeriodType.getDetailPeriodType() != null);
            }
        }
        return FpmOperateResult.success(reportDataList);
    }

    private void rollDataResetPosition(List<ReportData> reportDataList, ReportTemplate template, boolean hasDetailPeriod) {
        Report tempReport = new Report();
        tempReport.setReportDataList(reportDataList);
        int dataStartRow = template.getDataStartRow(hasDetailPeriod);
        dataStartRow += template.getTotalRow();
        Pair<List<Long>, List<List<Long>>> pageDimAndValGroup = template.buildPageDimAndValGroup();
        List pageDimList = (List)pageDimAndValGroup.getLeft();
        List right = (List)pageDimAndValGroup.getRight();
        for (List pageDimIdList : right) {
            List<Object> pageDimValList = pageDimIdList.stream().map(item -> item).collect(Collectors.toList());
            List<ReportData> currPageDataList = tempReport.getReportDataByDimInfo(pageDimList, pageDimValList);
            int currPageMinRow = dataStartRow;
            Map rowAndDataMap = currPageDataList.stream().collect(Collectors.groupingBy(ReportData::getRow, TreeMap::new, Collectors.toList()));
            for (Map.Entry next : rowAndDataMap.entrySet()) {
                Integer row = (Integer)next.getKey();
                List currRowDataList = (List)next.getValue();
                if (row > currPageMinRow) {
                    for (ReportData reportData : currRowDataList) {
                        reportData.setRow(currPageMinRow);
                    }
                }
                ++currPageMinRow;
            }
        }
    }

    @Override
    public void batchSubmitReport(Set<Long> reportIds) {
        FpmAssertUtil.isNotEmpty(reportIds, (String)"reportIds is empty");
        List<Report> reports = this.reportRepo.loadReportWithAllDimension(reportIds);
        if (CollectionUtils.isEmpty(reports)) {
            return;
        }
        FundPlanSystem system = this.dimRepo.loadSystem(reports.get(0).getSystemId());
        this.handleDetailReports(reports, system);
        this.handleFixedReport(reports, system);
    }

    private void handleFixedReport(List<Report> reports, FundPlanSystem system) {
        List reportList = reports.stream().filter(item -> !item.getTemplate().getTemplateType().isDetail()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(reportList)) {
            return;
        }
        for (Report report : reportList) {
            if (!report.getTemplate().isMainTable() && report.getInitFlag().booleanValue()) {
                this.setZeroReport(report);
                this.updateZeroReport(report.getId(), report.isZeroReport());
                continue;
            }
            if (report.getTemplate().isMainTable() && report.getInitFlag().booleanValue()) {
                this.reportService.genEmptyReportData(report, system, false);
                this.setZeroReport(report);
                this.reportDataSaveService.saveReportData(report);
                continue;
            }
            this.createReportData(report, system);
            this.reportService.calculateReport(report, system);
            this.reportService.reBuildReportData(report, system);
            this.sumDataToParent(report, system);
            if (EmptyUtil.isEmpty((Long)report.getInformantErId())) {
                report.setInformantErId(RequestContext.get().getCurrUserId());
                report.setInformanStr(RequestContext.get().getUserName());
            }
            report.setInitFlag(Boolean.TRUE);
            this.setZeroReport(report);
            this.reportDataSaveService.saveReportData(report);
        }
    }

    private void handleDetailReports(List<Report> reports, FundPlanSystem system) {
        List<Report> detailReport = reports.stream().filter(item -> item.getTemplate().getTemplateType().isDetail()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(detailReport)) {
            return;
        }
        detailReport.forEach(item -> {
            if (item.getInitFlag().booleanValue()) {
                this.setZeroReport((Report)item);
                this.updateZeroReport(item.getId(), item.isZeroReport());
                return;
            }
            FpmOperateResult<List<ReportData>> operateResult = this.loadRollReportData((Report)item, system);
            List<ReportData> dataList = operateResult.getData();
            if (!CollectionUtils.isEmpty(dataList)) {
                dataList.forEach(ReportData::clearAmt);
                item.setReportDataList(dataList);
                this.sumDataToParent((Report)item, system);
            }
            item.setInitFlag(Boolean.TRUE);
            item.setInformantErId(RequestContext.get().getCurrUserId());
            item.setInformanStr(RequestContext.get().getUserName());
            item.setReportDataList(Lists.newArrayList());
            item.setZeroReport(true);
            this.reportDataSaveService.saveReportData((Report)item);
        });
    }

    private void setZeroReport(Report report) {
        List<ReportData> reportDataList = report.getReportDataList();
        if (EmptyUtil.isEmpty(reportDataList)) {
            report.setZeroReport(true);
            return;
        }
        Optional<ReportData> any = reportDataList.stream().filter(rd -> !NumberUtils.equalsZero((BigDecimal)rd.getPlanAmt())).findAny();
        report.setZeroReport(!any.isPresent());
    }

    private void updateZeroReport(Long reportId, boolean zeroReport) {
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report set fzeroreport=? where fid= ?", Collections.singletonList(reportId), (t, d) -> {
            d.add(zeroReport ? "1" : "0");
            d.add(t);
        });
    }

    private void createReportData(Report report, FundPlanSystem system) {
        this.loadRollDataAndAutoPlanAmt(report, system);
        if (Objects.nonNull(report.getReferencePeriodMember())) {
            this.loadReferencePeriodReportData(system, report);
        }
        this.reportService.genEmptyReportData(report, system);
    }

    @Override
    public FpmOperateResult<Boolean> saveReport(Report report, FundPlanSystem system) {
        logger.info(String.format("\u62a5\u8868\u4fdd\u5b58\uff0c%s", report.getId()));
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            this.replaceMainTableData(report, system);
            this.reportService.calculateReport(report, system);
            this.reportService.reBuildReportData(report, system);
            ReportHelper.checkReportDataAmt(report);
            this.sumDataToParent(report, system);
            FpmOperateResult<Boolean> fpmOperateResult = this.reportDataSaveService.saveReportData(report);
            return fpmOperateResult;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            tx.markRollback();
            FpmOperateResult<Boolean> fpmOperateResult = FpmOperateResult.error(e.getMessage());
            return fpmOperateResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void sumDataToParent(Report report, FundPlanSystem system) {
        if (!report.getTemplate().isMainTable()) {
            Long parentReportId = this.reportRepo.queryParentReportId(report.getId());
            FpmAssertUtil.isNotNull((Object)parentReportId, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u7684\u4e3b\u8868", (String)"ReportBizService_17", (String)"tmc-fpm-business", (Object[])new Object[0]));
            ReportNeedPropDTO propDTO = new ReportNeedPropDTO();
            HashSet<Long> reportIdSet = new HashSet<Long>(1);
            reportIdSet.add(parentReportId);
            propDTO.setNeedTemplate(true);
            propDTO.setNeedCompanyMember(true);
            propDTO.setNeedPeriodMember(true);
            Report parentReport = this.reportRepo.loadSimpleReport(reportIdSet, propDTO).get(0);
            FpmAssertUtil.isNotNull((Object)parentReport, (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u7684\u4e3b\u8868", (String)"ReportBizService_17", (String)"tmc-fpm-business", (Object[])new Object[0]));
            boolean subDataEmpty = CollectionUtils.isEmpty(report.getReportDataList());
            if (subDataEmpty) {
                ReportDataQueryObject queryObject = new ReportDataQueryObject();
                queryObject.setReportIdS(Lists.newArrayList((Object[])new Long[]{report.getId()}));
                queryObject.setMainTable(false);
                List<ReportDataQueryResult> subReportDataResults = this.reportDataQueryService.queryReportData(queryObject);
                if (!CollectionUtils.isEmpty(subReportDataResults)) {
                    List<ReportData> subReportDataList = ReportHelper.convert(subReportDataResults);
                    subReportDataList.forEach(ReportData::clearAmt);
                    report.setReportDataList(subReportDataList);
                    logger.info("summarySubData2Main \u5b50\u8868\u6570\u636e\u6e05\u7a7a\uff0c\u6e05\u7a7a\u4e3b\u8868\u6570\u636e");
                }
            }
            this.reportService.sumToParent(parentReport, report, system);
            if (subDataEmpty) {
                report.setReportDataList(new ArrayList<ReportData>(0));
            }
            ReportHelper.checkReportDataAmt(parentReport);
            this.reportDataSaveService.saveReportData(parentReport.getReportDataList(), parentReport.getSystemId());
        }
    }

    private void replaceMainTableData(Report report, FundPlanSystem system) {
        if (report.getTemplate().isMainTable()) {
            List<ReportDataQueryResult> reportDataQueryResults;
            Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
            ReportTemplate template = report.getTemplate();
            List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
            ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>();
            List subjectIds = accountSettings.stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType()).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(subjectIds)) {
                return;
            }
            dimValList.add(subjectIds);
            ReportDataQueryObject queryObject = new ReportDataQueryObject();
            queryObject.setReportIdS(Lists.newArrayList((Object[])new Long[]{report.getId()}));
            queryObject.setDimIdList(Lists.newArrayList((Object[])new Dimension[]{subjectDim}));
            queryObject.setDimValList(dimValList);
            queryObject.setMainTable(true);
            queryObject.setSplit(true);
            queryObject.setNeedDimIfValueIsNotEmpty(true);
            TemplateDim metricTplDim = template.getMetricTplDim();
            if (EmptyUtil.isNoEmpty((Object)metricTplDim)) {
                queryObject.setMetricMemberScope(metricTplDim.getMemberScope());
            }
            if (CollectionUtils.isEmpty(reportDataQueryResults = this.reportDataQueryService.queryReportData(queryObject))) {
                return;
            }
            report.getIndexTree(system);
            List<ReportData> dbRDList = ReportHelper.convert(reportDataQueryResults);
            Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
            MetricMember metricMember = metricDim.getAllDimMemberList().stream().map(item -> (MetricMember)item).filter(item -> TemplateMetricType.PLANAMT == item.getTemplateMetricType()).findFirst().get();
            dbRDList = dbRDList.stream().filter(item -> item.getDimValList().contains(metricMember.getId())).filter(item -> !item.isAuxiliaryInfo()).collect(Collectors.toList());
            List<ReportData> treeNodeDataList = report.getTreeNodeDataList(dbRDList);
            Set treeNodeDataIdSet = treeNodeDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
            List<ReportData> filterReportData = report.getReportDataList().stream().filter(item -> !treeNodeDataIdSet.contains(item.getId())).collect(Collectors.toList());
            report.clearTreeNodeData(dbRDList);
            report.mountReportData(dbRDList);
            filterReportData.addAll(dbRDList);
            report.setReportDataList(filterReportData);
            ReportTreeNodeFormulaManager formulaManager = report.getFormulaManager(system);
            formulaManager.updateData(report.getTreeNodeList(dbRDList));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FpmOperateResult<Void> smartGetVal(BillMatchRule matchRule, Report report, FundPlanSystem system, List<TemplateDim> tplDimList, boolean isSyncPlanAmt) {
        FpmOperateResult<Void> fpmOperateResult;
        BaseDataByNameProvider baseDataByNameProvider;
        FpmOperateResult<Void> mappingReportDataResult;
        logger.info("\u8ba1\u5212\u7f16\u5236-\u667a\u80fd\u53d6\u503c");
        Long reportId = report.getId();
        TemplateDim subjectTplDim = tplDimList.stream().filter(item -> item.getDimType() == DimensionType.SUBJECTS).findFirst().get();
        List<Long> subjectMemberScope = subjectTplDim.getMemberScope();
        ReportTemplate template = report.getTemplate();
        if (template.getTemplateType() == TemplateType.FIXED) {
            List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
            List inputMemIdList = accountSettings.stream().filter(item -> item.getInputType() == ReportInputType.MANUAL_INPUT).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toList());
            subjectMemberScope = subjectMemberScope.stream().filter(item -> inputMemIdList.contains(item)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(subjectMemberScope)) {
            FpmOperateResult<Void> success = FpmOperateResult.success();
            success.setSuccessMessage(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff0c\u5bf9\u5e94\u8ba1\u5212\u7f16\u5236\u8868\u6ca1\u6709\u9700\u8981\u624b\u5de5\u586b\u62a5\u7684\u8ba1\u5212\u79d1\u76ee\u3002", (String)"ReportBizService_12", (String)"tmc-fpm-business", (Object[])new Object[0]));
            return success;
        }
        MatchRuleBizBillQParam matchRuleBizBillQParam = new MatchRuleBizBillQParam();
        matchRuleBizBillQParam.setEntityType(matchRule.getEntityType());
        matchRuleBizBillQParam.setBaseCondition(matchRule.getApplyCondition());
        HashMap<String, List<Object>> bizPropNameAndVal = new HashMap<String, List<Object>>(16);
        HashMap<String, MatchPropType> bizPropAndPropType = new HashMap<String, MatchPropType>(16);
        matchRuleBizBillQParam.setBizPropNameAndVal(bizPropNameAndVal);
        matchRuleBizBillQParam.setBizPropAndPropType(bizPropAndPropType);
        matchRuleBizBillQParam.setBizPropAndDimMemberMapping(new HashMap<String, DimMemberMapping>(8, 1.0f));
        matchRuleBizBillQParam.setBizPropAndAssistBizProp(new HashMap<String, String>(8, 1.0f));
        matchRuleBizBillQParam.setBizPropDimMemberMappingOptionalValMap(new HashMap<String, List<Long>>(8, 1.0f));
        ArrayList<String> otherQueryPropS = new ArrayList<String>(1);
        matchRuleBizBillQParam.setOtherQueryPropS(otherQueryPropS);
        List<Dimension> dimList = system.getDimList();
        Map<Long, Dimension> dimMap = dimList.stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        Map tplDimMap = tplDimList.stream().collect(Collectors.toMap(TemplateDim::getDimensionId, Function.identity()));
        List<MatchMapping> mappings = matchRule.getMappings();
        mappings = mappings.stream().filter(item -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{item.getBizProp()})).collect(Collectors.toList());
        Map<Long, String> dimAndPropMap = mappings.stream().collect(Collectors.toMap(MatchMapping::getDimId, MatchMapping::getBizProp));
        Map<String, Long> propAndDimMap = mappings.stream().collect(Collectors.toMap(MatchMapping::getBizProp, MatchMapping::getDimId));
        String amtFiled = "";
        for (MatchMapping mapping : mappings) {
            List memberObjScope;
            List<Long> memberScope;
            String bizProp;
            block30: {
                block27: {
                    Dimension currDim;
                    block32: {
                        block28: {
                            List periodMemberList;
                            IDataEntityProperty property;
                            block31: {
                                block29: {
                                    currDim = (Dimension)dimMap.get(mapping.getDimId());
                                    if (currDim.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                                        amtFiled = mapping.getBizProp();
                                        otherQueryPropS.add(amtFiled);
                                        continue;
                                    }
                                    TemplateDim templateDim = (TemplateDim)tplDimMap.get(mapping.getDimId());
                                    if (templateDim == null) continue;
                                    bizProp = mapping.getBizProp();
                                    List<Long> memberScopeTemp = templateDim.getMemberScope();
                                    if (currDim.getDimType() == DimensionType.SUBJECTS) {
                                        memberScopeTemp = subjectMemberScope;
                                    }
                                    memberScope = memberScopeTemp;
                                    memberObjScope = memberScope.stream().map(item -> item).collect(Collectors.toList());
                                    if (templateDim.getDimType() == DimensionType.DETAILDIM) break block27;
                                    if (currDim.getDimType() != DimensionType.PERIOD) break block28;
                                    property = new MatchRuleHelper().getFieldType(mapping.getBizProp(), matchRule.getEntityType());
                                    periodMemberList = currDim.getAllDimMemberList().stream().filter(item -> memberScope.contains(item.getId())).map(item -> (PeriodMember)item).collect(Collectors.toList());
                                    if (!(property instanceof DateProp)) break block29;
                                    Date startDate = periodMemberList.stream().map(PeriodMember::getStartDate).min(Date::compareTo).get();
                                    Date endDate = periodMemberList.stream().map(PeriodMember::getEndDate).max(Date::compareTo).get();
                                    memberObjScope = new ArrayList(2);
                                    memberObjScope.add(startDate);
                                    memberObjScope.add(endDate);
                                    break block30;
                                }
                                if (!(property instanceof TextProp)) break block31;
                                memberObjScope = periodMemberList.stream().map(DimMember::getName).collect(Collectors.toList());
                                break block30;
                            }
                            if (!(property instanceof BasedataProp)) break block30;
                            memberObjScope = periodMemberList.stream().map(DimMember::getNumber).collect(Collectors.toList());
                            break block30;
                        }
                        if (mapping.getMatchPropType() != MatchPropType.NAME) break block32;
                        memberObjScope = currDim.getAllDimMemberList().stream().filter(item -> memberScope.contains(item.getId())).map(DimMember::getName).collect(Collectors.toList());
                        break block30;
                    }
                    if (mapping.getMatchPropType() != MatchPropType.NUMBER) break block30;
                    memberObjScope = currDim.getAllDimMemberList().stream().filter(item -> memberScope.contains(item.getId())).map(DimMember::getNumber).collect(Collectors.toList());
                    break block30;
                }
                otherQueryPropS.add(bizProp);
                continue;
            }
            bizPropNameAndVal.put(bizProp, memberObjScope);
            bizPropAndPropType.put(bizProp, mapping.getMatchPropType());
            if (Objects.nonNull(mapping.getDimMapping())) {
                matchRuleBizBillQParam.getBizPropAndDimMemberMapping().put(bizProp, mapping.getDimMapping());
                matchRuleBizBillQParam.getBizPropDimMemberMappingOptionalValMap().put(bizProp, memberScope);
            }
            if (!EmptyUtil.isNoEmpty((String)mapping.getAssistBizProp())) continue;
            matchRuleBizBillQParam.getBizPropAndAssistBizProp().put(bizProp, mapping.getAssistBizProp());
        }
        logger.info("\u8ba1\u5212\u7f16\u5236-\u667a\u80fd\u53d6\u503c-\u67e5\u8be2\u4e1a\u52a1\u5355\u636e\u4fe1\u606f");
        List<BillBizInfo> billBizInfoS = this.matchRuleBizBillQueryService.queryBillBizInfoS(matchRuleBizBillQParam);
        HashMap<Long, List<ReportData>> bizBillAndRDMap = new HashMap<Long, List<ReportData>>();
        logger.info("\u8ba1\u5212\u7f16\u5236-\u667a\u80fd\u53d6\u503c-\u4e1a\u52a1\u5355\u636e\u6570\u91cf\uff1a{}", (Object)(CollectionUtils.isEmpty(billBizInfoS) ? 0 : billBizInfoS.size()));
        if (!CollectionUtils.isEmpty(billBizInfoS) && !(mappingReportDataResult = this.bizBillInReport(baseDataByNameProvider = this.getBaseDataProvider(billBizInfoS, dimMap, propAndDimMap), report, mappings, dimList, tplDimList, dimAndPropMap, bizBillAndRDMap, dimMap, billBizInfoS, amtFiled, isSyncPlanAmt, system)).isSuccess()) {
            return mappingReportDataResult;
        }
        logger.info("\u8ba1\u5212\u7f16\u5236-\u667a\u80fd\u53d6\u503c-\u53d6\u6570\u7684\u5355\u636e\u91cf\uff1a{}", (Object)bizBillAndRDMap.size());
        if (EmptyUtil.isEmpty(bizBillAndRDMap.keySet())) {
            this.afterSmartGelReportData(report, Collections.EMPTY_SET, system);
        }
        report.rebuildTree(system);
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            this.iInOutCollectSaveService.saveOrUpdateReportRelation(report, bizBillAndRDMap);
            FpmOperateResult<Boolean> saveReportResult = this.saveReport(report, system);
            if (saveReportResult.isSuccess()) {
                if (saveReportResult.getData() != false) return FpmOperateResult.success();
            }
            fpmOperateResult = FpmOperateResult.error(saveReportResult.getMessageList());
            return fpmOperateResult;
        }
        catch (Exception e) {
            h.markRollback();
            logger.error("\u667a\u80fd\u53d6\u503c\u5f02\u5e38\u5f02\u5e38", (Throwable)e);
            fpmOperateResult = FpmOperateResult.error(e.getMessage());
            return fpmOperateResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private FpmOperateResult<Void> bizBillInReport(BaseDataByNameProvider baseDataByNameProvider, Report report, List<MatchMapping> mappings, List<Dimension> dimList, List<TemplateDim> tplDimList, Map<Long, String> dimAndPropMap, Map<Long, List<ReportData>> bizBillAndRDMap, Map<Long, Dimension> dimMap, List<BillBizInfo> billBizInfoS, String amtFiled, boolean isSyncPlanAmt, FundPlanSystem system) {
        List<DimMemberMapping> dimMemberMappingList = mappings.stream().filter(Objects::nonNull).map(MatchMapping::getDimMapping).filter(Objects::nonNull).collect(Collectors.toList());
        DimMappingBaseDataProvider dimMappingBaseDataProvider = new DimMappingBaseDataProvider(dimMemberMappingList, false);
        ReportTemplate template = report.getTemplate();
        TemplateSmartGetValSetType smartGetValSetType = template.getSmartGetValSetType();
        HashMap maxRowMap = Maps.newHashMapWithExpectedSize((int)8);
        List<Long> pageDimList = this.getPageDimList(report, template, maxRowMap);
        Pair<TemplateDim, Map<Long, Integer>> detailColMap = this.getTemplateDimMapPairByDetail(report, template);
        Map dimMappingMap = mappings.stream().collect(Collectors.toMap(MatchMapping::getDimId, Function.identity()));
        Optional<Dimension> opTypeOptional = dimList.stream().filter(item -> DetailDimType.CONNTERPARTY_TYPE == item.getDetailDimType()).findFirst();
        Dimension opTypeDim = opTypeOptional.orElse(null);
        String opTypeProp = opTypeDim == null ? null : dimAndPropMap.get(opTypeDim.getId());
        boolean hasDetailPeriod = report.getReportPeriodType().getDetailPeriodType() != null;
        int templateDataStartRow = template.getDataStartRow(hasDetailPeriod) - 1;
        int totalRow = template.getTotalRow() + templateDataStartRow;
        HashSet<ReportData> reportDataSet = new HashSet<ReportData>(billBizInfoS.size());
        LinkedList<ReportData> detailReportNewDataList = new LinkedList<ReportData>();
        HashMap exchangeRateMap = Maps.newHashMapWithExpectedSize((int)4);
        Set currPeriodMemberIdSet = report.getCurrentAllPeriodMembers().stream().map(DimMember::getId).collect(Collectors.toSet());
        block0: for (BillBizInfo billBizInfo : billBizInfoS) {
            ArrayList<Long> sourceIdList;
            List<BizProps> bizProps = billBizInfo.getBizProps();
            Map bizValMap = bizProps.stream().collect(HashMap::new, (m, v) -> m.put(v.getBizProp(), v.getValue()), HashMap::putAll);
            Object opTypeVal = opTypeProp != null ? bizValMap.get(opTypeProp) : null;
            Object amtObj = bizValMap.get(amtFiled);
            BigDecimal amt = amtObj != null ? new BigDecimal(amtObj.toString()) : BigDecimal.ZERO;
            ArrayList<Object> targetDimValList = new ArrayList<Object>(tplDimList.size());
            for (TemplateDim templateDim : tplDimList) {
                String bizProp = dimAndPropMap.get(templateDim.getDimensionId());
                Object bizVal = bizValMap.get(bizProp);
                Dimension currDim = dimMap.get(templateDim.getDimensionId());
                if (templateDim.getDimType() != DimensionType.DETAILDIM) {
                    Optional<DimMember> first;
                    if (currDim.getDimType() == DimensionType.METRIC) {
                        Optional<MetricMember> first2 = currDim.getMemberList().stream().map(MetricMember.class::cast).filter(metricMember -> metricMember.getTemplateMetricType() == TemplateMetricType.PLANAMT).findFirst();
                        if (first2.isPresent()) {
                            targetDimValList.add(first2.get().getId());
                            continue;
                        }
                        targetDimValList.add(templateDim.getMemberScope().get(0));
                        continue;
                    }
                    MatchMapping matchMapping = (MatchMapping)dimMappingMap.get(templateDim.getDimensionId());
                    if (Objects.isNull(matchMapping)) continue;
                    MatchPropType matchPropType = matchMapping.getMatchPropType();
                    List<DimMember> allDimMemberList = currDim.getAllDimMemberList();
                    if (templateDim.getDimType() == DimensionType.PERIOD) {
                        first = allDimMemberList.stream().filter(item -> {
                            if (currPeriodMemberIdSet.contains(item.getId())) {
                                PeriodMember periodMember = (PeriodMember)item;
                                if (bizVal == null) {
                                    return false;
                                }
                                if (bizVal instanceof String) {
                                    return periodMember.getName().equals(bizVal.toString()) || periodMember.getNumber().equals(bizVal.toString());
                                }
                                Date date = DateUtils.stringToDate((String)bizVal.toString(), (String)"yyyy-MM-dd");
                                return periodMember.getStartDate().compareTo(date) <= 0 && periodMember.getEndDate().compareTo(date) >= 0;
                            }
                            return false;
                        }).findFirst();
                    } else {
                        HashSet<Long> currMemberScopeSet = new HashSet<Long>(templateDim.getMemberScope());
                        MappingInfo matchedMappingInfo = this.matchingDimMemberMapping(matchMapping, billBizInfo, currMemberScopeSet, dimMappingBaseDataProvider);
                        first = matchedMappingInfo != null ? allDimMemberList.stream().filter(member -> Objects.equals(matchedMappingInfo.getMemberId(), member.getId())).findAny() : Optional.empty();
                        amt = this.convertCurrencyAmtIfNeed(first.orElse(null), matchedMappingInfo, dimMap, exchangeRateMap, amt, report);
                        if (amt == null) continue block0;
                        Optional<DimMember> optional = first = first.isPresent() ? first : allDimMemberList.stream().filter(item -> {
                            if (currMemberScopeSet.contains(item.getId())) {
                                if (matchPropType == MatchPropType.NUMBER) {
                                    return item.getNumber().equals(bizVal);
                                }
                                return item.getName().equals(bizVal);
                            }
                            return false;
                        }).findFirst();
                    }
                    if (!first.isPresent()) continue block0;
                    DimMember dimMember = first.get();
                    targetDimValList.add(dimMember.getId());
                    continue;
                }
                Pair<Boolean, Object> transferResult = this.transferDetailDimVal4SmartGel(currDim, bizVal, opTypeVal, baseDataByNameProvider);
                if (!((Boolean)transferResult.getLeft()).booleanValue()) continue;
                Object finalBizVal = transferResult.getRight();
                targetDimValList.add(finalBizVal);
            }
            List<TemplateDim> finalTplDimList = tplDimList.stream().filter(item -> DetailDimType.PLAN_AMOUNT != item.getDetailDimType()).filter(item -> !item.getDimType().isVirtualDim()).collect(Collectors.toList());
            List<Long> dimIdList = finalTplDimList.stream().map(TemplateDim::getDimensionId).collect(Collectors.toList());
            ReportData reportData = null;
            if (template.getTemplateType() == TemplateType.FIXED) {
                List<ReportData> dbDataList = report.getReportDataByDimInfo(dimIdList, targetDimValList);
                if (dbDataList.size() == 1) {
                    reportData = dbDataList.get(0);
                }
            } else {
                Optional<ReportData> first = report.getReportDataList().stream().filter(item -> item.getSourceIdList() != null && item.getSourceIdList().contains(billBizInfo.getBillId())).findFirst();
                if (first.isPresent()) {
                    reportData = first.get();
                    reportData.setDimList(finalTplDimList);
                    reportData.setDimValList(targetDimValList);
                }
            }
            if (reportData == null) {
                reportData = new ReportData();
                reportData.setReportId(report.getId());
                reportData.setDimList(finalTplDimList);
                reportData.setDimValList(targetDimValList);
                reportData.setReportPeriodId(report.getPeriodMemberList().get(0).getId());
                reportData.setMainTable(template.isMainTable());
                reportData.setAmountUnit(template.getAmountUnit());
                if (template.getTemplateType() == TemplateType.DETAIL) {
                    ArrayList<String> dimMemIdStrList = new ArrayList<String>(pageDimList.size());
                    for (Long pageDimId : pageDimList) {
                        dimMemIdStrList.add(targetDimValList.get(dimIdList.indexOf(pageDimId)).toString());
                    }
                    int currMaxRow = Math.max(maxRowMap.getOrDefault(String.join((CharSequence)"#", dimMemIdStrList), 0), totalRow);
                    if (currMaxRow > template.getMaxLineCount() + totalRow) continue;
                    reportData.setRow(++currMaxRow);
                    if (detailColMap != null) {
                        TemplateDim left = (TemplateDim)detailColMap.getLeft();
                        if (left.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
                            reportData.setCol((Integer)((Map)detailColMap.getRight()).get(left.getDimensionId()));
                        } else {
                            Object dimValByDimType = reportData.getDimValByDimType(left.getDimType(), null);
                            Integer colNum = (Integer)((Map)detailColMap.getRight()).get((Long)dimValByDimType);
                            int col = Objects.nonNull(colNum) ? colNum.intValue() : reportData.getCol();
                            reportData.setCol(col);
                        }
                    }
                    maxRowMap.put(String.join((CharSequence)"#", dimMemIdStrList), currMaxRow);
                    detailReportNewDataList.add(reportData);
                }
                report.getReportDataList().add(reportData);
            }
            ArrayList<Long> arrayList = sourceIdList = (sourceIdList = reportData.getSourceIdList()) == null ? new ArrayList<Long>(16) : sourceIdList;
            if (!sourceIdList.contains(billBizInfo.getBillId())) {
                sourceIdList.add(billBizInfo.getBillId());
            }
            reportData.setSourceIdList(sourceIdList);
            reportData.setSmartGelFlag(true);
            AmountUnit amountUnit = template.getAmountUnit();
            BigDecimal finalPlanAmt = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (BigDecimal)amt);
            BigDecimal finalReferenceAmt = AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)((AmountUnitEnum)AmountUnitEnum.valueOf(AmountUnitEnum.class, (String)amountUnit.name())), (BigDecimal)amt);
            if (reportDataSet.contains(reportData)) {
                finalPlanAmt = reportData.getPlanAmt() != null ? reportData.getPlanAmt().add(finalPlanAmt) : finalPlanAmt;
                finalReferenceAmt = reportData.getPlanReferenceAmt() != null ? reportData.getPlanReferenceAmt().add(finalReferenceAmt) : finalReferenceAmt;
            } else {
                reportDataSet.add(reportData);
            }
            bizBillAndRDMap.computeIfAbsent(billBizInfo.getBillId(), o -> new ArrayList()).add(reportData);
            reportData.setDirty(true);
            reportData.setPlanReferenceAmt(finalReferenceAmt);
            if (smartGetValSetType != TemplateSmartGetValSetType.FILLPLANAMT && !isSyncPlanAmt) continue;
            reportData.setPlanAmt(finalPlanAmt);
        }
        List<String> errorMsgList = this.buildNonExistRateErrorMsgIfNeed(exchangeRateMap);
        if (!CollectionUtils.isEmpty(errorMsgList)) {
            return FpmOperateResult.error(errorMsgList);
        }
        ReportHelper.sortDetailReportDataRowByDim(template, detailReportNewDataList, system);
        this.afterSmartGelReportData(report, reportDataSet, system);
        return FpmOperateResult.success();
    }

    private List<Long> getPageDimList(Report report, ReportTemplate template, Map<String, Integer> maxRowMap) {
        List<Long> pageDimList = new ArrayList<Long>(3);
        if (template.getTemplateType() == TemplateType.DETAIL) {
            Pair<List<Long>, List<List<Long>>> pageDimAndValGroup = template.buildPageDimAndValGroup();
            pageDimList = (List)pageDimAndValGroup.getLeft();
            List right = (List)pageDimAndValGroup.getRight();
            for (List pageDimIdList : right) {
                List<Object> collect = pageDimIdList.stream().map(item -> item).collect(Collectors.toList());
                Optional<Integer> max = report.getReportDataByDimInfo(pageDimList, collect).stream().map(ReportData::getRow).max(Integer::compareTo);
                int currMaxRow = max.orElse(0);
                String pageDimIdStr = pageDimIdList.stream().map(Object::toString).collect(Collectors.joining("#"));
                maxRowMap.put(pageDimIdStr, currMaxRow);
            }
        }
        return pageDimList;
    }

    private Pair<TemplateDim, Map<Long, Integer>> getTemplateDimMapPairByDetail(Report report, ReportTemplate template) {
        Pair detailColMap;
        if (template.getTemplateType() != TemplateType.DETAIL) {
            return null;
        }
        Optional<TemplateDim> first = template.getColDimList().stream().filter(TemplateDim::isExpand).findFirst();
        List sortedDimList = template.getColDimList().stream().filter(TemplateDim::isVisible).sorted(Comparator.comparing(TemplateDim::getSequence, Integer::compareTo)).collect(Collectors.toList());
        boolean hasExpend = first.isPresent();
        if (hasExpend) {
            List detailPeriodIds;
            TemplateDim templateDim = first.get();
            int col = sortedDimList.indexOf(templateDim);
            List<Long> memberScope = templateDim.getMemberScope();
            HashMap<Long, Integer> colMap = new HashMap<Long, Integer>(16);
            if (templateDim.getDimType() == DimensionType.PERIOD && !CollectionUtils.isEmpty(detailPeriodIds = report.getCurrentReportPeriodDetail().stream().map(DimMember::getId).collect(Collectors.toList()))) {
                for (Long memberId : detailPeriodIds) {
                    colMap.put(memberId, col++);
                }
            }
            if (MapUtils.isEmpty(colMap)) {
                for (Long memberId : memberScope) {
                    colMap.put(memberId, col++);
                }
            }
            detailColMap = Pair.of((Object)templateDim, colMap);
        } else {
            TemplateDim templateDim = template.getColDimList().stream().filter(item -> DetailDimType.PLAN_AMOUNT == item.getDetailDimType()).findFirst().get();
            int col = sortedDimList.indexOf(templateDim);
            HashMap<Long, Integer> colMap = new HashMap<Long, Integer>(16);
            colMap.put(templateDim.getDimensionId(), col);
            detailColMap = Pair.of((Object)templateDim, colMap);
        }
        return detailColMap;
    }

    private BaseDataByNameProvider getBaseDataProvider(List<BillBizInfo> billBizInfoS, Map<Long, Dimension> dimMap, Map<String, Long> propAndDimMap) {
        List bizPropsList = billBizInfoS.stream().map(BillBizInfo::getBizProps).collect(Collectors.toList());
        HashMap<String, List<String>> entityAndNameListMap = new HashMap<String, List<String>>();
        for (List bizProps : bizPropsList) {
            List needHandleList = bizProps.stream().filter(item -> {
                Dimension currDim = (Dimension)dimMap.get(propAndDimMap.get(item.getBizProp()));
                if (currDim == null) {
                    return false;
                }
                if (currDim.getDimType() != DimensionType.DETAILDIM) {
                    return false;
                }
                return MemberType.BASE_DATA == currDim.getMemberType() || MemberType.MUTI_BASE_DATA == currDim.getMemberType();
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(needHandleList)) continue;
            Optional<BizProps> first = needHandleList.stream().filter(item -> {
                Dimension currDim = (Dimension)dimMap.get(propAndDimMap.get(item.getBizProp()));
                return currDim.getDetailDimType() == DetailDimType.CONNTERPARTY_TYPE;
            }).findFirst();
            BizProps opTypeInfo = null;
            if (first.isPresent()) {
                opTypeInfo = first.get();
            }
            for (BizProps props : needHandleList) {
                Dimension currDim = dimMap.get(propAndDimMap.get(props.getBizProp()));
                if (MemberType.MUTI_BASE_DATA == currDim.getMemberType() || props.getValue() == null) continue;
                DetailDimType detailDimType = currDim.getDetailDimType();
                if (detailDimType == DetailDimType.COUNTERPARTY_NAME) {
                    if (opTypeInfo == null) continue;
                    entityAndNameListMap.computeIfAbsent(opTypeInfo.getValue().toString(), o -> new ArrayList(16)).add(props.getValue().toString());
                    continue;
                }
                String entity = Objects.isNull(detailDimType.getExtVal()) ? currDim.getBaseDataType() : detailDimType.getExtVal().toString();
                entityAndNameListMap.computeIfAbsent(entity, o -> new ArrayList(16)).add(props.getValue().toString());
            }
        }
        return new BaseDataByNameProvider(entityAndNameListMap);
    }

    @Override
    public FpmOperateResult<Void> auditReport(final Long reportId, final List<Long> subReportIdList, Long sumOrgId, boolean mainTable) {
        return CommonUtils.traceInTracer("auditReport", span -> {
            FpmContext fpmContext = FpmContext.get();
            Map dimMemberMap = (Map)fpmContext.get("dimMemberMap");
            final FundPlanSystem fundPlanSystem = (FundPlanSystem)fpmContext.get("fundSystem");
            Long periodId = (Long)fpmContext.get("periodId");
            span.addTag("start audit report");
            if (mainTable) {
                OrgMember sumOrgMember = sumOrgId != null ? (OrgMember)dimMemberMap.get(sumOrgId) : null;
                ReportStatus tempFinalStatus = sumOrgMember == null ? ReportStatus.ENABLE : ReportStatus.REPORTING;
                String reportMainDataUpdateSql = "update t_fpm_reportdatamain set forgplanamt=fplanamt,freportplanamt=fplanamt, feffectflag =? where fid=?";
                String reportUpdateSql = "update t_fpm_report set fplanstatus=? where fid=?";
                LinkedList<Object[]> mainDataExeParams = new LinkedList<Object[]>();
                LinkedList<Object[]> dataExeParams = new LinkedList<Object[]>();
                mainDataExeParams.add(new Object[]{tempFinalStatus == ReportStatus.ENABLE ? "1" : "0", reportId});
                dataExeParams.add(new Object[]{tempFinalStatus.getVal(), reportId});
                for (Long subReportId : subReportIdList) {
                    mainDataExeParams.add(new Object[]{tempFinalStatus == ReportStatus.ENABLE ? "1" : "0", subReportId});
                    dataExeParams.add(new Object[]{tempFinalStatus.getVal(), subReportId});
                }
                logger.info("\u4e3b\u8868\u5ba1\u6838-\u6c47\u603b\u7f16\u62a5\uff0c\u66f4\u65b0\u8ba1\u5212\u7f16\u5236\u8868\uff0c{}", (Object)reportId);
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)reportMainDataUpdateSql, mainDataExeParams);
                span.addTag("executeBatch reportMainDataUpdateSql");
                if (sumOrgMember != null) {
                    ReportQDTO reportQDTO = new ReportQDTO();
                    reportQDTO.setReportOrgId(sumOrgMember.getId());
                    reportQDTO.setReportPeriodId(periodId);
                    reportQDTO.setReportPlanType(ReportPlanType.SUMPLAN);
                    List<Report> sumPlanReportList = this.reportRepo.loadReport(reportQDTO);
                    span.addTag("load sumplan Report");
                    if (!CollectionUtils.isEmpty(sumPlanReportList)) {
                        List finalSumPlanReportList = sumPlanReportList.stream().map(item -> (SumPlanReport)item).collect(Collectors.toList());
                        HashSet<Long> reportIdSet = new HashSet<Long>();
                        reportIdSet.add(reportId);
                        List<Report> reportList = this.reportRepo.loadReportWithAllDimension(reportIdSet);
                        span.addTag("load sumplan sub Report ");
                        logger.info("\u4e3b\u8868\u5ba1\u6838-\u6c47\u603b\u7f16\u62a5\uff0c\u6570\u636e\u6c47\u603b\uff0c{}", (Object)((SumPlanReport)finalSumPlanReportList.get(0)).getId());
                        FundPlanSystem system = (FundPlanSystem)fpmContext.get("fundSystem");
                        SumPlanReport sumPlanReport = (SumPlanReport)finalSumPlanReportList.get(0);
                        FpmOperateResult<SumPlanUpdateInfo> sumPlanResult = this.sumPlanService.sumPlanReportUpper(reportList, sumPlanReport, system);
                        span.addTag("sumPlanReportSum");
                        if (!sumPlanResult.isSuccess()) {
                            return FpmOperateResult.error(sumPlanResult.getMessageList());
                        }
                        logger.info("\u4e3b\u8868\u5ba1\u6838-\u6c47\u603b\u7f16\u62a5\uff0c\u66f4\u65b0\u6c47\u603b\u8868-before\uff0c{}", (Object)sumPlanReport.getId());
                        this.sumPlanDataService.batchSaveSumPlanUpdateInfo(sumPlanResult.getData());
                        span.addTag("update sumPlanReportSum result");
                        logger.info("\u4e3b\u8868\u5ba1\u6838-\u6c47\u603b\u7f16\u62a5\uff0c\u66f4\u65b0\u6c47\u603b\u8868-after\uff0c{}", (Object)sumPlanReport.getId());
                        this.asyncUpdateUnCompleteApprovedRecordIfNeed(sumOrgMember.getId(), periodId, sumPlanReport);
                    }
                }
                HashSet<Long> reportIdS = new HashSet<Long>();
                reportIdS.add(reportId);
                reportIdS.addAll(subReportIdList);
                List<InoutCollect> inoutCollectList = this.inoutCollectRep.loadByReportId(reportIdS);
                if (!CollectionUtils.isEmpty(inoutCollectList)) {
                    inoutCollectList.forEach(item -> {
                        item.setApplyStatus(ApplyStatus.APPLIED);
                        item.setBillStatus(BillStatus.AUDITED);
                    });
                    this.inoutCollectRep.save(inoutCollectList);
                }
                span.addTag("save inoutCollect");
                logger.info("\u4e3b\u8868\u5ba1\u6838-\u6c47\u603b\u7f16\u62a5\uff0c\u66f4\u65b0\u8ba1\u5212\u7f16\u5236\u8868reportUpdateSql\uff0c{}", (Object)reportId);
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)reportUpdateSql, dataExeParams);
                if (tempFinalStatus == ReportStatus.ENABLE) {
                    TX.addCommitListener((CommitListener)new CommitListener(){

                        public void onCommitted() {
                            try (TXHandle tx = TX.requiresNew();){
                                HashSet<Long> reportIds = new HashSet<Long>(subReportIdList);
                                reportIds.add(reportId);
                                HashMap<String, Object> param = new HashMap<String, Object>(4);
                                param.put("reportIds", reportIds);
                                param.put("system", fundPlanSystem);
                                FpmAsyncCalculateHelper.asyncCalculate(String.valueOf(reportId), "updateBeginEndSubjectRealAmount", param);
                            }
                        }
                    });
                }
                if (sumOrgMember == null) {
                    this.shrekReportDataService.syncReport(reportId);
                }
            } else {
                String reportMainDataUpdateSql = "update t_fpm_reportdatamain set freportplanamt=fplanamt where fid=?";
                LinkedList<Object[]> mainDataExeParams = new LinkedList<Object[]>();
                mainDataExeParams.add(new Object[]{reportId});
                DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)reportMainDataUpdateSql, mainDataExeParams);
            }
            span.addTag("audit report end");
            return FpmOperateResult.success();
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FpmOperateResult unAuditReport(Report report, ReportOpType opType) {
        try (IFpmTraceSpan unAuditSpan = IFpmTracer.getInstance().createSpan(String.format("%s-%s", ReportBizService.class.getSimpleName(), "unAuditReport"));){
            block33: {
                FpmOperateResult<Void> fpmOperateResult;
                TXHandle h;
                block34: {
                    logger.info(String.format("\u62a5\u8868\u53cd\u5ba1\u6838\uff0c%s", report.getId()));
                    unAuditSpan.addTag("unAuditReport-loadSystem");
                    FundPlanSystem fundPlanSystem = this.dimRepo.loadSystem(report.getSystemId());
                    unAuditSpan.addTag("unAuditReport-checkReport");
                    h = TX.required();
                    Throwable throwable = null;
                    try {
                        FpmOperateResult<Void> mainReportUnAudit;
                        ReportTemplate template = report.getTemplate();
                        if (!template.isMainTable() || (mainReportUnAudit = this.mainReportUnAudit(report, fundPlanSystem)).isSuccess()) break block33;
                        h.markRollback();
                        fpmOperateResult = mainReportUnAudit;
                        if (h == null) return fpmOperateResult;
                        if (throwable == null) break block34;
                    }
                    catch (Exception e) {
                        h.markRollback();
                        logger.error("\u62a5\u8868\u53cd\u5ba1\u6838\u5f02\u5e38", (Throwable)e);
                        FpmOperateResult fpmOperateResult2 = FpmOperateResult.error(e.toString());
                        return fpmOperateResult2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                    try {
                        h.close();
                        return fpmOperateResult;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return fpmOperateResult;
                    }
                }
                h.close();
                return fpmOperateResult;
            }
            FpmOperateResult fpmOperateResult = FpmOperateResult.success();
            return fpmOperateResult;
        }
    }

    private FpmOperateResult<Void> mainReportUnAudit(Report report, FundPlanSystem fundPlanSystem) {
        try (IFpmTraceSpan auditSpan = IFpmTracer.getInstance().createSpan(String.format("%s-%s", ReportBizService.class.getSimpleName(), "mainReportUnAudit"));){
            auditSpan.addTag("mainReportUnAudit-querySubReport");
            List<Long> subReportIdS = this.reportRepo.querySubReportId(report.getId());
            List<Object> subReports = new ArrayList(16);
            if (!CollectionUtils.isEmpty(subReportIdS)) {
                subReports = this.reportRepo.loadReport(new HashSet<Long>(subReportIdS));
            }
            auditSpan.addTag("mainReportAudit-bizHandle");
            OrgMember reportOrg = report.getCompanyMemberList().get(0);
            SumPlanParamConfig sumPlanParamConfig = this.sumPlanRepository.loadSumConfigBySystem(report.getSystemId(), report.getReportPeriodType().getReportPeriodId());
            OrgMember sumOrgMember = SumPlanRelationHelper.getParentSumOrg(reportOrg, sumPlanParamConfig, fundPlanSystem);
            ReportStatus finalStatus = ReportStatus.DISABLE;
            String reportMainDataUpdateSql = "update t_fpm_reportdatamain set feffectflag =? where fid=?";
            String reportUpdateSql = "update t_fpm_report set fplanstatus=? where fid=?";
            LinkedList<Object[]> mainDataExeParams = new LinkedList<Object[]>();
            LinkedList<Object[]> dataExeParams = new LinkedList<Object[]>();
            mainDataExeParams.add(new Object[]{"0", report.getId()});
            dataExeParams.add(new Object[]{finalStatus.getVal(), report.getId()});
            report.setReportStatus(finalStatus);
            report.getReportDataList().forEach(item -> item.setEffectFlag(false));
            for (Report report2 : subReports) {
                mainDataExeParams.add(new Object[]{"0", report2.getId()});
                dataExeParams.add(new Object[]{finalStatus.getVal(), report2.getId()});
                report2.setReportStatus(finalStatus);
                report2.getReportDataList().forEach(item -> item.setEffectFlag(false));
            }
            auditSpan.addTag("mainReportUAudit-loadInoutColl");
            HashSet<Long> reportIdS = new HashSet<Long>();
            reportIdS.add(report.getId());
            reportIdS.addAll(subReports.stream().map(Report::getId).collect(Collectors.toList()));
            if (sumOrgMember != null) {
                ArrayList<Report> arrayList = new ArrayList<Report>(reportIdS.size());
                arrayList.add(report);
                arrayList.addAll(subReports);
                auditSpan.addTag("mainReportAudit-sumOrgSum");
                ReportQDTO reportQDTO = new ReportQDTO();
                reportQDTO.setReportOrgId(sumOrgMember.getId());
                reportQDTO.setReportPeriodId(report.getPeriodMemberList().get(0).getId());
                reportQDTO.setReportPlanType(ReportPlanType.SUMPLAN);
                auditSpan.addTag("mainReportAudit-loadSumOrgData");
                List<Report> sumPlanReportList = this.reportRepo.loadReportWithAllDimensionByParam(reportQDTO);
                if (!CollectionUtils.isEmpty(sumPlanReportList)) {
                    List finalSumPlanReportList = sumPlanReportList.stream().map(item -> (SumPlanReport)item).collect(Collectors.toList());
                    auditSpan.addTag("mainReportAudit-sumPlanReportSum");
                    FpmOperateResult<SumPlanUpdateInfo> sumPlanResult = this.sumPlanService.cancelSumPlanReportUpper(arrayList, (SumPlanReport)finalSumPlanReportList.get(0), fundPlanSystem);
                    if (!sumPlanResult.isSuccess()) {
                        FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.error(sumPlanResult.getMessageList());
                        return fpmOperateResult;
                    }
                    this.sumPlanDataService.batchSaveSumPlanUpdateInfo(sumPlanResult.getData());
                }
            }
            auditSpan.addTag("mainReportAudit-db");
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)reportMainDataUpdateSql, mainDataExeParams);
            DB.executeBatch((DBRoute)DBRouteConst.TMC, (String)reportUpdateSql, dataExeParams);
            if (sumOrgMember == null) {
                this.shrekReportDataService.syncReport(report.getId());
            }
            List<InoutCollect> list = this.inoutCollectRep.loadByReportId(reportIdS);
            auditSpan.addTag("mainReportUAudit-handleInoutColl");
            FpmOperateResult<Void> inOutHandel = this.reportUnAuditInOutHandel(list, reportIdS);
            if (!inOutHandel.isSuccess()) {
                FpmOperateResult<Void> fpmOperateResult = inOutHandel;
                return fpmOperateResult;
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.inoutCollectRep.save(list);
            }
        }
        return FpmOperateResult.success();
    }

    private FpmOperateResult<Void> reportUnAuditInOutHandel(List<InoutCollect> inoutCollectList, Set<Long> reportIdS) {
        List otherInOutList = inoutCollectList.stream().filter(item -> {
            List<InoutCollect.InoutReportRelation> inoutReportRelationList = item.getInoutReportRelationList();
            return inoutReportRelationList.stream().anyMatch(o -> !reportIdS.contains(o.getPlanReportId()));
        }).collect(Collectors.toList());
        List otherEnableReportIdS = null;
        if (!CollectionUtils.isEmpty(otherInOutList)) {
            Set<Long> reportIdSet = otherInOutList.stream().map(InoutCollect::getInoutReportRelationList).flatMap(Collection::stream).map(InoutCollect.InoutReportRelation::getPlanReportId).collect(Collectors.toSet());
            ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
            reportNeedPropDTO.setNeedReportStatus(true);
            List<Report> reports = this.reportRepo.loadSimpleReport(reportIdSet, reportNeedPropDTO);
            otherEnableReportIdS = reports.stream().filter(item -> item.getReportStatus() == ReportStatus.ENABLE).map(Report::getId).collect(Collectors.toList());
        }
        List finalOtherEnableReportIdS = otherEnableReportIdS;
        inoutCollectList.stream().filter(item -> {
            if (CollectionUtils.isEmpty((Collection)finalOtherEnableReportIdS)) {
                return true;
            }
            List<InoutCollect.InoutReportRelation> inoutReportRelationList = item.getInoutReportRelationList();
            return inoutReportRelationList.stream().noneMatch(o -> finalOtherEnableReportIdS.contains(o.getPlanReportId()));
        }).forEach(item -> item.setApplyStatus(ApplyStatus.APPLYING));
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult unSubmitReport(Report report, ReportOpType opType) {
        if (ReportOpType.SERVICE.getNumber().equals(opType.getNumber())) {
            this.reportRepo.unSubmit(report.getId());
        }
        return FpmOperateResult.success();
    }

    private Pair<Boolean, Object> transferDetailDimVal4SmartGel(Dimension currDim, Object bizVal, Object counterpartyTypeVal, BaseDataByNameProvider baseDataByNameProvider) {
        MemberType memberType = currDim.getMemberType();
        if (currDim.getDetailDimType() == DetailDimType.PLAN_AMOUNT) {
            return Pair.of((Object)Boolean.FALSE, null);
        }
        Object finalBizVal = bizVal;
        if (memberType == MemberType.DATE) {
            finalBizVal = Objects.isNull(bizVal) ? null : DateUtils.stringToDate((String)bizVal.toString(), (String)"yyyy-MM-dd");
        } else if (memberType == MemberType.AMOUNT) {
            finalBizVal = bizVal != null ? new BigDecimal(bizVal.toString()) : BigDecimal.ZERO;
        } else if (memberType == MemberType.TEXT) {
            finalBizVal = bizVal != null ? bizVal.toString() : "";
        } else if (memberType == MemberType.BASE_DATA) {
            DynamicObject baseData;
            DetailDimType detailDimType = currDim.getDetailDimType();
            switch (detailDimType) {
                case BANK_CATE: 
                case BANK_ACCOUNT: 
                case BUSINESS_PARTNER: {
                    baseData = baseDataByNameProvider.getBaseData(detailDimType.getExtVal().toString(), bizVal);
                    break;
                }
                case COUNTERPARTY_NAME: {
                    baseData = Objects.isNull(counterpartyTypeVal) ? null : baseDataByNameProvider.getBaseData(counterpartyTypeVal.toString(), bizVal);
                    break;
                }
                default: {
                    baseData = baseDataByNameProvider.getBaseData(currDim.getBaseDataType(), bizVal);
                }
            }
            finalBizVal = Objects.nonNull(baseData) ? baseData.getLong("id") : 0L;
        }
        return Pair.of((Object)Boolean.TRUE, (Object)finalBizVal);
    }

    private MappingInfo matchingDimMemberMapping(MatchMapping matchMapping, BillBizInfo billBizInfo, Set<Long> tplMemberScope, DimMappingBaseDataProvider dimMappingBaseDataProvider) {
        DimMemberMappingStrategy iMappingStrategy = new DimMemberMappingStrategy(matchMapping, billBizInfo, true, tplMemberScope, dimMappingBaseDataProvider);
        iMappingStrategy.process();
        return iMappingStrategy.getResult();
    }

    private BigDecimal convertCurrencyAmtIfNeed(DimMember matchedDimMember, MappingInfo matchedMappingInfo, Map<Long, Dimension> dimList, Map<String, BigDecimal> exchangeRateMap, BigDecimal matchedPlanAmt, Report report) {
        BigDecimal rate;
        if (matchedDimMember == null || matchedMappingInfo == null || !dimList.containsKey(matchedDimMember.getDimensionId()) || !dimList.get(matchedDimMember.getDimensionId()).getDimType().isCurrencyDim()) {
            return matchedPlanAmt;
        }
        Long targetCurrencyId = matchedDimMember.getSourceId();
        Long sourceCurrencyId = matchedMappingInfo.getMainId();
        if (Objects.equals(sourceCurrencyId, targetCurrencyId)) {
            return matchedPlanAmt;
        }
        String rateKey = sourceCurrencyId + "#" + targetCurrencyId;
        if (exchangeRateMap.containsKey(rateKey)) {
            rate = exchangeRateMap.get(rateKey);
            if (rate == null) {
                return null;
            }
        } else {
            rate = BaseDataServiceHelper.getExchangeRate((Long)report.getExchangeRateTableId(), (Long)sourceCurrencyId, (Long)targetCurrencyId, (Date)report.getExchangeRateDate());
            if (rate == null) {
                exchangeRateMap.put(rateKey, null);
                return null;
            }
            exchangeRateMap.put(rateKey, rate);
        }
        matchedPlanAmt = matchedPlanAmt.multiply(rate);
        return matchedPlanAmt;
    }

    private List<String> buildNonExistRateErrorMsgIfNeed(Map<String, BigDecimal> exchangeRateMap) {
        LinkedList<String> errorMsgList = new LinkedList<String>();
        exchangeRateMap.forEach((rateKey, rate) -> {
            if (rate == null) {
                String[] currencyId = rateKey.split("#");
                DynamicObject sourceCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(currencyId[0]), (String)"bd_currency", (String)"name");
                DynamicObject targetCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(currencyId[1]), (String)"bd_currency", (String)"name");
                errorMsgList.add(String.format(ResManager.loadKDString((String)"%1$s\u548c%2$s\u5e01\u79cd\u4e4b\u95f4\u7f3a\u5c11\u8f6c\u6362\u6c47\u7387\uff0c\u8bf7\u5148\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"ReportPoConverter_1", (String)"tmc-fpm-business", (Object[])new Object[0]), sourceCurrency.getString("name"), targetCurrency.getString("name")));
            }
        });
        return errorMsgList;
    }

    private void afterSmartGelReportData(Report report, Set<ReportData> currBatchGelDataSet, FundPlanSystem system) {
        ReportTemplate template = report.getTemplate();
        if (template.getTemplateType() == TemplateType.FIXED) {
            List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
            List inputMemIdList = accountSettings.stream().filter(item -> item.getInputType() == ReportInputType.MANUAL_INPUT).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toList());
            report.getReportDataList().stream().forEach(item -> {
                Object subjectId = item.getDimValByDimType(DimensionType.SUBJECTS);
                if (!currBatchGelDataSet.contains(item) && inputMemIdList.contains(subjectId)) {
                    item.setPlanReferenceAmt(BigDecimal.ZERO);
                    item.setDirty(true);
                }
            });
        }
        if (template.getTemplateType() == TemplateType.DETAIL) {
            List<ReportData> finalList = report.getReportDataList().stream().filter(item -> currBatchGelDataSet.contains(item) || CollectionUtils.isEmpty(item.getSourceIdList())).collect(Collectors.toList());
            report.setReportDataList(finalList);
            ReportHelper.resetDetailReportRow(report, system);
        }
    }

    private void asyncUpdateUnCompleteApprovedRecordIfNeed(Long sumOrgId, Long reportPeriodId, SumPlanReport sumPlanReport) {
        QFilter qFilter = new QFilter("reportorg", "=", (Object)sumOrgId).and("reportperiod", "=", (Object)reportPeriodId);
        List sumPlanRecordIds = QueryServiceHelper.queryPrimaryKeys((String)"fpm_reportplansum", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)sumPlanRecordIds)) {
            return;
        }
        Long sumPlanRecordId = (Long)sumPlanRecordIds.get(0);
        ApprovedAmountRecord approvedAmountRecord = this.sumPlanRepository.loadApprovedAmtBySumId(sumPlanRecordId);
        if (EmptyUtil.isEmpty((Object)approvedAmountRecord)) {
            return;
        }
        Long taskId = DB.genGlobalLongId();
        logger.info("\u4e3b\u8868\u8ffd\u52a0\u4e0a\u6c47\u6c47\u603b\u8868[{}]-\u9700\u8981\u66f4\u65b0\u6c47\u603b\u8bb0\u5f55[{}]-\u672a\u5b8c\u5168\u6838\u5b9a\u7684\u6838\u5b9a\u8bb0\u5f55[{}]-\u5f02\u6b65\u66f4\u65b0\u4efb\u52a1ID[{}]", new Object[]{sumPlanReport.getId(), sumPlanRecordId, approvedAmountRecord.getId(), taskId});
        TaskRecord taskRecord = new TaskRecord();
        taskRecord.setId(taskId);
        taskRecord.setTaskType(TaskType.UN_COMPLETE_APPROVED_RECORD_UPDATE_TASK.name());
        taskRecord.setStatus(TaskStatus.WAITING.name());
        taskRecord.setGroupId(String.valueOf(sumPlanReport.getSystemId()));
        HashMap param = Maps.newHashMapWithExpectedSize((int)2);
        param.put("sumPlanRecordId", sumPlanRecordId);
        param.put("systemId", sumPlanReport.getSystemId());
        taskRecord.setTaskInfo(SerializationUtils.toJsonString((Object)param));
        this.taskHandleService.saveTask(taskRecord);
        TMCMQPublisher.sendFpmDefaultMsg(MQBusinessTypeEnum.LOCAL_SEQUENT_TASK, SerializationUtils.toJsonString((Object)taskRecord));
    }

    @Override
    public FpmOperateResult<Void> recalculateReportPlanAmt(RecalculateReportPlanAmtParamDTO qParam) {
        DynamicObjectCollection reportDyColl = QueryServiceHelper.query((String)"fpm_report", (String)String.join((CharSequence)",", ReportProp.loadRecalculateAmtProps()), (QFilter[])new QFilter[]{new QFilter("id", "in", qParam.getReportIds())});
        Map reportDyMap = reportDyColl.stream().collect(Collectors.toMap(key -> key.getLong("id"), Function.identity(), (a, b) -> a));
        HashSet reportOrgIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashMap detailSubReportMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap fixSubReportMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap mainReportMap = Maps.newHashMapWithExpectedSize((int)16);
        qParam.getReportIds().stream().filter(reportDyMap::containsKey).forEach(reportId -> {
            DynamicObject reportDy = (DynamicObject)reportDyMap.get(reportId);
            Long reportOrgId = reportDy.getLong("reportorg.id");
            reportOrgIdSet.add(reportOrgId);
            boolean isMainTable = reportDy.getBoolean("templatebak.ismaintable");
            if (isMainTable) {
                mainReportMap.put(reportOrgId, reportId);
                return;
            }
            String templateType = reportDy.getString("templatebak.templatetype");
            if (TemplateType.DETAIL == TemplateType.getByNumber(templateType)) {
                List detailSubReportIds = detailSubReportMap.computeIfAbsent(reportOrgId, val -> new LinkedList());
                detailSubReportIds.add(reportId);
                return;
            }
            if (TemplateType.FIXED == TemplateType.getByNumber(templateType)) {
                List fixSubReportIds = fixSubReportMap.computeIfAbsent(reportOrgId, val -> new LinkedList());
                fixSubReportIds.add(reportId);
            }
        });
        FundPlanSystem fundPlanSystem = this.dimRepo.loadSystem(qParam.getSystemId());
        for (Long reportOrgId : reportOrgIdSet) {
            Report mainReport = null;
            HashSet successSubReportIdSet = Sets.newHashSetWithExpectedSize((int)4);
            if (mainReportMap.containsKey(reportOrgId)) {
                mainReport = this.reportRepo.loadReportWithAllDimension((Long)mainReportMap.get(reportOrgId));
            }
            if (detailSubReportMap.containsKey(reportOrgId)) {
                List detailSubReportIds = (List)detailSubReportMap.get(reportOrgId);
                Set<Long> successDetailSubReportIdSet = this.recalculateDetailSubReportAmt(detailSubReportIds, fundPlanSystem, mainReport);
                successSubReportIdSet.addAll(successDetailSubReportIdSet);
            }
            if (fixSubReportMap.containsKey(reportOrgId)) {
                List fixSubReportIds = (List)fixSubReportMap.get(reportOrgId);
                Set<Long> successFixSubReportIdSet = this.recalculateFixSubReportAmt(fixSubReportIds, fundPlanSystem, mainReport);
                successSubReportIdSet.addAll(successFixSubReportIdSet);
            }
            if (mainReport == null) continue;
            this.recalculateMainReportAmt(mainReport, fundPlanSystem, successSubReportIdSet);
        }
        return FpmOperateResult.success();
    }

    private FpmOperateResult saveReportWithoutSumToParent(Report report, FundPlanSystem system) {
        logger.info(String.format("\u62a5\u8868\u4fdd\u5b58\uff0c%s", report.getId()));
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            this.reportService.calculateReport(report, system);
            this.reportService.reBuildReportData(report, system, true);
            report.getReportDataList().stream().filter(rd -> !rd.isEffectFlag()).forEach(rd -> {
                rd.setEffectFlag(true);
                rd.setDirty(Boolean.TRUE);
            });
            ReportHelper.checkReportDataAmt(report);
            FpmOperateResult<Boolean> fpmOperateResult = this.reportDataSaveService.saveReportData(report);
            return fpmOperateResult;
        }
        catch (Exception e) {
            logger.error("\u62a5\u8868[{}]\u4fdd\u5b58\u5f02\u5e38, {}", new Object[]{report.getId(), e.getMessage(), e});
            tx.markRollback();
            FpmOperateResult fpmOperateResult = FpmOperateResult.error(e.getMessage());
            return fpmOperateResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private Set<Long> recalculateDetailSubReportAmt(List<Long> detailSubReportIds, FundPlanSystem fundPlanSystem, Report mainReport) {
        HashSet<Long> successReportIdSet = new HashSet<Long>(detailSubReportIds);
        List<Report> detailSubReports = this.reportRepo.loadReport(successReportIdSet);
        for (Report detailReport : detailSubReports) {
            FpmOperateResult saveResult = this.saveReportWithoutSumToParent(detailReport, fundPlanSystem);
            if (!saveResult.isSuccess()) {
                successReportIdSet.remove(detailReport.getId());
                continue;
            }
            if (mainReport == null) continue;
            this.clearMainReportDetailInputSubjectAmt(mainReport, detailReport, fundPlanSystem);
            this.reportService.sumToParent(mainReport, detailReport, fundPlanSystem, MetricValueUtils.listAllBaseMetricMember(fundPlanSystem));
        }
        return successReportIdSet;
    }

    private Set<Long> recalculateFixSubReportAmt(List<Long> fixSubReportIds, FundPlanSystem fundPlanSystem, Report mainReport) {
        HashSet<Long> successFixSubReportIdSet = new HashSet<Long>(fixSubReportIds);
        List<Report> fixSubReports = this.reportRepo.loadReport(successFixSubReportIdSet);
        for (Report fixReport : fixSubReports) {
            this.reportService.genEmptyReportData(fixReport, fundPlanSystem, false);
            FpmOperateResult saveResult = this.saveReportWithoutSumToParent(fixReport, fundPlanSystem);
            if (!saveResult.isSuccess()) {
                successFixSubReportIdSet.remove(fixReport.getId());
                continue;
            }
            if (mainReport == null) continue;
            this.clearMainReportDetailInputSubjectAmt(mainReport, fixReport, fundPlanSystem);
            this.reportService.sumToParent(mainReport, fixReport, fundPlanSystem, MetricValueUtils.listAllBaseMetricMember(fundPlanSystem));
        }
        return successFixSubReportIdSet;
    }

    private void recalculateMainReportAmt(Report mainReport, FundPlanSystem fundPlanSystem, Set<Long> upperSumSubReportIdSet) {
        List<Long> allSubReportIds = this.reportRepo.querySubReportId(mainReport.getId());
        Set<Long> noneUpperSumSubReportIdSet = allSubReportIds.stream().filter(reportId -> !upperSumSubReportIdSet.contains(reportId)).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(noneUpperSumSubReportIdSet)) {
            List<Report> subReports = this.reportRepo.loadReport(noneUpperSumSubReportIdSet);
            for (Report subReport : subReports) {
                this.reportService.sumToParent(mainReport, subReport, fundPlanSystem, MetricValueUtils.listAllBaseMetricMember(fundPlanSystem));
            }
        }
        this.reportService.genEmptyReportData(mainReport, fundPlanSystem, false);
        this.saveReportWithoutSumToParent(mainReport, fundPlanSystem);
    }

    private void clearMainReportDetailInputSubjectAmt(Report mainReport, Report subReport, FundPlanSystem fundPlanSystem) {
        ReportTemplate subTemplate;
        ReportTemplate parentTemplate = mainReport.getTemplate();
        Set<Long> detailInputSubjectIdSet = TemplateInfoHelper.loadNeedSummaryToMainReportAllSubjectIds(parentTemplate, subTemplate = subReport.getTemplate());
        if (detailInputSubjectIdSet.isEmpty()) {
            return;
        }
        Dimension subjectDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.SUBJECTS);
        mainReport.getReportDataList().stream().filter(rd -> !rd.isAuxiliaryInfo()).filter(rd -> {
            Object subjectId = rd.getDimValByDimensionId(subjectDim.getId());
            return detailInputSubjectIdSet.contains(subjectId);
        }).forEach(ReportData::clearAmt);
    }

    private static /* synthetic */ ReportTemplate lambda$generateReportByPrepareId$19(ReportTemplate k1, ReportTemplate k2) {
        return k1;
    }

    private static /* synthetic */ PeriodMember lambda$generateReportByPrepareId$18(PeriodMember k1, PeriodMember k2) {
        return k1;
    }

    private static /* synthetic */ DimMember lambda$generateReportByPrepareId$17(DimMember k1, DimMember k2) {
        return k1;
    }

    private static /* synthetic */ ReportGenerateInfo lambda$generateReportByPrepareId$16(ReportGenerateInfo k1, ReportGenerateInfo k2) {
        return k1;
    }

    private static /* synthetic */ String lambda$generateReportByPrepareId$15(ReportGenerateInfo item) {
        return String.join((CharSequence)"#", item.getReportOrgId() + "", item.getPeriodMemberId() + "", item.getParentTemplateId() + "");
    }

    private static /* synthetic */ boolean lambda$generateReportByPrepareId$14(List needBackupTemplateIdList, ReportTemplate item) {
        return needBackupTemplateIdList.contains(item.getId()) && item.getStatAnalysisTemplateList() != null;
    }

    private static /* synthetic */ ReportUniqueCondition lambda$generateReportByPrepareId$13(Map.Entry item) {
        return (ReportUniqueCondition)item.getKey();
    }

    private static /* synthetic */ boolean lambda$generateReportByPrepareId$12(Map.Entry item) {
        return (Boolean)item.getValue() == false;
    }

    private static /* synthetic */ String lambda$generateReportByPrepareId$11(Long item) {
        return item.toString();
    }

    private static /* synthetic */ String lambda$generateReportByPrepareId$10(Long item) {
        return item.toString();
    }

    private static /* synthetic */ List lambda$generateReportByPrepareId$9(List o1, List o2) {
        return o1;
    }

    private static /* synthetic */ List lambda$generateReportByPrepareId$8(ReportTemplate item) {
        return item.getAccountSettings().stream().filter(accountItem -> accountItem.getChildTemplateId() != null).map(TemplateAccountSetting::getChildTemplateId).collect(Collectors.toList());
    }

    private static /* synthetic */ List lambda$generateReportByPrepareId$6(List o1, List o2) {
        return o1;
    }

    private static /* synthetic */ List lambda$generateReportByPrepareId$5(List enableOrgIds, ReportTemplate obj) {
        return obj.getUserIdList().stream().filter(userid -> !CollectionUtils.isEmpty((Collection)enableOrgIds) && enableOrgIds.contains(userid)).collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$generateReportByPrepareId$3(Map orgAndSumMap, ReportTemplate item) {
        return item.isRelease() && item.isEnable() && item.isMainTable() && !CollectionUtils.isEmpty(item.getUserIdList()) && (item.getTemplateUse() == TemplateUseType.PLANING || item.getTemplateUse() == TemplateUseType.SUMMARY && orgAndSumMap != null);
    }

    private static /* synthetic */ boolean lambda$generateReportByPrepareId$2(PeriodMember item) {
        return !item.isEnable();
    }

    private static /* synthetic */ boolean lambda$generateReportByPrepareId$1(Date currMonthFirstDay, Date finalStartDateEnd, PeriodMember o) {
        return currMonthFirstDay.compareTo(o.getStartDate()) <= 0 && finalStartDateEnd.compareTo(o.getStartDate()) >= 0;
    }

    private static /* synthetic */ boolean lambda$generateReportByPrepareId$0(FundPlanSystem system, DimMember dimMember) {
        return dimMember.getSourceId().equals(system.getOrgId());
    }
}

