/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ExecDetailRecordVO;
import kd.tmc.fpm.business.domain.model.report.ExecRecordDTO;
import kd.tmc.fpm.business.domain.model.report.ExecRecordVO;
import kd.tmc.fpm.business.domain.model.report.LimitRecordDTO;
import kd.tmc.fpm.business.domain.model.report.LinkExecRecordParamDTO;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.service.IControlTraceService;
import kd.tmc.fpm.business.mvc.service.IReportLinkExecRecordBizService;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.ExecutePlanOpTypeEnum;
import kd.tmc.fpm.common.enums.ExecuteStatusEnum;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import kd.tmc.fpm.common.utils.AmountUtil;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ReportLinkExecRecordBizServiceImpl
implements IReportLinkExecRecordBizService {
    private final IDimensionRepository dimRepo = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private final IReportDataQueryService iReportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
    private final IControlTraceService iControlTraceService = FpmServiceFactory.getBizService(IControlTraceService.class);
    private final ISummaryConfigService iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);
    private static final int LIMIT_RECORD_MAX_SIZE = 10000;
    private static final int LIMIT_RECORD_SINGLE_SIZE = 1000;

    @Override
    public FpmOperateResult<List<LimitRecordDTO>> loadLimitRecords(LinkExecRecordParamDTO queryParam) {
        FundPlanSystem fundPlanSystem = this.dimRepo.loadSystem(queryParam.getBodySystemId());
        ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(fundPlanSystem.getMainDimList().size());
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(fundPlanSystem.getMainDimList().size());
        for (Dimension dimension : fundPlanSystem.getMainDimList()) {
            List<Long> members;
            if (DimensionType.SUBJECTS == dimension.getDimType()) {
                dimIdList.add(dimension);
                List<Long> subjectMemberList = org.apache.commons.collections.CollectionUtils.isNotEmpty(queryParam.getSubjectIds()) ? new ArrayList<Long>(this.getAllLeafMemberIdsIfContains(dimension, new HashSet<Long>(queryParam.getSubjectIds()))) : this.listDimAllMemberId(dimension);
                FlowType flowType = FlowType.getByNumber(queryParam.getFlow());
                ArrayList<Long> memberList = flowType == FlowType.NONLIMIT ? new ArrayList<Long>(subjectMemberList) : dimension.getAllDimMemberList().stream().filter(member -> subjectMemberList.contains(member.getId())).map(o -> (AccountMember)o).filter(account -> account.getFlowType() == flowType).map(DimMember::getId).collect(Collectors.toList());
                dimValList.add(memberList);
                continue;
            }
            if (DimensionType.PERIOD == dimension.getDimType() && org.apache.commons.collections.CollectionUtils.isNotEmpty(queryParam.getPeriodIds())) {
                dimIdList.add(dimension);
                ReportPeriodType reportPeriodType = fundPlanSystem.getReportTypeList().stream().filter(type -> type.getReportPeriodId().compareTo(queryParam.getReportTypeId()) == 0).findAny().get();
                List periodIds = Objects.nonNull((Object)reportPeriodType.getDetailPeriodType()) ? dimension.getAllDimMemberList().stream().map(PeriodMember.class::cast).filter(periodMember -> Objects.equals(periodMember.getPeriodTypeId(), reportPeriodType.getReportPeriodId())).filter(periodMember -> periodMember.getPeriodType() == reportPeriodType.getDetailPeriodType()).filter(periodMember -> queryParam.getPeriodIds().contains(periodMember.getParentId())).map(DimMember::getId).collect(Collectors.toList()) : queryParam.getPeriodIds().stream().map(item -> item).collect(Collectors.toList());
                dimValList.add(periodIds);
                continue;
            }
            if (DimensionType.ORG == dimension.getDimType() && org.apache.commons.collections.CollectionUtils.isNotEmpty(queryParam.getOrgIds())) {
                dimIdList.add(dimension);
                dimValList.add(new ArrayList<Long>(this.loadAllLeafOrgIdsIfContains(queryParam, dimension, new HashSet<Long>(queryParam.getOrgIds()))));
                continue;
            }
            if (DimensionType.CURRENCY == dimension.getDimType() && org.apache.commons.collections.CollectionUtils.isNotEmpty(queryParam.getCurrencyIds())) {
                dimIdList.add(dimension);
                dimValList.add(queryParam.getCurrencyIds().stream().map(item -> item).collect(Collectors.toList()));
                continue;
            }
            if (DimensionType.COMPANY == dimension.getDimType() && org.apache.commons.collections.CollectionUtils.isNotEmpty(queryParam.getCompanyIds())) {
                dimIdList.add(dimension);
                dimValList.add(new ArrayList<Long>(queryParam.getCompanyIds()));
            }
            if (DimensionType.SETTLEMENT_TYPE == dimension.getDimType() && org.apache.commons.collections.CollectionUtils.isNotEmpty(queryParam.getSettlementMethodIds())) {
                dimIdList.add(dimension);
                dimValList.add(new ArrayList<Long>(queryParam.getSettlementMethodIds()));
            }
            if (DimensionType.CUSTOM != dimension.getDimType() || !MapUtils.isNotEmpty(queryParam.getCustomDimension()) || !org.apache.commons.collections.CollectionUtils.isNotEmpty(members = queryParam.getCustomDimension().get(dimension.getId()))) continue;
            dimIdList.add(dimension);
            dimValList.add(members.stream().map(item -> item).collect(Collectors.toList()));
        }
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        queryObject.setDimIdList(dimIdList);
        queryObject.setDimValList(dimValList);
        queryObject.setReportPeriodIds(queryParam.getPeriodIds());
        queryObject.setResource("openApi");
        queryObject.setMainTable(TemplateType.FIXED == queryParam.getPlanQueryScope());
        queryObject.setTemplateType(queryParam.getPlanQueryScope());
        queryObject.setQueryDetail(TemplateType.DETAIL == queryParam.getPlanQueryScope());
        Optional<Object> singleSizeOpt = Optional.ofNullable(FpmGlobalConfigHelper.loadConfig((String)"lsinglesize"));
        int singleSize = singleSizeOpt.map(o -> Integer.parseInt(o.toString())).orElse(1000);
        singleSize = Math.min(singleSize, 10000);
        queryObject.setIdTopSize(singleSize);
        List<ReportDataQueryResult> resultList = this.iReportDataQueryService.queryReportData(queryObject);
        List<LimitRecordDTO> limitRecordDTOList = this.converterToLimitRecordDTO(resultList, queryParam.getAmountUnit());
        return FpmOperateResult.success(limitRecordDTOList);
    }

    @Override
    public FpmOperateResult<List<ExecRecordVO>> beforeLoadExecRecords(LinkExecRecordParamDTO queryParam) {
        LinkedList<ExecRecordVO> execRecordVOList;
        String entryReportDataIdProp = String.join((CharSequence)".", "hold_entryentity", "hold_reportdataid");
        QFilter qFilter = new QFilter(entryReportDataIdProp, "in", queryParam.getReportDataIds()).and("executeoperatorstatus", "=", (Object)PlanExecuteStatus.SUCCESSFUL.getValue()).and("bodysys", "=", (Object)queryParam.getBodySystemId()).and("deleteflag", "=", (Object)"0");
        String groupByFields = String.join((CharSequence)",", "bizbillid", entryReportDataIdProp);
        DataSet originalDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"fpm_executeplan", (String)groupByFields, (QFilter[])qFilter.toArray(), (String)groupByFields);
        try (DataSet groupByDataSet = originalDataSet.groupBy(new String[]{"bizbillid", entryReportDataIdProp}).finish();){
            execRecordVOList = new LinkedList<ExecRecordVO>();
            while (groupByDataSet.hasNext()) {
                Row rowData = groupByDataSet.next();
                ExecRecordVO execRecordVO = new ExecRecordVO();
                execRecordVO.setBizBillId(rowData.getLong("bizbillid"));
                execRecordVO.setReportDataId(rowData.getLong(entryReportDataIdProp));
                execRecordVOList.add(execRecordVO);
            }
        }
        return FpmOperateResult.success(execRecordVOList);
    }

    @Override
    public FpmOperateResult<List<ExecRecordVO>> loadExecRecords(LinkExecRecordParamDTO queryParam) {
        List<ExecRecordDTO> execRecordDTOList;
        String entryReportDataIdProp = String.join((CharSequence)".", "hold_entryentity", "hold_reportdataid");
        QFilter qFilter = new QFilter(entryReportDataIdProp, "in", queryParam.getReportDataIds()).and("executeoperatorstatus", "=", (Object)PlanExecuteStatus.SUCCESSFUL.getValue()).and("bodysys", "=", (Object)queryParam.getBodySystemId()).and("deleteflag", "=", (Object)"0");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(queryParam.getLastPageBizBillIds()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(queryParam.getLastPageReportDataIds())) {
            qFilter.and(entryReportDataIdProp, "in", queryParam.getLastPageReportDataIds()).and("bizbillid", "in", queryParam.getLastPageBizBillIds());
        }
        Set<String> execPlanPropertySet = this.getExecPlanSumPropertySet();
        String orderByFields = String.join((CharSequence)",", "bizbillid", entryReportDataIdProp, "id");
        try (DataSet execPlanDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"fpm_executeplan", (String)String.join((CharSequence)",", execPlanPropertySet), (QFilter[])qFilter.toArray(), (String)orderByFields);){
            execRecordDTOList = this.convert(execPlanDataSet, queryParam.getAmountUnit());
        }
        return FpmOperateResult.success(this.sumExecRecordByBizBill(execRecordDTOList));
    }

    @Override
    public FpmOperateResult<List<ExecDetailRecordVO>> beforeLoadExecDetailRecords(LinkExecRecordParamDTO queryParam) {
        LinkedList<ExecDetailRecordVO> execDetailRecordVOList;
        String entryReportDataIdProp = String.join((CharSequence)".", "hold_entryentity", "hold_reportdataid");
        QFilter qFilter = new QFilter("bodysys", "=", (Object)queryParam.getBodySystemId()).and("executeoperatorstatus", "=", (Object)ExecuteStatusEnum.SUCCESSFUL.getValue()).and("deleteflag", "=", (Object)"0").and(entryReportDataIdProp, "in", queryParam.getReportDataIds());
        String orderByFields = String.join((CharSequence)",", entryReportDataIdProp, "id");
        DataSet execPlanDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"fpm_executeplan", (String)"id", (QFilter[])qFilter.toArray(), (String)orderByFields);
        try (DataSet groupByDataSet = execPlanDataSet.groupBy(new String[]{"id"}).finish();){
            execDetailRecordVOList = new LinkedList<ExecDetailRecordVO>();
            while (groupByDataSet.hasNext()) {
                Row rowData = groupByDataSet.next();
                ExecDetailRecordVO execDetailRecordVO = new ExecDetailRecordVO();
                execDetailRecordVO.setExecutePlanId(rowData.getLong("id"));
                execDetailRecordVOList.add(execDetailRecordVO);
            }
        }
        return FpmOperateResult.success(execDetailRecordVOList);
    }

    @Override
    public FpmOperateResult<List<ExecDetailRecordVO>> loadExecDetailRecords(LinkExecRecordParamDTO queryParam) {
        QFilter qFilter = new QFilter("id", "in", queryParam.getLastPageExecutePlanIds());
        Set<String> execPlanPropertySet = this.getExecPlanDetailPropertySet();
        String orderByFields = String.join((CharSequence)",", "id");
        try (DataSet execPlanDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"fpm_executeplan", (String)String.join((CharSequence)",", execPlanPropertySet), (QFilter[])qFilter.toArray(), (String)orderByFields);){
            FpmOperateResult<List<ExecDetailRecordVO>> fpmOperateResult = FpmOperateResult.success(this.convertToExecDetailRecordDTO(execPlanDataSet, queryParam.getAmountUnit()));
            return fpmOperateResult;
        }
    }

    private List<LimitRecordDTO> converterToLimitRecordDTO(List<ReportDataQueryResult> resultList, AmountUnit targetAmountUnit) {
        ArrayList<LimitRecordDTO> result = new ArrayList<LimitRecordDTO>(resultList.size());
        AmountUnitEnum targetAmountUnitEnum = AmountUnitEnum.get((String)targetAmountUnit.getNumber());
        HashMap<Long, Long> currencyIdMap = new HashMap<Long, Long>(4, 1.0f);
        for (ReportDataQueryResult reportDataQueryResult : resultList) {
            if (NumberUtils.equalsZero((BigDecimal)reportDataQueryResult.getPlanAmt()) && NumberUtils.equalsZero((BigDecimal)reportDataQueryResult.getActAmt()) && NumberUtils.equalsZero((BigDecimal)reportDataQueryResult.getLockAmt()) && NumberUtils.equalsZero((BigDecimal)reportDataQueryResult.getApplyPlanAmt()) && NumberUtils.equalsZero((BigDecimal)reportDataQueryResult.getOriginalPlanAmt()) && NumberUtils.equalsZero((BigDecimal)reportDataQueryResult.getOffsetAmt()) || reportDataQueryResult.isAuxiliaryInfo()) continue;
            LimitRecordDTO recordDTO = new LimitRecordDTO();
            recordDTO.setId(reportDataQueryResult.getId());
            recordDTO.setVersion(reportDataQueryResult.getVersion() + 1);
            recordDTO.setDimList(reportDataQueryResult.getDimList());
            recordDTO.setDimValList(reportDataQueryResult.getDimValList());
            recordDTO.setReportPeriodId(reportDataQueryResult.getDimList().stream().filter(item -> item.getDimType() == DimensionType.PERIOD).findFirst().get().getId());
            recordDTO.setReportId(reportDataQueryResult.getReportId());
            recordDTO.setMainTable(reportDataQueryResult.isMainTable());
            recordDTO.setOffsetAmt(reportDataQueryResult.getOffsetAmt());
            recordDTO.setRow(reportDataQueryResult.getRow());
            recordDTO.setCol(reportDataQueryResult.getCol());
            AmountUnitEnum sourceAmountUnitEnum = AmountUnitEnum.get((String)reportDataQueryResult.getAmountUnit().getNumber());
            recordDTO.setAmountUnit(targetAmountUnit);
            recordDTO.setActAmt(AmountUtil.convert((AmountUnitEnum)sourceAmountUnitEnum, (AmountUnitEnum)targetAmountUnitEnum, (BigDecimal)Optional.ofNullable(reportDataQueryResult.getActAmt()).orElse(BigDecimal.ZERO)));
            recordDTO.setPlanAmt(AmountUtil.convert((AmountUnitEnum)sourceAmountUnitEnum, (AmountUnitEnum)targetAmountUnitEnum, (BigDecimal)Optional.ofNullable(reportDataQueryResult.getPlanAmt()).orElse(BigDecimal.ZERO)));
            recordDTO.setLockAmt(AmountUtil.convert((AmountUnitEnum)sourceAmountUnitEnum, (AmountUnitEnum)targetAmountUnitEnum, (BigDecimal)Optional.ofNullable(reportDataQueryResult.getLockAmt()).orElse(BigDecimal.ZERO)));
            BigDecimal useAmt = reportDataQueryResult.getPlanAmt().subtract(reportDataQueryResult.getLockAmt()).subtract(reportDataQueryResult.getHoldLockAmt()).subtract(reportDataQueryResult.getActAmt()).subtract(reportDataQueryResult.getHoldActAmt());
            recordDTO.setUseAmt(AmountUtil.convert((AmountUnitEnum)sourceAmountUnitEnum, (AmountUnitEnum)targetAmountUnitEnum, (BigDecimal)useAmt));
            recordDTO.setReportPlanAmt(AmountUtil.convert((AmountUnitEnum)sourceAmountUnitEnum, (AmountUnitEnum)targetAmountUnitEnum, (BigDecimal)Optional.ofNullable(reportDataQueryResult.getReportPlanAmt()).orElse(BigDecimal.ZERO)));
            recordDTO.setOriginalPlanAmt(AmountUtil.convert((AmountUnitEnum)sourceAmountUnitEnum, (AmountUnitEnum)targetAmountUnitEnum, (BigDecimal)Optional.ofNullable(reportDataQueryResult.getApplyPlanAmt()).orElse(BigDecimal.ZERO)));
            recordDTO.putAllMetricVal(reportDataQueryResult.getMetricValMap());
            recordDTO.setRow(reportDataQueryResult.getRow());
            recordDTO.setCol(reportDataQueryResult.getCol());
            Long currencyDimVal = (Long)DimensionInfoHelper.getMainDimVal(recordDTO.getDimList(), recordDTO.getDimValList(), DimensionType.CURRENCY);
            if (Objects.nonNull(currencyDimVal)) {
                Long limitCurrencyId = currencyIdMap.computeIfAbsent(currencyDimVal, key -> {
                    DynamicObject currencyMemberDy = BusinessDataServiceHelper.loadSingle((String)"fpm_member", (String)"sourceid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currencyDimVal)});
                    return currencyMemberDy.getLong("sourceid");
                });
                recordDTO.setLimitCurrencyId(limitCurrencyId);
            }
            result.add(recordDTO);
        }
        return result;
    }

    private Set<String> getExecPlanPropertySet() {
        HashSet<String> propertySet = new HashSet<String>(16);
        propertySet.add("id");
        propertySet.add("bodysys");
        propertySet.add("bizorg");
        propertySet.add("billbizetype");
        propertySet.add("bizbillcode");
        propertySet.add("bizbillid");
        propertySet.add("entryid");
        propertySet.add("bizbillcurrency");
        propertySet.add("bizbillamount");
        propertySet.add("executedate");
        propertySet.add("planexecuteop");
        propertySet.add("realamt");
        propertySet.add("realamtbase");
        propertySet.add("aclremainamt");
        return propertySet;
    }

    private Set<String> getExecPlanSumPropertySet() {
        Set<String> propertySet = this.getExecPlanPropertySet();
        propertySet.add(String.join((CharSequence)".", "hold_entryentity", "hold_reportdataid"));
        propertySet.add(String.join((CharSequence)".", "hold_entryentity", "id"));
        return propertySet;
    }

    private Set<String> getExecPlanDetailPropertySet() {
        Set<String> execPlanPropertySet = this.getExecPlanPropertySet();
        execPlanPropertySet.add("billno");
        execPlanPropertySet.add("bodysys");
        execPlanPropertySet.add("executeoperatorstatus");
        execPlanPropertySet.add("exectuefailreason");
        execPlanPropertySet.add("reportorg");
        execPlanPropertySet.add("reporttype");
        execPlanPropertySet.add("subjectmem");
        execPlanPropertySet.add("currencymem");
        execPlanPropertySet.add("rate");
        execPlanPropertySet.add("billstatus");
        execPlanPropertySet.add("creator");
        execPlanPropertySet.add("createtime");
        return execPlanPropertySet;
    }

    private List<ExecRecordDTO> convert(DataSet execPlanDataSet, AmountUnit targetAmountUnit) {
        ArrayList<ExecRecordDTO> execRecordDTOList = new ArrayList<ExecRecordDTO>(10);
        AmountUnitEnum targetUnit = AmountUnitEnum.get((String)targetAmountUnit.getNumber());
        while (execPlanDataSet.hasNext()) {
            Row rowData = execPlanDataSet.next();
            ExecRecordDTO execRecordDTO = new ExecRecordDTO();
            execRecordDTO.setBodySysId(rowData.getLong("bodysys"));
            execRecordDTO.setBizOrg(rowData.getString("bizorg"));
            execRecordDTO.setBillBizType(rowData.getString("billbizetype"));
            execRecordDTO.setBizBillCode(rowData.getString("bizbillcode"));
            execRecordDTO.setBizBillId(rowData.getLong("bizbillid"));
            Long bizBillEntryId = EmptyUtil.isEmpty((String)rowData.getString("entryid")) ? Long.valueOf(0L) : Long.valueOf(rowData.getString("entryid"));
            execRecordDTO.setBizBillEntryId(bizBillEntryId);
            execRecordDTO.setBizBillCurrencyId(rowData.getLong("bizbillcurrency"));
            execRecordDTO.setBizBillAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)targetUnit, (BigDecimal)Optional.ofNullable(rowData.getBigDecimal("bizbillamount")).orElse(BigDecimal.ZERO)));
            execRecordDTO.setExecuteDate(rowData.getDate("executedate"));
            execRecordDTO.setPlanExecuteOpType(rowData.getString("planexecuteop"));
            execRecordDTO.setRealAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)targetUnit, (BigDecimal)Optional.ofNullable(rowData.getBigDecimal("realamt")).orElse(BigDecimal.ZERO)));
            execRecordDTO.setAclRemainAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)targetUnit, (BigDecimal)Optional.ofNullable(rowData.getBigDecimal("aclremainamt")).orElse(BigDecimal.ZERO)));
            execRecordDTO.setRealAmtCurrencyId(rowData.getLong("realamtbase"));
            execRecordDTO.setReportDataId(rowData.getLong(String.join((CharSequence)".", "hold_entryentity", "hold_reportdataid")));
            execRecordDTO.setExecutePlanId(rowData.getLong("id"));
            execRecordDTO.setPreOccupyRecordId(rowData.getLong(String.join((CharSequence)".", "hold_entryentity", "id")));
            execRecordDTOList.add(execRecordDTO);
        }
        return execRecordDTOList;
    }

    private List<ExecDetailRecordVO> convertToExecDetailRecordDTO(DataSet execPlanDataSet, AmountUnit targetAmtUnit) {
        ArrayList<ExecDetailRecordVO> list = new ArrayList<ExecDetailRecordVO>(10);
        AmountUnitEnum targetUnit = AmountUnitEnum.get((String)targetAmtUnit.getNumber());
        while (execPlanDataSet.hasNext()) {
            Row rowData = execPlanDataSet.next();
            ExecDetailRecordVO detailDTO = new ExecDetailRecordVO();
            detailDTO.setExecutePlanId(rowData.getLong("id"));
            detailDTO.setBizOrg(rowData.getString("bizorg"));
            detailDTO.setBillBizType(rowData.getString("billbizetype"));
            detailDTO.setBizBillCode(rowData.getString("bizbillcode"));
            detailDTO.setBizBillId(rowData.getLong("bizbillid"));
            detailDTO.setBizBillCurrencyId(rowData.getLong("bizbillcurrency"));
            detailDTO.setBizBillAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)targetUnit, (BigDecimal)Optional.ofNullable(rowData.getBigDecimal("bizbillamount")).orElse(BigDecimal.ZERO)));
            detailDTO.setExecuteDate(rowData.getDate("executedate"));
            ArrayList<String> planExecuteOpList = new ArrayList<String>(1);
            planExecuteOpList.add(rowData.getString("planexecuteop"));
            detailDTO.setPlanExecuteOpList(planExecuteOpList);
            detailDTO.setPreOccupyAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)targetUnit, (BigDecimal)Optional.ofNullable(rowData.getBigDecimal("realamt")).orElse(BigDecimal.ZERO)));
            detailDTO.setBillNo(rowData.getString("billno"));
            detailDTO.setBillId(rowData.getLong("bizbillid"));
            detailDTO.setPlanExecuteOp(rowData.getString("planexecuteop"));
            detailDTO.setBodySysId(rowData.getLong("bodysys"));
            detailDTO.setExecOpStatus(rowData.getString("executeoperatorstatus"));
            detailDTO.setExecFailReason(rowData.getString("exectuefailreason"));
            detailDTO.setReportOrgId(rowData.getLong("reportorg"));
            detailDTO.setReportTypeId(rowData.getLong("reporttype"));
            detailDTO.setSubjectMemId(rowData.getLong("subjectmem"));
            detailDTO.setCurrencyMemId(rowData.getLong("currencymem"));
            detailDTO.setRate(rowData.getBigDecimal("rate"));
            detailDTO.setRealAmt(AmountUtil.convert((AmountUnitEnum)AmountUnitEnum.ONE, (AmountUnitEnum)targetUnit, (BigDecimal)Optional.ofNullable(rowData.getBigDecimal("realamt")).orElse(BigDecimal.ZERO)));
            detailDTO.setRealAmtCurrencyId(rowData.getLong("realamtbase"));
            detailDTO.setBillStatus(rowData.getString("billstatus"));
            detailDTO.setCreatorId(rowData.getLong("creator"));
            detailDTO.setCreateTime(rowData.getDate("createtime"));
            list.add(detailDTO);
        }
        return list;
    }

    private List<ExecRecordVO> sumExecRecordByBizBill(List<ExecRecordDTO> execRecordDTOList) {
        Map<String, List<ExecRecordDTO>> bizBillIdMap = execRecordDTOList.stream().collect(Collectors.groupingBy(execRecordDTO -> String.join((CharSequence)"#", String.valueOf(execRecordDTO.getBizBillId()), String.valueOf(execRecordDTO.getReportDataId()))));
        LinkedList<ExecRecordVO> result = new LinkedList<ExecRecordVO>();
        for (Map.Entry<String, List<ExecRecordDTO>> sameBillIdEntry : bizBillIdMap.entrySet()) {
            List<ExecRecordDTO> bizBillExecRecordData = sameBillIdEntry.getValue();
            Date finalExecDate = bizBillExecRecordData.get(bizBillExecRecordData.size() - 1).getExecuteDate();
            ExecRecordVO vo = new ExecRecordVO(bizBillExecRecordData.get(0));
            vo.setExecuteDate(finalExecDate);
            boolean existWriteExecRecord = bizBillExecRecordData.stream().anyMatch(record -> ExecutePlanOpTypeEnum.WRITE == ExecutePlanOpTypeEnum.get((String)record.getPlanExecuteOpType()));
            Map<Long, List<ExecRecordDTO>> bizBillEntryIdMap = bizBillExecRecordData.stream().collect(Collectors.groupingBy(ExecRecordDTO::getBizBillEntryId));
            this.groupByBizBillAndEntryId(vo, bizBillEntryIdMap, existWriteExecRecord);
            vo.setRemainPreOccupyAmt(vo.getPreOccupyAmt().add(vo.getPreOccupyReleaseAmt()));
            BillBizInfo billBizInfo = new BillBizInfo();
            billBizInfo.setBillId(vo.getBizBillId());
            billBizInfo.setBillNo(vo.getBizBillCode());
            billBizInfo.setEntityType(vo.getBillBizType());
            List<ControlTraceInfo> controlTraceInfoList = this.iControlTraceService.getControlTraceInfo(billBizInfo, vo.getBodySysId());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(controlTraceInfoList)) {
                vo.getAssocBizBillInfoList().addAll(controlTraceInfoList);
            }
            result.add(vo);
        }
        return result;
    }

    private void calVOExecPlanOpAmt(ExecRecordVO vo, ExecutePlanOpTypeEnum op, BigDecimal addAmt) {
        switch (op) {
            case PREEMPTED_WRITE: {
                vo.setPreOccupyAmt(vo.getPreOccupyAmt().add(addAmt));
                return;
            }
            case PREEMPTED_RELEASE: {
                vo.setPreOccupyReleaseAmt(vo.getPreOccupyReleaseAmt().add(addAmt));
                return;
            }
            case WRITE: {
                vo.setWriteAmt(vo.getWriteAmt().add(addAmt));
                return;
            }
            case RELEASE: 
            case UPDATE: {
                vo.setReleaseAmt(vo.getReleaseAmt().add(addAmt));
                return;
            }
        }
    }

    private boolean calVOBizBillAmt(ExecRecordVO vo, ExecutePlanOpTypeEnum op, BigDecimal bizBillAmt, boolean existWriteExecRecord) {
        if (op != ExecutePlanOpTypeEnum.PREEMPTED_WRITE && op != ExecutePlanOpTypeEnum.WRITE) {
            return false;
        }
        if (!existWriteExecRecord && op == ExecutePlanOpTypeEnum.PREEMPTED_WRITE) {
            vo.setBizBillAmt(vo.getBizBillAmt().add(bizBillAmt));
            return true;
        }
        if (existWriteExecRecord && op == ExecutePlanOpTypeEnum.WRITE) {
            vo.setBizBillAmt(vo.getBizBillAmt().add(bizBillAmt));
            return true;
        }
        return false;
    }

    private void mergeExecPlanOpType(ExecRecordVO vo, ExecutePlanOpTypeEnum op) {
        if (op != ExecutePlanOpTypeEnum.PREEMPTED_WRITE && op != ExecutePlanOpTypeEnum.WRITE) {
            return;
        }
        if (vo.getPlanExecuteOpList().contains(op.getValue())) {
            return;
        }
        vo.getPlanExecuteOpList().add(op.getValue());
    }

    private Set<Long> getAllLeafMemberIdsIfContains(Dimension dimension, Set<Long> selectedMemberIds) {
        List selectedMemberList = dimension.getAllDimMemberList().stream().filter(dimMember -> selectedMemberIds.contains(dimMember.getId())).collect(Collectors.toList());
        Set<Long> allLeafMemberIdSet = selectedMemberList.stream().filter(dimMember -> !dimMember.isLeaf()).map(DimMember::getAllChildMember).flatMap(Collection::stream).filter(DimMember::isLeaf).map(DimMember::getId).collect(Collectors.toSet());
        allLeafMemberIdSet.addAll(selectedMemberIds);
        return allLeafMemberIdSet;
    }

    private List<Long> listDimAllMemberId(Dimension dimension) {
        return dimension.getAllDimMemberList().stream().map(DimMember::getId).collect(Collectors.toList());
    }

    private void groupByBizBillAndEntryId(ExecRecordVO vo, Map<Long, List<ExecRecordDTO>> bizBillEntryIdMap, boolean existWriteExecRecord) {
        for (Map.Entry<Long, List<ExecRecordDTO>> sameEntryIdEntry : bizBillEntryIdMap.entrySet()) {
            List<ExecRecordDTO> bizBillEntryExecRecordData = sameEntryIdEntry.getValue();
            vo.getBizBillEntryIdSet().add(sameEntryIdEntry.getKey());
            int preemptedWriteRecordSize = 0;
            int preemptedReleaseRecordSize = 0;
            for (ExecRecordDTO execRecordDTO : bizBillEntryExecRecordData) {
                ExecutePlanOpTypeEnum execPlanOpType = ExecutePlanOpTypeEnum.get((String)execRecordDTO.getPlanExecuteOpType());
                if (!ExecutePlanOpTypeEnum.isPreemptedExecuteOp((ExecutePlanOpTypeEnum)execPlanOpType)) continue;
                preemptedWriteRecordSize = execPlanOpType == ExecutePlanOpTypeEnum.PREEMPTED_WRITE ? preemptedWriteRecordSize + 1 : preemptedWriteRecordSize;
                preemptedReleaseRecordSize = execPlanOpType == ExecutePlanOpTypeEnum.PREEMPTED_RELEASE ? preemptedReleaseRecordSize + 1 : preemptedReleaseRecordSize;
            }
            boolean preemptedRecordExistDiff = preemptedWriteRecordSize - preemptedReleaseRecordSize != 0;
            boolean sameEntryBizBillAmtCalFlag = false;
            for (ExecRecordDTO execRecordDTO : bizBillEntryExecRecordData) {
                ExecutePlanOpTypeEnum execPlanOpType = ExecutePlanOpTypeEnum.get((String)execRecordDTO.getPlanExecuteOpType());
                if (ExecutePlanOpTypeEnum.isPreemptedExecuteOp((ExecutePlanOpTypeEnum)execPlanOpType)) {
                    int preemptedRecordSize;
                    preemptedWriteRecordSize = execPlanOpType == ExecutePlanOpTypeEnum.PREEMPTED_WRITE ? preemptedWriteRecordSize - 1 : preemptedWriteRecordSize;
                    int n = preemptedReleaseRecordSize = execPlanOpType == ExecutePlanOpTypeEnum.PREEMPTED_RELEASE ? preemptedReleaseRecordSize - 1 : preemptedReleaseRecordSize;
                    if (preemptedRecordExistDiff && execPlanOpType == ExecutePlanOpTypeEnum.PREEMPTED_WRITE && preemptedWriteRecordSize > 0 || preemptedRecordExistDiff && execPlanOpType == ExecutePlanOpTypeEnum.PREEMPTED_RELEASE) continue;
                    int n2 = preemptedRecordSize = execPlanOpType == ExecutePlanOpTypeEnum.PREEMPTED_WRITE ? preemptedWriteRecordSize : preemptedReleaseRecordSize;
                    if (!preemptedRecordExistDiff && preemptedRecordSize > 0) continue;
                }
                this.calVOExecPlanOpAmt(vo, execPlanOpType, execRecordDTO.getRealAmt());
                if (execPlanOpType == ExecutePlanOpTypeEnum.WRITE) {
                    vo.setAclRemainAmt(vo.getAclRemainAmt().add(execRecordDTO.getAclRemainAmt()));
                }
                if (!sameEntryBizBillAmtCalFlag) {
                    sameEntryBizBillAmtCalFlag = this.calVOBizBillAmt(vo, execPlanOpType, execRecordDTO.getBizBillAmt(), existWriteExecRecord);
                }
                this.mergeExecPlanOpType(vo, execPlanOpType);
                Collections.addAll(vo.getExecutePlanIdSet(), execRecordDTO.getExecutePlanId());
                Collections.addAll(vo.getHoldEntryIdSet(), execRecordDTO.getPreOccupyRecordId());
            }
        }
    }

    private Set<Long> loadAllLeafOrgIdsIfContains(LinkExecRecordParamDTO queryParam, Dimension orgDimension, Set<Long> parentOrgIdSet) {
        SumPlanParamConfig sumPlanParamConfig;
        SumPlanParamConfig sumPlanParamConfig2 = sumPlanParamConfig = Objects.isNull(queryParam.getReportId()) ? this.iSummaryConfigService.getNewestEnableSummaryParamConfig(queryParam.getBodySystemId(), queryParam.getReportTypeId()) : this.iSummaryConfigService.getSummaryParamConfig(queryParam.getReportId());
        if (Objects.isNull(sumPlanParamConfig)) {
            return this.getAllLeafMemberIdsIfContains(orgDimension, parentOrgIdSet);
        }
        Set<Long> allLeafMemberIdSet = sumPlanParamConfig.getConfigInfoList().stream().filter(item -> parentOrgIdSet.contains(item.getOrgMemberId())).filter(item -> CollectionUtils.isNotEmpty(item.getChildren())).map(SumPlanParamConfigInfo::getAllChildren).flatMap(Collection::stream).filter(item -> CollectionUtils.isEmpty(item.getChildren())).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        allLeafMemberIdSet.addAll(parentOrgIdSet);
        return allLeafMemberIdSet;
    }
}

