/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.mvc.service.IReportOrgCheckService;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class ReportOrgCheckServiceImpl
implements IReportOrgCheckService {
    private static final Log logger = LogFactory.getLog(ReportOrgCheckServiceImpl.class);

    @Override
    public boolean check(ControlContext controlContext, ControlExecuteParam param) {
        List<BizProps> bizProps;
        List<MatchMapping> matchMappings;
        if (EmptyUtil.isEmpty((Object)param)) {
            return false;
        }
        Long reportOrgId = param.getReportOrgId();
        if (EmptyUtil.isEmpty((Long)reportOrgId)) {
            logger.info("ControlExecuteParam\u7f16\u62a5\u4e3b\u4f53\u4e3a\u7a7a\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", (Object)param);
            return false;
        }
        BillMatchRule matchRule = param.getMatchRule();
        BillBizInfo billBizInfo = param.getBillBizInfo();
        if (EmptyUtil.isEmpty((Object)matchRule) || EmptyUtil.isEmpty(matchMappings = matchRule.getMappings()) || EmptyUtil.isEmpty((Object)billBizInfo) || EmptyUtil.isEmpty(bizProps = billBizInfo.getBizProps())) {
            logger.info("ControlExecuteParam\u5339\u914d\u5230\u7684\u53d6\u6570\u89c4\u5219\u4e3a\u7a7a,\u83b7\u53d6\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", (Object)param);
            return false;
        }
        Long systemId = matchRule.getSystemId();
        if (EmptyUtil.isEmpty((Long)systemId)) {
            logger.info("ControlExecuteParam\u5339\u914d\u5230\u7684\u53d6\u6570\u89c4\u5219:{}\u7684\u4f53\u7cfbid\u4e3a\u7a7a\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", (Object)matchRule.getNumber(), (Object)param);
            return false;
        }
        FundPlanSystem fundPlanSystem = controlContext.getSystem(systemId);
        if (EmptyUtil.isEmpty((Object)fundPlanSystem)) {
            logger.info("ControlExecuteParam\u5339\u914d\u5230\u7684\u4f53\u7cfb\u4e3a\u7a7a\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", (Object)param);
            return false;
        }
        Dimension orgDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.ORG);
        if (EmptyUtil.isEmpty((Object)orgDim)) {
            logger.info("ControlExcuteServiceLogParamDTO\u5339\u914d\u5230\u7684\u4f53\u7cfb\uff1a{}\u5bf9\u5e94\u7684\u7f16\u62a5\u4e3b\u4f53\u7ef4\u5ea6\u4e3a\u7a7a\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", (Object)fundPlanSystem.getNumber(), (Object)param);
            return false;
        }
        Dimension periodDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.PERIOD);
        if (EmptyUtil.isEmpty((Object)periodDim)) {
            logger.info("ControlExcuteServiceLogParamDTO\u5339\u914d\u5230\u7684\u4f53\u7cfb:{}\u5bf9\u5e94\u7684\u671f\u95f4\u7ef4\u5ea6\u4e3a\u7a7a\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", (Object)fundPlanSystem.getNumber(), (Object)param);
            return false;
        }
        DimMember reportOrg = orgDim.getDimMemberById(reportOrgId);
        if (EmptyUtil.isEmpty((Object)reportOrg) || !OrgMember.class.isInstance(reportOrg)) {
            logger.info("ControlExcuteServiceLogParamDTO\u5339\u914d\u5230\u7684\u4f53\u7cfb:{}\u5bf9\u5e94\u7684\u7f16\u62a5\u4e3b\u4f53\u7ef4\u5ea6\u6ca1\u6709\u5bf9\u5e94\u7684\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", (Object)fundPlanSystem, (Object)param);
            return false;
        }
        OrgMember orgMember = (OrgMember)reportOrg;
        Date enableDate = orgMember.getEnableDate();
        Date disableDate = orgMember.getDisableDate();
        Optional<MatchMapping> first = matchMappings.stream().filter(Objects::nonNull).filter(matchMapping -> Objects.equals(matchMapping.getDimId(), periodDim.getId())).findFirst();
        if (!first.isPresent()) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u53d6\u6570\u89c4\u5219\uff1a{}\uff0c\u6ca1\u6709\u671f\u95f4\u7ef4\u5ea6\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", new Object[]{fundPlanSystem.getNumber(), matchRule.getNumber(), param});
            return false;
        }
        MatchMapping matchMapping2 = first.get();
        String bizProp = matchMapping2.getBizProp();
        Optional<BizProps> propsOptional = bizProps.stream().filter(Objects::nonNull).filter(bp -> Objects.equals(bp.getBizProp(), bizProp)).findFirst();
        if (controlContext.getPlanExecuteOpType().isPositiveOp() && !propsOptional.isPresent()) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u53d6\u6570\u89c4\u5219\uff1a{}\uff0c\u671f\u95f4\u7ef4\u5ea6\u6ca1\u6709\u5339\u914d\u4e0a\u4e1a\u52a1\u5355\u636e:{}\u7684\u5c5e\u6027:{}\uff0c\u8bf7\u68c0\u67e5\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", new Object[]{fundPlanSystem.getNumber(), matchRule.getNumber(), billBizInfo.getBillNo(), bizProp, param});
            return false;
        }
        Date bizDate = null;
        BizProps billBizProp = propsOptional.get();
        Object value = billBizProp.getValue();
        if (Date.class.isInstance(value)) {
            bizDate = (Date)value;
        } else if (value instanceof String) {
            String dateStr = (String)value;
            bizDate = DateUtils.stringToDate((String)dateStr, (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (bizDate == null) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u53d6\u6570\u89c4\u5219\uff1a{}\uff0c\u671f\u95f4\u7ef4\u5ea6\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636e:{}\u7684\u5c5e\u6027:{}\u4e0d\u662f\u65e5\u671f\u7c7b\u578b\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", new Object[]{fundPlanSystem.getNumber(), matchRule.getNumber(), billBizInfo.getBillNo(), bizProp, param});
            return !controlContext.getPlanExecuteOpType().isPositiveOp();
        }
        long bizTime = bizDate.getTime();
        if (Objects.isNull(enableDate)) {
            enableDate = DateUtils.stringToDate((String)"1970-01-01", (String)"yyyy-MM-dd");
        }
        if (Objects.isNull(disableDate)) {
            disableDate = DateUtils.stringToDate((String)"9999-01-01", (String)"yyyy-MM-dd");
        }
        if (enableDate.getTime() > bizTime || disableDate.getTime() < bizTime) {
            logger.info("\u4f53\u7cfb\uff1a{}\uff0c\u53d6\u6570\u89c4\u5219\uff1a{}\uff0c\u671f\u95f4\u7ef4\u5ea6\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636e:{}\u7684\u5c5e\u6027:{}\u5bf9\u5e94\u7684\u503c\uff1a{}\u5c0f\u4e8e\u5339\u914d\u5230\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u7684\u542f\u7528\u65e5\u671f\uff1a{}\u6216\u5927\u4e8e\u5339\u914d\u5230\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u7684\u542f\u7528\u65e5\u671f\uff1a{}\uff0c\u79fb\u9664\u6b64\u5bf9\u8c61\uff1a{}", new Object[]{fundPlanSystem.getNumber(), matchRule.getNumber(), billBizInfo.getBillNo(), bizProp, value, enableDate, disableDate, param});
            return false;
        }
        return true;
    }
}

