/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DynamicObjectUtil;
import kd.tmc.fpm.business.dataproc.save.ReportDataSaveService;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.service.impl.ReportService;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ReportPlanMainDataUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ReportPlanMainDataUpgradeServiceImpl.class);
    private ReportRepository reportRepository = new ReportRepository();
    private ReportService reportService = new ReportService();
    private DimensionRepository dimensionRepository = new DimensionRepository();
    private ReportDataSaveService reportDataSaveService = new ReportDataSaveService();

    @Override
    public void updateData() {
        logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u8ba1\u5212\u7f16\u5236\u4e3b\u8868\u6570\u636e\u5f00\u59cb\u5347\u7ea7... ");
        int totalCount = TmcDataServiceHelper.count((String)"fpm_report", (QFilter[])new QFilter[0]);
        int pageSize = 10;
        int pages = totalCount / pageSize + 1;
        for (int pageIndex = 0; pageIndex < pages; ++pageIndex) {
            this.recomputeReport(null, pageSize, pageIndex);
        }
        logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u8ba1\u5212\u7f16\u5236\u4e3b\u8868\u6570\u636e\u5347\u7ea7\u7ed3\u675f... ");
    }

    private void recomputeReport(QFilter filter, int pageSize, int pageIndex) {
        DynamicObject[] reportList = TmcDataServiceHelper.load((String)"fpm_report", (String)String.join((CharSequence)",", "id"), (QFilter[])new QFilter[]{filter}, (String)"", (int)pageIndex, (int)pageSize);
        Set<Long> idList = Arrays.stream(reportList).map(item -> item.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(idList)) {
            logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u672c\u6b21\u67e5\u8be2\u62a5\u8868ID\u5217\u8868\u4e3a\u7a7a\uff0cpageIndex\uff1a{}\uff0cpageSize\uff1a{}", (Object)pageIndex, (Object)pageSize);
            return;
        }
        try {
            List<Report> reports = this.reportRepository.loadReportWithAllDimension(idList);
            if (CollectionUtils.isEmpty(reports)) {
                logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u672c\u6b21\u67e5\u8be2\u62a5\u8868\u5217\u8868\u4e3a\u7a7a\uff0cpageIndex\uff1a{}\uff0cpageSize\uff1a{}", (Object)pageIndex, (Object)pageSize);
                return;
            }
            List mainTables = reports.stream().filter(item -> item.getTemplate().isMainTable()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(mainTables)) {
                logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u672c\u6b21\u67e5\u8be2\u4e3b\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u9700\u5347\u7ea7\uff0cpageIndex\uff1a{}\uff0cpageSize\uff1a{}", (Object)pageIndex, (Object)pageSize);
                return;
            }
            List<Report> mainTableWithDetail = mainTables.stream().filter(item -> {
                List<TemplateAccountSetting> accountSettings = item.getTemplate().getAccountSettings();
                return accountSettings.stream().anyMatch(setting -> ReportInputType.DETAIL_INPUT == setting.getInputType());
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(mainTableWithDetail)) {
                logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u672c\u6b21\u67e5\u8be2\u4e3b\u8868\u6570\u636e\u4e2d\u4e0d\u542b\u6709\u660e\u7ec6\u586b\u62a5\u6570\u636e\uff0c\u65e0\u9700\u5347\u7ea7\uff0cpageIndex\uff1a{}\uff0cpageSize\uff1a{}", (Object)pageIndex, (Object)pageSize);
                return;
            }
            logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u5f53\u524d\u6279\u6b21\u6570\u636e\u5347\u7ea7\u4e2d\uff0cpageIndex\uff1a{}\uff0cpageSize\uff1a{}", (Object)pageIndex, (Object)pageSize);
            this.handleData(pageSize, pageIndex, mainTableWithDetail);
            logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u5f53\u524d\u6279\u6b21\u5347\u7ea7\u7ed3\u675f\uff0cpageIndex\uff1a{}\uff0cpageSize\uff1a{}", (Object)pageIndex, (Object)pageSize);
        }
        catch (Exception e) {
            logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u8ba1\u5212\u7f16\u5236\u4e3b\u8868\u6570\u636e\u5347\u7ea7\u5f02\u5e38, \u62a5\u8868id:{}", (Object)idList.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(int pageSize, int pageIndex, List<Report> mainTableWithDetail) {
        for (Report report : mainTableWithDetail) {
            try {
                this.backReport(report);
                FundPlanSystem system = this.dimensionRepository.loadSystem(report.getSystemId());
                String lockMain = report.getId().toString();
                boolean lockMainReport = MutexServiceHelper.request((String)lockMain, (String)"fpm_report", (String)"lockMainReport");
                if (!lockMainReport) {
                    logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u672c\u6b21\u67e5\u8be2\u4e3b\u8868\u6570\u636e\u52a0\u9501\u5931\u8d25\uff0c\u65e0\u6cd5\u5347\u7ea7\uff0cpageIndex\uff1a{}\uff0cpageSize\uff1a{}", (Object)pageIndex, (Object)pageSize);
                    continue;
                }
                ReportTemplate template = report.getTemplate();
                List<TemplateAccountSetting> accountSettings = template.getAccountSettings();
                Set detailInputSubjectsId = accountSettings.stream().filter(item -> ReportInputType.DETAIL_INPUT == item.getInputType()).map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
                report.setReportDataList(new ArrayList<ReportData>(0));
                List<Long> subReportIdS = this.reportRepository.querySubReportId(report.getId());
                List<Object> subReports = new ArrayList(16);
                if (!CollectionUtils.isEmpty(subReportIdS)) {
                    subReports = this.reportRepository.loadReport(new HashSet<Long>(subReportIdS));
                }
                List subLockIds = subReportIdS.stream().map(Object::toString).collect(Collectors.toList());
                ArrayList<String> requestSuccessIds = new ArrayList<String>(subLockIds.size());
                try {
                    Map request = MutexServiceHelper.batchRequest(subLockIds, (String)"fpm_report", (String)"lockSubReport");
                    for (Map.Entry entry : request.entrySet()) {
                        String string = (String)entry.getKey();
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        requestSuccessIds.add(string);
                    }
                    if (subLockIds.size() != requestSuccessIds.size()) {
                        logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u672c\u6b21\u67e5\u8be2\u5b50\u8868\u6570\u636e\u52a0\u9501\u5931\u8d25\uff0c\u65e0\u6cd5\u5347\u7ea7\uff0cpageIndex\uff1a{}\uff0cpageSize\uff1a{}", (Object)pageIndex, (Object)pageSize);
                        continue;
                    }
                    boolean sumFail = false;
                    for (Report report2 : subReports) {
                        try {
                            this.reportService.sumToParent(report, report2, system);
                        }
                        catch (Throwable e) {
                            logger.info("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u672c\u6b21\u67e5\u8be2\u4e3b\u5b50\u8868\u6570\u636e\u6c47\u603b\u5931\u8d25\uff0c\u4e3b\u8868ID:{}\uff0c\u5b50\u8868ID:{}\uff0c\u539f\u56e0:{}", new Object[]{report.getId(), report2.getId(), ExceptionUtils.getStackTrace((Throwable)e)});
                            sumFail = true;
                        }
                        if (!sumFail) continue;
                        break;
                    }
                    if (sumFail) continue;
                    this.reportDataSaveService.saveReportData(report);
                }
                finally {
                    MutexServiceHelper.batchRelease(requestSuccessIds, (String)"fpm_report", (String)"lockSubReport");
                    MutexServiceHelper.release((String)lockMain, (String)"fpm_report", (String)"lockMainReport");
                }
            }
            catch (Exception e) {
                logger.warn("[ReportPlanMainDataUpgradeServiceImpl] >>>> \u672c\u6b21\u67e5\u8be2\u4e3b\u5b50\u8868\u6570\u636e\u5347\u7ea7\u5931\u8d25\uff0c\u4e3b\u8868ID:{}\uff0c\u539f\u56e0:{}", (Object)report.getId(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    private void backReport(Report report) {
        DynamicObject reportObj = TmcDataServiceHelper.loadSingle((Object)report.getId(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_report"));
        DynamicObject reportBakObj = TmcDataServiceHelper.newDynamicObject((String)"fpm_report_bak");
        DynamicObjectUtil.copy((DynamicObject)reportObj, (DynamicObject)reportBakObj, (String[])new String[]{""});
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{reportBakObj});
    }
}

