/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.common.enums.AuxiliaryFieldTypeEnum;

public class ReportRefAuxiliaryUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ReportRefAuxiliaryUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        logger.info("[ReportRefAuxiliaryUpgradeServiceImpl] >>>> \u62a5\u8868\u5907\u6ce8\u6570\u636e\u5f00\u59cb\u5347\u7ea7... ");
        this.upgradeRemark();
        logger.info("[ReportRefAuxiliaryUpgradeServiceImpl] >>>> \u62a5\u8868\u5907\u6ce8\u6570\u636e\u5347\u7ea7\u7ed3\u675f... ");
    }

    private void upgradeRemark() {
        String entity = "fpm_report";
        Object[] load = TmcDataServiceHelper.load((String)entity, (String)String.join((CharSequence)",", "id"), (QFilter[])new QFilter[0]);
        if (EmptyUtil.isEmpty((Object[])load)) {
            logger.info("[ReportRefAuxiliaryUpgradeServiceImpl] >>>> \u6ca1\u6709\u8981\u66f4\u65b0\u7684\u62a5\u8868\u6570\u636e");
            return;
        }
        List ids = Arrays.stream(load).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] reports = TmcDataServiceHelper.load((String)entity, (String)"id,detailentry.maindimdataid,detailentry.remark,auxentry.aux_reportdataid,auxentry.aux_bdtype,auxentry.aux_content,bodysys.id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("detailentry.remark", "!=", (Object)""), new QFilter("detailentry.remark", "is not null", null), new QFilter("auxentry.aux_content", "is null", null).or(new QFilter("auxentry.aux_content", "=", (Object)""))});
        DynamicObject[] auxCollections = TmcDataServiceHelper.load((String)"fpm_auxiliaryfields", (String)"id,bodysys,type", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)AuxiliaryFieldTypeEnum.REMARK.getValue())});
        Map<Object, DynamicObject> remarkMap = Arrays.stream(auxCollections).collect(Collectors.toMap(aux -> aux.get("bodysys.id"), v -> v, (a, b) -> a));
        ArrayList<DynamicObject> saveObjList = new ArrayList<DynamicObject>(128);
        for (DynamicObject dynamicObject : reports) {
            Object bodySysId = dynamicObject.get("bodysys.id");
            DynamicObjectCollection detailDOS = dynamicObject.getDynamicObjectCollection("detailentry");
            DynamicObjectCollection auxDOS = dynamicObject.getDynamicObjectCollection("auxentry");
            DynamicObject remarkDO = remarkMap.get(bodySysId);
            if (remarkDO == null) continue;
            boolean save = false;
            for (DynamicObject detailDO : detailDOS) {
                String remark = detailDO.getString("remark");
                Object reportDataId = detailDO.get("maindimdataid");
                if (remark == null || "".equals(remark)) continue;
                DynamicObject newEntry = auxDOS.addNew();
                newEntry.set("aux_reportdataid", reportDataId);
                newEntry.set("aux_bdtype", remarkDO.getPkValue());
                newEntry.set("aux_content", (Object)remark);
                save = true;
            }
            if (!save) continue;
            saveObjList.add(dynamicObject);
        }
        HashMap<String, String> needThrowErrorMsg = new HashMap<String, String>(16);
        try {
            if (EmptyUtil.isNoEmpty(saveObjList)) {
                TmcDataServiceHelper.save((DynamicObject[])saveObjList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (EmptyUtil.isEmpty((String)message)) {
                message = Arrays.stream(e.getStackTrace()).map(s -> String.join((CharSequence)":", s.getClassName(), s.getMethodName(), String.valueOf(s.getLineNumber()))).collect(Collectors.joining(","));
            }
            needThrowErrorMsg.put("", message);
        }
        if (!CollectionUtils.isEmpty(needThrowErrorMsg)) {
            throw new KDBizException(String.join((CharSequence)",", needThrowErrorMsg.values()));
        }
    }
}

