/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.domain.model.control.ControlRequestUpdateInfo;
import kd.tmc.fpm.business.mvc.repository.IControlRequestUpdateInfoRepository;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class RequestIdTimeOutMakDeletePostProcessor
implements IControlExecuteParamPostProcessor {
    private static final Log logger = LogFactory.getLog(RequestIdTimeOutMakDeletePostProcessor.class);
    private IControlRequestUpdateInfoRepository controlRequestUpdateInfoRepository = FpmServiceFactory.getBizService(IControlRequestUpdateInfoRepository.class);
    private IDataSaveService dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> paramDTOList) {
        String traceId = RequestContext.get().getTraceId();
        ThreadPools.executeOnce((String)"RequestIdTimeOutMakDeletePostProcessor", () -> {
            logger.info("\u5f00\u59cb\u6e05\u7406\u65e9\u4e8e\u4e09\u5929\u524d\u56e0\u7cfb\u7edf\u91cd\u542f\u800c\u4e00\u76f4\u505c\u7559\u5728\u521d\u59cb\u72b6\u6001\u7684\u8bb0\u5f55\u3002traceId:{}", (Object)traceId);
            List<ControlRequestUpdateInfo> controlRequestUpdateInfos = this.controlRequestUpdateInfoRepository.queryInitControlRequestUpdateInfoListBeforeThreeDays();
            if (EmptyUtil.isEmpty(controlRequestUpdateInfos)) {
                return;
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_controlupdateinfo set fcontrolstatus='D' where fid=? and fcontrolstatus='A'", controlRequestUpdateInfos, (t, d) -> d.add(t.getId()));
                }
                catch (Exception e) {
                    h.markRollback();
                    logger.error(e.getMessage(), (Throwable)e);
                }
                logger.info("\u6e05\u7406\u65e9\u4e8e\u4e09\u5929\u524d\u56e0\u7cfb\u7edf\u91cd\u542f\u800c\u4e00\u76f4\u505c\u7559\u5728\u521d\u59cb\u72b6\u6001\u7684\u8bb0\u5f55\u5b8c\u6bd5\uff0c\u6e05\u7406\u6761\u6570\uff1a{}", (Object)controlRequestUpdateInfos.size());
            }
        });
    }

    @Override
    public int getOrder() {
        return -93;
    }
}

