/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.mvc.converter.ShrekModelConverter;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import kd.tmc.fpm.common.helper.ReportDataFieldHelper;
import kd.tmc.fpm.olap.command.ShrekCommand;
import kd.tmc.fpm.olap.command.ShrekSyncCommand;
import kd.tmc.fpm.olap.command.executor.ShrekExecutor;
import kd.tmc.fpm.olap.enums.ShrekCommandType;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.utils.ShrekIdUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class ShrekBodySystemSyncUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(ShrekBodySystemSyncUpgradeServiceImpl.class);
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private List<DynamicObject> syncSystem = new ArrayList<DynamicObject>();
    private List<DynamicObject> syncDim;
    private List<DynamicObject> syncDimensionMember;
    private Map<Long, List<Dimension>> syncDimensions = new HashMap<Long, List<Dimension>>();

    public ShrekBodySystemSyncUpgradeServiceImpl() {
        this.syncDim = new ArrayList<DynamicObject>();
        this.syncDimensionMember = new ArrayList<DynamicObject>();
    }

    @Override
    public void updateData() {
        logger.info("[ShrekBodySystemSyncUpgradeServiceImpl] >>>> \u4f53\u7cfb\u3001\u7ef4\u5ea6\u540c\u6b65\u591a\u7ef4\u6570\u636e\u5e93\u5f00\u59cb... ");
        if (!FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
            logger.info("\u672a\u542f\u52a8\u591a\u7ef4\u540c\u6b65\u529f\u80fd\uff0c\u505c\u6b62\u540c\u6b65.");
            return;
        }
        String selectProp = String.join((CharSequence)",", "id", "number", "shreksyncstatus", "shrekdatakey", String.join((CharSequence)".", "applyrereportentry", "rereporttypestatus"), String.join((CharSequence)".", "applyrereportentry", "rerporttype"));
        DynamicObject[] allSystem = TmcDataServiceHelper.load((String)"fpm_bodysysmanage", (String)selectProp, (QFilter[])new QFilter[]{new QFilter("shreksyncstatus", "!=", (Object)ShrekSyncStatus.SYNC_DONE.name())});
        if (allSystem == null || allSystem.length == 0) {
            logger.info("[ShrekBodySystemSyncUpgradeServiceImpl] >>>> \u4f53\u7cfb\u3001\u7ef4\u5ea6\u540c\u6b65\u591a\u7ef4\u6570\u636e\u5e93\u7ed3\u675f, \u4f53\u7cfb\u67e5\u8be2\u4e3a\u7a7a");
            return;
        }
        List<DynamicObject> syncSuccessList = this.updateSystemStatus(allSystem);
        this.updateDimAndMembersStatus(syncSuccessList);
        Map systemMap = Arrays.stream(allSystem).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        for (DynamicObject system : this.syncSystem) {
            try {
                logger.info("[ShrekBodySystemSyncUpgradeServiceImpl] >>>> \u5f53\u524d\u540c\u6b65\u4f53\u7cfb\u4e3a:{}", (Object)system.getString("id"));
                long systemId = Long.parseLong(system.getPkValue().toString());
                String cubeNumber = ShrekIdUtil.getCubeNumber((String)String.valueOf(systemId), (String)system.getString("number"));
                ShrekSyncCommand syncCubeCommand = new ShrekSyncCommand();
                syncCubeCommand.setCommandType(ShrekCommandType.SYNC_CUBE);
                syncCubeCommand.setMetaDataByNumber(cubeNumber);
                ShrekExecutor.execute((ShrekCommand)syncCubeCommand);
                List<Dimension> dimensions = this.syncDimensions.get(systemId);
                Dimension reportPeriodDim = this.generateReportPeriodDim((DynamicObject)systemMap.get(system.getPkValue()), dimensions);
                if (EmptyUtil.isNoEmpty((Object)reportPeriodDim)) {
                    dimensions.add(reportPeriodDim);
                }
                this.fillIntoRedundantFieldAsMember(systemId);
                ShrekSyncCommand syncDimensionCommand = new ShrekSyncCommand();
                syncDimensionCommand.setMetaDataByNumber(cubeNumber);
                syncDimensionCommand.setCommandType(ShrekCommandType.SYNC_DIMENSION);
                syncDimensionCommand.setDimensionList(ShrekModelConverter.convertAndFillRoot(cubeNumber, dimensions));
                ShrekExecutor.execute((ShrekCommand)syncDimensionCommand);
            }
            catch (Throwable e) {
                logger.warn("[ShrekBodySystemSyncUpgradeServiceImpl] >>>> \u4f53\u7cfb\u3001\u7ef4\u5ea6\u540c\u6b65\u591a\u7ef4\u6570\u636e\u5e93\u7ed3\u675f, \u4f53\u7cfb\uff1a{}\uff0c\u540c\u6b65\u62a5\u9519:{}", (Object)system.getString("number"), (Object)ExceptionUtils.getStackTrace((Throwable)e));
                system.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_FAILED.name());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{system});
                if (CollectionUtils.isNotEmpty(this.syncDim)) {
                    List<DynamicObject> updateFailDim = this.syncDim.stream().filter(item -> item.getDynamicObject("bodysystem").getPkValue().equals(system.getPkValue())).collect(Collectors.toList());
                    updateFailDim.forEach(item -> item.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_FAILED.name()));
                    SaveServiceHelper.update((DynamicObject[])updateFailDim.toArray(new DynamicObject[0]));
                }
                if (!CollectionUtils.isNotEmpty(this.syncDimensionMember)) continue;
                List<DynamicObject> updateFailDimMember = this.syncDimensionMember.stream().filter(item -> item.getDynamicObject("bodysystem").getPkValue().equals(system.getPkValue())).collect(Collectors.toList());
                updateFailDimMember.forEach(item -> item.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_FAILED.name()));
                SaveServiceHelper.update((DynamicObject[])updateFailDimMember.toArray(new DynamicObject[0]));
            }
        }
        logger.info("[ShrekBodySystemSyncUpgradeServiceImpl] >>>> \u4f53\u7cfb\u3001\u7ef4\u5ea6\u540c\u6b65\u591a\u7ef4\u6570\u636e\u5e93\u7ed3\u675f... ");
    }

    private Dimension generateReportPeriodDim(DynamicObject system, List<Dimension> dimensions) {
        DynamicObjectCollection dynamicObjectCollection = system.getDynamicObjectCollection("applyrereportentry");
        Map reportTypeDyMap = dynamicObjectCollection.stream().filter(dy -> StringUtils.equals((CharSequence)"enable", (CharSequence)dy.getString("rereporttypestatus"))).map(dy -> dy.getDynamicObject("rerporttype")).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        List<DimMember> reportPeriodDimMemberList = dimensions.stream().filter(dimension -> dimension.getDimType().isPeriodDim()).map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).map(PeriodMember.class::cast).filter(p -> {
            Long periodTypeId = p.getPeriodTypeId();
            DynamicObject reportTypeDy = (DynamicObject)reportTypeDyMap.get(periodTypeId);
            if (Objects.isNull(reportTypeDy)) {
                return false;
            }
            String reportCycle = reportTypeDy.getString("orgreportcycle");
            return Objects.equals(p.getPeriodType().getNumber(), reportCycle);
        }).collect(Collectors.toList());
        Dimension dimension2 = new Dimension();
        dimension2.setNumber("ReportPeriodDim");
        dimension2.setMemberList(reportPeriodDimMemberList);
        return dimension2;
    }

    private List<DynamicObject> updateSystemStatus(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> updateSystem = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            ShrekSyncStatus systemStatus = ShrekSyncStatus.SYNC_DONE;
            DynamicObject bodySystem = BusinessDataServiceHelper.newDynamicObject((String)"fpm_bodysysmanage");
            bodySystem.set("id", dynamicObject.getPkValue());
            bodySystem.set("number", (Object)dynamicObject.getString("number"));
            String cubeNumber = dynamicObject.getPkValue() + dynamicObject.getString("number");
            bodySystem.set("shrekdatakey", (Object)cubeNumber);
            bodySystem.set("shreksyncstatus", (Object)systemStatus.name());
            updateSystem.add(bodySystem);
        }
        SaveServiceHelper.update((DynamicObject[])updateSystem.toArray(new DynamicObject[0]));
        this.syncSystem.addAll(updateSystem);
        return updateSystem;
    }

    private void updateDimAndMembersStatus(List<DynamicObject> syncSuccessList) {
        Set ids = syncSuccessList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        DynamicObject[] systemList = TmcDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_bodysysmanage"));
        Map systemMap = Arrays.stream(systemList).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        DynamicObject[] dimArr = TmcDataServiceHelper.load((String)"fpm_dimension", (String)String.join((CharSequence)",", "id", "basedata", "bodysystem"), (QFilter[])new QFilter[]{new QFilter("bodysystem", "in", ids)});
        Map<Object, List<DynamicObject>> collect = Arrays.stream(dimArr).collect(Collectors.groupingBy(o -> o.getDynamicObject("bodysystem").getPkValue()));
        for (Map.Entry<Object, List<DynamicObject>> entry : collect.entrySet()) {
            Object systemId = entry.getKey();
            List<Long> mainIdList = entry.getValue().stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            List<Dimension> dimensions = this.dimensionRepository.loadMainDimension(mainIdList);
            DynamicObject system = (DynamicObject)systemMap.get(systemId);
            this.setDimensionAndMemberList(this.syncDim, this.syncDimensionMember, system, dimensions);
            this.syncDimensions.put(Long.parseLong(systemId.toString()), dimensions);
        }
        SaveServiceHelper.update((DynamicObject[])this.syncDim.toArray(new DynamicObject[0]));
        SaveServiceHelper.update((DynamicObject[])this.syncDimensionMember.toArray(new DynamicObject[0]));
    }

    private void setDimensionAndMemberList(List<DynamicObject> updateDimension, List<DynamicObject> updateMember, DynamicObject bodySystem, List<Dimension> dimList) {
        for (Dimension dimension : dimList) {
            DynamicObject dimensionObj = BusinessDataServiceHelper.newDynamicObject((String)"fpm_dimension");
            dimensionObj.set("bodysystem", (Object)bodySystem);
            dimensionObj.set("id", (Object)dimension.getId());
            dimensionObj.set("shrekdatakey", (Object)ShrekIdUtil.getDimNumber((String)dimension.getNumber()));
            dimensionObj.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_DONE.name());
            updateDimension.add(dimensionObj);
            for (DimMember dimMember : dimension.getAllDimMemberList()) {
                DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)"fpm_member");
                member.set("dimension", (Object)dimensionObj);
                member.set("bodysystem", bodySystem.get("id"));
                member.set("id", (Object)dimMember.getId());
                member.set("shrekdatakey", (Object)ShrekIdUtil.getDefaultMemberNumber((String)dimMember.getNumber()));
                member.set("shreksyncstatus", (Object)ShrekSyncStatus.SYNC_DONE.name());
                updateMember.add(member);
            }
        }
    }

    private void fillIntoRedundantFieldAsMember(long systemId) {
        List<Dimension> dimensions = this.syncDimensions.get(systemId);
        ReportDataFieldHelper.REDUNDANT_FIELD_MAPPING_MAP.forEach((key, val) -> {
            Dimension dim = new Dimension();
            dim.setNumber((String)key);
            ArrayList<DimMember> dimMembers = new ArrayList<DimMember>();
            val.forEach(item -> {
                DimMember member = new DimMember();
                member.setNumber((String)item);
                dimMembers.add(member);
            });
            dim.setMemberList(dimMembers);
            dimensions.add(dim);
        });
    }
}

