/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IDimensionCombinationQueryService;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.ISyncShrekReportDataService;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.enums.TemplateDimMemScopeType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.index.DimensionIndexTree;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.WarpBean;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.domain.model.report.AnalysisHeader;
import kd.tmc.fpm.business.domain.model.report.MetricHeader;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SumPlanHeader;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtDetailInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountAmtInfo;
import kd.tmc.fpm.business.domain.model.sumplan.ApprovedAmountRecord;
import kd.tmc.fpm.business.domain.model.sumplan.DetailEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionVal;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelDetail;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRecord;
import kd.tmc.fpm.business.domain.model.sumplan.InnerCancelRule;
import kd.tmc.fpm.business.domain.model.sumplan.MainEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.SourceIdEntryData;
import kd.tmc.fpm.business.domain.model.sumplan.SumOrCancelPlanReportUpperParam;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfig;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigInfo;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanParamConfigSnapshot;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecordCount;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanUpdateInfo;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.domain.service.ISumPlanService;
import kd.tmc.fpm.business.helper.FpmAsyncCalculateHelper;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportQDTO;
import kd.tmc.fpm.business.mvc.service.IRelateReportDataManager;
import kd.tmc.fpm.business.mvc.service.IReportBizService;
import kd.tmc.fpm.business.mvc.service.IReportDataBizService;
import kd.tmc.fpm.business.mvc.service.ISumPlanBizService;
import kd.tmc.fpm.business.mvc.service.SumPlanDataService;
import kd.tmc.fpm.business.mvc.service.control.factory.RelateReportDataManagerFactory;
import kd.tmc.fpm.business.mvc.service.dto.RDBizLoadDto;
import kd.tmc.fpm.business.mvc.service.dto.RecalculateSumPlanAmtParamDTO;
import kd.tmc.fpm.business.mvc.service.dto.ReportQueryParamDTO;
import kd.tmc.fpm.business.service.interior.offset.context.InternalOffsetContext;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetGroupData;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetMessage;
import kd.tmc.fpm.business.service.interior.offset.model.InternalOffsetParam;
import kd.tmc.fpm.business.service.interior.offset.service.datasource.DataSourceHandler;
import kd.tmc.fpm.business.service.sumreport.service.ISummaryConfigService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.ReportUtils;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.helper.AmountCurrencyRateHelper;
import kd.tmc.fpm.common.property.SummaryConfigSnapshotProp;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.MD5Utils;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SumPlanBizServiceImpl
implements ISumPlanBizService {
    private static Log logger = LogFactory.getLog(SumPlanBizServiceImpl.class);
    private ISumPlanRepository repository = FpmServiceFactory.getBizService(ISumPlanRepository.class);
    private IReportRepository reportRepository;
    private IReportBizService reportBizService;
    private IDimensionRepository dimensionRepository;
    private IReportService reportService;
    private ISumPlanService service = FpmServiceFactory.getBizService(ISumPlanService.class);
    private IReportDataQueryService dataQueryService;
    private IReportDataBizService reportDataBizService;
    private IDataSaveService dataSaveService;
    private ITemplateRepository templateRepository;
    private IDimensionCombinationQueryService dimensionCombinationQueryService;
    private ISyncShrekReportDataService shrekReportDataService;
    private SumPlanDataService sumPlanDataService;
    private ISummaryConfigService iSummaryConfigService;

    public SumPlanBizServiceImpl() {
        this.reportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
        this.reportService = FpmServiceFactory.getBizService(IReportService.class);
        this.dimensionRepository = FpmServiceFactory.getBizService(IDimensionRepository.class);
        this.dataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
        this.reportDataBizService = FpmServiceFactory.getBizService(IReportDataBizService.class);
        this.reportBizService = FpmServiceFactory.getBizService(IReportBizService.class);
        this.dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
        this.templateRepository = FpmServiceFactory.getBizService(ITemplateRepository.class);
        this.dimensionCombinationQueryService = FpmServiceFactory.getBizService(IDimensionCombinationQueryService.class);
        this.shrekReportDataService = FpmServiceFactory.getBizService(ISyncShrekReportDataService.class);
        this.sumPlanDataService = FpmServiceFactory.getBizService(SumPlanDataService.class);
        this.iSummaryConfigService = FpmServiceFactory.getBizService(ISummaryConfigService.class);
    }

    @Override
    public SumPlanRecord load(Long id) {
        SumPlanRecord load = this.repository.load(id);
        return load;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FpmOperateResult<SumPlanRecord> load(Long id, FundPlanSystem system, SumPlanHeader sumPlanHeader) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanBizServiceImpl.class.getSimpleName());){
            span.addTag("load step1: loadSumPlanRecord");
            SumPlanRecord sumPlanRecord = this.repository.load(id);
            span.addTag("load step2: getSumPlanReports");
            FpmOperateResult<Void> loadSumPlanReportResult = this.loadSumPlanReport(sumPlanRecord, system, true);
            if (!loadSumPlanReportResult.isSuccess()) {
                FpmOperateResult<SumPlanRecord> fpmOperateResult = FpmOperateResult.error(loadSumPlanReportResult.getMessageList());
                return fpmOperateResult;
            }
            span.addTag("load step3: getSumPlanInfo");
            SumPlanInfo sumPlanInfo = this.getSumPlanInfo(sumPlanRecord, sumPlanHeader, system);
            span.addTag("load step4: loadSumConfigBySystem for DIRECT_SUB_LEVEL");
            List<SumPlanReport> sumPlanReportList = sumPlanRecord.getSumPlanReportList();
            List<ReportData> subReportDataList = this.getDownSubReportDataIfNeed(sumPlanReportList.get(0), sumPlanRecord.getReportOrg(), system);
            span.addTag("load step6: transfer");
            FpmOperateResult<Void> transferResult = this.service.transfer(sumPlanInfo, subReportDataList);
            if (!transferResult.isSuccess()) {
                FpmOperateResult<SumPlanRecord> fpmOperateResult = FpmOperateResult.error(transferResult.getMessageList());
                return fpmOperateResult;
            }
            FpmOperateResult<SumPlanRecord> fpmOperateResult = FpmOperateResult.success(sumPlanRecord);
            return fpmOperateResult;
        }
        catch (KDBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FpmOperateResult<SumPlanRecord> loadWithOutReference(Long id, FundPlanSystem system, SumPlanHeader sumPlanHeader) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanBizServiceImpl.class.getSimpleName());){
            span.addTag("load step1: loadSumPlanRecord");
            SumPlanRecord sumPlanRecord = this.repository.load(id);
            span.addTag("load step2: getSumPlanReports");
            FpmOperateResult<Void> loadSumPlanReportResult = this.loadSumPlanReport(sumPlanRecord, system, false);
            if (!loadSumPlanReportResult.isSuccess()) {
                FpmOperateResult<SumPlanRecord> fpmOperateResult = FpmOperateResult.error(loadSumPlanReportResult.getMessageList());
                return fpmOperateResult;
            }
            span.addTag("load step3: getSumPlanInfo");
            SumPlanInfo sumPlanInfo = this.getSumPlanInfo(sumPlanRecord, sumPlanHeader, system);
            span.addTag("load step4: loadSumConfigBySystem for DIRECT_SUB_LEVEL");
            List<SumPlanReport> sumPlanReportList = sumPlanRecord.getSumPlanReportList();
            List<ReportData> subReportDataList = this.getDownSubReportDataIfNeed(sumPlanReportList.get(0), sumPlanRecord.getReportOrg(), system);
            span.addTag("load step6: transfer");
            FpmOperateResult<Void> transferResult = this.service.transfer(sumPlanInfo, subReportDataList);
            if (!transferResult.isSuccess()) {
                FpmOperateResult<SumPlanRecord> fpmOperateResult = FpmOperateResult.error(transferResult.getMessageList());
                return fpmOperateResult;
            }
            FpmOperateResult<SumPlanRecord> fpmOperateResult = FpmOperateResult.success(sumPlanRecord);
            return fpmOperateResult;
        }
        catch (KDBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private SumPlanInfo getSumPlanInfo(SumPlanRecord sumPlanRecord, SumPlanHeader sumPlanHeader, FundPlanSystem system) {
        List<SumPlanReport> sumPlanReportList = sumPlanRecord.getSumPlanReportList();
        Dimension orgDimension = system.getMainDimensionByDimType(DimensionType.ORG);
        DimMember dimMember = orgDimension.getDimMemberById(sumPlanRecord.getReportOrg());
        SumPlanInfo sumPlanInfo = SumPlanInfo.builder().sumPlanHeader(sumPlanHeader).report(sumPlanReportList.get(0)).sumOrgMember(dimMember).system(system).currencyRateMap(sumPlanRecord.getCurrencyRateMap()).build();
        if (sumPlanRecord.getReportStatus() != ReportStatus.ENABLE) {
            ApprovedAmountRecord approvedAmountRecord = this.repository.loadApprovedAmtBySumId(sumPlanRecord.getId());
            sumPlanInfo.setApprovedAmountRecord(approvedAmountRecord);
        }
        List<InnerCancelRecord> innerCancelRecords = this.getInnerCancelRecords(sumPlanRecord.getId(), sumPlanHeader);
        sumPlanInfo.setInnerCancelRecordList(innerCancelRecords);
        List<ReportData> relationDataList = this.getRelationReportData(sumPlanInfo);
        sumPlanInfo.setRelationDataList(relationDataList);
        return sumPlanInfo;
    }

    private boolean needSearchDownData(ReportTemplate reportTemplate, TemplateDim orgDim) {
        if (reportTemplate.getTemplateUse() == TemplateUseType.ANALYSIS) {
            return true;
        }
        if (reportTemplate.getTemplateUse() != TemplateUseType.SUMMARY) {
            return false;
        }
        if (Objects.isNull(orgDim)) {
            return false;
        }
        return orgDim.getScopeType() == TemplateDimMemScopeType.DIRECT_SUB_LEVEL;
    }

    private List<ReportData> getDownSubReportDataIfNeed(Report report, Long sumOrgId, FundPlanSystem system) {
        TemplateDim orgTplDim;
        ReportPeriodType reportPeriodType = report.getReportPeriodType();
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        ReportTemplate template = report.getTemplate();
        if (!this.needSearchDownData(template, orgTplDim = template.getAllTemplateDim().stream().filter(item -> item.getDimType() == DimensionType.ORG).findFirst().get())) {
            return Collections.emptyList();
        }
        SumPlanParamConfig sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(report);
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        Map configInfoMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity(), (a, b) -> a));
        Map<Long, Boolean> configInfoSumAuditMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, SumPlanParamConfigInfo::isSumAuditNode));
        RDBizLoadDto rdBizLoadDto = new RDBizLoadDto();
        ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(6);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(6);
        List<TemplateDim> allTemplateDim = template.getAllTemplateDim();
        List<Long> orgMemberScope = Collections.emptyList();
        for (TemplateDim templateDim : allTemplateDim) {
            if (!templateDim.isVisible()) continue;
            Dimension dimension = system.getMainDimensionByDimensionId(templateDim.getDimensionId());
            List<Long> memberScope = new ArrayList<Long>(templateDim.getMemberScope());
            if (templateDim.getDimType() == DimensionType.ORG) {
                orgMemberScope = new ArrayList<Long>(templateDim.getMemberScope());
                memberScope = memberScope.stream().filter(item -> !Objects.equals(item, sumOrgId)).collect(Collectors.toList());
                List<Long> finalMemberScope = memberScope;
                List allChildrenIdList = dimension.getAllDimMemberList().stream().filter(item -> finalMemberScope.contains(item.getId()) && configInfoSumAuditMap.getOrDefault(item.getId(), Boolean.FALSE) == false).map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                memberScope.addAll(allChildrenIdList);
            }
            if (templateDim.getDimType() == DimensionType.PERIOD && detailPeriodType != null) {
                List<PeriodMember> periodMemberList;
                List<PeriodMember> memberList = periodMemberList = report.getPeriodMemberList();
                List rollPeriodMembers = Collections.emptyList();
                if (!report.isRollContainsDetail()) {
                    PeriodMember periodMember = periodMemberList.get(0);
                    memberList = Collections.singletonList(periodMember);
                    rollPeriodMembers = periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
                }
                memberScope = memberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                memberScope.addAll(rollPeriodMembers);
            }
            if (templateDim.getDimType() == DimensionType.CURRENCY) {
                SumPlanParamConfigInfo configInfo = (SumPlanParamConfigInfo)configInfoMap.get(sumOrgId);
                SumPlanParamConfigInfo.CurrencyMapCase currencyMapCase = configInfo.getCurrencyMapCase();
                if (configInfo.isSumAuditNode() && Objects.nonNull(currencyMapCase)) {
                    List<SumPlanParamConfigInfo.CurrencyMapCaseInfo> currencyMapCaseInfoList = currencyMapCase.getCurrencyMapCaseInfoList();
                    List currencyIdList = currencyMapCaseInfoList.stream().map(SumPlanParamConfigInfo.CurrencyMapCaseInfo::getSubOrgReportCurrencyId).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                    memberScope.addAll(currencyIdList);
                }
            }
            dimIdList.add(dimension);
            dimValList.add(memberScope.stream().map(item -> item).collect(Collectors.toList()));
        }
        rdBizLoadDto.setDimIdList(dimIdList);
        rdBizLoadDto.setDimValList(dimValList);
        rdBizLoadDto.setReportPeriodId(report.getPeriodMemberList().get(0).getId());
        ArrayList<ReportStatus> statusList = new ArrayList<ReportStatus>(2);
        statusList.add(ReportStatus.REPORTING);
        statusList.add(ReportStatus.ENABLE);
        rdBizLoadDto.setMainTable(Boolean.TRUE);
        rdBizLoadDto.setReportStatusList(statusList);
        FpmOperateResult<List<ReportData>> subReportDataResult = this.reportDataBizService.loadReportData(rdBizLoadDto, system);
        if (!subReportDataResult.isSuccess()) {
            return Collections.emptyList();
        }
        List<ReportData> subReportDataList = subReportDataResult.getData();
        this.handleSubLevelData(orgMemberScope, sumOrgId, system, subReportDataList, orgTplDim);
        return subReportDataList;
    }

    private void handleSubLevelData(List<Long> orgMemberScope, Long sumOrgId, FundPlanSystem system, List<ReportData> subReportDataList, TemplateDim orgDim) {
        if (EmptyUtil.isEmpty(subReportDataList)) {
            return;
        }
        Dimension orgDimension = system.getMainDimensionByDimType(DimensionType.ORG);
        Map orgDimMemberMap = orgDimension.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        Set<Object> dataAllOrgSet = subReportDataList.stream().map(rd -> rd.getDimValByDimType(DimensionType.ORG, null)).collect(Collectors.toSet());
        List subLevelOrgMemberList = orgMemberScope.stream().filter(orgId -> !Objects.equals(orgId, sumOrgId)).map(orgDimMemberMap::get).sorted(Comparator.comparing(DimMember::getLevel)).collect(Collectors.toList());
        HashMap subOrgToParentSetMap = new HashMap(64);
        HashSet<Long> nonNeedOrgSet = new HashSet<Long>(subLevelOrgMemberList.size());
        for (DimMember dimMember : subLevelOrgMemberList) {
            if (nonNeedOrgSet.contains(dimMember.getId()) && orgDim.getLocation().inPage()) continue;
            HashSet<Long> resultSet = new HashSet<Long>(32);
            this.buildNeedOrg(Collections.singletonList(dimMember), dataAllOrgSet, resultSet, nonNeedOrgSet);
            if (EmptyUtil.isEmpty(resultSet)) continue;
            for (Long subOrg : resultSet) {
                if (subOrgToParentSetMap.containsKey(subOrg)) {
                    ((Set)subOrgToParentSetMap.get(subOrg)).add(dimMember.getId());
                    continue;
                }
                HashSet<Long> parentIdSet = new HashSet<Long>(16);
                parentIdSet.add(dimMember.getId());
                subOrgToParentSetMap.put(subOrg, parentIdSet);
            }
        }
        ArrayList<ReportData> summaryDataList = new ArrayList<ReportData>(subReportDataList.size());
        block2: for (ReportData reportData : subReportDataList) {
            Long currentOrgId;
            if (reportData.isAuxiliaryInfo() || !subOrgToParentSetMap.containsKey(currentOrgId = (Long)reportData.getDimValByDimType(DimensionType.ORG, null))) continue;
            Set needToSumParentSet = (Set)subOrgToParentSetMap.get(currentOrgId);
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dimValList = reportData.getDimValList();
            for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                if (templateDim.getDimType() != DimensionType.ORG) continue;
                for (Long parentId : needToSumParentSet) {
                    if (orgDim.getLocation().inPage()) {
                        dimValList.set(i, parentId);
                        continue;
                    }
                    Object orgId2 = dimValList.get(i);
                    if (Objects.equals(orgId2, parentId)) continue;
                    ReportData copy = new ReportData(reportData);
                    copy.getDimValList().set(i, parentId);
                    copy.setId(DB.genGlobalLongId());
                    summaryDataList.add(copy);
                }
                continue block2;
            }
        }
        subReportDataList.addAll(summaryDataList);
    }

    private List<ReportData> getRelationReportData(SumPlanInfo sumPlanInfo) {
        Report sumPlanReport = sumPlanInfo.getReport();
        ApprovedAmountRecord approvedAmountRecord = sumPlanInfo.getApprovedAmountRecord();
        List<InnerCancelRecord> innerCancelRecords = sumPlanInfo.getInnerCancelRecordList();
        if (EmptyUtil.isEmpty((Object)approvedAmountRecord) && EmptyUtil.isEmpty(innerCancelRecords)) {
            return Collections.emptyList();
        }
        ArrayList<Long> reportDataIdList = new ArrayList<Long>(16);
        if (Objects.nonNull(approvedAmountRecord)) {
            Set sumReportDataIdSet = approvedAmountRecord.getAmountAmtInfoList().stream().map(ApprovedAmountAmtInfo::getReportDataIdStr).map(str -> str.split(",")).flatMap(Arrays::stream).map(Long::valueOf).collect(Collectors.toSet());
            List sumReportData = sumPlanReport.getReportDataList().stream().filter(i -> sumReportDataIdSet.contains(i.getId())).collect(Collectors.toList());
            FundPlanSystem system = sumPlanInfo.getSystem();
            Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
            ArrayList relData = new ArrayList(sumReportData);
            DimensionIndexTree indexTree = sumPlanReport.rebuildTree(system);
            Map<Long, PeriodMember> periodMemberIdReportPeriodMap = ReportUtils.getPeriodMemberIdReportPeriodMap(sumPlanReport);
            for (ReportData reportData : sumReportData) {
                Long parentPeriodId;
                Long periodMemberId;
                PeriodMember periodMember;
                if (reportData.isAuxiliaryInfo() || Objects.isNull(periodMember = periodMemberIdReportPeriodMap.get(periodMemberId = (Long)reportData.getDimValByDimType(DimensionType.PERIOD))) || Objects.equals(parentPeriodId = periodMember.getId(), periodMemberId)) continue;
                DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
                dimensionInfoBean.replaceValueIfContains(periodDim.getId(), (Object)parentPeriodId);
                TreeNode node = indexTree.find(dimensionInfoBean);
                if (node == null || org.apache.commons.collections4.CollectionUtils.isEmpty(node.getDataList())) continue;
                List rdList = node.getDataList().stream().map(ReportData.class::cast).collect(Collectors.toList());
                relData.addAll(rdList);
            }
            sumPlanReport.clearIndexTree();
            Set subMainReportDataIds = relData.stream().map(ReportData::getSourceIdList).flatMap(Collection::stream).collect(Collectors.toSet());
            reportDataIdList.addAll(subMainReportDataIds);
            List nonApprovedAmtLeafRDIds = sumPlanReport.getReportDataList().stream().filter(item -> {
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(item.getSourceIdList())) {
                    return item.getSourceIdList().stream().anyMatch(subMainReportDataIds::contains);
                }
                return false;
            }).map(item -> item.getSourceIdList().stream().filter(sourceId -> !subMainReportDataIds.contains(sourceId)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
            reportDataIdList.addAll(nonApprovedAmtLeafRDIds);
        }
        if (EmptyUtil.isNoEmpty(innerCancelRecords)) {
            List innerCancelRDIdList = innerCancelRecords.stream().filter(item -> item.getCancelDetailList() != null).map(InnerCancelRecord::getCancelDetailList).flatMap(Collection::stream).map(InnerCancelDetail::getReportDataId).collect(Collectors.toList());
            reportDataIdList.addAll(innerCancelRDIdList);
        }
        if (EmptyUtil.isEmpty(reportDataIdList)) {
            return Collections.emptyList();
        }
        ReportDataQueryObject queryObject = new ReportDataQueryObject();
        queryObject.setNeedDimIfValueIsNotEmpty(true);
        queryObject.setIdList(reportDataIdList);
        List<ReportDataQueryResult> relationDataResult = this.dataQueryService.queryReportData(queryObject);
        return ReportHelper.convert(relationDataResult);
    }

    @Override
    public FpmOperateResult<SumPlanRecord> loadWithReport(Long id) {
        SumPlanRecord sumPlanRecord = this.load(id);
        FundPlanSystem system = this.dimensionRepository.loadSystem(sumPlanRecord.getSystemId());
        SumPlanHeader sumPlanHeader = new SumPlanHeader();
        sumPlanHeader.setDataStatus(sumPlanRecord.isInnerCancel() ? 2 : 1);
        return this.load(id, system, sumPlanHeader);
    }

    private void buildNeedOrg(List<DimMember> dimMemberS, Set<Object> dataAllOrgSet, Set<Long> resultOrgSet, Set<Long> nonNeedOrgSet) {
        for (DimMember dimMember : dimMemberS) {
            if (dataAllOrgSet.contains(dimMember.getId())) {
                resultOrgSet.add(dimMember.getId());
                nonNeedOrgSet.addAll(dimMember.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toSet()));
                continue;
            }
            if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(dimMember.getChildren())) continue;
            this.buildNeedOrg(dimMember.getChildren(), dataAllOrgSet, resultOrgSet, nonNeedOrgSet);
        }
    }

    private FpmOperateResult<Void> loadSumPlanReport(SumPlanRecord sumPlanRecord, FundPlanSystem system, boolean includeRefPeriod) {
        List<Long> originalReportIdList = sumPlanRecord.getOriginalReportIdList();
        Long reportId = originalReportIdList.get(0);
        ReportQueryParamDTO reportQueryParamDTO = new ReportQueryParamDTO();
        reportQueryParamDTO.setSystem(system);
        reportQueryParamDTO.setReportId(reportId);
        reportQueryParamDTO.setQueryRollData(false);
        reportQueryParamDTO.setQueryRefData(includeRefPeriod);
        FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReportByParam(reportQueryParamDTO);
        if (!reportFpmOperateResult.isSuccess()) {
            return FpmOperateResult.error(reportFpmOperateResult.getMessageList());
        }
        SumPlanReport report = (SumPlanReport)reportFpmOperateResult.getData();
        report.setInnerOffset(sumPlanRecord.isInnerCancel());
        sumPlanRecord.setSumPlanReportList(Collections.singletonList(report));
        return FpmOperateResult.success();
    }

    @Override
    public void getSumPlanReports(Long reportId, SumPlanRecord sumPlanRecord, SumPlanHeader sumPlanHeader) {
        ArrayList<SumPlanReport> reportList = new ArrayList<SumPlanReport>(1);
        if (reportId != null) {
            FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReport(reportId);
            SumPlanReport report = (SumPlanReport)reportFpmOperateResult.getData();
            report.setInnerOffset(sumPlanRecord.isInnerCancel());
            reportList.add(report);
        } else {
            List<Long> reportIdList = sumPlanRecord.getOriginalReportIdList();
            MetricHeader metricHeader = null;
            if (sumPlanHeader != null && EmptyUtil.isNoEmpty(sumPlanHeader.getMetricMemberIds())) {
                metricHeader = new MetricHeader();
                metricHeader.setMetricMemberIds(sumPlanHeader.getMetricMemberIds());
            }
            for (Long reportid : reportIdList) {
                FpmOperateResult<Report> reportFpmOperateResult = this.reportBizService.loadReportNotContRefData(reportid, metricHeader);
                SumPlanReport report = (SumPlanReport)reportFpmOperateResult.getData();
                report.setInnerOffset(sumPlanRecord.isInnerCancel());
                reportList.add(report);
            }
        }
        sumPlanRecord.setSumPlanReportList(reportList);
    }

    @Override
    public FpmOperateResult<Void> sumReportSumAllData(Long sumRecordId) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanBizServiceImpl.class.getSimpleName());){
            logger.info("\u6c47\u603b\u6240\u6709\u4e0b\u7ea7\u6570\u636e{}", (Object)sumRecordId);
            span.addTag("sumReportSumAllData step1: loadSumPlanRecord");
            SumPlanRecord sumPlanRecord = this.repository.loadSumPlanRecord(sumRecordId);
            List<Long> sumPlanReportIdList = sumPlanRecord.getOriginalReportIdList();
            span.addTag("sumReportSumAllData step2: loadReport");
            List<Report> reportList = this.reportRepository.loadReport(new HashSet<Long>(sumPlanReportIdList));
            List sumPlanReportList = reportList.stream().map(item -> (SumPlanReport)item).collect(Collectors.toList());
            span.addTag("sumReportSumAllData step3: loadSumConfigBySystem");
            SumPlanParamConfig sumPlanParamConfig = this.repository.loadSumConfigBySystem(sumPlanRecord.getSystemId(), sumPlanRecord.getReportPeriodTypeId());
            span.addTag("sumReportSumAllData step4: sumReportSumAllData");
            this.sumReportSumAllData((SumPlanReport)sumPlanReportList.get(0), sumPlanParamConfig);
            span.addTag("sumReportSumAllData step5: updateReport");
        }
        return FpmOperateResult.success();
    }

    @Override
    public SumPlanRecordCount countSumPlan(Long sumRecordId) {
        return this.repository.countSumPlan(sumRecordId);
    }

    @Override
    public FpmOperateResult<Void> genSumOrgOffsetAmt(Long sumRecordId) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanBizServiceImpl.class.getSimpleName());){
            span.addTag("genSumOrgOffsetAmt step1: loadSumPlanRecord");
            SumPlanRecord sumPlanRecord = this.repository.loadSumPlanRecord(sumRecordId);
            span.addTag("genSumOrgOffsetAmt step2: loadInCRecordBySumId");
            List<InnerCancelRecord> innerCancelRecords = this.repository.loadInCRecordBySumId(sumRecordId);
            if (innerCancelRecords.isEmpty()) {
                FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.success();
                return fpmOperateResult;
            }
            ArrayList reportData = new ArrayList(16);
            span.addTag("genSumOrgOffsetAmt step3: loadReport");
            Report report = this.reportRepository.loadReport(sumPlanRecord.getOriginalReportIdList().get(0));
            HashMap info = new HashMap(16);
            BigDecimal bigDecimal = new BigDecimal(0);
            report.getReportDataList().stream().forEach(e -> e.setOffsetAmt(bigDecimal));
            innerCancelRecords.stream().forEach(item -> report.getReportDataList().forEach(data -> {
                Object period = data.getDimValByDimType(DimensionType.PERIOD, null);
                Object org = data.getDimValByDimType(DimensionType.ORG, null);
                Object currency = data.getDimValByDimType(DimensionType.CURRENCY, null);
                Object settlement = data.getDimValByDimType(DimensionType.SETTLEMENT_TYPE, null);
                Object subjects = data.getDimValByDimType(DimensionType.SUBJECTS, null);
                Object company = data.getDimValByDimType(DimensionType.COMPANY, null);
                if (item.getCancelPeriod().equals(period) && item.getOrgId().equals(org) && item.getCurrencyId().equals(currency)) {
                    item.getCancelDetailList().stream().forEach(e -> {
                        if (e.getSubjectId().equals(subjects) && bigDecimal.compareTo(e.getCancelAmt()) != 0 && (e.getSettleTypeId() == null || e.getSettleTypeId().equals(settlement)) && (e.getCompanyId() == null || e.getCompanyId().equals(company))) {
                            reportData.add(data);
                            info.put(e.getReportNumber(), e.getCancelAmt());
                            data.setOffsetAmt(e.getCancelAmt().add(data.getOffsetAmt()));
                        }
                    });
                }
            }));
            span.addTag("genSumOrgOffsetAmt step4: loadSystem");
            FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(report.getSystemId());
            List<ReportData> reportDataList = reportData.stream().distinct().collect(Collectors.toList());
            logger.info("offsetlist to " + info);
            span.addTag("genSumOrgOffsetAmt step5: calcFormulaData");
            this.reportService.calcFormulaData(report, fundPlanSystem, reportDataList);
            span.addTag("genSumOrgOffsetAmt step6: reBuildReportData");
            this.reportService.reBuildReportData(report);
            span.addTag("genSumOrgOffsetAmt step7: saveReport");
            this.reportRepository.saveReport(report);
            FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.success();
            return fpmOperateResult;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FpmOperateResult<Report> loadSumPlanAnalysisReport(FundPlanSystem system, ReportTemplate analysisReportTemplate, AnalysisHeader headerInfo) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(SumPlanBizServiceImpl.class.getSimpleName());){
            span.addTag("load step1: getSumPlanReports");
            SumPlanRecord sumPlanRecord = new SumPlanRecord();
            sumPlanRecord.setId(headerInfo.getReportSumRecordId());
            sumPlanRecord.setOriginalReportIdList(Collections.singletonList(headerInfo.getReportSumId()));
            this.loadSumPlanReport(sumPlanRecord, system, false);
            span.addTag("load step2: getSumPlanInfo");
            SumPlanHeader sumPlanHeader = new SumPlanHeader();
            int dataStatus = EmptyUtil.isNoEmpty((String)headerInfo.getInternalOffsetState()) ? Integer.parseInt(headerInfo.getInternalOffsetState()) : SumPlanHeader.DATA_STATUS_INNER_CANCEL_BEFORE;
            sumPlanHeader.setDataStatus(dataStatus);
            sumPlanRecord.setReportOrg(headerInfo.getSumReportOrg());
            SumPlanInfo sumPlanInfo = this.getSumPlanInfo(sumPlanRecord, sumPlanHeader, system);
            Report report = sumPlanInfo.getReport();
            this.fillIntoExchangeRate(system, analysisReportTemplate, report);
            report.setReferencePeriodMember(null);
            report.setTemplate(analysisReportTemplate);
            List<SumPlanReport> sumPlanReportList = sumPlanRecord.getSumPlanReportList();
            span.addTag("load step3: getDownSubReportDataIfNeed");
            List<Object> subReportDataList = new ArrayList(10);
            boolean orgDimInPage = analysisReportTemplate.getAllTemplateDim().stream().filter(item -> item.getDimType().isOrgDim()).anyMatch(item -> item.getLocation().inPage());
            if (!headerInfo.getOrg().contains(headerInfo.getSumReportOrg()) || !orgDimInPage) {
                subReportDataList = this.getDownSubReportDataIfNeed(sumPlanReportList.get(0), sumPlanRecord.getReportOrg(), system);
            }
            this.analysisTemplateAdaptor(analysisReportTemplate, report);
            if (!org.apache.commons.collections4.CollectionUtils.isEmpty(subReportDataList) && orgDimInPage) {
                report.setReportDataList(Lists.newArrayListWithCapacity((int)subReportDataList.size()));
            }
            span.addTag("load step4: transfer");
            FpmOperateResult<Void> transferResult = this.service.transfer(sumPlanInfo, subReportDataList);
            if (!transferResult.isSuccess()) {
                FpmOperateResult<Report> fpmOperateResult = FpmOperateResult.error(transferResult.getMessageList());
                return fpmOperateResult;
            }
            sumPlanInfo.rebuildIndex();
            this.adaptorAnalysisTemplateByAnalysisHeader(analysisReportTemplate, headerInfo);
            this.service.rebuildReportData(sumPlanInfo);
            FpmOperateResult<Report> fpmOperateResult = FpmOperateResult.success(report);
            return fpmOperateResult;
        }
        catch (KDBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void fillIntoExchangeRate(FundPlanSystem system, ReportTemplate template, Report report) {
        Long targetCurrencyId = system.getCurrencyId();
        boolean existsCurrency = template.getAllTemplateDim().stream().anyMatch(item -> item.getDimType() == DimensionType.CURRENCY && item.isIncludeSum());
        Date exchangeRateDate = report.getExchangeRateDate();
        if (existsCurrency && exchangeRateDate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6b63\u786e\u7684\u6c47\u7387\u65e5\u671f\uff0c\u8bf7\u68c0\u67e5\u8ba1\u5212\u7f16\u5236\u4e2d\u7684\u6c47\u7387\u65e5\u671f\u3002", (String)"SumPlanBizServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        BigDecimal baseRate = BigDecimal.ONE;
        HashMap exchangeRateMap = Maps.newHashMapWithExpectedSize((int)10);
        Dimension currencyDim = system.getMainDimensionByDimType(DimensionType.CURRENCY);
        List currencyIdList = currencyDim.getAllDimMemberList().stream().map(DimMember::getId).collect(Collectors.toList());
        for (Long currencyRangeId : currencyIdList) {
            DimMember currencyMember = currencyDim.getDimMemberById(currencyRangeId);
            Long sourceId = currencyMember.getSourceId();
            BigDecimal exchangeRate = null;
            if (existsCurrency && sourceId.compareTo(targetCurrencyId) != 0) {
                exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)report.getExchangeRateTableId(), (Long)sourceId, (Long)targetCurrencyId, (Date)exchangeRateDate);
                if (Objects.isNull(exchangeRate)) {
                    continue;
                }
            } else {
                exchangeRate = baseRate;
            }
            exchangeRateMap.put(currencyRangeId, exchangeRate);
        }
        if (exchangeRateMap.size() > 0) {
            report.setExchangeRateMap(exchangeRateMap);
        }
    }

    private void adaptorAnalysisTemplateByAnalysisHeader(ReportTemplate analysisReportTemplate, AnalysisHeader headerInfo) {
        List<TemplateDim> pageDimList = analysisReportTemplate.getPageDimList();
        Iterator<TemplateDim> iterator = pageDimList.iterator();
        while (iterator.hasNext()) {
            TemplateDim templateDim = iterator.next();
            DimensionType dimType = templateDim.getDimType();
            switch (dimType) {
                case ORG: {
                    this.removePageDimIfNeed(iterator, () -> headerInfo.getOrg());
                    break;
                }
                case PERIOD: {
                    this.removePageDimIfNeed(iterator, () -> headerInfo.getPeriodId());
                    break;
                }
                case COMPANY: {
                    this.removePageDimIfNeed(iterator, () -> headerInfo.getCompany());
                    break;
                }
                case SUBJECTS: {
                    this.removePageDimIfNeed(iterator, () -> headerInfo.getSubjects());
                    break;
                }
                case SETTLEMENT_TYPE: {
                    this.removePageDimIfNeed(iterator, () -> headerInfo.getSettlementMethod());
                    break;
                }
                case CUSTOM: {
                    Long dimensionId = templateDim.getDimensionId();
                    Map<String, List<Long>> customDimension = headerInfo.getCustomDimension();
                    List customDimensionOrDefault = customDimension.getOrDefault(dimensionId.toString(), Collections.emptyList());
                    this.removePageDimIfNeed(iterator, () -> customDimensionOrDefault);
                }
            }
        }
    }

    private void removePageDimIfNeed(Iterator<TemplateDim> iterator, Supplier<List<Long>> memberScopeSupplier) {
        List<Long> memberScope = memberScopeSupplier.get();
        if (EmptyUtil.isEmpty(memberScope)) {
            return;
        }
        iterator.remove();
    }

    @Override
    public FpmOperateResult<Report> loadSumPlanDetailAnalysisReport(FundPlanSystem fundPlanSystem, ReportTemplate reportTemplate, AnalysisHeader headerInfo) {
        Long reportSumId = headerInfo.getReportSumId();
        List<Report> reports = this.reportRepository.loadSimpleReport((Set<Long>)Sets.newHashSet((Object[])new Long[]{reportSumId}), p -> {
            p.setNeedTemplate(true);
            p.setNeedPeriodMember(true);
            p.setNeedReportPeriodType(true);
        });
        Report report = reports.get(0);
        ReportPeriodType reportPeriodType = report.getReportPeriodType();
        PeriodType detailPeriodType = reportPeriodType.getDetailPeriodType();
        SumPlanParamConfig sumPlanParamConfig = this.iSummaryConfigService.getSummaryParamConfig(report);
        if (Objects.isNull(sumPlanParamConfig)) {
            throw new KDBizException("sumPlanParamConfigs is null");
        }
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        List sumOrgIds = configInfoList.stream().filter(SumPlanParamConfigInfo::isSumAuditNode).sorted(Comparator.comparing(SumPlanParamConfigInfo::getLevel)).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(sumOrgIds)) {
            logger.warn("sumPlanParamConfigs isSumAuditNode sumOrgIds is null\uff0c number:{}", (Object)sumPlanParamConfig.getNumber());
            throw new KDBizException("sumPlanParamConfigs isSumAuditNode sumOrgIds is null");
        }
        RDBizLoadDto rdBizLoadDto = new RDBizLoadDto();
        ArrayList<Dimension> dimIdList = new ArrayList<Dimension>(6);
        ArrayList<List<Object>> dimValList = new ArrayList<List<Object>>(6);
        List allTemplateDim = reportTemplate.getAllTemplateDim().stream().filter(tpl -> !tpl.isViDim()).collect(Collectors.toList());
        boolean onlyIncludeDetailPeriod = false;
        TemplateDim totalDim = null;
        TemplateDim expandDim = null;
        for (TemplateDim templateDim : allTemplateDim) {
            Map<String, List<Long>> customDimension;
            List<Long> memberIds;
            if (!templateDim.isVisible()) continue;
            if (templateDim.isTotalRow()) {
                totalDim = templateDim;
            }
            if (templateDim.isExpand()) {
                expandDim = templateDim;
            }
            if (templateDim.getDimType() == DimensionType.DETAILDIM) continue;
            Dimension dimension = fundPlanSystem.getMainDimensionByDimensionId(templateDim.getDimensionId());
            List<Long> memberScope = new ArrayList<Long>(templateDim.getMemberScope());
            if (templateDim.getDimType() == DimensionType.ORG) {
                memberScope = headerInfo.getOrg();
            }
            if (templateDim.getDimType() == DimensionType.CUSTOM && org.apache.commons.collections4.CollectionUtils.isNotEmpty(memberIds = (customDimension = headerInfo.getCustomDimension()).get(templateDim.getDimensionId().toString()))) {
                memberScope = memberIds;
            }
            if (templateDim.getDimType() == DimensionType.PERIOD && detailPeriodType != null) {
                List<PeriodMember> periodMemberList;
                Map periodMembersMap = dimension.getAllDimMemberList().stream().collect(Collectors.toMap(DimMember::getId, Function.identity()));
                List<PeriodMember> memberList = periodMemberList = report.getPeriodMemberList();
                List rollPeriodMembers = Collections.emptyList();
                if (!report.isRollContainsDetail()) {
                    PeriodMember periodMember = periodMemberList.get(0);
                    memberList = Collections.singletonList(periodMember);
                    rollPeriodMembers = periodMemberList.subList(1, periodMemberList.size()).stream().map(DimMember::getId).collect(Collectors.toList());
                }
                memberScope = memberList.stream().map(DimMember::getAllChildMember).flatMap(Collection::stream).map(DimMember::getId).collect(Collectors.toList());
                memberScope.addAll(rollPeriodMembers);
                if (!org.apache.commons.collections4.CollectionUtils.isEmpty(headerInfo.getPeriodId())) {
                    ArrayList<Long> members = new ArrayList<Long>(headerInfo.getPeriodId().size());
                    ArrayList<Object> periodId = new ArrayList<Object>(16);
                    for (Long l : headerInfo.getPeriodId()) {
                        DimMember member = (DimMember)periodMembersMap.get(l);
                        if (Objects.isNull(member)) continue;
                        List childMembers = member.getAllChildMember().stream().map(DimMember::getId).collect(Collectors.toList());
                        periodId.addAll(childMembers);
                        periodId.add(member.getId());
                    }
                    for (Long l : periodId) {
                        if (!memberScope.contains(l)) continue;
                        members.add(l);
                    }
                    memberScope = members;
                    List periodMembers = headerInfo.getPeriodId().stream().map(periodMembersMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                    List list = periodMembers.stream().filter(DimMember::isLeaf).collect(Collectors.toList());
                    List parentPeriodMembers = periodMembers.stream().filter(item -> !item.isLeaf()).collect(Collectors.toList());
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(list) && org.apache.commons.collections4.CollectionUtils.isNotEmpty(parentPeriodMembers)) {
                        List<Long> tplMemberScope = parentPeriodMembers.stream().map(DimMember::getId).collect(Collectors.toList());
                        templateDim.setMemberScope(tplMemberScope);
                    } else if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(list)) {
                        onlyIncludeDetailPeriod = true;
                    }
                }
            }
            if (!org.apache.commons.collections4.CollectionUtils.isNotEmpty(memberScope)) continue;
            dimIdList.add(dimension);
            dimValList.add(memberScope.stream().map(item -> item).collect(Collectors.toList()));
        }
        rdBizLoadDto.setDimIdList(dimIdList);
        rdBizLoadDto.setDimValList(dimValList);
        rdBizLoadDto.setReportPeriodId(report.getPeriodMemberList().get(0).getId());
        ArrayList<ReportStatus> statusList = new ArrayList<ReportStatus>(2);
        statusList.add(ReportStatus.REPORTING);
        statusList.add(ReportStatus.ENABLE);
        rdBizLoadDto.setReportStatusList(statusList);
        rdBizLoadDto.setTemplateType(TemplateType.DETAIL);
        rdBizLoadDto.setMainTable(false);
        FpmOperateResult<List<ReportData>> subReportDataResult = this.reportDataBizService.loadReportData(rdBizLoadDto, fundPlanSystem);
        List<ReportData> subReportDataList = subReportDataResult.getData();
        this.transferAmountUnit(subReportDataList, report.getTemplate().getAmountUnit());
        subReportDataList = subReportDataList.stream().sorted(this.getReportDataComparator(report, fundPlanSystem)).collect(Collectors.toList());
        int rowOffset = reportTemplate.getDataStartRow(detailPeriodType != null);
        int n = rowOffset = onlyIncludeDetailPeriod ? rowOffset - 1 : rowOffset;
        if (expandDim != null) {
            rowOffset = totalDim == null ? rowOffset : rowOffset - 1;
        }
        this.summarizingDataIfExpand(report, rowOffset, subReportDataList, reportTemplate, expandDim);
        return FpmOperateResult.success(report);
    }

    private void summarizingDataIfExpand(Report report, int rowOffset, List<ReportData> subReportDataList, ReportTemplate reportTemplate, TemplateDim expandDim) {
        if (expandDim == null) {
            for (int i = 0; i < subReportDataList.size(); ++i) {
                ReportData reportData2 = subReportDataList.get(i);
                reportData2.setRow(i + rowOffset);
            }
            reportTemplate.setMaxLineCount(subReportDataList.size());
            report.setReportDataList(subReportDataList);
            return;
        }
        List needGroupDimensionIdList = reportTemplate.getAllTemplateDim().stream().filter(tpl -> !tpl.isViDim()).filter(templateDim -> !templateDim.isExpand()).map(TemplateDim::getDimensionId).collect(Collectors.toList());
        Map combinationListMap = subReportDataList.stream().collect(Collectors.groupingBy(rd -> EvalDimensionCombination.getEvalDimensionCombinationWithDetailDim(rd, td -> needGroupDimensionIdList.contains(td.getDimensionId())), LinkedHashMap::new, Collectors.toList()));
        ArrayList<ReportData> result = new ArrayList<ReportData>(subReportDataList.size());
        int idx = 0;
        for (Map.Entry entry : combinationListMap.entrySet()) {
            int row = idx + rowOffset;
            ArrayList<ReportData> mergeResult = new ArrayList<ReportData>(((List)entry.getValue()).size());
            DimensionType dimType = expandDim.getDimType();
            Map<Object, List<ReportData>> dataGroup = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(reportData -> reportData.getDimValByDimType(dimType)));
            for (Map.Entry<Object, List<ReportData>> innerEntry : dataGroup.entrySet()) {
                List<ReportData> dataList = innerEntry.getValue();
                if (dataList.size() <= 1) {
                    mergeResult.add(dataList.get(0));
                    continue;
                }
                ReportData mergeData = new ReportData(dataList.get(0));
                mergeData.clearAmt();
                for (ReportData reportData3 : dataList) {
                    if (!Objects.equals(mergeData.getReportPeriodId(), reportData3.getReportPeriodId())) break;
                    mergeData.addPlanAmt(reportData3.getPlanAmt());
                    mergeData.addReportPlanAmt(reportData3.getReportPlanAmt());
                    mergeData.addOriginalPlanAmt(reportData3.getOriginalPlanAmt());
                    mergeData.addPlanReferenceAmt(reportData3.getPlanReferenceAmt());
                    mergeData.addLockAmt(reportData3.getLockAmt());
                    mergeData.addActAmt(reportData3.getActAmt());
                }
                mergeResult.add(mergeData);
            }
            mergeResult.forEach(reportData -> reportData.setRow(row));
            result.addAll(mergeResult);
            ++idx;
        }
        reportTemplate.setMaxLineCount(combinationListMap.size());
        report.setReportDataList(result);
    }

    @Override
    public FpmOperateResult<Void> recalculateSumPlanAmt(RecalculateSumPlanAmtParamDTO qParam) {
        Map<Long, Set<Long>> existsReportIdMap = this.reportRepository.getExistsReportId(t -> {
            t.setReportOrgIdList(qParam.getReportOrgIds());
            t.setReportPeriodId(qParam.getReportPeriodId());
            t.setReportPlanType(ReportPlanType.SUMPLAN);
            t.setProcessStatus(ReportProcessStatus.AUDIT);
            t.setReportStatus(ReportStatus.ENABLE);
        });
        FundPlanSystem fundPlanSystem = this.dimensionRepository.loadSystem(qParam.getSystemId());
        for (Map.Entry<Long, Set<Long>> entry : existsReportIdMap.entrySet()) {
            Set<Long> sumReportIdSet = entry.getValue();
            if (EmptyUtil.isEmpty(sumReportIdSet)) continue;
            for (Long sumReportId : sumReportIdSet) {
                this.recalculateSingleSumReportAmt(sumReportId, fundPlanSystem);
            }
        }
        return FpmOperateResult.success(null);
    }

    private Comparator<ReportData> getReportDataComparator(Report report, FundPlanSystem system) {
        Map dimMemberMap = system.getDimList().stream().map(Dimension::getAllDimMemberList).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity()));
        ReportTemplate template = report.getTemplate();
        List sortMainDimList = template.getAllTemplateDim().stream().filter(item -> item.getDimType().isDefaultCompareMainDimension()).sorted(Comparator.comparingInt(i -> i.getDimType().getAnalyseDimOrder())).collect(Collectors.toList());
        return (o1, o2) -> this.defaultSortResult(dimMemberMap, sortMainDimList, (ReportData)o1, (ReportData)o2);
    }

    private int defaultSortResult(Map<Long, DimMember> dimMemberMap, List<TemplateDim> sortMainDimList, ReportData o1, ReportData o2) {
        for (TemplateDim templateDim : sortMainDimList) {
            int result = this.sortByDimType(dimMemberMap, templateDim, o1, o2);
            if (NumberUtils.equalsZero((Integer)result)) continue;
            return result;
        }
        return 0;
    }

    private int sortByDimType(Map<Long, DimMember> dimMemberMap, TemplateDim finalSortDim, ReportData o1, ReportData o2) {
        Object o1Value = o1.getDimValByDimType(finalSortDim.getDimType());
        Object o2Value = o2.getDimValByDimType(finalSortDim.getDimType());
        if (Objects.isNull(o1Value) && Objects.nonNull(o2Value)) {
            return -1;
        }
        if (Objects.nonNull(o1Value) && Objects.isNull(o2Value)) {
            return 1;
        }
        if (Objects.isNull(o1Value)) {
            return 0;
        }
        DimMember dimMember1 = dimMemberMap.get(o1Value);
        DimMember dimMember2 = dimMemberMap.get(o2Value);
        int result = dimMember1.getSortCode().compareTo(dimMember2.getSortCode());
        if (!NumberUtils.equalsZero((Integer)result)) {
            return result;
        }
        return 0;
    }

    private int getLongCompareResult(TemplateDim finalSortDim, ReportData o1, ReportData o2) {
        Object o1Value = o1.getDimValByDimType(finalSortDim.getDimType());
        Object o2Value = o2.getDimValByDimType(finalSortDim.getDimType());
        if (Objects.isNull(o1Value) && Objects.nonNull(o2Value)) {
            return -1;
        }
        if (Objects.nonNull(o1Value) && Objects.isNull(o2Value)) {
            return 1;
        }
        if (Objects.isNull(o1Value)) {
            return 0;
        }
        return Long.compare((Long)o1Value, (Long)o2Value);
    }

    public void transferAmountUnit(List<ReportData> subReportDataList, AmountUnit amountUnit) {
        for (ReportData rd : subReportDataList) {
            rd.setPlanAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)rd.getPlanAmt(), (AmountUnitEnum)AmountUnit.convert(rd.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit)));
            rd.setPlanReferenceAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)rd.getPlanReferenceAmt(), (AmountUnitEnum)AmountUnit.convert(rd.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit)));
            rd.setActAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)rd.getActAmt(), (AmountUnitEnum)AmountUnit.convert(rd.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit)));
            rd.setReportPlanAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)rd.getReportPlanAmt(), (AmountUnitEnum)AmountUnit.convert(rd.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit)));
            rd.setLockAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)rd.getLockAmt(), (AmountUnitEnum)AmountUnit.convert(rd.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit)));
            rd.setOriginalPlanAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)rd.getOriginalPlanAmt(), (AmountUnitEnum)AmountUnit.convert(rd.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit)));
            for (int i = 0; i < rd.getDimList().size(); ++i) {
                String amountStr;
                TemplateDim templateDim = rd.getDimList().get(i);
                if (!templateDim.isDetailDim() || templateDim.getDetailDataType() != DetailDataType.AMOUNT) continue;
                Object val = rd.getDimValList().get(i);
                if (val instanceof BigDecimal) {
                    BigDecimal newAmount = AmountCurrencyRateHelper.convertAmt((BigDecimal)((BigDecimal)val), (AmountUnitEnum)AmountUnit.convert(rd.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit));
                    rd.getDimValList().set(i, newAmount.toString());
                    continue;
                }
                if (!(val instanceof String) || !StringUtils.isNotEmpty((CharSequence)(amountStr = (String)val))) continue;
                BigDecimal newAmount = AmountCurrencyRateHelper.convertAmt((BigDecimal)new BigDecimal(amountStr), (AmountUnitEnum)AmountUnit.convert(rd.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(amountUnit));
                rd.getDimValList().set(i, newAmount.toString());
            }
        }
    }

    private void analysisTemplateAdaptor(ReportTemplate analysisReportTemplate, Report report) {
        ReportTemplate template = report.getTemplate();
        Set dimensionIds = template.getAllTemplateDim().stream().filter(TemplateDim::isVisible).map(TemplateDim::getDimensionId).collect(Collectors.toSet());
        List<TemplateDim> allTemplateDim = analysisReportTemplate.getAllTemplateDim();
        Map<DimLocation, List<TemplateDim>> dimLocationListMap = allTemplateDim.stream().filter(templateDim -> !dimensionIds.contains(templateDim.getDimensionId())).collect(Collectors.groupingBy(TemplateDim::getLocation));
        for (Map.Entry<DimLocation, List<TemplateDim>> entry : dimLocationListMap.entrySet()) {
            switch (entry.getKey()) {
                case PAGE: {
                    analysisReportTemplate.getPageDimList().removeAll((Collection)entry.getValue());
                    break;
                }
                case ROW: {
                    analysisReportTemplate.getRowDimList().removeAll((Collection)entry.getValue());
                    break;
                }
                case COL: {
                    analysisReportTemplate.getColDimList().removeAll((Collection)entry.getValue());
                }
            }
        }
    }

    public FpmOperateResult<Void> sumReportSumAllData(SumPlanReport sumPlanReport, SumPlanParamConfig sumPlanParamConfig) {
        Long reportOrgId = sumPlanReport.getCompanyMemberList().get(0).getId();
        Long reportPeriodId = sumPlanReport.getPeriodMemberList().get(0).getId();
        Long systemId = sumPlanReport.getSystemId();
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        Map configInfoMap = configInfoList.stream().collect(Collectors.toMap(SumPlanParamConfigInfo::getOrgMemberId, Function.identity()));
        FundPlanSystem system = this.dimensionRepository.loadSystem(systemId);
        SumPlanParamConfigInfo currConfigInfo = (SumPlanParamConfigInfo)configInfoMap.get(reportOrgId);
        List<Long> subSumOrgIds = currConfigInfo.getAllChildren().stream().filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toList());
        List<SumPlanRecord> sumPlanRecords = this.repository.loadSumPlanRecord(subSumOrgIds, reportPeriodId);
        Set<Long> nonAuditSumOrgIds = sumPlanRecords.stream().filter(sumPlanRecord -> sumPlanRecord.getStatus() != BillStatus.AUDITED).map(SumPlanRecord::getReportOrg).collect(Collectors.toSet());
        List<SumPlanParamConfigInfo> allChildIfAudit = this.getAllChildIfAudit(currConfigInfo, nonAuditSumOrgIds);
        for (SumPlanParamConfigInfo orgMember : allChildIfAudit) {
            if (orgMember.isSumAuditNode()) continue;
            ReportQDTO reportQDTO = new ReportQDTO();
            reportQDTO.setReportOrgId(orgMember.getOrgMemberId());
            reportQDTO.setReportPeriodId(reportPeriodId);
            reportQDTO.setReportPlanType(ReportPlanType.REPORTPLAN);
            reportQDTO.setProcessStatus(ReportProcessStatus.AUDIT);
            reportQDTO.setReportStatus(ReportStatus.REPORTING);
            reportQDTO.setMainTable(true);
            List<Report> mainReportList = this.reportRepository.loadReportWithAllDimensionByParam(reportQDTO);
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(mainReportList)) continue;
            FpmOperateResult<SumPlanUpdateInfo> fpmOperateResult = this.service.sumPlanReportUpper(mainReportList, sumPlanReport, system);
            if (!fpmOperateResult.isSuccess()) {
                logger.error("\u6c47\u603b\u5f02\u5e38\uff0c{}", (Object)JSON.toJSONString(fpmOperateResult.getMessageList()));
                return FpmOperateResult.error(fpmOperateResult.getMessageList());
            }
            this.sumPlanDataService.batchSaveSumPlanUpdateInfo(fpmOperateResult.getData());
        }
        return FpmOperateResult.success();
    }

    private List<SumPlanParamConfigInfo> getAllChildIfAudit(SumPlanParamConfigInfo currConfigInfo, Set<Long> nonAuditSumOrgIds) {
        ArrayList<SumPlanParamConfigInfo> allChildren = new ArrayList<SumPlanParamConfigInfo>(16);
        this.getAllChildren(allChildren, currConfigInfo.getChildren(), nonAuditSumOrgIds);
        return allChildren;
    }

    private void getAllChildren(List<SumPlanParamConfigInfo> allChildren, List<SumPlanParamConfigInfo> children, Set<Long> nonAuditSumOrgIds) {
        if (EmptyUtil.isEmpty(children)) {
            return;
        }
        allChildren.addAll(children);
        for (SumPlanParamConfigInfo configInfo : children) {
            if (nonAuditSumOrgIds.contains(configInfo.getOrgMemberId())) continue;
            this.getAllChildren(allChildren, configInfo.getChildren(), nonAuditSumOrgIds);
        }
    }

    @Override
    public FpmOperateResult<Void> save(SumPlanRecord sumPlanRecord) {
        this.repository.save(sumPlanRecord);
        return FpmOperateResult.success();
    }

    @Override
    public FpmOperateResult<Void> submit(Long id) {
        FpmOperateResult<SumPlanRecord> innerCancelResult;
        FpmOperateResult<Void> result = FpmOperateResult.success();
        if (result.isSuccess() && !(innerCancelResult = this.innerCancelAmt(id)).isSuccess()) {
            innerCancelResult.setSuccess(false);
            result.setMessageList(innerCancelResult.getMessageList());
        }
        return result;
    }

    @Override
    public FpmOperateResult<Void> audit(Long id, FundPlanSystem system) {
        return CommonUtils.trace(SumPlanBizServiceImpl.class.getSimpleName(), span -> {
            logger.info(String.format("\u6c47\u603b\u7f16\u62a5\u5ba1\u6838\uff0c%s", id));
            span.addTag("sumPlan audit step1: loadSumPlanRecord");
            SumPlanRecord sumPlanRecord = this.repository.loadSumPlanRecord(id);
            if (EmptyUtil.isEmpty((Object)sumPlanRecord)) {
                return FpmOperateResult.success();
            }
            this.getSumPlanReports(null, sumPlanRecord, null);
            List<SumPlanReport> currReportList = sumPlanRecord.getSumPlanReportList();
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(currReportList)) {
                return FpmOperateResult.success();
            }
            span.addTag("sumPlan audit step2: loadSumConfigBySystem");
            SumPlanParamConfig sumPlanParamConfig = this.repository.loadSumConfigBySystem(sumPlanRecord.getSystemId(), sumPlanRecord.getReportType());
            SumPlanReport sumReport = currReportList.get(0);
            OrgMember reportOrg = sumReport.getCompanyMemberList().get(0);
            span.addTag("sumPlan audit step2: loadSumConfigBySystem");
            Long reportPeriodId = sumPlanRecord.getReportPeriodId();
            Optional<SumPlanParamConfigInfo> first = sumPlanParamConfig.getConfigInfoList().stream().filter(SumPlanParamConfigInfo::isSumAuditNode).filter(info -> Objects.equals(info.getOrgMemberId(), reportOrg.getId())).findFirst();
            if (!first.isPresent()) {
                // empty if block
            }
            SumPlanParamConfigInfo configInfo = first.get();
            sumPlanRecord.setStatus(BillStatus.AUDITED);
            sumReport.setRecordBillStatus(BillStatus.AUDITED);
            sumReport.setProcessStatus(ReportProcessStatus.AUDIT);
            span.addTag("sumPlan audit step3: getUpperSumReport");
            List<Long> reportIdList = this.getUpperSumReport(reportOrg, reportPeriodId, sumPlanParamConfig);
            if (EmptyUtil.isNoEmpty(reportIdList)) {
                sumPlanRecord.setReportStatus(ReportStatus.REPORTING);
                sumReport.setReportStatus(ReportStatus.REPORTING);
                Long upperSumReportId = reportIdList.get(0);
                String dLockName = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "sumReportAuditOrUnAudit", upperSumReportId);
                BiFunction<List, SumPlanReport, FpmOperateResult> callBack = (subReports, upperSumReport) -> this.service.sumPlanReportUpper((List<Report>)subReports, (SumPlanReport)upperSumReport, system);
                span.addTag("sumPlan audit step4.1: sumOrSubDownReportDataToUpper");
                Supplier<SumPlanReport> supplier = () -> (SumPlanReport)this.reportRepository.loadReport(upperSumReportId);
                FpmOperateResult voidFpmOperateResult = CommonUtils.processInDLock(dLockName, () -> this.sumOrSubDownReportDataToUpper(sumPlanRecord, (SumPlanReport)supplier.get(), configInfo, callBack));
                if (!voidFpmOperateResult.isSuccess()) {
                    return voidFpmOperateResult;
                }
            } else {
                span.addTag("sumPlan audit step4.2 option: reverse write planning Report");
                sumPlanRecord.setReportStatus(ReportStatus.ENABLE);
                sumReport.setReportStatus(ReportStatus.ENABLE);
                FpmOperateResult sumPlanResult = CommonUtils.processInTransaction(() -> this.reverseWriteDownReport(sumPlanRecord, configInfo, system, sumPlanParamConfig));
                if (Objects.nonNull(sumPlanResult) && !sumPlanResult.isSuccess()) {
                    return sumPlanResult;
                }
            }
            span.addTag("sumPlan audit step5 option: send message for execute inner cancel");
            return FpmOperateResult.success();
        });
    }

    private FpmOperateResult<Void> reverseWriteDownReport(SumPlanRecord sumPlanRecord, SumPlanParamConfigInfo sumPlanParamConfigInfo, FundPlanSystem system, SumPlanParamConfig sumPlanParamConfig) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("reverseWriteDownReport");){
            span.addTag("getAllDownLevelAuditedSumPlanRecords");
            List<SumPlanRecord> downLevelSumPlanRecords = this.getAllDownLevelAuditedSumPlanRecords(sumPlanRecord, sumPlanParamConfigInfo);
            ArrayList<SumPlanRecord> downLevelSumPlanRecordsContainsCurrent = new ArrayList<SumPlanRecord>(downLevelSumPlanRecords);
            downLevelSumPlanRecordsContainsCurrent.add(sumPlanRecord);
            SumPlanReport sumPlanReport = sumPlanRecord.getSumPlanReportList().get(0);
            span.addTag("doReverseWriteDownReport");
            logger.info("\u5f00\u59cb\u53cd\u5199\u6240\u6709\u4e0b\u7ea7(\u542b\u672c\u8eab)\u5b58\u5728\u6838\u5b9a\u8bb0\u5f55\u65f6\u7684\u7f16\u5236\u6570\u636e");
            this.doReverseWriteDownReport(downLevelSumPlanRecordsContainsCurrent, sumPlanReport, system);
            span.addTag("getSumReportMapLastStageReportOrgIds");
            logger.info("\u83b7\u53d6\u6240\u6709\u4e0b\u7ea7(\u542b\u672c\u7ea7)\u5bf9\u5e94\u7684\u6240\u6709\u672b\u7ea7\u7f16\u62a5\u4e3b\u4f53");
            Map<Long, Set<Long>> sumOrgIdMapLastStageReportOrgIds = this.getSumReportMapLastStageReportOrgIds(sumPlanParamConfigInfo, downLevelSumPlanRecordsContainsCurrent, false);
            logger.info("\u6240\u6709\u4e0b\u7ea7(\u542b\u672c\u7ea7)\u5bf9\u5e94\u7684\u6240\u6709\u672b\u7ea7\u7f16\u62a5\u4e3b\u4f53\uff1a{}", sumOrgIdMapLastStageReportOrgIds);
            List<Long> lastStageReportOrgIds = sumOrgIdMapLastStageReportOrgIds.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
            logger.info("\u51c6\u5907\u66f4\u65b0\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u6570\u636e\u72b6\u6001\u548c\u8ba1\u5212\u7f16\u5236\u8868\u72b6\u6001\u4e3a\u5df2\u751f\u6548");
            span.addTag("updateLastStageReportStatus");
            Set<Long> lastReportIds = this.updateLastStageReportStatus(lastStageReportOrgIds, sumPlanRecord.getReportPeriodId(), true, system);
            logger.info("\u5f00\u59cb\u66f4\u65b0\u672b\u7ea7(\u542b\u672c\u7ea7)\u6c47\u603b\u8bb0\u5f55\u72b6\u6001\u548c\u6c47\u603b\u8868\u53ca\u6c47\u603b\u7f16\u5236\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u751f\u6548");
            downLevelSumPlanRecords.forEach(t -> t.setReportStatus(ReportStatus.ENABLE));
            span.addTag("updateSumRecordsStatus");
            Set<Long> sumReportIds = this.updateSumRecordsStatus(sumPlanRecord, downLevelSumPlanRecords, system);
            lastReportIds.addAll(sumReportIds);
            logger.info("\u751f\u6210\u6c47\u603b\u53c2\u6570\u5feb\u7167\u5e76\u540c\u6b65\u76f8\u5173\u62a5\u8868");
            this.syncSummaryConfigSnapshot(sumPlanReport, sumPlanParamConfig, lastReportIds);
            logger.info("\u66f4\u65b0\u671f\u521d\u79d1\u76ee\u7684\u5b9e\u9645\u6570\u7b49\u4e8e\u8ba1\u5212\u6570");
            this.updateActAmtForPeriodStartEndIfNeed(sumPlanRecord, lastReportIds, system);
            FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.success();
            return fpmOperateResult;
        }
    }

    private List<SumPlanRecord> getAllDownLevelAuditedSumPlanRecords(SumPlanRecord sumPlanRecord, SumPlanParamConfigInfo currentConfigInfo) {
        List<SumPlanParamConfigInfo> allChildren = currentConfigInfo.getAllChildren();
        Set<Long> sumReportOrgMemberIds = allChildren.stream().filter(SumPlanParamConfigInfo::isSumAuditNode).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(sumReportOrgMemberIds)) {
            return new ArrayList<SumPlanRecord>(1);
        }
        logger.info("\u67e5\u8be2\u4e0b\u7ea7\u6240\u6709\u5df2\u5ba1\u6838\u7684\u6c47\u603b\u8bb0\u5f55\uff0c\u6240\u6709\u4e0b\u7ea7\u7f16\u62a5\u4e3b\u4f53\uff1a{}\uff0c\u7f16\u62a5\u671f\u95f4:{}", sumReportOrgMemberIds, (Object)sumPlanRecord.getReportPeriodId());
        List<SumPlanRecord> downLevelSumPlanRecords = this.repository.loadSumPlanRecord(sumReportOrgMemberIds, sumPlanRecord.getReportPeriodId()).stream().filter(record -> record.getStatus() == BillStatus.AUDITED).collect(Collectors.toList());
        return downLevelSumPlanRecords;
    }

    private List<ReportData> queryAllSumReportDataByApprovalReportDataDimensionInfo(List<Long> sumReportIds, List<ReportData> lastStageApprovalReportData, Dimension subjectDimension) {
        logger.info("\u5f00\u59cb\u67e5\u8be2\u53c2\u4e0e\u6838\u5b9a\u4e86\u7684\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u6570\u636e\u5bf9\u5e94\u7684\u79d1\u76ee\u7684\u6240\u6709\u6c47\u603b\u7f16\u5236\u6570\u636e\uff0c\u6240\u6709\u6c47\u603b\u7f16\u5236\u8868\uff1a{}", sumReportIds);
        if (EmptyUtil.isEmpty(lastStageApprovalReportData)) {
            logger.info("\u672b\u7ea7\u6ca1\u6709\u53c2\u4e0e\u6838\u5b9a\u7684\u8ba1\u5212\u7f16\u5236\u6570\u636e");
            return Collections.emptyList();
        }
        ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
        reportDataQueryObject.setReportIdS(sumReportIds);
        HashSet<Object> subjectIds = new HashSet<Object>(256);
        for (ReportData rd : lastStageApprovalReportData) {
            Object subjectId = rd.getDimValByDimType(DimensionType.SUBJECTS, null);
            subjectIds.add(subjectId);
        }
        reportDataQueryObject.setDimIdList(Collections.singletonList(subjectDimension));
        reportDataQueryObject.setDimValList(Collections.singletonList(new ArrayList(subjectIds)));
        List<ReportDataQueryResult> reportDataQueryResults = this.dataQueryService.queryReportData(reportDataQueryObject);
        return ReportHelper.convert(reportDataQueryResults);
    }

    private Set<Long> updateSumRecordsStatus(SumPlanRecord sumPlanRecord, List<SumPlanRecord> downLevelSumPlanRecords, FundPlanSystem system) {
        logger.info("\u66f4\u65b0\u4e0b\u7ea7(\u4e0d\u542b\u672c\u7ea7\u6c47\u603b\u8bb0\u5f55\u72b6\u6001\u4e3a\u5df2\u751f\u6548|\u4e0a\u62a5\u4e2d)");
        this.dataSaveService.update(IDataSaveService.Constants.SUM_RECORD_STATUS_UPDATE, downLevelSumPlanRecords, (t, d) -> {
            d.add(t.getReportStatus().getVal());
            d.add(t.getId());
        });
        logger.info("\u66f4\u65b0\u4e0b\u7ea7(\u4e0d\u542b\u672c\u7ea7\u6c47\u603b\u7f16\u5236\u8868\u72b6\u6001\u4e3a\u5df2\u751f\u6548|\u4e0a\u62a5\u4e2d)");
        this.dataSaveService.update(IDataSaveService.Constants.REPORT_STATUS_UPDATE, downLevelSumPlanRecords, (t, d) -> {
            d.add(t.getReportStatus().getVal());
            d.add(t.getOriginalReportIdList().get(0));
        });
        logger.info("\u66f4\u65b0\u4e0b\u7ea7(\u542b\u672c\u7ea7\u6c47\u603b\u7f16\u5236\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u751f\u6548|\u672a\u751f\u6548)");
        downLevelSumPlanRecords.add(sumPlanRecord);
        this.dataSaveService.update(IDataSaveService.Constants.REPORT_DATA_EFFECTIVE_UPDATE, downLevelSumPlanRecords, (t, d) -> {
            d.add(t.getReportStatus() == ReportStatus.ENABLE ? "1" : "0");
            d.add(t.getOriginalReportIdList().get(0));
        });
        logger.info("\u66f4\u65b0\u672c\u7ea7\u6c47\u603b\u8bb0\u5f55\u72b6\u6001\u4e3a\u5df2\u751f\u6548|\u672a\u751f\u6548");
        this.dataSaveService.updateSingle(IDataSaveService.Constants.SUM_RECORD_STATUS_UPDATE, sumPlanRecord, (t, d) -> {
            d.add(t.getReportStatus().getVal());
            d.add(t.getId());
        });
        logger.info("\u66f4\u65b0\u672c\u7ea7\u6c47\u603b\u7f16\u5236\u8868\u72b6\u6001\u4e3a\u5df2\u751f\u6548|\u672a\u751f\u6548");
        this.dataSaveService.updateSingle(IDataSaveService.Constants.REPORT_BILL_STATUS_UPDATE, sumPlanRecord, (t, d) -> {
            d.add(t.getReportStatus().getVal());
            d.add(t.getSumPlanReportList().get(0).getProcessStatus().getValue());
            d.add(t.getOriginalReportIdList().get(0));
        });
        Set<Long> reportIds = downLevelSumPlanRecords.stream().map(SumPlanRecord::getOriginalReportIdList).flatMap(Collection::stream).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        reportIds.add(sumPlanRecord.getSumPlanReportList().get(0).getId());
        return reportIds;
    }

    private void updateActAmtForPeriodStartEndIfNeed(final SumPlanRecord sumPlanRecord, final Set<Long> reportIds, final FundPlanSystem system) {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onCommitted() {
                try (TXHandle tx = TX.requiresNew();){
                    HashMap<String, Object> param = new HashMap<String, Object>(4);
                    param.put("reportIds", reportIds);
                    param.put("system", system);
                    FpmAsyncCalculateHelper.asyncCalculate(String.valueOf(sumPlanRecord.getId()), "updateBeginEndSubjectRealAmount", param);
                }
            }
        });
    }

    private Set<Long> updateLastStageReportStatus(List<Long> lastStageReportOrgIds, Long reportPeriodId, boolean isAudit, FundPlanSystem system) {
        logger.info("\u6839\u636e\u672b\u7ea7\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\uff0c\u67e5\u8be2\u53ef\u80fd\u5b58\u5728\u7684\u8ba1\u5212\u7f16\u5236\u8868id");
        ReportStatus queryReportStatus = isAudit ? ReportStatus.REPORTING : ReportStatus.ENABLE;
        Map<Long, Set<Long>> existsReportId = this.reportRepository.getExistsReportId(t -> {
            t.setReportOrgIdList(lastStageReportOrgIds);
            t.setReportPeriodId(reportPeriodId);
            t.setReportStatus(queryReportStatus);
            t.setReportPlanType(ReportPlanType.REPORTPLAN);
            t.setProcessStatus(ReportProcessStatus.AUDIT);
        });
        if (CollectionUtils.isEmpty(existsReportId)) {
            logger.info("\u4e0d\u5b58\u5728\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868");
            return Sets.newHashSet();
        }
        Set<Long> reportIds = existsReportId.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(reportIds)) {
            logger.info("\u4e0d\u5b58\u5728\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868\u3002\u3002\u3002");
            return Sets.newHashSet();
        }
        logger.info("\u6240\u6709\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868id\uff1a{}", reportIds);
        ReportStatus reportStatus = isAudit ? ReportStatus.ENABLE : ReportStatus.REPORTING;
        logger.info("\u5f00\u59cb\u66f4\u65b0\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868\u72b6\u6001\u4e3a " + reportStatus.getName());
        this.dataSaveService.update(IDataSaveService.Constants.REPORT_STATUS_UPDATE, new ArrayList(reportIds), (t, d) -> {
            d.add(reportStatus.getVal());
            d.add(t);
        });
        String effectiveFlag = isAudit ? "1" : "0";
        logger.info("\u5f00\u59cb\u66f4\u65b0\u8ba1\u5212\u7f16\u5236\u6570\u636e\u72b6\u6001\u4e3a" + effectiveFlag);
        this.dataSaveService.update(IDataSaveService.Constants.REPORT_DATA_EFFECTIVE_UPDATE, new ArrayList(reportIds), (t, d) -> {
            d.add(effectiveFlag);
            d.add(t);
        });
        this.dataSaveService.update(IDataSaveService.Constants.REPORT_DATA_ORG_PLAN_AMT_UPDATE, new ArrayList(reportIds), (t, d) -> d.add(t));
        this.shrekReportDataService.syncReport(reportIds);
        return reportIds;
    }

    private Map<Long, Set<Long>> getSumReportMapLastStageReportOrgIds(SumPlanParamConfigInfo sumPlanParamConfigInfo, List<SumPlanRecord> downLevelSumPlanRecords, boolean needAllLevel) {
        Set auditedSumReportOrgIds = downLevelSumPlanRecords.stream().map(SumPlanRecord::getReportOrg).collect(Collectors.toSet());
        ArrayList<SumPlanParamConfigInfo> allChildren = new ArrayList<SumPlanParamConfigInfo>(sumPlanParamConfigInfo.getAllChildren());
        allChildren.add(sumPlanParamConfigInfo);
        Collections.sort(allChildren, Comparator.comparing(SumPlanParamConfigInfo::getLevel));
        ArrayList<SumPlanParamConfigInfo> auditSumReportConfigInfoList = new ArrayList<SumPlanParamConfigInfo>(auditedSumReportOrgIds.size());
        HashSet<Long> unAuditSumReportOrgIds = new HashSet<Long>(8);
        for (SumPlanParamConfigInfo configInfo : allChildren) {
            if (!configInfo.isSumAuditNode()) continue;
            Long orgMemberId = configInfo.getOrgMemberId();
            if (!auditedSumReportOrgIds.contains(orgMemberId)) {
                unAuditSumReportOrgIds.add(orgMemberId);
                continue;
            }
            auditSumReportConfigInfoList.add(configInfo);
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(auditSumReportConfigInfoList.size());
        for (SumPlanParamConfigInfo configInfo : auditSumReportConfigInfoList) {
            List<SumPlanParamConfigInfo> allChildIfAudit = this.getAllChildIfAudit(configInfo, unAuditSumReportOrgIds);
            map.put(configInfo.getOrgMemberId(), allChildIfAudit.stream().filter(t -> !t.isSumAuditNode()).map(SumPlanParamConfigInfo::getOrgMemberId).collect(Collectors.toSet()));
            if (needAllLevel) continue;
            break;
        }
        return map;
    }

    private void doReverseWriteDownReport(List<SumPlanRecord> sumPlanRecordList, SumPlanReport sumPlanReport, FundPlanSystem system) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("doReverseWriteDownReport");){
            List<Long> downLevelSumRecordIds = sumPlanRecordList.stream().map(SumPlanRecord::getId).collect(Collectors.toList());
            span.addTag("queryApprovalReportDataList");
            List<ReportData> reportDataList = this.queryApprovalReportDataList(downLevelSumRecordIds, system);
            if (EmptyUtil.isEmpty(reportDataList)) {
                logger.info("\u672b\u7ea7\u53c2\u4e0e\u6838\u5b9a\u7684\u7f16\u5236\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            List<Long> sumReportIds = sumPlanRecordList.stream().map(SumPlanRecord::getOriginalReportIdList).flatMap(Collection::stream).collect(Collectors.toList());
            List<Long> sumReportOrgList = sumPlanRecordList.stream().map(SumPlanRecord::getReportOrg).distinct().collect(Collectors.toList());
            span.addTag("queryAllSumReportDataByApprovalReportDataDimensionInfo");
            List<ReportData> sumReportDataList = this.queryAllSumReportDataByApprovalReportDataDimensionInfo(sumReportIds, reportDataList, system.getMainDimensionByDimType(DimensionType.SUBJECTS));
            if (EmptyUtil.isEmpty(sumReportDataList)) {
                logger.info("\u53c2\u4e0e\u6838\u5b9a\u4e86\u7684\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u6570\u636e\u5bf9\u5e94\u7684\u79d1\u76ee\u7684\u6240\u6709\u6c47\u603b\u7f16\u5236\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            span.addTag("queryRemainSourceReportData");
            this.queryRemainSourceReportData(sumReportDataList, reportDataList);
            List warpBeanList = this.getWarpBeanList(sumReportDataList, null);
            SumPlanUpdateInfo sumPlanUpdateInfo = new SumPlanUpdateInfo();
            logger.info("\u5bf9\u6240\u6709\u53c2\u4e0e\u6838\u5b9a\u7684\u8ba1\u5212\u7f16\u5236\u5bf9\u5e94\u7684\u79d1\u76ee\u7684\u6240\u6709\u6c47\u603b\u7f16\u5236\u6570\u636e\u6784\u5efa\u5012\u6392\u7d22\u5f15");
            span.addTag("QueryIndexInfoMapGenerator.build");
            QueryIndexInfo<Long, ReportData> queryIndexInfo = QueryIndexInfoMapGenerator.build(warpBeanList, system, rd -> !rd.isAuxiliaryInfo());
            Consumer<ReportData> reverseWriteSumReportDataConsumer = this.reverseWriteSumReportDataConsumer(sumPlanUpdateInfo, sumReportOrgList, queryIndexInfo);
            span.addTag("reverseWriteSumReportData");
            reportDataList.stream().forEach(reverseWriteSumReportDataConsumer::accept);
            logger.info("\u51c6\u5907\u6279\u91cf\u66f4\u65b0");
            span.addTag("batchSaveOrUpdate");
            this.batchSaveOrUpdate(sumPlanUpdateInfo);
        }
    }

    private void queryRemainSourceReportData(List<ReportData> sumReportDataList, List<ReportData> reportDataList) {
        if (EmptyUtil.isEmpty(sumReportDataList)) {
            return;
        }
        Set reportIdSet = reportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
        logger.info("\u51c6\u5907\u67e5\u8be2\u5269\u4f59\u7684\u5173\u8054\u6570\u636e\u3002\u3002\u3002\u3002");
        List<Long> remainReportDataIds = sumReportDataList.stream().map(ReportData::getSourceIdList).flatMap(Collection::stream).filter(id -> !reportIdSet.contains(id)).distinct().collect(Collectors.toList());
        if (EmptyUtil.isEmpty(remainReportDataIds)) {
            logger.info("\u6240\u6709\u5173\u8054\u6570\u636e\u90fd\u5df2\u67e5\u51fa\u3002\u3002\u3002\u3002");
            return;
        }
        ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
        reportDataQueryObject.setIdList(remainReportDataIds);
        logger.info("\u67e5\u8be2\u5173\u8054\u6570\u636e\u524d\u6570\u636e\u96c6\u5927\u5c0f\uff1a{},\u5f85\u67e5\u8be2\u7684\u5173\u8054\u6570\u636eid:{}", (Object)reportDataList.size(), remainReportDataIds);
        List<ReportDataQueryResult> reportDataQueryResults = this.dataQueryService.queryReportData(reportDataQueryObject);
        List<ReportData> dataList = ReportHelper.convert(reportDataQueryResults);
        reportDataList.addAll(dataList);
        logger.info("\u67e5\u8be2\u5173\u8054\u6570\u636e\u540e\u6570\u636e\u96c6\u5927\u5c0f\uff1a{}", (Object)reportDataList.size());
    }

    private void reset(ReportData sumReportData) {
        sumReportData.setPlanAmt(BigDecimal.ZERO);
        sumReportData.setOriginalPlanAmt(BigDecimal.ZERO);
    }

    private List<WarpBean<Long, ReportData>> getWarpBeanList(List<ReportData> sumReportDataList, Consumer<ReportData> consumer) {
        ArrayList<WarpBean<Long, ReportData>> warpBeanList = new ArrayList<WarpBean<Long, ReportData>>(sumReportDataList.size());
        for (ReportData reportData : sumReportDataList) {
            if (Objects.nonNull(consumer)) {
                consumer.accept(reportData);
            }
            warpBeanList.add(new WarpBean<Long, ReportData>(reportData.getId(), DimensionInfoHelper.getDimensionInfoBean(reportData), reportData));
        }
        return warpBeanList;
    }

    private Consumer<ReportData> reverseWriteSumReportDataConsumer(SumPlanUpdateInfo sumPlanUpdateInfo, List<Long> sumReportOrgList, QueryIndexInfo<Long, ReportData> queryIndexInfo) {
        ReportDataIndexQueryMap<Long> indexQueryMap = queryIndexInfo.getIndexQueryMap();
        Map<Long, ReportData> dataMap = queryIndexInfo.getDataMap();
        HashSet summedReportDataIdSet = new HashSet(dataMap.size());
        return reportData -> {
            reportData.setPlanAmt(reportData.getOriginalPlanAmt());
            Consumer<ReportData> consumer = this.reverseLastPlanAmtToSumPlanAmtAndOriginalAmt((ReportData)reportData, sumPlanUpdateInfo, summedReportDataIdSet);
            for (Long sumOrgId : sumReportOrgList) {
                DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.replaceSumOrgFromDownDimensionInfo(reportData, sumOrgId);
                List list = indexQueryMap.findList(dimensionInfoBean);
                if (EmptyUtil.isEmpty(list)) continue;
                list.stream().map(dataMap::get).filter(Objects::nonNull).filter(rd -> rd.getSourceIdList().contains(reportData.getId())).forEach(consumer::accept);
            }
        };
    }

    private Consumer<ReportData> reverseLastPlanAmtToSumPlanAmtAndOriginalAmt(ReportData lastStageReportData, SumPlanUpdateInfo sumPlanUpdateInfo, Set<Long> summedReportDataIdSet) {
        return sumReportData -> {
            if (summedReportDataIdSet.add(sumReportData.getId())) {
                this.reset((ReportData)sumReportData);
            }
            sumReportData.addOriginalPlanAmt(AmountCurrencyRateHelper.convertAmt((BigDecimal)lastStageReportData.getOriginalPlanAmt(), (AmountUnitEnum)AmountUnit.convert(lastStageReportData.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(sumReportData.getAmountUnit())));
            sumReportData.setPlanAmt(sumReportData.getOriginalPlanAmt());
            sumPlanUpdateInfo.addUpdateReportData((ReportData)sumReportData);
        };
    }

    private List<ReportData> queryApprovalReportDataList(List<Long> downLevelSumRecordIds, FundPlanSystem system) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("queryApprovalReportDataList");){
            span.addTag("loadApprovedAmtBySumIds");
            logger.info("\u5f00\u59cb\u67e5\u8be2\u6240\u6709\u6c47\u603b\u7f16\u5236\u8bb0\u5f55\uff1a{}\u7684\u6838\u5b9a\u8bb0\u5f55", downLevelSumRecordIds);
            List<ApprovedAmountAmtDetailInfo> detailInfoList = this.repository.loadApprovedAmtBySumIds(downLevelSumRecordIds, null);
            if (EmptyUtil.isEmpty(detailInfoList)) {
                logger.info("\u6240\u6709\u6c47\u603b\u7f16\u5236\u8bb0\u5f55\u90fd\u6ca1\u6709\u505a\u91d1\u989d\u6838\u5b9a");
                List<ReportData> list = Collections.emptyList();
                return list;
            }
            List<Long> reportDataIds = detailInfoList.stream().map(ApprovedAmountAmtDetailInfo::getReportDataId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (EmptyUtil.isEmpty(reportDataIds)) {
                logger.info("\u53c2\u4e0e\u91d1\u989d\u6838\u5b9a\u7684\u672b\u7ea7\u7f16\u5236\u8bb0\u5f55id\u4e3a\u7a7a\u3002\u3002\u3002");
                List<ReportData> list = Collections.emptyList();
                return list;
            }
            span.addTag("queryReportData");
            logger.info("\u5f00\u59cb\u67e5\u8be2\u6240\u6709\u672b\u7ea7\u53c2\u4e0e\u6838\u5b9a\u7684\u8ba1\u5212\u7f16\u5236\u6570\u636e:{}", reportDataIds);
            ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
            reportDataQueryObject.setIdList(reportDataIds);
            List<ReportDataQueryResult> reportDataQueryResults = this.dataQueryService.queryReportData(reportDataQueryObject);
            List<ReportData> reportDataList = ReportHelper.convert(reportDataQueryResults);
            if (EmptyUtil.isEmpty(reportDataList)) {
                logger.info("\u6240\u6709\u672b\u7ea7\u53c2\u4e0e\u6838\u5b9a\u7684\u8ba1\u5212\u7f16\u5236\u6570\u636e:{}\u4e0d\u5b58\u5728\u6216\u88ab\u5df2\u5220\u9664\u3002\u3002", reportDataIds);
                List<ReportData> list = Collections.emptyList();
                return list;
            }
            span.addTag("queryRelationReportData");
            logger.info("\u67e5\u8be2\u5173\u8054\u6570\u636e\u524d\uff0creportDataList\u5927\u5c0f:{}", (Object)reportDataList.size());
            this.queryRelationReportData(reportDataList, system);
            logger.info("\u67e5\u8be2\u5173\u8054\u6570\u636e\u540e\uff0creportDataList\u5927\u5c0f:{}", (Object)reportDataList.size());
            List<ReportData> list = reportDataList;
            return list;
        }
    }

    private void queryRelationReportData(List<ReportData> reportDataList, FundPlanSystem system) {
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        IRelateReportDataManager relateReportDataManager = RelateReportDataManagerFactory.getRelateReportDataManagerInstance(reportDataList, system);
        List<ReportData> dataListBySourceCanDiff = relateReportDataManager.getRelateReportDataListBySourceCanDiff(reportDataList);
        reportDataList.addAll(dataListBySourceCanDiff);
    }

    private Consumer<DimensionInfoBean> getDimensionInfoBeanToDimensionCombinationConsumer(Set<EvalDimensionCombination> combinations, FundPlanSystem system) {
        List<Dimension> mainDimList = system.getMainDimList();
        Map dimensionMap = mainDimList.stream().collect(Collectors.toMap(Dimension::getId, Function.identity()));
        return dimensionInfoBean -> {
            EvalDimensionCombination combination = new EvalDimensionCombination(system.getId());
            List dimensionIdList = dimensionInfoBean.getDimensionIdList();
            List memberIdList = dimensionInfoBean.getMemberIdList();
            if (EmptyUtil.isEmpty((Collection)dimensionIdList)) {
                return;
            }
            for (int i = 0; i < dimensionIdList.size(); ++i) {
                Dimension dimension;
                Long dimensionId = (Long)dimensionIdList.get(i);
                if (!dimensionMap.containsKey(dimensionId) || Objects.isNull(dimension = (Dimension)dimensionMap.get(dimensionId))) continue;
                combination.addEvalDimensionVal(new EvalDimensionVal(dimensionId, dimension.getDimType(), memberIdList.get(i)));
            }
            combinations.add(combination);
        };
    }

    private FpmOperateResult<Void> sumOrSubDownReportDataToUpper(SumPlanRecord sumPlanRecord, SumPlanReport upperSumPlanReport, SumPlanParamConfigInfo sumPlanParamConfigInfo, BiFunction<List<Report>, SumPlanReport, FpmOperateResult<SumPlanUpdateInfo>> callBack) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("sumOrSubDownReportDataToUpper");){
            String number = sumPlanRecord.getNumber();
            Long reportOrg = sumPlanRecord.getReportOrg();
            span.addTag("getAllDownLevelAuditedSumPlanRecords");
            logger.info("\u6c47\u603b\u672b\u7ea7\u6570\u636e\u5230\u4e0a\u7ea7\uff0c\u5f00\u59cb\u67e5\u8be2\u5f53\u524d\u6c47\u603b\u7f16\u5236\u8bb0\u5f55\uff1a{}\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\uff1a{}\u4e0b\u7ea7\u6240\u6709\u5df2\u5ba1\u6838\u7684\u6c47\u603b\u8bb0\u5f55", (Object)number, (Object)reportOrg);
            List<SumPlanRecord> downLevelAuditedSumPlanRecords = this.getAllDownLevelAuditedSumPlanRecords(sumPlanRecord, sumPlanParamConfigInfo);
            downLevelAuditedSumPlanRecords.add(sumPlanRecord);
            span.addTag("getSumReportMapLastStageReportOrgIds");
            Map<Long, Set<Long>> sumOrgIdMapLastStageReportOrgIds = this.getSumReportMapLastStageReportOrgIds(sumPlanParamConfigInfo, downLevelAuditedSumPlanRecords, false);
            List subPlanOrgList = sumOrgIdMapLastStageReportOrgIds.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
            logger.info("\u5f00\u59cb\u67e5\u8be2\u5f53\u524d\u6c47\u603b\u8bb0\u5f55\uff1a{}\u5f53\u524d\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\uff1a{}\u6240\u6709\u975e\u76f4\u63a5\u672b\u7ea7\u7684\u672b\u7ea7\u975e\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u53ef\u80fd\u5b58\u5728\u7684\u8ba1\u5212\u7f16\u5236\u8868id\uff0c\u67e5\u8be2\u6761\u4ef6\uff1a\u672b\u7ea7\u7f16\u62a5\u4e3b\u4f53\uff1a{}\uff0c\u7f16\u62a5\u671f\u95f4\uff1a{}\uff0c\u4e0a\u62a5\u4e2d\u7684\u5df2\u5ba1\u6838\u7684\u8ba1\u5212\u7f16\u5236\u8868", new Object[]{number, reportOrg, subPlanOrgList, sumPlanRecord.getReportPeriodId()});
            Map<Long, Set<Long>> existsReportIdMap = this.reportRepository.getExistsReportId(t -> {
                t.setReportOrgIdList(subPlanOrgList);
                t.setReportPeriodId(sumPlanRecord.getReportPeriodId());
                t.setReportPlanType(ReportPlanType.REPORTPLAN);
                t.setProcessStatus(ReportProcessStatus.AUDIT);
                t.setReportStatus(ReportStatus.REPORTING);
                t.setMainTable(Boolean.TRUE);
            });
            if (CollectionUtils.isEmpty(existsReportIdMap)) {
                logger.warn("\u5f53\u524d\u6c47\u603b\u8bb0\u5f55\uff1a{}\u5f53\u524d\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\uff1a{}\u4e0d\u5b58\u5728\u975e\u76f4\u63a5\u672b\u7ea7\u7684\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868", (Object)number, (Object)reportOrg);
            }
            span.addTag("one by one sum to upper");
            logger.info("\u5f53\u524d\u6c47\u603b\u8bb0\u5f55\uff1a{}\u5f53\u524d\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\uff1a{},\u5f00\u59cb\u6c47\u603b\u975e\u76f4\u63a5\u672b\u7ea7\u7684\u4e00\u5957\u4e00\u5957\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868", (Object)number, (Object)reportOrg);
            for (Map.Entry<Long, Set<Long>> reportIdEntry : existsReportIdMap.entrySet()) {
                Long downLevelSumOrgId = reportIdEntry.getKey();
                Set<Long> reportIdSet = reportIdEntry.getValue();
                if (EmptyUtil.isEmpty(reportIdSet)) {
                    logger.info("\u4e0b\u7ea7\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\uff1a{}\uff0c\u4e0d\u5b58\u5728\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868", (Object)downLevelSumOrgId);
                }
                span.addTag("one by one sum to upper, loadReport");
                logger.info("\u5f00\u59cb\u67e5\u8be2\u975e\u76f4\u63a5\u672b\u7ea7\u7684\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868:{}", reportIdSet);
                List<Report> subPlanReportList = this.reportRepository.loadReportWithAllDimension(reportIdSet);
                if (EmptyUtil.isEmpty(subPlanReportList)) {
                    logger.info("\u975e\u76f4\u63a5\u672b\u7ea7\u7684\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u8868:{}\u4e0d\u5b58\u5728", reportIdSet);
                    continue;
                }
                span.addTag("one by one sum to upper, sumPlanReportUpper");
                logger.info("\u51c6\u5907\u6c47\u603b\u975e\u76f4\u63a5\u672b\u7ea7\u7684\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u6570\u636e\u5230\u5f53\u524d\u6c47\u603b\u8bb0\u5f55\uff1a{}\u7684\u6c47\u603b\u7f16\u5236\u8868\uff1a{}", (Object)number, (Object)upperSumPlanReport.getNumber());
                FpmOperateResult<SumPlanUpdateInfo> operateResult = callBack.apply(subPlanReportList, upperSumPlanReport);
                if (!operateResult.isSuccess()) {
                    logger.info("\u6c47\u603b\u975e\u76f4\u63a5\u672b\u7ea7\u7684\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u6570\u636e\u5230\u5f53\u524d\u6c47\u603b\u8bb0\u5f55\uff1a{}\u7684\u6c47\u603b\u7f16\u5236\u8868\uff1a{}\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{number, upperSumPlanReport.getNumber(), operateResult.getMessageList()});
                    FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.error(operateResult.getMessageList());
                    return fpmOperateResult;
                }
                SumPlanUpdateInfo sumPlanUpdateInfo = operateResult.getData();
                logger.info("\u6c47\u603b\u5f53\u524d\u5957\u8868\uff1a{}\u5230\u6c47\u603b\u7f16\u5236\u8868\uff1a{}\u6210\u529f\uff0c\u51c6\u5907\u66f4\u65b0\u6570\u636e\uff1a{}", reportIdSet, (Object)upperSumPlanReport.getNumber());
                this.batchSaveOrUpdate(sumPlanUpdateInfo);
            }
            span.addTag("one by one sum to upper, batchSaveOrUpdate");
            logger.info("\u51c6\u5907\u66f4\u65b0\u6c47\u603b\u7f16\u5236\u8bb0\u5f55\u548c\u6c47\u603b\u7f16\u5236\u8868\u3002\u3002\u3002");
            SumPlanUpdateInfo sumPlanUpdateInfo = new SumPlanUpdateInfo(sumPlanRecord);
            sumPlanUpdateInfo.setEnd(true);
            this.batchSaveOrUpdate(sumPlanUpdateInfo);
            FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.success();
            return fpmOperateResult;
        }
    }

    private void batchSaveOrUpdate(SumPlanUpdateInfo sumPlanUpdateInfo) {
        if (Objects.isNull(sumPlanUpdateInfo)) {
            return;
        }
        logger.info("\u5f00\u59cb\u6279\u91cf\u4fdd\u5b58\u66f4\u65b0\u3002\u3002\u3002\u3002");
        SumPlanReport sumPlanReport = sumPlanUpdateInfo.getSumPlanReport();
        if (Objects.isNull(sumPlanReport)) {
            logger.info("\u4f20\u5165\u7684\u6c47\u603b\u7f16\u5236\u8868\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u4fdd\u5b58\u6570\u636e\uff0c\u53ea\u80fd\u66f4\u65b0\u7f16\u5236\u6570\u636e");
        }
        List<ReportData> updateReportDataList = sumPlanUpdateInfo.getUpdateReportDataList();
        logger.info("\u5f00\u59cb\u66f4\u65b0\u9700\u8981\u66f4\u65b0\u7684\u7f16\u5236\u6570\u636e\uff1a{}\u6761", (Object)updateReportDataList.size());
        this.dataSaveService.update(IDataSaveService.Constants.SUM_REPORT_REPORT_DATA_UPDATE, updateReportDataList, (t, d) -> {
            d.add(t.getPlanAmt());
            d.add(t.getReportPlanAmt());
            d.add(t.getOriginalPlanAmt());
            d.add(t.getPlanReferenceAmt());
            d.add(t.getId());
        });
        if (Objects.nonNull(sumPlanReport)) {
            List<SumPlanReport.SunReportSumRecord> sunReportSumRecordList = sumPlanUpdateInfo.getSaveReportSumRecordList();
            logger.info("\u5f00\u59cb\u4fdd\u5b58\u6c47\u603b\u8868\u7684\u6c47\u603b\u6c47\u603b\u8bb0\u5f55\uff1a{}", sunReportSumRecordList);
            this.dataSaveService.saveEntryDataThrow(sunReportSumRecordList, sumPlanReport.getId());
            List<SumPlanReport.SunReportSumRecord> updateReportSumRecordList = sumPlanUpdateInfo.getUpdateReportSumRecordList();
            logger.info("\u5f00\u59cb\u66f4\u65b0\u6c47\u603b\u8868\u7684\u6c47\u603b\u6c47\u603b\u8bb0\u5f55\uff1a{}", updateReportSumRecordList);
            this.dataSaveService.update(IDataSaveService.Constants.SUM_REPORT_SUM_RECORD_STATUS_UPDATE, updateReportSumRecordList, (t, d) -> {
                d.add(t.getSumStatus().getNumber());
                d.add(sumPlanReport.getId());
                d.add(t.getSunReportId());
            });
            this.dataSaveService.saveEntryDataThrow(new ArrayList<SourceIdEntryData>(sumPlanUpdateInfo.getSaveSourceIdEntryDataSet()), sumPlanReport.getId());
            this.saveReportData(sumPlanUpdateInfo, sumPlanReport);
        }
        if (sumPlanUpdateInfo.isEnd()) {
            logger.info("\u6700\u540e\u66f4\u65b0\u6c47\u603b\u7f16\u5236\u8868\u72b6\u6001\u3002\u3002\u3002");
            this.dataSaveService.updateSingle(IDataSaveService.Constants.REPORT_BILL_STATUS_UPDATE, sumPlanReport, (t, d) -> {
                d.add(t.getReportStatus().getVal());
                d.add(t.getProcessStatus().getValue());
                d.add(t.getId());
            });
            logger.info("\u6700\u540e\u66f4\u65b0\u6c47\u603b\u8bb0\u5f55\u72b6\u6001\u3002\u3002\u3002");
            SumPlanRecord sumPlanRecord = sumPlanUpdateInfo.getSumPlanRecord();
            this.dataSaveService.updateSingle(IDataSaveService.Constants.SUM_RECORD_STATUS_UPDATE, sumPlanRecord, (t, d) -> {
                d.add(t.getReportStatus().getVal());
                d.add(t.getId());
            });
        }
    }

    private void saveReportData(SumPlanUpdateInfo sumPlanUpdateInfo, SumPlanReport sumPlanReport) {
        List<ReportData> saveReportDataList = sumPlanUpdateInfo.getSaveReportDataList();
        logger.info("\u5f00\u59cb\u4fdd\u5b58\u7f16\u5236\u6570\u636e:{}\u6761", (Object)saveReportDataList.size());
        ArrayList<MainEntryReportData> mainEntryReportDataList = new ArrayList<MainEntryReportData>(saveReportDataList.size());
        ArrayList<DetailEntryReportData> detailEntryReportDataList = new ArrayList<DetailEntryReportData>(saveReportDataList.size());
        for (ReportData reportData : saveReportDataList) {
            MainEntryReportData mainEntryReportData = new MainEntryReportData(reportData);
            mainEntryReportData.setId(reportData.getId());
            mainEntryReportData.setSystemId(sumPlanReport.getSystemId());
            mainEntryReportDataList.add(mainEntryReportData);
            DetailEntryReportData detailEntryReportData = new DetailEntryReportData(reportData);
            detailEntryReportData.setId(reportData.getId());
            detailEntryReportDataList.add(detailEntryReportData);
        }
        this.dataSaveService.saveEntryDataThrow(mainEntryReportDataList, sumPlanReport.getId());
        this.dataSaveService.saveEntryDataThrow(detailEntryReportDataList, sumPlanReport.getId());
    }

    private List<Long> getUpperSumReport(OrgMember currentSumOrg, Long reportPeriodId, SumPlanParamConfig sumPlanParamConfig) {
        List<DimMember> allParentMember = currentSumOrg.getAllParentMember();
        if (EmptyUtil.isEmpty(allParentMember)) {
            return Collections.emptyList();
        }
        Set parentMemIdSet = allParentMember.stream().map(DimMember::getId).collect(Collectors.toSet());
        List<SumPlanParamConfigInfo> configInfoList = sumPlanParamConfig.getConfigInfoList();
        List sumOrgList = configInfoList.stream().filter(SumPlanParamConfigInfo::isSumAuditNode).sorted(Comparator.comparing(SumPlanParamConfigInfo::getLevel).reversed()).map(SumPlanParamConfigInfo::getOrgMemberId).filter(parentMemIdSet::contains).collect(Collectors.toList());
        if (EmptyUtil.isEmpty(sumOrgList)) {
            return Collections.emptyList();
        }
        Map<Long, Set<Long>> existsReportId = this.reportRepository.getExistsReportId(t -> {
            t.setReportPlanType(ReportPlanType.SUMPLAN);
            t.setReportStatus(ReportStatus.DISABLE);
            t.setReportPeriodId(reportPeriodId);
            t.setReportOrgIdList(sumOrgList);
            t.setBodySysId(sumPlanParamConfig.getSystemId());
        });
        if (MapUtils.isEmpty(existsReportId)) {
            return Collections.emptyList();
        }
        for (Long sumReportOrgId : sumOrgList) {
            Set<Long> reportIds = existsReportId.get(sumReportOrgId);
            if (EmptyUtil.isEmpty(reportIds)) continue;
            return new ArrayList<Long>(reportIds);
        }
        return Collections.emptyList();
    }

    @Override
    public FpmOperateResult<Void> unSubmit(Long id) {
        return null;
    }

    @Override
    public FpmOperateResult<Void> unAudit(Long id, FundPlanSystem system) {
        return CommonUtils.trace(SumPlanBizServiceImpl.class.getSimpleName(), span -> {
            logger.info(String.format("\u6c47\u603b\u7f16\u62a5\u53cd\u5ba1\u6838\uff0c%s", id));
            span.addTag("sumPlan unAudit step1: loadSumPlanRecord");
            SumPlanRecord sumPlanRecord = this.repository.loadSumPlanRecord(id);
            if (EmptyUtil.isEmpty((Object)sumPlanRecord)) {
                return FpmOperateResult.success();
            }
            this.getSumPlanReports(null, sumPlanRecord, null);
            List<SumPlanReport> currReportList = sumPlanRecord.getSumPlanReportList();
            if (org.apache.commons.collections4.CollectionUtils.isEmpty(currReportList)) {
                return FpmOperateResult.success();
            }
            span.addTag("sumPlan unAudit step2: loadSumConfigBySystem");
            SumPlanParamConfig sumPlanParamConfig = this.repository.loadSumConfigBySystem(sumPlanRecord.getSystemId(), sumPlanRecord.getReportType());
            SumPlanReport sumReport = currReportList.get(0);
            OrgMember reportOrg = sumReport.getCompanyMemberList().get(0);
            Long reportPeriodId = sumPlanRecord.getReportPeriodId();
            Optional<SumPlanParamConfigInfo> first = sumPlanParamConfig.getConfigInfoList().stream().filter(SumPlanParamConfigInfo::isSumAuditNode).filter(info -> Objects.equals(info.getOrgMemberId(), reportOrg.getId())).findFirst();
            if (!first.isPresent()) {
                // empty if block
            }
            SumPlanParamConfigInfo configInfo = first.get();
            span.addTag("sumPlan audit step3: getUpperSumReport");
            List<Long> reportList = this.getUpperSumReport(reportOrg, reportPeriodId, sumPlanParamConfig);
            sumPlanRecord.setReportStatus(ReportStatus.DISABLE);
            sumPlanRecord.setStatus(BillStatus.STAGE);
            sumReport.setReportStatus(ReportStatus.DISABLE);
            sumReport.setProcessStatus(ReportProcessStatus.SAVE);
            sumReport.setRecordBillStatus(BillStatus.STAGE);
            if (EmptyUtil.isEmpty(reportList)) {
                span.addTag("sumPlan audit step4.1: reverseAllChildReportStatus");
                return CommonUtils.processInTransaction(() -> this.reverseAllChildReportStatus(sumPlanRecord, configInfo, system));
            }
            Long upperSumPlanReportId = reportList.get(0);
            String dLockName = String.format("%s.%s.%s", CacheKeyUtil.getAcctId(), "sumReportAuditOrUnAudit", upperSumPlanReportId);
            BiFunction<List, SumPlanReport, FpmOperateResult> callBack = (subReports, upperSumReport) -> this.service.cancelSumPlanReportUpper((List<Report>)subReports, (SumPlanReport)upperSumReport, system);
            span.addTag("sumPlan audit step4.2: sumOrSubDownReportDataToUpper");
            Supplier<SumPlanReport> supplier = () -> (SumPlanReport)this.reportRepository.loadReport(upperSumPlanReportId);
            return CommonUtils.processInDLock(dLockName, () -> this.sumOrSubDownReportDataToUpper(sumPlanRecord, (SumPlanReport)supplier.get(), configInfo, callBack));
        });
    }

    private FpmOperateResult<Void> reverseAllChildReportStatus(SumPlanRecord sumPlanRecord, SumPlanParamConfigInfo sumPlanParamConfigInfo, FundPlanSystem system) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("reverseAllChildReportStatus");){
            span.addTag("getAllDownLevelAuditedSumPlanRecords");
            List<SumPlanRecord> downLevelSumPlanRecords = this.getAllDownLevelAuditedSumPlanRecords(sumPlanRecord, sumPlanParamConfigInfo);
            ArrayList<SumPlanRecord> downLevelSumPlanRecordsContainsCurrent = new ArrayList<SumPlanRecord>(downLevelSumPlanRecords);
            downLevelSumPlanRecordsContainsCurrent.add(sumPlanRecord);
            span.addTag("getSumReportMapLastStageReportOrgIds");
            logger.info("\u83b7\u53d6\u6240\u6709\u4e0b\u7ea7(\u542b\u672c\u7ea7)\u5bf9\u5e94\u7684\u6240\u6709\u672b\u7ea7\u7f16\u62a5\u4e3b\u4f53");
            Map<Long, Set<Long>> sumOrgIdMapLastStageReportOrgIds = this.getSumReportMapLastStageReportOrgIds(sumPlanParamConfigInfo, downLevelSumPlanRecordsContainsCurrent, false);
            logger.info("\u6240\u6709\u4e0b\u7ea7(\u542b\u672c\u7ea7)\u5bf9\u5e94\u7684\u6240\u6709\u672b\u7ea7\u7f16\u62a5\u4e3b\u4f53\uff1a{}", sumOrgIdMapLastStageReportOrgIds);
            List<Long> lastStageReportOrgIds = sumOrgIdMapLastStageReportOrgIds.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
            span.addTag("updateLastStageReportStatus");
            logger.info("\u51c6\u5907\u66f4\u65b0\u672b\u7ea7\u8ba1\u5212\u7f16\u5236\u6570\u636e\u72b6\u6001\u548c\u8ba1\u5212\u7f16\u5236\u8868\u72b6\u6001\u4e3a\u4e0a\u62a5\u4e2d");
            this.updateLastStageReportStatus(lastStageReportOrgIds, sumPlanRecord.getReportPeriodId(), false, system);
            logger.info("\u5f00\u59cb\u66f4\u65b0\u672b\u7ea7(\u4e0d\u542b\u672c\u7ea7)\u6c47\u603b\u8bb0\u5f55\u72b6\u6001\u548c\u6c47\u603b\u8868\u53ca\u6c47\u603b\u7f16\u5236\u6570\u636e\u72b6\u6001\u4e3a\u4e0a\u62a5\u4e2d");
            downLevelSumPlanRecords.stream().forEach(t -> t.setReportStatus(ReportStatus.REPORTING));
            span.addTag("updateSumRecordsStatus");
            logger.info("\u5f00\u59cb\u66f4\u65b0\u672b\u7ea7\u6c47\u603b\u8bb0\u5f55\u72b6\u6001\u548c\u6c47\u603b\u8868\u53ca\u6c47\u603b\u7f16\u5236\u6570\u636e\u72b6\u6001\u4e3a\u4e0a\u62a5\u4e2d,\u672c\u7ea7\u6c47\u603b\u8bb0\u5f55\u4e3a\u672a\u751f\u6548");
            this.updateSumRecordsStatus(sumPlanRecord, downLevelSumPlanRecords, system);
            FpmOperateResult<Void> fpmOperateResult = FpmOperateResult.success();
            return fpmOperateResult;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FpmOperateResult<SumPlanRecord> innerCancelAmt(Long sumId) {
        void var11_18;
        logger.info("\u5f00\u59cb\u6267\u884c\u5185\u90e8\u62b5\u6d88-sumId[{}]", (Object)sumId);
        DataSourceHandler handler = new DataSourceHandler(sumId, this.repository, this.dimensionRepository, this.reportRepository);
        InternalOffsetMessage message = handler.prepare();
        if (EmptyUtil.isNoEmpty((Object)message)) {
            return message.getOpResult();
        }
        List<InternalOffsetParam> internalOffsetParams = handler.getInternalOffsetParam();
        HashMap errMsgMap = new HashMap(16);
        for (InternalOffsetParam internalOffsetParam : internalOffsetParams) {
            Long ruleId = internalOffsetParam.getInnerCancelRule().getId();
            List<String> errMsgs = errMsgMap.containsKey(ruleId) ? (List)errMsgMap.get(ruleId) : new ArrayList(10);
            for (InternalOffsetGroupData internalOffsetGroupData : internalOffsetParam.getGroupDatas()) {
                boolean success = internalOffsetGroupData.isSuccess();
                if (success) continue;
                errMsgs.add(internalOffsetGroupData.getErrMsg());
            }
            if (!EmptyUtil.isNoEmpty(errMsgs)) continue;
            errMsgMap.put(ruleId, errMsgs);
        }
        InternalOffsetContext context = new InternalOffsetContext();
        List<InnerCancelRecord> records = context.calling(internalOffsetParams);
        SumPlanRecord sumPlanRecord = handler.getSumPlanRecord();
        String saveErrMsg = null;
        if (EmptyUtil.isNoEmpty(records)) {
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    this.repository.deleteInnerCancleRecordBySumPlanId(sumId);
                    sumPlanRecord.setInnerCancel(true);
                    this.repository.saveSumPlanRecord(sumPlanRecord);
                    this.repository.batchSaveInnerCancleRecord(records);
                    tx.commit();
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("\u62b5\u6d88\u8bb0\u5f55\u6570\u636e\u5165\u5e93\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a\n", (Throwable)e);
                    saveErrMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                }
            }
            catch (Throwable e) {
                Throwable throwable2 = e;
                throw e;
            }
        }
        FpmOperateResult<SumPlanRecord> operateResult = FpmOperateResult.success();
        operateResult.setMessageList(new ArrayList<String>(1));
        boolean bl = true;
        if (EmptyUtil.isNoEmpty(saveErrMsg)) {
            boolean bl2 = false;
            operateResult.getMessageList().add(saveErrMsg);
        } else if (errMsgMap != null && !errMsgMap.isEmpty()) {
            Map<Long, InnerCancelRule> offsetRuleRelationMap = handler.getOffsetRuleRelationMap();
            boolean bl3 = false;
            for (Map.Entry entry : errMsgMap.entrySet()) {
                String otherErrMsg = "";
                if (EmptyUtil.isNoEmpty(entry.getValue())) {
                    otherErrMsg = "\uff0c" + String.format(ResManager.loadKDString((String)"\u5176\u4e2d\uff1a%1$s", (String)"SumPlanBizServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), ((List)entry.getValue()).stream().collect(Collectors.joining("\r\n")));
                }
                InnerCancelRule innerCancelRule = offsetRuleRelationMap.get(entry.getKey());
                String errMsg = null;
                errMsg = records.size() > 0 ? String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5355\u636e\u201c%2$s\u201d\u62b5\u6d88\u89c4\u5219\u672c\u6b21\u6267\u884c\u6210\u529f\uff0c\u5df2\u6309\u89c4\u5219\u751f\u6210\u62b5\u6d88\u8bb0\u5f55%3$s\u7b14%4$s\u3002", (String)"SumPlanBizServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), sumPlanRecord.getNumber(), innerCancelRule.getNumber(), records.size(), otherErrMsg) : String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6c47\u603b\u5355\u636e\u6267\u884c\u5185\u90e8\u62b5\u6d88\u5931\u8d25\uff0c%1$s", (String)"SumPlanBizServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), otherErrMsg);
                operateResult.getMessageList().add(errMsg);
            }
        } else {
            operateResult.setSuccessMessage(ResManager.loadKDString((String)"\u5185\u90e8\u62b5\u6d88\u5df2\u6210\u529f\u3002", (String)"SumPlanBizServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        operateResult.setSuccess((boolean)var11_18);
        operateResult.setData(sumPlanRecord);
        return operateResult;
    }

    private List<InnerCancelRecord> getInnerCancelRecords(Long id, SumPlanHeader sumPlanHeader) {
        if (sumPlanHeader.getDataStatus() != SumPlanHeader.DATA_STATUS_INNER_CANCEL_AFTER) {
            return Collections.emptyList();
        }
        return this.repository.loadInCRecordBySumId(id);
    }

    private void syncSummaryConfigSnapshot(SumPlanReport sumPlanReport, SumPlanParamConfig sumPlanParamConfig, Set<Long> syncReportIdSet) {
        boolean isChanged;
        Long summaryConfigSnapshotId = sumPlanReport.getSumParamConfigSnapshotId();
        if (EmptyUtil.isEmpty((Long)summaryConfigSnapshotId)) {
            summaryConfigSnapshotId = this.iSummaryConfigService.generateSnapshot(sumPlanParamConfig);
            this.iSummaryConfigService.syncSnapshotToReport(summaryConfigSnapshotId, syncReportIdSet);
            return;
        }
        SumPlanParamConfigSnapshot oldSnapshot = this.iSummaryConfigService.getSummaryParamConfigSnapshot(summaryConfigSnapshotId);
        if (Objects.isNull(oldSnapshot)) {
            summaryConfigSnapshotId = this.iSummaryConfigService.generateSnapshot(sumPlanParamConfig);
            this.iSummaryConfigService.syncSnapshotToReport(summaryConfigSnapshotId, syncReportIdSet);
            return;
        }
        SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
        filter.getIncludes().addAll(SummaryConfigSnapshotProp.CALCULATE_MD5_PROPS);
        SerializeFilter[] filters = new SerializeFilter[]{filter};
        String newestConfigInfoJson = JSON.toJSONString(sumPlanParamConfig.getConfigInfoList(), (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        String newestConfigInfoMD5 = MD5Utils.getMD5Code((String)newestConfigInfoJson);
        boolean bl = isChanged = !Objects.equals(newestConfigInfoMD5, oldSnapshot.getConfigInfoListMD5());
        if (isChanged) {
            summaryConfigSnapshotId = this.iSummaryConfigService.generateSnapshot(sumPlanParamConfig);
        }
        this.iSummaryConfigService.syncSnapshotToReport(summaryConfigSnapshotId, syncReportIdSet);
    }

    private void recalculateSingleSumReportAmt(Long sumReportId, FundPlanSystem fundPlanSystem) {
        SumPlanReport sumPlanReport = (SumPlanReport)this.reportRepository.loadReport(sumReportId);
        List<SumPlanReport.SunReportSumRecord> sunReportSumRecordList = CollectionUtils.isEmpty(sumPlanReport.getSunReportSumRecordList()) ? Collections.EMPTY_LIST : sumPlanReport.getSunReportSumRecordList();
        List subPlanReportIds = sunReportSumRecordList.stream().filter(item -> item.getSumStatus() == SunReportSumStatus.SUM).map(SumPlanReport.SunReportSumRecord::getSunReportId).collect(Collectors.toList());
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(subPlanReportIds)) {
            return;
        }
        sumPlanReport.getReportDataList().forEach(reportData -> {
            reportData.setPlanAmt(BigDecimal.ZERO);
            reportData.setReportPlanAmt(BigDecimal.ZERO);
            reportData.setOriginalPlanAmt(BigDecimal.ZERO);
            reportData.setLockAmt(BigDecimal.ZERO);
            reportData.setActAmt(BigDecimal.ZERO);
            reportData.setPlanReferenceAmt(BigDecimal.ZERO);
        });
        List subPlanReportIdGroup = Lists.partition(subPlanReportIds, (int)5);
        for (List group : subPlanReportIdGroup) {
            for (Long subPlanReportId : group) {
                this.doPlanReportAgainUpperSum(subPlanReportId, sumPlanReport, fundPlanSystem);
            }
        }
    }

    private FpmOperateResult<Void> doPlanReportAgainUpperSum(Long subPlanReportId, SumPlanReport sumPlanReport, FundPlanSystem fundPlanSystem) {
        HashSet subPlanReportIdSet = Sets.newHashSet((Object[])new Long[]{subPlanReportId});
        List<Report> reportList = this.reportRepository.loadReportWithAllDimension(subPlanReportIdSet);
        SumOrCancelPlanReportUpperParam upperParam = new SumOrCancelPlanReportUpperParam();
        upperParam.setSystem(fundPlanSystem);
        upperParam.setSumPlanReport(sumPlanReport);
        upperParam.setReportPlanList(reportList);
        upperParam.setSumStatus(SunReportSumStatus.SUM);
        upperParam.setBusinessType("REBUILD_SUM_REPORT_DATA");
        FpmOperateResult<SumPlanUpdateInfo> sumPlanResult = this.service.rebuildSumReportData(upperParam);
        if (!sumPlanResult.isSuccess()) {
            logger.error("\u4e3b\u8868\u3010\u3011\u6c47\u603b\u7f16\u62a5\uff0c\u66f4\u65b0\u6c47\u603b\u8868\u3010\u3011-\u5931\u8d25", (Object)reportList.stream().map(Report::getId).map(String::valueOf).collect(Collectors.joining(",")), (Object)sumPlanReport.getId());
            return FpmOperateResult.error(sumPlanResult.getMessageList());
        }
        this.sumPlanDataService.batchSaveSumPlanUpdateInfo(sumPlanResult.getData());
        return FpmOperateResult.success();
    }
}

