/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.DetailEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.MainEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.SourceIdEntryData;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanUpdateInfo;
import kd.tmc.fpm.business.mvc.service.SumPlanDataService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class SumPlanDataServiceImpl
implements SumPlanDataService {
    private static Log logger = LogFactory.getLog(SumPlanDataServiceImpl.class);
    private IDataSaveService dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);

    @Override
    public void batchSaveSumPlanUpdateInfo(SumPlanUpdateInfo sumPlanUpdateInfo) {
        if (Objects.isNull(sumPlanUpdateInfo)) {
            return;
        }
        logger.info("\u5f00\u59cb\u6279\u91cf\u4fdd\u5b58\u66f4\u65b0\u3002\u3002\u3002\u3002");
        SumPlanReport sumPlanReport = sumPlanUpdateInfo.getSumPlanReport();
        if (Objects.isNull(sumPlanReport)) {
            logger.info("\u4f20\u5165\u7684\u6c47\u603b\u7f16\u5236\u8868\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u4fdd\u5b58\u6570\u636e\uff0c\u53ea\u80fd\u66f4\u65b0\u7f16\u5236\u6570\u636e");
        }
        List<ReportData> updateReportDataList = sumPlanUpdateInfo.getUpdateReportDataList();
        logger.info("\u5f00\u59cb\u66f4\u65b0\u9700\u8981\u66f4\u65b0\u7684\u7f16\u5236\u6570\u636e\uff1a{}\u6761", (Object)updateReportDataList.size());
        this.dataSaveService.update(IDataSaveService.Constants.SUM_REPORT_REPORT_DATA_UPDATE, updateReportDataList, (t, d) -> {
            d.add(t.getPlanAmt());
            d.add(t.getReportPlanAmt());
            d.add(t.getOriginalPlanAmt());
            d.add(t.getPlanReferenceAmt());
            d.add(t.getId());
        });
        if (Objects.nonNull(sumPlanReport)) {
            List<SumPlanReport.SunReportSumRecord> sunReportSumRecordList = sumPlanUpdateInfo.getSaveReportSumRecordList();
            logger.info("\u5f00\u59cb\u4fdd\u5b58\u6c47\u603b\u8868\u7684\u6c47\u603b\u6c47\u603b\u8bb0\u5f55\uff1a{}", sunReportSumRecordList);
            this.dataSaveService.saveEntryDataThrow(sunReportSumRecordList, sumPlanReport.getId());
            List<SumPlanReport.SunReportSumRecord> updateReportSumRecordList = sumPlanUpdateInfo.getUpdateReportSumRecordList();
            logger.info("\u5f00\u59cb\u66f4\u65b0\u6c47\u603b\u8868\u7684\u6c47\u603b\u6c47\u603b\u8bb0\u5f55\uff1a{}", updateReportSumRecordList);
            this.dataSaveService.update(IDataSaveService.Constants.SUM_REPORT_SUM_RECORD_STATUS_UPDATE, updateReportSumRecordList, (t, d) -> {
                d.add(t.getSumStatus().getNumber());
                d.add(sumPlanReport.getId());
                d.add(t.getSunReportId());
            });
            this.dataSaveService.saveEntryDataThrow(new ArrayList<SourceIdEntryData>(sumPlanUpdateInfo.getSaveSourceIdEntryDataSet()), sumPlanReport.getId());
            this.saveReportData(sumPlanUpdateInfo, sumPlanReport);
        }
        if (sumPlanUpdateInfo.isEnd()) {
            logger.info("\u6700\u540e\u66f4\u65b0\u6c47\u603b\u7f16\u5236\u8868\u72b6\u6001\u3002\u3002\u3002");
            this.dataSaveService.updateSingle(IDataSaveService.Constants.REPORT_BILL_STATUS_UPDATE, sumPlanReport, (t, d) -> {
                d.add(t.getReportStatus().getVal());
                d.add(t.getProcessStatus().getValue());
                d.add(t.getId());
            });
            logger.info("\u6700\u540e\u66f4\u65b0\u6c47\u603b\u8bb0\u5f55\u72b6\u6001\u3002\u3002\u3002");
            SumPlanRecord sumPlanRecord = sumPlanUpdateInfo.getSumPlanRecord();
            this.dataSaveService.updateSingle(IDataSaveService.Constants.SUM_RECORD_STATUS_UPDATE, sumPlanRecord, (t, d) -> {
                d.add(t.getReportStatus().getVal());
                d.add(t.getId());
            });
        }
    }

    private void saveReportData(SumPlanUpdateInfo sumPlanUpdateInfo, SumPlanReport sumPlanReport) {
        List<ReportData> saveReportDataList = sumPlanUpdateInfo.getSaveReportDataList();
        logger.info("\u5f00\u59cb\u4fdd\u5b58\u7f16\u5236\u6570\u636e:{}\u6761", (Object)saveReportDataList.size());
        ArrayList<MainEntryReportData> mainEntryReportDataList = new ArrayList<MainEntryReportData>(saveReportDataList.size());
        ArrayList<DetailEntryReportData> detailEntryReportDataList = new ArrayList<DetailEntryReportData>(saveReportDataList.size());
        for (ReportData reportData : saveReportDataList) {
            MainEntryReportData mainEntryReportData = new MainEntryReportData(reportData);
            mainEntryReportData.setId(reportData.getId());
            mainEntryReportData.setSystemId(sumPlanReport.getSystemId());
            mainEntryReportDataList.add(mainEntryReportData);
            DetailEntryReportData detailEntryReportData = new DetailEntryReportData(reportData);
            detailEntryReportData.setId(reportData.getId());
            detailEntryReportDataList.add(detailEntryReportData);
        }
        this.dataSaveService.saveEntryDataThrow(mainEntryReportDataList, sumPlanReport.getId());
        this.dataSaveService.saveEntryDataThrow(detailEntryReportDataList, sumPlanReport.getId());
    }
}

