/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportCalcModel;
import kd.tmc.fpm.business.domain.model.report.ReportModel;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateBaseInfo;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.domain.service.ITemplateService;
import kd.tmc.fpm.business.helper.SumPlanRelationHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.service.ITemplateManageService;
import kd.tmc.fpm.business.mvc.service.dto.TemplateParamDTO;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.spread.datamanager.ReportDataManagerFactory;

public class TemplateManageService
implements ITemplateManageService {
    private static Log logger = LogFactory.getLog(TemplateManageService.class);
    private ITemplateRepository tempRepo = FpmServiceFactory.getBizService(ITemplateRepository.class);
    private IDimensionRepository dimRepo = FpmServiceFactory.getBizService(IDimensionRepository.class);
    private ITemplateService templateService = FpmServiceFactory.getBizService(ITemplateService.class);
    private IReportService reportService = FpmServiceFactory.getBizService(IReportService.class);
    private ISumPlanRepository sumPlanRepository = FpmServiceFactory.getBizService(ISumPlanRepository.class);

    @Override
    public FpmOperateResult<ReportTemplate> createTemplate(TemplateBaseInfo baseInfo) {
        FundPlanSystem system = this.dimRepo.loadSystem(baseInfo.getSystemId());
        FpmOperateResult<ReportTemplate> reportTemplateOperateResult = this.templateService.newTemplate(system, baseInfo);
        ReportTemplate data = reportTemplateOperateResult.getData();
        return FpmOperateResult.success(data);
    }

    @Override
    public FpmOperateResult<ReportTemplate> loadTemplate(long templateId) {
        ReportTemplate template = this.tempRepo.loadTemplate(templateId);
        return FpmOperateResult.success(template);
    }

    @Override
    public FpmOperateResult<ReportTemplate> saveTemplate(ReportTemplate template) {
        FpmOperateResult re;
        FundPlanSystem system = this.dimRepo.loadSystem(template.getSystemId());
        List<ReportTemplate> subTemplateList = new ArrayList<ReportTemplate>(16);
        if (template.isMainTable()) {
            List<Long> childTPLIdList = template.getAccountSettings().stream().filter(item -> item.getChildTemplateId() != null && item.getChildTemplateId() != 0L).map(TemplateAccountSetting::getChildTemplateId).collect(Collectors.toList());
            subTemplateList = this.tempRepo.loadTemplate(childTPLIdList);
        }
        if ((re = this.templateService.checkTemplate(TemplateParamDTO.builder().system(system).template(template).subTemplateList(subTemplateList).opKey("saveandview").build())).isSuccess()) {
            ReportTemplate result = this.tempRepo.saveTemplate(template);
            return FpmOperateResult.success(result);
        }
        return re;
    }

    @Override
    public FpmOperateResult<ReportModel> refreshReport(ReportTemplate template, Long periodTypeId) {
        return this.refreshReport(template, periodTypeId, null);
    }

    @Override
    public FpmOperateResult<ReportModel> refreshReport(ReportTemplate template, Long periodTypeId, Long sumOrgId) {
        FpmOperateResult<Report> reportGenResult;
        if (periodTypeId == null) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u7f16\u62a5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateManageService_0", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        Long systemId = template.getSystemId();
        FundPlanSystem system = this.dimRepo.loadSystem(systemId);
        List<TemplateDim> rowDimList = template.getRowDimList();
        List<TemplateDim> colDimList = template.getColDimList();
        if (template.getTemplateUse() == TemplateUseType.SUMMARY) {
            Optional<TemplateDim> hasRowOrgDim = rowDimList.stream().filter(templateDim -> templateDim.getDimType() == DimensionType.ORG).findFirst();
            Optional<TemplateDim> hasColOrgDim = colDimList.stream().filter(templateDim -> templateDim.getDimType() == DimensionType.ORG).findFirst();
            if (template.getTemplateType() != TemplateType.DETAIL && (hasColOrgDim.isPresent() || hasRowOrgDim.isPresent()) && EmptyUtil.isEmpty((Long)sumOrgId)) {
                return FpmOperateResult.error(ResManager.loadKDString((String)"\u6c47\u603b\u7f16\u5236\u7f16\u62a5\u4e3b\u4f53\u5728\u884c\u7ef4\u6216\u5217\u7ef4\u65f6\uff0c\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateManageService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
        if (!(reportGenResult = this.reportService.generateTemplatePreviewReport(system, template, periodTypeId, sumOrgId)).isSuccess()) {
            return FpmOperateResult.error(reportGenResult.getMessageList());
        }
        Report report = reportGenResult.getData();
        ReportModel reportModel = ReportDataManagerFactory.createReportModelForTemplatePreview(system, report);
        this.checkMaxCellSize(100000, reportModel, report);
        return FpmOperateResult.success(reportModel);
    }

    private void checkMaxCellSize(int maxSize, ReportModel reportModel, Report report) {
        int rowLeafDimValSize;
        TemplateType templateType = report.getTemplate().getTemplateType();
        if (TemplateType.FIXED != templateType) {
            return;
        }
        ReportCalcModel templateModel = reportModel.getTemplateModel();
        int colLeafDimValSize = templateModel.getColTree().getLeafList().size();
        if (colLeafDimValSize * (rowLeafDimValSize = templateModel.getRowTree().getLeafList().size()) > maxSize) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u9884\u89c8\u5931\u8d25\uff0c\u6240\u9700\u67e5\u8be2\u6570\u636e\u91cf\u7684\u884c\u6570*\u5217\u6570\u4e0d\u53ef\u5927\u4e8e100000\uff0c\u8bf7\u786e\u8ba4\u6210\u5458\u8303\u56f4\u3002", (String)"TemplateManageService_2", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
    }

    @Override
    public FpmOperateResult<ReportTemplate> releaseTemplate(ReportTemplate reportTemplate) {
        FpmOperateResult<ReportTemplate> result = new FpmOperateResult<ReportTemplate>();
        FundPlanSystem system = this.dimRepo.loadSystem(reportTemplate.getSystemId());
        ArrayList<ReportTemplate> subTemplateList = new ArrayList(16);
        if (reportTemplate.isMainTable()) {
            List<Long> childTPLIdList = reportTemplate.getAccountSettings().stream().filter(item -> item.getChildTemplateId() != null && item.getChildTemplateId() != 0L).map(TemplateAccountSetting::getChildTemplateId).collect(Collectors.toList());
            subTemplateList = this.tempRepo.loadTemplate(childTPLIdList);
        }
        List<TemplateParamDTO.RelationTemplate> downRelationTemplate = SumPlanRelationHelper.getRelationTemplate(reportTemplate, system, false);
        List<TemplateParamDTO.RelationTemplate> upperRelationTemplate = SumPlanRelationHelper.getRelationTemplate(reportTemplate, system, true);
        FpmOperateResult fpmOperateResult = this.templateService.checkTemplate(TemplateParamDTO.builder().system(system).template(reportTemplate).subTemplateList(subTemplateList).opKey("releaseop").sumPlanParamConfigList(this.sumPlanRepository.loadSumConfigBySystem(system.getId())).upperRelationTemplates(upperRelationTemplate).downRelationTemplates(downRelationTemplate).build());
        if (!fpmOperateResult.isSuccess()) {
            return fpmOperateResult;
        }
        logger.info(String.format("\u6a21\u677f\u53d1\u5e03\uff1a%s", reportTemplate.getId()));
        reportTemplate.setRelease(true);
        ReportTemplate resultData = this.tempRepo.saveTemplate(reportTemplate);
        result.setData(resultData);
        return result;
    }

    @Override
    public FpmOperateResult<ReportTemplate> updateDimLayout(ReportTemplate template, TemplateLayout layout) {
        return this.templateService.updateDimLayout(template, layout);
    }
}

