/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldType;
import kd.tmc.fpm.business.domain.enums.AuxiliaryFieldsUseType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateReferencePosType;
import kd.tmc.fpm.business.mvc.service.IUpgradeService;

public class TemplateReferenceMetricUpgradeServiceImpl
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(TemplateReferenceMetricUpgradeServiceImpl.class);

    @Override
    public void updateData() {
        LOGGER.info("\u5f00\u59cb\u5347\u7ea7\u6a21\u677f\uff0c\u5907\u4efd\u6a21\u677f\u53c2\u8003\u6307\u6807\u53ca\u5ea6\u91cf\u503c......");
        HashMap<Long, Map<String, DynamicObject>> systemMetricDyMap = new HashMap<Long, Map<String, DynamicObject>>(32);
        HashMap<Long, DynamicObject> auxiliaryFieldDyMap = new HashMap<Long, DynamicObject>(32);
        this.updateData("fpm_template", systemMetricDyMap, auxiliaryFieldDyMap);
        this.updateData("fpm_template_bak", systemMetricDyMap, auxiliaryFieldDyMap);
        LOGGER.info("\u6a21\u677f\uff0c\u5907\u4efd\u6a21\u677f\u53c2\u8003\u6307\u6807\u53ca\u5ea6\u91cf\u503c\u6570\u636e\u5347\u7ea7\u7ed3\u675f......");
    }

    private void updateData(String entityName, Map<Long, Map<String, DynamicObject>> systemMetricDyMap, Map<Long, DynamicObject> auxiliaryFieldDyMap) {
        Object[] load = TmcDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])new QFilter[0]);
        if (EmptyUtil.isEmpty((Object[])load)) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u6570\u636e");
            return;
        }
        load = TmcDataServiceHelper.load((Object[])Arrays.stream(load).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        Map<Object, DynamicObject> bodySysMap = Arrays.stream(load).map(dy -> dy.getDynamicObject("model")).filter(Objects::nonNull).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a));
        TemplateReferenceMetricUpgradeServiceImpl.fillSystemMetricDyMapIFNeed(bodySysMap, systemMetricDyMap);
        this.fillSystemAuxiliaryFieldDyMapIFNeed(bodySysMap, auxiliaryFieldDyMap);
        ArrayList<Object> saveObjList = new ArrayList<Object>(128);
        HashMap<String, String> needThrowErrorMsg = new HashMap<String, String>(16);
        for (Object template : load) {
            DynamicObjectCollection dynamicObjectCollection = template.getDynamicObjectCollection("reporttypeentry");
            DynamicObject bodySys = template.getDynamicObject("model");
            if (EmptyUtil.isEmpty((DynamicObject)bodySys) || EmptyUtil.isEmpty((String)bodySys.getString("name"))) {
                LOGGER.info("\u6a21\u677f\u3010%s\u3011\u5bf9\u5e94\u7684\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u4e3a\u5783\u573e\u6570\u636e\u3002\u3002\u3002", (Object)template.getString("number"));
                continue;
            }
            DynamicObjectCollection metricDc = template.getDynamicObjectCollection("metricentry");
            boolean needSave = this.updateMetricEntryIfNeed((DynamicObject)template, systemMetricDyMap, metricDc, bodySys, needThrowErrorMsg);
            needSave = needSave || this.updateReferencePosIfNeed((DynamicObject)template, systemMetricDyMap, dynamicObjectCollection, bodySys, needThrowErrorMsg);
            boolean bl = needSave = needSave || this.updateRemarkIfNeed((DynamicObject)template, auxiliaryFieldDyMap, dynamicObjectCollection, bodySys, needThrowErrorMsg);
            if (!needSave) continue;
            saveObjList.add(template);
        }
        try {
            if (EmptyUtil.isNoEmpty(saveObjList)) {
                TmcDataServiceHelper.save((DynamicObject[])saveObjList.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (EmptyUtil.isEmpty((String)message)) {
                message = Arrays.stream(e.getStackTrace()).map(s -> String.join((CharSequence)":", s.getClassName(), s.getMethodName(), String.valueOf(s.getLineNumber()))).collect(Collectors.joining(","));
            }
            needThrowErrorMsg.put("", message);
        }
        if (!CollectionUtils.isEmpty(needThrowErrorMsg)) {
            throw new KDBizException(needThrowErrorMsg.values().stream().collect(Collectors.joining(",")));
        }
    }

    private boolean updateRemarkIfNeed(DynamicObject template, Map<Long, DynamicObject> auxiliaryFieldDyMap, DynamicObjectCollection dynamicObjectCollection, DynamicObject bodySys, Map<String, String> needThrowErrorMsg) {
        boolean showRemark = template.getBoolean("isshownote");
        if (!showRemark) {
            LOGGER.info("\u6a21\u677f\u3010{}\u3011\u4e0d\u663e\u793a\u5907\u6ce8\u5217\uff0c\u4e0d\u9700\u8981\u5347\u7ea7\u5907\u6ce8\u5217\u6570\u636e\u3002\u3002\u3002", (Object)template.getString("name"));
            return false;
        }
        DynamicObjectCollection remarkFieldDc = template.getDynamicObjectCollection("remarkfield");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)remarkFieldDc)) {
            LOGGER.info("\u65b0\u7684\u5907\u6ce8\u5217\u5b57\u6bb5\u6709\u503c\uff0c\u6570\u636e\u5df2\u5347\u7ea7\u6216\u662f\u65b0\u6570\u636e\uff0c\u4e0d\u9700\u8981\u5347\u7ea7\u3002\u3002\u3002");
            return false;
        }
        Object pkValue = bodySys.getPkValue();
        if (!auxiliaryFieldDyMap.containsKey(pkValue)) {
            LOGGER.info("\u4f53\u7cfb\u3010%s\u3011\u6ca1\u6709\u9884\u7f6e\u8f85\u52a9\u5217\u5b57\u6bb5\u4e2d\u7684\u5907\u6ce8\u6570\u636e");
            needThrowErrorMsg.put(String.join((CharSequence)"_", String.valueOf(pkValue), "remarkfield"), String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u6ca1\u6709\u9884\u7f6e\u8f85\u52a9\u5217\u5b57\u6bb5\u4e2d\u7684\u5907\u6ce8\u6570\u636e", (String)"TemplateReferenceMetricUpgradeServiceImpl_0", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySys.getString("name")));
            return false;
        }
        DynamicObject remarkFields = auxiliaryFieldDyMap.get(pkValue);
        DynamicObjectCollection remarkFieldsDc = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)template, (DynamicObjectType)template.getDynamicObjectType(), (String)"remarkfield", (DynamicObject[])new DynamicObject[]{remarkFields});
        template.set("remarkfield", (Object)remarkFieldsDc);
        return true;
    }

    private boolean updateReferencePosIfNeed(DynamicObject template, Map<Long, Map<String, DynamicObject>> systemMetricDyMap, DynamicObjectCollection dynamicObjectCollection, DynamicObject bodySys, Map<String, String> needThrowErrorMsg) {
        boolean needSave = false;
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return false;
        }
        Object bodySysId = bodySys.getPkValue();
        Map<String, DynamicObject> metricMap = systemMetricDyMap.get(bodySysId);
        if (CollectionUtils.isEmpty(metricMap)) {
            LOGGER.info("\u4f53\u7cfb\u3010{}\u3011\u4e0b\u6ca1\u6709\u9884\u7f6e\u7684\u5ea6\u91cf\u6307\u6807", (Object)bodySys.getString("name"));
            needThrowErrorMsg.put(String.valueOf(bodySysId), String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u6ca1\u6709\u9884\u7f6e\u597d\u5ea6\u91cf\u6307\u6807\u7ef4\u5ea6\u7684\u6570\u636e", (String)"TemplateReferenceMetricUpgradeServiceImpl_1", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySys.getString("name")));
            return false;
        }
        for (DynamicObject entry : dynamicObjectCollection) {
            entry.set("rollcontaindetail", (Object)Boolean.TRUE);
            DynamicObject dynamicObject = entry.getDynamicObject("e_refrenceorg");
            if (EmptyUtil.isEmpty((DynamicObject)dynamicObject)) {
                LOGGER.info("\u6a21\u677f\u3010{}\u3011\u53c2\u8003\u7f16\u62a5\u7c7b\u578b\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u6570\u636e\u5347\u7ea7", (Object)template.getString("name"));
                continue;
            }
            DynamicObjectCollection referencePosDc = entry.getDynamicObjectCollection("newreferencepos");
            if (!EmptyUtil.isEmpty((DynamicObjectCollection)referencePosDc)) {
                LOGGER.info("\u6a21\u677f\u3010{}\u3011\u65b0\u7684\u53c2\u8003\u6307\u6807\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u6570\u636e\u5347\u7ea7", (Object)template.getString("name"));
                continue;
            }
            String referencePos = entry.getString("refrencepos");
            if (EmptyUtil.isEmpty((String)referencePos)) {
                LOGGER.info("\u6a21\u677f\u3010{}\u3011\u65e7\u7684\u53c2\u8003\u6307\u6807\u4e3a\u7a7a\uff0c\u4e3a\u9519\u8bef\u6570\u636e\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u6570\u636e\u5347\u7ea7", (Object)template.getString("name"));
                continue;
            }
            String[] split = referencePos.split(",");
            Set metricNumbers = Arrays.stream(split).map(TemplateReferencePosType::getByNumber).map(TemplateReferencePosType::getByTemplateReferencePosType).map(TemplateMetricType::getCode).filter(key -> !metricMap.containsKey(key)).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(metricNumbers)) {
                LOGGER.info("\u4f53\u7cfb\u3010{}\u3011\u4e0b\u6ca1\u6709\u9884\u7f6e\u7684\u5ea6\u91cf\u6307\u6807\u3010{}\u3011", (Object)bodySys.getString("name"), metricNumbers);
                needThrowErrorMsg.put(String.valueOf(bodySysId), String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u4e0b\u6ca1\u6709\u9884\u7f6e\u7684\u5ea6\u91cf\u6307\u6807\u3010%2$s\u3011", (String)"TemplateReferenceMetricUpgradeServiceImpl_2", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySys.getString("name"), metricNumbers));
                return false;
            }
            DynamicObject[] objects = Arrays.stream(split).map(TemplateReferencePosType::getByNumber).map(TemplateReferencePosType::getByTemplateReferencePosType).map(TemplateMetricType::getNumber).map(metricMap::get).collect(Collectors.toSet()).toArray(new DynamicObject[0]);
            DynamicObjectCollection newReferencePosDc = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)entry, (DynamicObjectType)entry.getDynamicObjectType(), (String)"newreferencepos", (DynamicObject[])objects);
            entry.set("newreferencepos", (Object)newReferencePosDc);
            needSave = true;
        }
        return needSave;
    }

    private boolean updateMetricEntryIfNeed(DynamicObject template, Map<Long, Map<String, DynamicObject>> systemMetricDyMap, DynamicObjectCollection metricDc, DynamicObject bodySys, Map<String, String> needThrowErrorMsg) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)metricDc)) {
            LOGGER.info("\u6a21\u677f\uff1a{}\u5ea6\u91cf\u503c\u5206\u5f55\u4e3a\u7a7a\u3002\u3002\u3002", (Object)template.getString("number"));
            DynamicObject object = metricDc.addNew();
            object.set("metrictype", (Object)TemplateMetricType.PLANAMT.getCode());
        }
        boolean needSave = false;
        Object pkValue = bodySys.getPkValue();
        if (!systemMetricDyMap.containsKey(pkValue)) {
            LOGGER.info("\u4f53\u7cfb\uff1a{}\u672a\u914d\u7f6e\u9884\u7f6e\u6307\u6807\u7ef4\u5ea6", (Object)bodySys.getString("name"));
            needThrowErrorMsg.put(String.valueOf(pkValue), String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u6ca1\u6709\u9884\u7f6e\u597d\u5ea6\u91cf\u6307\u6807\u7ef4\u5ea6\u7684\u6570\u636e", (String)"TemplateReferenceMetricUpgradeServiceImpl_3", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySys.getString("name")));
            return false;
        }
        Map<String, DynamicObject> metricMap = systemMetricDyMap.get(pkValue);
        for (DynamicObject entry : metricDc) {
            DynamicObject metricDy = entry.getDynamicObject("newmetrictype");
            if (EmptyUtil.isNoEmpty((DynamicObject)metricDy)) {
                LOGGER.info("\u6a21\u677f\uff1a{}\u5ea6\u91cf\u6307\u6807\u5206\u5f55\uff1a{}\u4e2d\u7684\u5ea6\u91cf\u6307\u6807\u5c5e\u6027\u6709\u503c\uff0c\u4e0d\u9700\u8981\u8fdb\u884c\u6570\u636e\u5347\u7ea7\u3002\u3002\u3002", (Object)template.getString("number"), entry.getPkValue());
                continue;
            }
            String metricType = entry.getString("metrictype");
            if (EmptyUtil.isEmpty((String)metricType)) {
                LOGGER.info("\u6a21\u677f\uff1a{}\u5ea6\u91cf\u6307\u6807\u5206\u5f55:{}\u4e2d\u7684\u65e7\u7684\u5ea6\u91cf\u6307\u6807\u4e3a\u7a7a", (Object)template.getString("number"), entry.getPkValue());
                continue;
            }
            TemplateMetricType templateMetricType = ITypeEnum.getByNumber(metricType, TemplateMetricType.class);
            if (EmptyUtil.isEmpty((Object)templateMetricType)) {
                LOGGER.info("\u6a21\u677f\uff1a{}\u5ea6\u91cf\u6307\u6807\u5206\u5f55:{}\u4e2d\u7684\u65e7\u7684\u5ea6\u91cf\u6307\u6807{}\u6709\u8bef", new Object[]{template.getString("number"), entry.getPkValue(), metricType});
                continue;
            }
            if (!metricMap.containsKey(metricType)) {
                LOGGER.info("\u6a21\u677f\uff1a{}\u5ea6\u91cf\u6307\u6807\u5206\u5f55:{}\u4e2d\u7684\u65e7\u7684\u5ea6\u91cf\u6307\u6807{}\u5728\u5ea6\u91cf\u6307\u6807\u7ef4\u5ea6\u4e2d\u4e0d\u5b58\u5728\u9884\u7f6e\u6570\u636e", new Object[]{template.getString("number"), entry.getPkValue(), metricType});
                String key = template.getString("name") + "_" + metricType;
                needThrowErrorMsg.put(key, String.format(ResManager.loadKDString((String)"\u6a21\u677f\uff1a\u3010%1$s\u3011\u5ea6\u91cf\u6307\u6807\u5206\u5f55\uff1a\u3010%2$s\u3011\u4e2d\u7684\u65e7\u7684\u5ea6\u91cf\u6307\u6807\u3010%3$s\u3011\u5728\u5ea6\u91cf\u6307\u6807\u7ef4\u5ea6\u4e2d\u4e0d\u5b58\u5728\u9884\u7f6e\u6570\u636e", (String)"TemplateReferenceMetricUpgradeServiceImpl_4", (String)"tmc-fpm-business", (Object[])new Object[0]), template.getString("name"), entry.getPkValue(), metricType));
                return false;
            }
            DynamicObject metricMemberDy = metricMap.get(metricType);
            entry.set("newmetrictype", (Object)metricMemberDy);
            needSave = true;
        }
        return needSave;
    }

    private static void fillSystemMetricDyMapIFNeed(Map<Object, DynamicObject> bodySysMap, Map<Long, Map<String, DynamicObject>> systemMetricDyMap) {
        Object[] bodySysArr = TmcDataServiceHelper.load((Object[])bodySysMap.keySet().toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_bodysysmanage"));
        if (EmptyUtil.isEmpty((Object[])bodySysArr)) {
            return;
        }
        bodySysMap.clear();
        bodySysMap.putAll(Arrays.stream(bodySysArr).filter(dy -> EmptyUtil.isNotEmpty((CharSequence)dy.getString("name"))).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (a, b) -> a)));
        Set metricCodeSet = Arrays.stream(TemplateMetricType.values()).filter(tm -> tm != TemplateMetricType.CUSTOM).map(TemplateMetricType::getCode).collect(Collectors.toSet());
        Set filterBodySysIds = bodySysMap.keySet().stream().filter(sysId -> !systemMetricDyMap.containsKey(sysId)).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(filterBodySysIds)) {
            return;
        }
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("metricpresettype", "in", metricCodeSet).and("dimtype", "=", (Object)DimensionType.METRIC.getNumber()).and("bodysystem", "in", filterBodySysIds).and("preset", "=", (Object)Boolean.TRUE)});
        load = TmcDataServiceHelper.load((Object[])Arrays.stream(load).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_member"));
        Map mapMap = Arrays.stream(load).collect(Collectors.groupingBy(dy -> (Long)dy.getDynamicObject("bodysystem").getPkValue(), Collectors.mapping(Function.identity(), Collectors.toMap(dy -> dy.getString("metricpresettype"), Function.identity()))));
        HashSet notExistsMetricSystemIds = new HashSet(filterBodySysIds);
        notExistsMetricSystemIds.removeAll(mapMap.keySet());
        if (EmptyUtil.isNoEmpty(notExistsMetricSystemIds)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u6ca1\u6709\u9884\u7f6e\u597d\u5ea6\u91cf\u6307\u6807\u7ef4\u5ea6\u7684\u6570\u636e", (String)"TemplateReferenceMetricUpgradeServiceImpl_5", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySysMap.entrySet().stream().filter(entry -> notExistsMetricSystemIds.contains(entry.getKey())).map(Map.Entry::getValue).map(dy -> dy.getString("name")).collect(Collectors.joining(","))));
        }
        systemMetricDyMap.putAll(mapMap);
    }

    private void fillSystemAuxiliaryFieldDyMapIFNeed(Map<Object, DynamicObject> bodySysMap, Map<Long, DynamicObject> auxiliaryFieldDyMap) {
        Set filterBodySysIds = bodySysMap.keySet().stream().filter(sysId -> !auxiliaryFieldDyMap.containsKey(sysId)).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty(filterBodySysIds)) {
            return;
        }
        DynamicObject[] load = TmcDataServiceHelper.load((String)"fpm_auxiliaryfields", (String)"id", (QFilter[])new QFilter[]{new QFilter("bodysys", "in", filterBodySysIds).and("ispreset", "=", (Object)Boolean.TRUE).and("type", "=", (Object)AuxiliaryFieldType.REMARK.getNumber()).and("usetype", "=", (Object)AuxiliaryFieldsUseType.PLAN.getNumber())});
        load = TmcDataServiceHelper.load((Object[])Arrays.stream(load).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_auxiliaryfields"));
        Map mapMap = Arrays.stream(load).collect(Collectors.toMap(dy -> (Long)dy.getDynamicObject("bodysys").getPkValue(), Function.identity()));
        HashSet notExistsMetricSystemIds = new HashSet(filterBodySysIds);
        notExistsMetricSystemIds.removeAll(mapMap.keySet());
        if (EmptyUtil.isNoEmpty(notExistsMetricSystemIds)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u6ca1\u6709\u9884\u7f6e\u597d\u8f85\u52a9\u5217\u5b57\u6bb5\u5b9a\u4e49\u4e2d\u7684\u3010\u5907\u6ce8\u3011\u7684\u6570\u636e", (String)"TemplateReferenceMetricUpgradeServiceImpl_6", (String)"tmc-fpm-business", (Object[])new Object[0]), bodySysMap.entrySet().stream().filter(entry -> notExistsMetricSystemIds.contains(entry.getKey())).map(Map.Entry::getValue).map(dy -> dy.getString("name")).collect(Collectors.joining(","))));
        }
        auxiliaryFieldDyMap.putAll(mapMap);
    }
}

