/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.impl;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.mvc.service.IControlExecuteParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ZeroFilterPostProcessor
implements IControlExecuteParamPostProcessor {
    private static final Log logger = LogFactory.getLog(ZeroFilterPostProcessor.class);

    @Override
    public void postProcess(ControlContext controlContext, List<ControlExecuteParam> controlExecuteParamList) {
        if (controlContext.getPlanExecuteOpType().isDelete() || controlContext.getPlanExecuteOpType().isRelease() || controlContext.getPlanExecuteOpType().isUpdate()) {
            return;
        }
        logger.info("\u8fc7\u6ee4\u5339\u914d\u5230\u7684\u91d1\u989d\u4e3a0\u7684\u6570\u636e\uff0c\u8fc7\u6ee4\u524d\u5927\u5c0f\uff1a{}", (Object)controlExecuteParamList.size());
        Iterator<ControlExecuteParam> iterator = controlExecuteParamList.iterator();
        while (iterator.hasNext()) {
            ControlExecuteParam controlExecuteParam = iterator.next();
            if (BigDecimal.ZERO.compareTo(CommonUtils.getBigDecimalValue(controlExecuteParam.getActAmount())) != 0) continue;
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            List<ControlTraceInfo> controlTraceInfoList = controlContext.getControlTraceInfo(controlExecuteParam.getSystemId(), billBizInfo.getBillId());
            if (EmptyUtil.isEmpty(controlTraceInfoList)) {
                iterator.remove();
                continue;
            }
            ControlTraceInfo controlTraceInfo = controlTraceInfoList.get(0);
            if (!Objects.equals(controlTraceInfo.getBillId(), billBizInfo.getBillId()) || !Objects.equals(controlTraceInfo.getEntityType(), billBizInfo.getEntityType())) {
                iterator.remove();
                continue;
            }
            List<PlanExecuteRecord> executeRecordList = controlTraceInfo.getExecuteRecordList();
            Optional<PlanExecuteRecord> first = executeRecordList.stream().filter(p -> p.getExecuteOpType() == controlContext.getPlanExecuteOpType()).findFirst();
            if (first.isPresent()) continue;
            iterator.remove();
        }
        logger.info("\u8fc7\u6ee4\u5339\u914d\u5230\u7684\u91d1\u989d\u4e3a0\u7684\u6570\u636e\uff0c\u8fc7\u6ee4\u540e\u5927\u5c0f\uff1a{}", (Object)controlExecuteParamList.size());
    }

    @Override
    public int getOrder() {
        return 25;
    }
}

