/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.compare;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fpm.business.domain.enums.InspectionCompareType;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.inspection.compare.AbstractCompareHandler;
import kd.tmc.fpm.business.mvc.service.inspection.compare.InspectChainContext;
import kd.tmc.fpm.business.mvc.service.inspection.compare.InspectHandlerChain;

public class BottomCompareHandler
extends AbstractCompareHandler {
    @Override
    public void doHandle(InspectChainContext context, InspectHandlerChain chain) {
        if (!this.isSkip(context)) {
            this.doCompare(context);
        }
        chain.doHandle(context);
    }

    private void doCompare(InspectChainContext context) {
        List<ReportData> matchedList = context.getMatchedReportDataList();
        for (ReportData matchedRD : matchedList) {
            Map<Long, ControlAmountCache.AmountInfo> amountInfoMap = context.getAmountInfoMap();
            if (!amountInfoMap.containsKey(matchedRD.getId())) continue;
            this.doCompareAndRecord(matchedRD, context);
        }
    }

    private void doCompareAndRecord(ReportData matchedRD, InspectChainContext context) {
        boolean actAmtIsEq;
        ControlAmountCache.AmountInfo amountInfo = context.getAmountInfoMap().get(matchedRD.getId());
        boolean lockAmtIsEq = amountInfo.getLockDiffAmt().compareTo(matchedRD.getLockAmt()) == 0;
        boolean bl = actAmtIsEq = amountInfo.getActDiffAmt().compareTo(matchedRD.getActAmt()) == 0;
        if (lockAmtIsEq && actAmtIsEq) {
            return;
        }
        context.setExecResult(InspectionExecResult.EXCEPTION);
        if (!lockAmtIsEq) {
            context.getRawErrorInfoList().add(new InspectChainContext.RawErrorInfo(matchedRD, this.getErrorInfo(InspectionCompareType.PRE_OCCUPY.getDesc(), matchedRD, amountInfo)));
        }
        if (!actAmtIsEq) {
            context.getRawErrorInfoList().add(new InspectChainContext.RawErrorInfo(matchedRD, this.getErrorInfo(InspectionCompareType.ACTUAL_OCCUPY.getDesc(), matchedRD, amountInfo)));
        }
    }

    private String getErrorInfo(String compareTypeDesc, ReportData matchedRD, ControlAmountCache.AmountInfo amountInfo) {
        if (InspectionCompareType.PRE_OCCUPY.getDesc().equals(compareTypeDesc)) {
            return String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8868%1$s\u989d\u5ea6%2$s\uff1b\u6267\u884c\u8bb0\u5f55\u5408\u8ba1\u989d\u5ea6%3$s", (String)"AmountConsistencyInspectService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), compareTypeDesc, matchedRD.getLockAmt().setScale(12, 6).stripTrailingZeros().toPlainString(), amountInfo.getLockDiffAmt().setScale(12, 6).stripTrailingZeros().toPlainString());
        }
        return String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8868%1$s\u989d\u5ea6%2$s\uff1b\u6267\u884c\u8bb0\u5f55\u5408\u8ba1\u989d\u5ea6%3$s", (String)"AmountConsistencyInspectService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), compareTypeDesc, matchedRD.getActAmt().setScale(12, 6).stripTrailingZeros().toPlainString(), amountInfo.getActDiffAmt().setScale(12, 6).stripTrailingZeros().toPlainString());
    }
}

