/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.compare;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtExceptionInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.inspection.compare.AbstractCompareHandler;
import kd.tmc.fpm.business.mvc.service.inspection.compare.InspectChainContext;
import kd.tmc.fpm.business.mvc.service.inspection.compare.InspectHandlerChain;
import kd.tmc.fpm.business.utils.LogFormatUtil;

public class DataPackageHandler
extends AbstractCompareHandler {
    @Override
    public void doHandle(InspectChainContext context, InspectHandlerChain chain) {
        if (!this.isSkip(context)) {
            Map<Object, DimMember> dimMemberMap = context.getSystem().getMainDimList().stream().map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
            for (InspectChainContext.RawErrorInfo rawErrorInfo : context.getRawErrorInfoList()) {
                AmtExceptionInfo amtExceptionInfo = this.createAmtExceptionInfo(rawErrorInfo.getMatchedRD(), rawErrorInfo.getErrorInfo(), dimMemberMap);
                context.getLog().getAmtExceptionInfoList().add(amtExceptionInfo);
            }
        }
        chain.doHandle(context);
    }

    protected AmtExceptionInfo createAmtExceptionInfo(ReportData matchedRD, String errorInfo, Map<Object, DimMember> dimMemberMap) {
        AmtExceptionInfo amtExceptionInfo = new AmtExceptionInfo();
        amtExceptionInfo.setDimensionCombo(LogFormatUtil.formatRDDimensionValue(matchedRD, dimMemberMap));
        amtExceptionInfo.setRepairResult(InspectionRepairResult.PENDING);
        amtExceptionInfo.setReportId(matchedRD.getReportId());
        amtExceptionInfo.setErrorInfo(errorInfo);
        amtExceptionInfo.setPeriodId(matchedRD.getReportPeriodId());
        amtExceptionInfo.setReportDataId(matchedRD.getId());
        amtExceptionInfo.setOrgId((Long)matchedRD.getDimValByDimType(DimensionType.ORG));
        return amtExceptionInfo;
    }

    @Override
    public boolean isSkip(InspectChainContext context) {
        return context.getExecResult() != InspectionExecResult.EXCEPTION;
    }
}

