/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.compare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InspectionCompareType;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.SunReportSumStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.inspection.InspectDateRange;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtConsistencyLog;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtExceptionInfo;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.SumPlanReport;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanUpdateInfo;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.ISumPlanService;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.LogFormatUtil;
import kd.tmc.fpm.common.bean.DimensionInfoBean;
import org.apache.commons.collections.CollectionUtils;

public class SumPlanCompareHandler {
    private final Log logger = LogFactory.getLog(SumPlanCompareHandler.class);
    private final IReportRepository reportRepository = FpmServiceFactory.getBizService(IReportRepository.class);
    private final ISumPlanService sumPlanService = FpmServiceFactory.getBizService(ISumPlanService.class);

    public void doHandle(AmtConsistencyLog log, InspectContext inspectContext) {
        List sumOrgMemberList = inspectContext.getOrgMemberList().stream().filter(OrgMember::isSum).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sumOrgMemberList)) {
            return;
        }
        FundPlanSystem system = inspectContext.getSystem();
        Map<Object, DimMember> dimMemberMap = system.getMainDimList().stream().map(Dimension::getAllDimMemberList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toMap(DimMember::getId, Function.identity(), (a, b) -> a));
        Dimension subjectDim = system.getMainDimensionByDimType(DimensionType.SUBJECTS);
        List<DimMember> memberList = subjectDim.getAllDimMemberList();
        List beginEndDimensionInfoBeans = memberList.stream().map(AccountMember.class::cast).filter(accountMember -> Objects.nonNull(accountMember.getPeriodDirection())).map(member -> DimensionInfoBean.of(Collections.singletonList(subjectDim.getId()), Collections.singletonList(member.getId()))).collect(Collectors.toList());
        InspectDateRange inspectDateRange = inspectContext.getInspectDateRange();
        Set<Long> allPeriodMemberIdList = inspectDateRange.getAllPeriodMemberIdList();
        Dimension metricDim = system.getMainDimensionByDimType(DimensionType.METRIC);
        List<MetricMember> metricMembers = metricDim.getAllDimMemberList().stream().map(item -> (MetricMember)item).filter(item -> item.getTemplateMetricType() == TemplateMetricType.LOCKAMT || item.getTemplateMetricType() == TemplateMetricType.ACTMAT).collect(Collectors.toList());
        for (Long periodId : allPeriodMemberIdList) {
            for (OrgMember sumOrgMember : sumOrgMemberList) {
                SumPlanReport sumPlanReportReSum;
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(4);
                qFilterList.add(new QFilter("reportorg", "=", (Object)sumOrgMember.getId()));
                qFilterList.add(new QFilter("bodysys", "=", (Object)system.getId()));
                qFilterList.add(new QFilter("reportperiod", "=", (Object)periodId));
                qFilterList.add(new QFilter("reportplantype", "=", (Object)ReportPlanType.SUMPLAN.getNumber()));
                DynamicObjectCollection reportIdColl = QueryServiceHelper.query((String)"fpm_report", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]));
                if (CollectionUtils.isEmpty((Collection)reportIdColl)) {
                    this.logger.info("\u627e\u4e0d\u5230\u6c47\u603b\u8868id\uff0c\u7f16\u62a5\u4e3b\u4f53\uff1a{}\uff0c\u4f53\u7cfb\uff1a{}\uff0c\u671f\u95f4\uff1a{}", new Object[]{sumOrgMember.getName() + sumOrgMember.getId(), system.getNumber(), periodId});
                    continue;
                }
                long sumReportId = ((DynamicObject)reportIdColl.get(0)).getLong("id");
                SumPlanReport sumPlanReport = (SumPlanReport)this.reportRepository.loadReportWithAllDimension(sumReportId);
                Set<Long> subSumReportIdSet = sumPlanReport.getSunReportSumRecordList().stream().filter(sunReportSumRecord -> sunReportSumRecord.getSumStatus() == SunReportSumStatus.SUM).map(SumPlanReport.SunReportSumRecord::getSunReportId).collect(Collectors.toSet());
                List<Report> subReports = this.reportRepository.loadReportWithAllDimension(subSumReportIdSet);
                FpmOperateResult<SumPlanUpdateInfo> sumResult = this.sumPlanService.sumPlanReportUpper(subReports, sumPlanReportReSum = this.copySumPlanReport(sumPlanReport), system, metricMembers);
                if (!sumResult.isSuccess()) continue;
                SumPlanReport sumReportResult = sumResult.getData().getSumPlanReport();
                QueryIndexInfo<Object, ReportData> queryIndexInfo = sumReportResult.getQueryIndexInfo(system);
                Set beginEndReportDataIds = beginEndDimensionInfoBeans.stream().map(queryIndexInfo::findList).flatMap(Collection::stream).map(ReportData::getId).collect(Collectors.toSet());
                for (ReportData reportData : sumPlanReport.getReportDataList()) {
                    AmtExceptionInfo sumExceptionInfo;
                    String errorInfo;
                    boolean actAmtIsEq;
                    DimensionInfoBean dimensionInfoBean = DimensionInfoHelper.getDimensionInfoBean(reportData);
                    ReportData reportDataReSum = queryIndexInfo.findOne(dimensionInfoBean);
                    if (reportDataReSum == null) {
                        this.logger.info("\u627e\u4e0d\u5230\u7ef4\u5ea6\uff1a{}\uff0creportDataId\uff1a{}", (Object)LogFormatUtil.formatRDDimensionValue(reportData, dimMemberMap), (Object)reportData.getId());
                        continue;
                    }
                    if (beginEndReportDataIds.contains(reportDataReSum.getId())) {
                        this.logger.info("\u8df3\u8fc7\u671f\u521d\u671f\u672b\u6570\u636e\uff0c\u6570\u636e\u7ef4\u5ea6\uff1a{}\uff0creportDataId\uff1a{}", (Object)LogFormatUtil.formatRDDimensionValue(reportData, dimMemberMap), (Object)reportData.getId());
                        continue;
                    }
                    boolean lockAmtIsEq = reportData.getLockAmt().compareTo(reportDataReSum.getLockAmt()) == 0;
                    boolean bl = actAmtIsEq = reportData.getActAmt().compareTo(reportDataReSum.getActAmt()) == 0;
                    if (lockAmtIsEq && actAmtIsEq) continue;
                    if (!lockAmtIsEq) {
                        this.logger.info("\u4e0e\u672b\u7ea7\u7ec4\u7ec7\u9884\u5360\u989d\u5ea6\u7d2f\u52a0\u4e0d\u4e00\u81f4\uff0c\u6c47\u603b\u8868\u989d\u5ea6{}\uff1b\u672b\u7ea7\u7ec4\u7ec7\u8ba1\u7b97\u6240\u5f97\u989d\u5ea6{}\uff0creportDataId\uff1b[{}]", new Object[]{reportData.getLockAmt(), reportDataReSum.getLockAmt(), reportData.getId()});
                        errorInfo = String.format(ResManager.loadKDString((String)"\u4e0e\u672b\u7ea7\u7ec4\u7ec7%s\u989d\u5ea6\u7d2f\u52a0\u4e0d\u4e00\u81f4", (String)"AmountConsistencyInspectService_2", (String)"tmc-fpm-business", (Object[])new Object[0]), InspectionCompareType.PRE_OCCUPY.getDesc());
                        sumExceptionInfo = this.createSumExceptionInfo(reportData, errorInfo, dimMemberMap);
                        log.getAmtExceptionInfoList().add(sumExceptionInfo);
                    }
                    if (actAmtIsEq) continue;
                    this.logger.info("\u4e0e\u672b\u7ea7\u7ec4\u7ec7\u5b9e\u5360\u989d\u5ea6\u7d2f\u52a0\u4e0d\u4e00\u81f4\uff0c\u6c47\u603b\u8868\u989d\u5ea6{}\uff1b\u672b\u7ea7\u7ec4\u7ec7\u8ba1\u7b97\u6240\u5f97\u989d\u5ea6{}\uff0creportDataId\uff1b[{}]", new Object[]{reportData.getActAmt(), reportDataReSum.getActAmt(), reportData.getId()});
                    errorInfo = String.format(ResManager.loadKDString((String)"\u4e0e\u672b\u7ea7\u7ec4\u7ec7%s\u989d\u5ea6\u7d2f\u52a0\u4e0d\u4e00\u81f4", (String)"AmountConsistencyInspectService_2", (String)"tmc-fpm-business", (Object[])new Object[0]), InspectionCompareType.ACTUAL_OCCUPY.getDesc());
                    sumExceptionInfo = this.createSumExceptionInfo(reportData, errorInfo, dimMemberMap);
                    log.getAmtExceptionInfoList().add(sumExceptionInfo);
                }
            }
        }
    }

    private AmtExceptionInfo createSumExceptionInfo(ReportData reportData, String errorInfo, Map<Object, DimMember> dimMemberMap) {
        AmtExceptionInfo amtExceptionInfo = new AmtExceptionInfo();
        amtExceptionInfo.setDimensionCombo(LogFormatUtil.formatRDDimensionValue(reportData, dimMemberMap));
        amtExceptionInfo.setRepairResult(InspectionRepairResult.PENDING);
        amtExceptionInfo.setReportId(reportData.getReportId());
        amtExceptionInfo.setErrorInfo(errorInfo);
        amtExceptionInfo.setPeriodId(reportData.getReportPeriodId());
        amtExceptionInfo.setOrgId((Long)reportData.getDimValByDimType(DimensionType.ORG));
        amtExceptionInfo.setReportDataId(reportData.getId());
        return amtExceptionInfo;
    }

    private SumPlanReport copySumPlanReport(SumPlanReport sumPlanReport) {
        SumPlanReport report = new SumPlanReport();
        report.setId(sumPlanReport.getId());
        report.setName(sumPlanReport.getName());
        report.setNumber(sumPlanReport.getNumber());
        report.setInitFlag(sumPlanReport.getInitFlag());
        report.setProcessStatus(ReportProcessStatus.SAVE);
        report.setReportPeriodId(sumPlanReport.getReportPeriodId());
        report.setReportStatus(sumPlanReport.getReportStatus());
        report.setReportPlanType(sumPlanReport.getReportPlanType());
        report.setTemplate(sumPlanReport.getTemplate());
        report.setCompanyMemberList(sumPlanReport.getCompanyMemberList());
        report.setReportDataList(new ArrayList<ReportData>(sumPlanReport.getReportDataList().size()));
        report.setSunReportSumRecordList(new ArrayList<SumPlanReport.SunReportSumRecord>(sumPlanReport.getSunReportSumRecordList().size()));
        return report;
    }
}

