/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.factory;

import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.inspection.InspectControlConfig;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.IDataInspectStrategy;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.ActualCancelDataInspectStrategy;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.ActualDataInspectStrategy;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.ActualReleaseDataInspectStrategy;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.ActualUpdateDataInspectStrategy;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.OccupyCancelDataInspectStrategy;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.OccupyDataInspectStrategy;
import kd.tmc.fpm.business.mvc.service.inspection.strategy.impl.OccupyReleaseDataInspectStrategy;

public class DataInspectStrategyFactory {
    public static IDataInspectStrategy getDataInspectStrategy(InspectContext inspectContext, InspectControlConfig.InspectControlConfigItem inspectControlConfigItem) {
        PlanExecuteOpType planExecuteOpType = inspectControlConfigItem.getPlanExecuteOpType();
        switch (planExecuteOpType) {
            case PRE_OCCUPY_WRITE: {
                return new OccupyDataInspectStrategy(inspectContext);
            }
            case PRE_OCCUPY_DELETE: {
                return new OccupyCancelDataInspectStrategy(inspectContext);
            }
            case PRE_OCCUPY_RELEASE: {
                return new OccupyReleaseDataInspectStrategy(inspectContext);
            }
            case WRITE: {
                return new ActualDataInspectStrategy(inspectContext);
            }
            case CANCEL: {
                return new ActualCancelDataInspectStrategy(inspectContext);
            }
            case RELEASE: {
                return new ActualReleaseDataInspectStrategy(inspectContext);
            }
            case UPDATE: {
                return new ActualUpdateDataInspectStrategy(inspectContext);
            }
        }
        throw new UnsupportedOperationException();
    }
}

