/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionExecStatus;
import kd.tmc.fpm.business.domain.model.inspection.DateRange;
import kd.tmc.fpm.business.domain.model.inspection.InspectionConfig;
import kd.tmc.fpm.business.domain.model.inspection.log.BaseLog;
import kd.tmc.fpm.business.domain.model.message.MessageParam;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectService;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.utils.MessageHelper;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractDataInspectService<T extends BaseLog>
implements IDataInspectService<T> {
    protected InspectContext inspectContext;

    public AbstractDataInspectService(InspectContext inspectContext) {
        this.inspectContext = inspectContext;
    }

    @Override
    public T dataInspect() {
        T log = this.getLogInstance();
        this.initBaseLogInfo(log);
        this.doDataInspect(log);
        this.finish(log);
        this.sendMsgIfException(log);
        return log;
    }

    protected abstract void doDataInspect(T var1);

    protected abstract T getLogInstance();

    public void initBaseLogInfo(T log) {
        ((BaseLog)log).setId(DB.genGlobalLongId());
        ((BaseLog)log).setSystemId(this.inspectContext.getSystem().getId());
        ((BaseLog)log).setInspectionType(this.inspectContext.getInspectionType());
        ((BaseLog)log).setInspectionConfigId(this.inspectContext.getInspectionConfig().getId());
        ((BaseLog)log).setInspectionScope(this.inspectContext.getInspectionScope());
        ((BaseLog)log).setNotifyStaffIdList(this.inspectContext.getInspectionConfig().getNotifyObjIdList());
        DateRange dateRange = this.inspectContext.getInspectDateRange().getDateRange();
        if (EmptyUtil.isNoEmpty((Object)dateRange)) {
            ((BaseLog)log).setInspectionStartDate(dateRange.getStartDate());
            ((BaseLog)log).setInspectionEndDate(dateRange.getEndDate());
        }
        ((BaseLog)log).setInspectionPeriodScope(new ArrayList<Long>(this.inspectContext.getInspectDateRange().getAllPeriodMemberIdList()));
        ((BaseLog)log).setInspectionOrgScope(new ArrayList<Long>(this.inspectContext.getInspectReportOrgScope()));
        ((BaseLog)log).setExecDate(new Date());
        ((BaseLog)log).setExecStatus(InspectionExecStatus.RUNNING);
        ((BaseLog)log).setExecResult(InspectionExecResult.SUCCESS);
    }

    public void finish(T log) {
        ((BaseLog)log).setFinishDate(new Date());
        ((BaseLog)log).setExecStatus(InspectionExecStatus.FINISHED);
    }

    protected void sendMsgIfException(T log) {
        InspectionConfig inspectionConfig = this.inspectContext.getInspectionConfig();
        if (CollectionUtils.isEmpty(inspectionConfig.getNotifyObjIdList())) {
            return;
        }
        if (((BaseLog)log).getExecResult() != InspectionExecResult.EXCEPTION) {
            return;
        }
        MessageParam messageParam = MessageParam.builder().userIds(new HashSet<Long>(inspectionConfig.getNotifyObjIdList())).title(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u6570\u636e\u5de1\u68c0\u6267\u884c\u5df2\u7ed3\u675f\uff0c\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u5c3d\u5feb\u67e5\u770b\u548c\u5904\u7406\u3002", (String)"AbstractDataInspectService_0", (String)"tmc-fpm-business", (Object[])new Object[0])).tag(ResManager.loadKDString((String)"\u8d44\u91d1\u8ba1\u5212\u6570\u636e\u5de1\u68c0\u6267\u884c\u7ed3\u679c", (String)"AbstractDataInspectService_1", (String)"tmc-fpm-business", (Object[])new Object[0])).tplScene("fpm_inspection_warn").entityName("fpm_inspection_log").formId("fpm_inspection_log").pkId(((BaseLog)log).getId()).warpMessage(messageInfo -> messageInfo.setContent(ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u65e5\u5fd7", (String)"AbstractDataInspectService_2", (String)"tmc-fpm-business", (Object[])new Object[0]))).build();
        MessageHelper.batchSendMessageByTemplate(Collections.singletonList(messageParam));
    }
}

