/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.InspectionExecResult;
import kd.tmc.fpm.business.domain.enums.InspectionRepairResult;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.inspection.AmtConsistencyExecRecord;
import kd.tmc.fpm.business.domain.model.inspection.BatchDataSet;
import kd.tmc.fpm.business.domain.model.inspection.InspectDateRange;
import kd.tmc.fpm.business.domain.model.inspection.InspectQueryParam;
import kd.tmc.fpm.business.domain.model.inspection.log.AmtConsistencyLog;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.inspection.compare.BottomCompareHandler;
import kd.tmc.fpm.business.mvc.service.inspection.compare.DataPackageHandler;
import kd.tmc.fpm.business.mvc.service.inspection.compare.InspectChainContext;
import kd.tmc.fpm.business.mvc.service.inspection.compare.InspectHandlerChain;
import kd.tmc.fpm.business.mvc.service.inspection.compare.RelateCompareHandler;
import kd.tmc.fpm.business.mvc.service.inspection.compare.SumPlanCompareHandler;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.impl.AbstractDataInspectService;
import kd.tmc.fpm.business.mvc.service.inspection.query.IInspectDataQueryService;
import kd.tmc.fpm.business.mvc.service.inspection.query.impl.AmountConsistencyQueryService;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import org.apache.commons.collections.CollectionUtils;

public class AmountConsistencyInspectService
extends AbstractDataInspectService<AmtConsistencyLog> {
    private final Log logger = LogFactory.getLog(AmountConsistencyInspectService.class);
    private final IReportDataQueryService reportDataQueryService = FpmServiceFactory.getBizService(IReportDataQueryService.class);
    private final IInspectDataQueryService<AmtConsistencyExecRecord> inspectDataQueryService = new AmountConsistencyQueryService();
    private final SumPlanCompareHandler sumPlanCompareHandler = new SumPlanCompareHandler();

    public AmountConsistencyInspectService(InspectContext inspectContext) {
        super(inspectContext);
    }

    @Override
    protected void doDataInspect(AmtConsistencyLog log) {
        Date createTime = new Date();
        this.logger.info("[AmountConsistencyInspectService] >>>>> Start Executing Amount Consistency Inspection, Start Date:[{}]", (Object)createTime);
        InspectDateRange inspectDateRange = this.inspectContext.getInspectDateRange();
        Set<Long> allPeriodMemberIdList = inspectDateRange.getAllPeriodMemberIdList();
        if (EmptyUtil.isEmpty(allPeriodMemberIdList)) {
            return;
        }
        List<OrgMember> orgMemberList = this.getOrgMemberList();
        List orgIdList = orgMemberList.stream().map(DimMember::getId).collect(Collectors.toList());
        for (Long periodId : allPeriodMemberIdList) {
            BatchDataSet<AmtConsistencyExecRecord> batchDataSet = this.inspectDataQueryService.query(this.inspectContext, new InspectQueryParam().addParam("reportOrgId", orgIdList).addParam("reportPeriodId", periodId).addParam("createTime", createTime));
            Throwable throwable = null;
            try {
                ControlAmountCache controlAmountCache = new ControlAmountCache();
                while (batchDataSet.hasNext()) {
                    List<AmtConsistencyExecRecord> batchData = batchDataSet.getBatchData();
                    this.updateControlAmountCache(batchData, controlAmountCache);
                }
                Map<Long, List<ControlAmountCache.AmountInfo>> reportAmountMap = controlAmountCache.getAllData().stream().collect(Collectors.groupingBy(ControlAmountCache.AmountInfo::getReportId));
                this.logger.info("[AmountConsistencyInspectService] >>>>> Grouping by reportId, reportAmountMap Size:[{}]", (Object)reportAmountMap.size());
                for (Map.Entry<Long, List<ControlAmountCache.AmountInfo>> entry : reportAmountMap.entrySet()) {
                    List<ControlAmountCache.AmountInfo> amountInfoList = entry.getValue();
                    Long reportId = entry.getKey();
                    this.doInspect(amountInfoList, log, reportId);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (batchDataSet == null) continue;
                if (throwable != null) {
                    try {
                        batchDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                batchDataSet.close();
            }
        }
        this.sumPlanCompareHandler.doHandle(log, this.inspectContext);
        if (CollectionUtils.isNotEmpty(log.getAmtExceptionInfoList())) {
            log.setExecResult(InspectionExecResult.EXCEPTION);
            log.setInspectionRepairResult(InspectionRepairResult.PENDING);
        }
        this.logger.info("[AmountConsistencyInspectService] >>>>> Finish Executing Amount Consistency Inspection");
    }

    private void updateControlAmountCache(List<AmtConsistencyExecRecord> amtConsistencyExecRecordList, ControlAmountCache controlAmountCache) {
        Dimension subjectDim = this.inspectContext.getSystem().getMainDimensionByDimType(DimensionType.SUBJECTS);
        List leafSubjectMember = subjectDim.getAllDimMemberList().stream().filter(DimMember::isLeaf).map(DimMember::getId).collect(Collectors.toList());
        amtConsistencyExecRecordList.removeIf(amtConsistencyExecRecord -> !leafSubjectMember.contains(amtConsistencyExecRecord.getSubjectMember()));
        Set allReportDataIdSet = amtConsistencyExecRecordList.stream().flatMap(record -> record.getMatchedReportDataIdList().stream()).collect(Collectors.toSet());
        List<ReportData> reportDataList = this.getReportData(new ArrayList<Long>(allReportDataIdSet));
        if (CollectionUtils.isEmpty(reportDataList)) {
            return;
        }
        Map<Long, ReportData> reportDataMap = reportDataList.stream().collect(Collectors.toMap(ReportData::getId, v -> v, (k1, k2) -> k1));
        Long systemId = this.inspectContext.getSystem().getId();
        for (AmtConsistencyExecRecord amtConsistencyExecRecord2 : amtConsistencyExecRecordList) {
            List<Long> matchedReportDataIdList = amtConsistencyExecRecord2.getMatchedReportDataIdList();
            Long reportOrgId = amtConsistencyExecRecord2.getReportOrgId();
            for (Long reportDataId : matchedReportDataIdList) {
                ReportData reportData;
                PlanExecuteOpType executeOpType = amtConsistencyExecRecord2.getExecuteOpType();
                if (!reportDataMap.containsKey(reportDataId) || !Objects.equals(reportOrgId, (reportData = reportDataMap.get(reportDataId)).getDimValByDimType(DimensionType.ORG))) continue;
                controlAmountCache.init(reportData, systemId);
                BigDecimal execAmt = reportData.getReportActAmount(amtConsistencyExecRecord2.getActAmount());
                if (executeOpType == PlanExecuteOpType.PRE_OCCUPY_WRITE || executeOpType == PlanExecuteOpType.PRE_OCCUPY_RELEASE) {
                    controlAmountCache.updateLockAmount(reportData.getId(), execAmt);
                    continue;
                }
                if (executeOpType != PlanExecuteOpType.WRITE && executeOpType != PlanExecuteOpType.RELEASE && executeOpType != PlanExecuteOpType.UPDATE) continue;
                controlAmountCache.updateActAmount(reportData.getId(), execAmt);
            }
        }
    }

    private void doInspect(List<ControlAmountCache.AmountInfo> amountInfoList, AmtConsistencyLog log, Long reportId) {
        Map<Long, ControlAmountCache.AmountInfo> amountInfoMap = amountInfoList.stream().collect(Collectors.toMap(ControlAmountCache.AmountInfo::getReportDataId, Function.identity(), (a, b) -> a));
        List<Long> allReportDataIdList = amountInfoList.stream().map(ControlAmountCache.AmountInfo::getReportDataId).collect(Collectors.toList());
        List<ReportData> matchedReportDataList = this.getReportData(allReportDataIdList);
        this.logger.info("[AmountConsistencyInspectService] >>>>> matchedReportDataList size:[{}], reportId:[{}]", (Object)matchedReportDataList.size(), (Object)reportId);
        InspectChainContext context = new InspectChainContext(log, matchedReportDataList, amountInfoMap, this.inspectContext.getSystem());
        InspectHandlerChain inspectHandlerChain = new InspectHandlerChain();
        inspectHandlerChain.addHandler(new BottomCompareHandler()).addHandler(new RelateCompareHandler()).addHandler(new DataPackageHandler());
        inspectHandlerChain.doHandle(context);
    }

    private List<OrgMember> getOrgMemberList() {
        FundPlanSystem system = this.inspectContext.getSystem();
        Dimension orgDim = system.getMainDimensionByDimType(DimensionType.ORG);
        List<OrgMember> orgMemberList = orgDim.getAllDimMemberList().stream().map(OrgMember.class::cast).filter(orgMember -> {
            if (CollectionUtils.isEmpty(this.inspectContext.getInspectReportOrgScope())) {
                return true;
            }
            return this.inspectContext.getInspectReportOrgScope().contains(orgMember.getId());
        }).collect(Collectors.toList());
        this.inspectContext.setOrgMemberList(orgMemberList);
        return orgMemberList;
    }

    @Override
    protected AmtConsistencyLog getLogInstance() {
        return new AmtConsistencyLog();
    }

    private List<ReportData> getReportData(List<Long> allReportDataIds) {
        if (CollectionUtils.isEmpty(allReportDataIds)) {
            return new ArrayList<ReportData>(1);
        }
        List<ReportData> reportDataList = this.reportDataQueryService.queryReportData(t -> {
            t.setIdList(allReportDataIds);
            t.setNeedDimIfValueIsNotEmpty(true);
        });
        return reportDataList;
    }
}

