/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.postprocessor;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.helper.ControlBOTPHelper;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;

public class BillControlTraceFilterPostProcessor
implements IDataInspectParamPostProcessor {
    @Override
    public void postProcess(InspectContext inspectContext, InspectParam dataInspectParam) {
        List<BillBizInfo> billBizInfoList = dataInspectParam.getBillBizInfoList();
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = inspectContext.getBusinessBillExecuteRecordInfo();
        for (BillBizInfo billBizInfo : billBizInfoList) {
            List<ControlBOTPInfo> downBillBizInfoList;
            Long billId = billBizInfo.getBillId();
            Long controlTraceId = businessBillExecuteRecordInfo.getControlTraceId(billId);
            if (EmptyUtil.isEmpty((Long)controlTraceId) || EmptyUtil.isEmpty(downBillBizInfoList = businessBillExecuteRecordInfo.getDownBillBizInfoList(billId))) continue;
            HashSet<ControlBOTPInfo> waitRemove = new HashSet<ControlBOTPInfo>(16);
            for (ControlBOTPInfo controlBOTPInfo : downBillBizInfoList) {
                Long downBillControlTraceId;
                if (businessBillExecuteRecordInfo.isMultiSourceBillId(controlBOTPInfo.getId()) || waitRemove.contains(controlBOTPInfo) || EmptyUtil.isEmpty((Long)(downBillControlTraceId = businessBillExecuteRecordInfo.getControlTraceId(controlBOTPInfo.getId()))) || Objects.equals(controlTraceId, downBillControlTraceId)) continue;
                waitRemove.add(controlBOTPInfo);
                businessBillExecuteRecordInfo.removeDownBill(controlBOTPInfo, billId);
                List<ControlBOTPInfo> downBill = ControlBOTPHelper.findDownBill(controlBOTPInfo.getEntityType(), controlBOTPInfo.getId());
                waitRemove.addAll(downBill);
                downBill.forEach(downInfo -> businessBillExecuteRecordInfo.removeDownBill((ControlBOTPInfo)downInfo, billId));
            }
        }
    }
}

