/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.postprocessor;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.control.MatchMapping;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.inspection.InspectDateRange;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;

public class DataInspectParamInfoDateFilterPostProcessor
implements IDataInspectParamPostProcessor {
    private static final Log logger = LogFactory.getLog(DataInspectParamInfoDateFilterPostProcessor.class);

    @Override
    public void postProcess(InspectContext inspectContext, InspectParam dataInspectParam) {
        List<BillBizInfo> billBizInfoList = dataInspectParam.getBillBizInfoList();
        Iterator<BillBizInfo> iterator = billBizInfoList.iterator();
        InspectDateRange inspectDateRange = inspectContext.getInspectDateRange();
        FundPlanSystem system = inspectContext.getSystem();
        Dimension periodDim = system.getMainDimensionByDimType(DimensionType.PERIOD);
        BillMatchRule matchRule = inspectContext.getMatchRule(dataInspectParam.getInspectControlConfigItem().getMatchRuleId());
        MatchMapping periodMatchMapping = matchRule.getMappings().stream().filter(matchMapping -> Objects.equals(periodDim.getId(), matchMapping.getDimId())).findFirst().get();
        logger.info("DataInspectParamInfoDateFilterPostProcessor  \u8fc7\u6ee4\u524d\u5927\u5c0f\uff1a{}", (Object)billBizInfoList.size());
        String bizProp = periodMatchMapping.getBizProp();
        while (iterator.hasNext()) {
            BillBizInfo billBizInfo = iterator.next();
            Optional<BizProps> first = billBizInfo.getBizProps().stream().filter(bizProps -> Objects.equals(bizProps.getBizProp(), bizProp)).findFirst();
            if (!first.isPresent()) {
                iterator.remove();
                continue;
            }
            BizProps bizProps2 = first.get();
            Object value = bizProps2.getValue();
            if (inspectDateRange.isInRange(value)) continue;
            iterator.remove();
        }
        logger.info("DataInspectParamInfoDateFilterPostProcessor  \u8fc7\u6ee4\u540e\u5927\u5c0f\uff1a{}", (Object)billBizInfoList.size());
    }
}

