/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.mvc.service.inspection.postprocessor;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillControlTraceIdInfo;
import kd.tmc.fpm.business.domain.model.control.ControlBOTPInfo;
import kd.tmc.fpm.business.helper.ControlBOTPHelper;
import kd.tmc.fpm.business.mvc.repository.IBillControlTraceIdInfoRepository;
import kd.tmc.fpm.business.mvc.service.inspection.IDataInspectParamPostProcessor;
import kd.tmc.fpm.business.mvc.service.inspection.context.BusinessBillExecuteRecordInfo;
import kd.tmc.fpm.business.mvc.service.inspection.context.InspectContext;
import kd.tmc.fpm.business.mvc.service.inspection.param.InspectParam;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;

public class DataInspectParamInfoFillPostProcessor
implements IDataInspectParamPostProcessor {
    private IBillControlTraceIdInfoRepository billControlTraceIdInfoRepository = FpmServiceFactory.getBizService(IBillControlTraceIdInfoRepository.class);

    @Override
    public void postProcess(InspectContext inspectContext, InspectParam dataInspectParam) {
        List<BillBizInfo> billBizInfoList = dataInspectParam.getBillBizInfoList();
        BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo = inspectContext.getBusinessBillExecuteRecordInfo();
        HashSet<Long> waitSearchTraceBillIds = new HashSet<Long>(billBizInfoList.size());
        for (BillBizInfo billBizInfo : billBizInfoList) {
            waitSearchTraceBillIds.add(billBizInfo.getBillId());
            List<ControlBOTPInfo> upBill = ControlBOTPHelper.findUpBill(billBizInfo.getEntityType(), billBizInfo.getBillId());
            businessBillExecuteRecordInfo.addUpperBillBizInfo(billBizInfo.getBillId(), upBill);
            upBill.forEach(bill -> waitSearchTraceBillIds.add(bill.getId()));
            List<ControlBOTPInfo> downBill = ControlBOTPHelper.findDownBill(billBizInfo.getEntityType(), billBizInfo.getBillId());
            businessBillExecuteRecordInfo.addDownBillBizInfo(billBizInfo.getBillId(), downBill);
            downBill.forEach(bill -> waitSearchTraceBillIds.add(bill.getId()));
            this.registerMultiSourceIfNeed(businessBillExecuteRecordInfo, downBill);
        }
        List<BillControlTraceIdInfo> billControlTraceIdInfos = this.billControlTraceIdInfoRepository.loadByBusinessBillIds(waitSearchTraceBillIds);
        businessBillExecuteRecordInfo.addBillControlTraceIdInfoList(billControlTraceIdInfos);
    }

    private void registerMultiSourceIfNeed(BusinessBillExecuteRecordInfo businessBillExecuteRecordInfo, List<ControlBOTPInfo> downBill) {
        if (EmptyUtil.isEmpty(downBill)) {
            return;
        }
        block0: for (ControlBOTPInfo down : downBill) {
            String entityType = down.getEntityType();
            List<ControlBOTPInfo> upperList = ControlBOTPHelper.findUpBill(entityType, down.getId());
            if (EmptyUtil.isEmpty(upperList)) continue;
            String currentUpperEntityType = "";
            int count = 0;
            for (ControlBOTPInfo upper : upperList) {
                String upperEntityType = upper.getEntityType();
                if (Objects.equals(entityType, upperEntityType)) continue;
                if (EmptyUtil.isEmpty((String)currentUpperEntityType)) {
                    currentUpperEntityType = upperEntityType;
                    ++count;
                    continue;
                }
                if (!Objects.equals(currentUpperEntityType, upperEntityType)) continue block0;
                if (++count <= 1) continue;
                businessBillExecuteRecordInfo.addMultiSourceBillId(down.getId());
                continue block0;
            }
        }
    }
}

